(function() {
  var COMPLETIONS, cssDocsURL, firstCharsEqual, firstInlinePropertyNameWithColonPattern, hasScope, importantPrefixPattern, inlinePropertyNameWithColonPattern, lineEndsWithSemicolon, path, propertyNamePrefixPattern, propertyNameWithColonPattern, pseudoSelectorPrefixPattern, tagSelectorPrefixPattern;

  path = require('path');

  COMPLETIONS = require('../completions.json');

  firstInlinePropertyNameWithColonPattern = /{\s*(\S+)\s*:/;

  inlinePropertyNameWithColonPattern = /(?:;.+?)*;\s*(\S+)\s*:/;

  propertyNameWithColonPattern = /^\s*(\S+)\s*:/;

  propertyNamePrefixPattern = /[a-zA-Z]+[-a-zA-Z]*$/;

  pseudoSelectorPrefixPattern = /:(:)?([a-z]+[a-z-]*)?$/;

  tagSelectorPrefixPattern = /(^|\s|,)([a-z]+)?$/;

  importantPrefixPattern = /(![a-z]+)$/;

  cssDocsURL = "https://developer.mozilla.org/en-US/docs/Web/CSS";

  module.exports = {
    selector: '.source.css, .source.sass',
    disableForSelector: '.source.css .comment, .source.css .string, .source.sass .comment, .source.sass .string',
    properties: COMPLETIONS.properties,
    pseudoSelectors: COMPLETIONS.pseudoSelectors,
    tags: COMPLETIONS.tags,
    filterSuggestions: true,
    getSuggestions: function(request) {
      var completions, isSass, scopes, tagCompletions;
      completions = null;
      scopes = request.scopeDescriptor.getScopesArray();
      isSass = hasScope(scopes, 'source.sass');
      if (this.isCompletingValue(request)) {
        completions = this.getPropertyValueCompletions(request);
      } else if (this.isCompletingPseudoSelector(request)) {
        completions = this.getPseudoSelectorCompletions(request);
      } else {
        if (isSass && this.isCompletingNameOrTag(request)) {
          completions = this.getPropertyNameCompletions(request).concat(this.getTagCompletions(request));
        } else if (!isSass && this.isCompletingName(request)) {
          completions = this.getPropertyNameCompletions(request);
        }
      }
      if (!isSass && this.isCompletingTagSelector(request)) {
        tagCompletions = this.getTagCompletions(request);
        if (tagCompletions != null ? tagCompletions.length : void 0) {
          if (completions == null) {
            completions = [];
          }
          completions = completions.concat(tagCompletions);
        }
      }
      return completions;
    },
    onDidInsertSuggestion: function(arg) {
      var editor, suggestion;
      editor = arg.editor, suggestion = arg.suggestion;
      if (suggestion.type === 'property') {
        return setTimeout(this.triggerAutocomplete.bind(this, editor), 1);
      }
    },
    triggerAutocomplete: function(editor) {
      return atom.commands.dispatch(atom.views.getView(editor), 'autocomplete-plus:activate', {
        activatedManually: false
      });
    },
    isCompletingValue: function(arg) {
      var beforePrefixBufferPosition, beforePrefixScopes, beforePrefixScopesArray, bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      beforePrefixBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      beforePrefixScopes = editor.scopeDescriptorForBufferPosition(beforePrefixBufferPosition);
      beforePrefixScopesArray = beforePrefixScopes.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      return (hasScope(scopes, 'meta.property-list.css') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.css')) || (hasScope(scopes, 'meta.property-list.scss') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.scss')) || (hasScope(scopes, 'source.sass') && (hasScope(scopes, 'meta.property-value.sass') || (!hasScope(beforePrefixScopesArray, 'entity.name.tag.css') && !hasScope(beforePrefixScopesArray, 'entity.name.tag.css.sass') && prefix.trim() === ":")));
    },
    isCompletingName: function(arg) {
      var bufferPosition, editor, isAtBeginScopePunctuation, isAtEndScopePunctuation, isAtParentSymbol, isAtTerminator, isInPropertyList, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      isAtTerminator = prefix.endsWith(';');
      isAtParentSymbol = prefix.endsWith('&');
      isInPropertyList = !isAtTerminator && (hasScope(scopes, 'meta.property-list.css') || hasScope(scopes, 'meta.property-list.scss'));
      if (!isInPropertyList) {
        return false;
      }
      if (isAtParentSymbol) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(previousScopesArray, 'entity.other.attribute-name.class.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id') || hasScope(previousScopesArray, 'entity.other.attribute-name.parent-selector.css') || hasScope(previousScopesArray, 'entity.name.tag.reference.scss') || hasScope(previousScopesArray, 'entity.name.tag.scss')) {
        return false;
      }
      isAtBeginScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.scss');
      isAtEndScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.scss');
      if (isAtBeginScopePunctuation) {
        return prefix.endsWith('{');
      } else if (isAtEndScopePunctuation) {
        return !prefix.endsWith('}');
      } else {
        return true;
      }
    },
    isCompletingNameOrTag: function(arg) {
      var bufferPosition, editor, prefix, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      return this.isPropertyNamePrefix(prefix) && hasScope(scopes, 'meta.selector.css') && !hasScope(scopes, 'entity.other.attribute-name.id.css.sass') && !hasScope(scopes, 'entity.other.attribute-name.class.sass');
    },
    isCompletingTagSelector: function(arg) {
      var bufferPosition, editor, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes, tagSelectorPrefix;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      tagSelectorPrefix = this.getTagSelectorPrefix(editor, bufferPosition);
      if (!(tagSelectorPrefix != null ? tagSelectorPrefix.length : void 0)) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss') || hasScope(scopes, 'source.css.less')) {
        return !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'meta.property-value.css') && !hasScope(previousScopesArray, 'support.type.property-value.css');
      } else {
        return false;
      }
    },
    isCompletingPseudoSelector: function(arg) {
      var bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if ((hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) && !hasScope(scopes, 'source.sass')) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss') || hasScope(scopes, 'source.css.less') || hasScope(scopes, 'source.sass')) {
        prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
        if (prefix) {
          previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
          previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
          previousScopesArray = previousScopes.getScopesArray();
          return !hasScope(previousScopesArray, 'meta.property-name.scss') && !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'support.type.property-name.css') && !hasScope(previousScopesArray, 'support.type.property-value.css');
        } else {
          return false;
        }
      } else {
        return false;
      }
    },
    isPropertyValuePrefix: function(prefix) {
      prefix = prefix.trim();
      return prefix.length > 0 && prefix !== ':';
    },
    isPropertyNamePrefix: function(prefix) {
      if (prefix == null) {
        return false;
      }
      prefix = prefix.trim();
      return prefix.length > 0 && prefix.match(/^[a-zA-Z-]+$/);
    },
    getImportantPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = importantPrefixPattern.exec(line)) != null ? ref[1] : void 0;
    },
    getPreviousPropertyName: function(bufferPosition, editor) {
      var column, line, propertyName, ref, ref1, ref2, row;
      row = bufferPosition.row, column = bufferPosition.column;
      while (row >= 0) {
        line = editor.lineTextForBufferRow(row);
        if (row === bufferPosition.row) {
          line = line.substr(0, column);
        }
        propertyName = (ref = inlinePropertyNameWithColonPattern.exec(line)) != null ? ref[1] : void 0;
        if (propertyName == null) {
          propertyName = (ref1 = firstInlinePropertyNameWithColonPattern.exec(line)) != null ? ref1[1] : void 0;
        }
        if (propertyName == null) {
          propertyName = (ref2 = propertyNameWithColonPattern.exec(line)) != null ? ref2[1] : void 0;
        }
        if (propertyName) {
          return propertyName;
        }
        row--;
      }
    },
    getPropertyValueCompletions: function(arg) {
      var addSemicolon, bufferPosition, completions, editor, i, importantPrefix, j, len, len1, prefix, property, ref, scopeDescriptor, scopes, value, values;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix, scopeDescriptor = arg.scopeDescriptor;
      property = this.getPreviousPropertyName(bufferPosition, editor);
      values = (ref = this.properties[property]) != null ? ref.values : void 0;
      if (values == null) {
        return null;
      }
      scopes = scopeDescriptor.getScopesArray();
      addSemicolon = !lineEndsWithSemicolon(bufferPosition, editor) && !hasScope(scopes, 'source.sass');
      completions = [];
      if (this.isPropertyValuePrefix(prefix)) {
        for (i = 0, len = values.length; i < len; i++) {
          value = values[i];
          if (firstCharsEqual(value, prefix)) {
            completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
          }
        }
      } else {
        for (j = 0, len1 = values.length; j < len1; j++) {
          value = values[j];
          completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
        }
      }
      if (importantPrefix = this.getImportantPrefix(editor, bufferPosition)) {
        completions.push({
          type: 'keyword',
          text: '!important',
          displayText: '!important',
          replacementPrefix: importantPrefix,
          description: "Forces this property to override any other declaration of the same property. Use with caution.",
          descriptionMoreURL: cssDocsURL + "/Specificity#The_!important_exception"
        });
      }
      return completions;
    },
    buildPropertyValueCompletion: function(value, propertyName, addSemicolon) {
      var text;
      text = value;
      if (addSemicolon) {
        text += ';';
      }
      return {
        type: 'value',
        text: text,
        displayText: value,
        description: value + " value for the " + propertyName + " property",
        descriptionMoreURL: cssDocsURL + "/" + propertyName + "#Values"
      };
    },
    getPropertyNamePrefix: function(bufferPosition, editor) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = propertyNamePrefixPattern.exec(line)) != null ? ref[0] : void 0;
    },
    getPropertyNameCompletions: function(arg) {
      var activatedManually, bufferPosition, completions, editor, line, options, prefix, property, ref, scopeDescriptor, scopes;
      bufferPosition = arg.bufferPosition, editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, activatedManually = arg.activatedManually;
      scopes = scopeDescriptor.getScopesArray();
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      if (hasScope(scopes, 'source.sass') && !line.match(/^(\s|\t)/)) {
        return [];
      }
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      if (!(activatedManually || prefix)) {
        return [];
      }
      completions = [];
      ref = this.properties;
      for (property in ref) {
        options = ref[property];
        if (!prefix || firstCharsEqual(property, prefix)) {
          completions.push(this.buildPropertyNameCompletion(property, prefix, options));
        }
      }
      return completions;
    },
    buildPropertyNameCompletion: function(propertyName, prefix, arg) {
      var description;
      description = arg.description;
      return {
        type: 'property',
        text: propertyName + ": ",
        displayText: propertyName,
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + propertyName
      };
    },
    getPseudoSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = line.match(pseudoSelectorPrefixPattern)) != null ? ref[0] : void 0;
    },
    getPseudoSelectorCompletions: function(arg) {
      var bufferPosition, completions, editor, options, prefix, pseudoSelector, ref;
      bufferPosition = arg.bufferPosition, editor = arg.editor;
      prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
      if (!prefix) {
        return null;
      }
      completions = [];
      ref = this.pseudoSelectors;
      for (pseudoSelector in ref) {
        options = ref[pseudoSelector];
        if (firstCharsEqual(pseudoSelector, prefix)) {
          completions.push(this.buildPseudoSelectorCompletion(pseudoSelector, prefix, options));
        }
      }
      return completions;
    },
    buildPseudoSelectorCompletion: function(pseudoSelector, prefix, arg) {
      var argument, completion, description;
      argument = arg.argument, description = arg.description;
      completion = {
        type: 'pseudo-selector',
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + pseudoSelector
      };
      if (argument != null) {
        completion.snippet = pseudoSelector + "(${1:" + argument + "})";
      } else {
        completion.text = pseudoSelector;
      }
      return completion;
    },
    getTagSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = tagSelectorPrefixPattern.exec(line)) != null ? ref[2] : void 0;
    },
    getTagCompletions: function(arg) {
      var bufferPosition, completions, editor, i, len, prefix, ref, tag;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix;
      completions = [];
      if (prefix) {
        ref = this.tags;
        for (i = 0, len = ref.length; i < len; i++) {
          tag = ref[i];
          if (firstCharsEqual(tag, prefix)) {
            completions.push(this.buildTagCompletion(tag));
          }
        }
      }
      return completions;
    },
    buildTagCompletion: function(tag) {
      return {
        type: 'tag',
        text: tag,
        description: "Selector for <" + tag + "> elements"
      };
    }
  };

  lineEndsWithSemicolon = function(bufferPosition, editor) {
    var line, row;
    row = bufferPosition.row;
    line = editor.lineTextForBufferRow(row);
    return /;\s*$/.test(line);
  };

  hasScope = function(scopesArray, scope) {
    return scopesArray.indexOf(scope) !== -1;
  };

  firstCharsEqual = function(str1, str2) {
    return str1[0].toLowerCase() === str2[0].toLowerCase();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
