/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;

public abstract class ApplicationHandle {
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_DESCRIPTOR = "application.descriptor";
    public static final String APPLICATION_STATE = "application.state";
    public static final String APPLICATION_SUPPORTS_EXITVALUE = "application.supports.exitvalue";
    public static final String RUNNING = "RUNNING";
    public static final String STOPPING = "STOPPING";
    private final String instanceId;
    private final ApplicationDescriptor descriptor;
    Delegate delegate;
    static /* synthetic */ Class class$org$osgi$service$application$ApplicationHandle;
    static /* synthetic */ Class class$java$lang$Object;

    protected ApplicationHandle(String instanceId, ApplicationDescriptor descriptor) {
        if (null == instanceId || null == descriptor) {
            throw new NullPointerException("Parameters must not be null!");
        }
        this.instanceId = instanceId;
        this.descriptor = descriptor;
        try {
            this.delegate = new Delegate();
            this.delegate.setApplicationHandle(this, descriptor.delegate);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("No implementation available for ApplicationDescriptor, property is: " + Delegate.cName);
        }
    }

    public final ApplicationDescriptor getApplicationDescriptor() {
        return this.descriptor;
    }

    public abstract String getState();

    public Object getExitValue(long timeout) throws ApplicationException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public final String getInstanceId() {
        return this.instanceId;
    }

    public final void destroy() {
        try {
            this.delegate.destroy();
        }
        catch (SecurityException se) {
            this.descriptor.isLaunchableSpecific();
            throw se;
        }
        this.destroySpecific();
    }

    protected abstract void destroySpecific();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Delegate {
        static String cName;
        static Class implementation;
        static Method setApplicationHandle;
        static Method destroy;
        Object target = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return implementation.newInstance();
            }
        });

        Delegate() throws Exception {
        }

        void setApplicationHandle(ApplicationHandle d, ApplicationDescriptor.Delegate descriptor) {
            try {
                try {
                    setApplicationHandle.invoke(this.target, d, descriptor.target);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void destroy() {
            try {
                try {
                    destroy.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    cName = System.getProperty("org.osgi.vendor.application.ApplicationHandle");
                    if (cName == null) {
                        throw new NoClassDefFoundError("org.osgi.vendor.application.ApplicationHandle property must be set");
                    }
                    try {
                        implementation = Class.forName(cName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(((Object)e).toString());
                    }
                    try {
                        setApplicationHandle = implementation.getMethod("setApplicationHandle", class$org$osgi$service$application$ApplicationHandle == null ? (class$org$osgi$service$application$ApplicationHandle = ApplicationHandle.class$("org.osgi.service.application.ApplicationHandle")) : class$org$osgi$service$application$ApplicationHandle, class$java$lang$Object == null ? (class$java$lang$Object = ApplicationHandle.class$("java.lang.Object")) : class$java$lang$Object);
                        destroy = implementation.getMethod("destroy", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new NoSuchMethodError(((Object)e).toString());
                    }
                    return null;
                }
            });
        }
    }
}

