/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.tree.Bookmark;
import genj.tree.TreeMetrics;
import genj.tree.TreeView;
import genj.util.Resources;
import genj.util.swing.ColorsWidget;
import genj.util.swing.FontChooser;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeViewSettings
extends JTabbedPane {
    private static final Resources RESOURCES = Resources.get(TreeViewSettings.class);
    private final JSpinner[] spinners = new JSpinner[5];
    private final ColorsWidget colors;
    private final JCheckBox checkBending;
    private final JCheckBox checkAntialiasing;
    private final JCheckBox checkMarrSymbols;
    private final JComboBox<OnAction> jcAction;
    private final JCheckBox cbShowPopup;
    private final JCheckBox cbTreeAutoScroll;
    private AbstractAncestrisAction up = new Move(-1);
    private AbstractAncestrisAction down = new Move(1);
    private AbstractAncestrisAction delete = new Delete();
    private final FontChooser font;
    private final Commit commit;
    private Bookmarks bookmarks;
    private JList bList;

    public TreeViewSettings(TreeView view) {
        this.commit = new Commit(view);
        JPanel options = new JPanel((LayoutManager)new NestedBlockLayout("<col><check gx=\"1\"/><row><label/><checkbox/></row><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><font gx=\"1\"/><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row></col>"));
        this.checkBending = this.createCheck("bend", view.getModel().isBendArcs());
        this.checkAntialiasing = this.createCheck("antialiasing", view.isAntialising());
        this.checkMarrSymbols = this.createCheck("marrsymbols", view.getModel().isMarrSymbols());
        this.jcAction = new JComboBox<OnAction>(OnAction.values());
        this.jcAction.setSelectedItem((Object)TreeView.getOnAction());
        this.jcAction.addActionListener(this.commit);
        this.cbTreeAutoScroll = this.createCheck("autoscroll", TreeView.isAutoScroll());
        this.cbShowPopup = this.createCheck("showpopup", TreeView.showPopup());
        this.font = new FontChooser();
        this.font.setSelectedFont(view.getContentFont());
        this.font.addChangeListener((ChangeListener)this.commit);
        options.add(this.cbShowPopup);
        options.add(new JLabel(RESOURCES.getString("tv.action")));
        options.add(this.jcAction);
        options.add(this.cbTreeAutoScroll);
        options.add(this.checkBending);
        options.add(this.checkAntialiasing);
        options.add(this.checkMarrSymbols);
        options.add((Component)this.font);
        TreeMetrics m = view.getModel().getMetrics();
        this.spinners[0] = this.createSpinner("indiwidth", options, 0.4, (double)m.wIndis * 0.1, 16.0);
        this.spinners[1] = this.createSpinner("indiheight", options, 0.4, (double)m.hIndis * 0.1, 16.0);
        this.spinners[2] = this.createSpinner("famwidth", options, 0.4, (double)m.wFams * 0.1, 16.0);
        this.spinners[3] = this.createSpinner("famheight", options, 0.4, (double)m.hFams * 0.1, 16.0);
        this.spinners[4] = this.createSpinner("padding", options, 0.4, (double)m.pad * 0.1, 4.0);
        this.colors = new ColorsWidget();
        for (String key : view.getColors().keySet()) {
            this.colors.addColor(key, RESOURCES.getString("color." + key), view.getColors().get(key));
        }
        this.colors.addChangeListener((ChangeListener)this.commit);
        this.bookmarks = new Bookmarks(view.getModel().getBookmarks());
        this.bookmarks.addListDataListener(this.commit);
        this.bList = new JList(this.bookmarks);
        this.bList.setSelectionMode(0);
        this.bList.getModel().addListDataListener(this.commit);
        this.bList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = TreeViewSettings.this.bList.getSelectedIndex();
                int n = TreeViewSettings.this.bookmarks.getSize();
                TreeViewSettings.this.up.setEnabled(i > 0);
                TreeViewSettings.this.down.setEnabled(i >= 0 && i < n - 1);
                TreeViewSettings.this.delete.setEnabled(i >= 0);
            }
        });
        JPanel bPanel = new JPanel((LayoutManager)new NestedBlockLayout("<col><list wx=\"1\" wy=\"1\"/><row><up/><dn/><del/></row></col>"));
        bPanel.add(new JScrollPane(this.bList));
        bPanel.add(new JButton((Action)this.up));
        bPanel.add(new JButton((Action)this.down));
        bPanel.add(new JButton((Action)this.delete));
        this.add(RESOURCES.getString("page.main"), options);
        this.add(RESOURCES.getString("page.colors"), (Component)this.colors);
        this.add(RESOURCES.getString("page.bookmarks"), bPanel);
    }

    private JCheckBox createCheck(String key, boolean checked) {
        JCheckBox result = new JCheckBox(RESOURCES.getString(key), checked);
        result.setToolTipText(RESOURCES.getString(key + ".tip", false));
        result.addActionListener(this.commit);
        return result;
    }

    private JSpinner createSpinner(String key, Container c, double min, double val, double max) {
        val = Math.min(max, Math.max(val, min));
        JSpinner result = new JSpinner(new SpinnerNumberModel(val, min, max, 0.1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(result, "##0.0");
        result.setEditor(editor);
        result.addChangeListener(editor);
        result.setToolTipText(RESOURCES.getString("info." + key + ".tip"));
        result.addChangeListener(this.commit);
        c.add(new JLabel(RESOURCES.getString("info." + key)));
        c.add(result);
        return result;
    }

    public static enum OnAction {
        NONE("tv.action.none"),
        CENTER("tv.action.center"),
        SETROOT("tv.action.setroot");

        private final String description;

        private OnAction(String desc) {
            this.description = RESOURCES.getString(desc);
        }

        public String toString() {
            return this.description;
        }
    }

    private class Commit
    implements ChangeListener,
    ActionListener,
    ListDataListener {
        private final TreeView view;

        private Commit(TreeView view) {
            this.view = view;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeView.setOnAction((OnAction)((Object)TreeViewSettings.this.jcAction.getSelectedItem()));
            TreeView.setAutoScroll(TreeViewSettings.this.cbTreeAutoScroll.isSelected());
            TreeView.setShowPopup(TreeViewSettings.this.cbShowPopup.isSelected());
            this.view.getModel().setBendArcs(TreeViewSettings.this.checkBending.isSelected());
            this.view.setAntialiasing(TreeViewSettings.this.checkAntialiasing.isSelected());
            this.view.setContentFont(TreeViewSettings.this.font.getSelectedFont());
            this.view.getModel().setMarrSymbols(TreeViewSettings.this.checkMarrSymbols.isSelected());
            this.view.getModel().setMetrics(new TreeMetrics((int)((Double)TreeViewSettings.this.spinners[0].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[1].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[2].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[3].getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.spinners[4].getModel().getValue() * 10.0)));
            this.view.setColors(TreeViewSettings.this.colors.getColors());
            this.view.getModel().setBookmarks(TreeViewSettings.this.bookmarks.get());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.actionPerformed(null);
        }
    }

    private class Delete
    extends AbstractAncestrisAction {
        private Delete() {
            this.setText(RESOURCES.getString("bookmark.del"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int i = TreeViewSettings.this.bList.getSelectedIndex();
            TreeViewSettings.this.bookmarks.delete(i);
        }
    }

    private class Move
    extends AbstractAncestrisAction {
        private final int by;

        private Move(int how) {
            this.setText(RESOURCES.getString("bookmark.move." + how));
            this.setEnabled(false);
            this.by = how;
        }

        public void actionPerformed(ActionEvent e) {
            int i = TreeViewSettings.this.bList.getSelectedIndex();
            TreeViewSettings.this.bookmarks.swap(i, i + this.by);
            TreeViewSettings.this.bList.setSelectedIndex(i + this.by);
        }
    }

    private class Bookmarks
    extends AbstractListModel {
        private final ArrayList<Bookmark> list;

        Bookmarks(List<Bookmark> list) {
            this.list = new ArrayList<Bookmark>(list);
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public void swap(int i, int j) {
            if (i == j) {
                return;
            }
            Bookmark b = this.list.get(i);
            this.list.set(i, this.list.get(j));
            this.list.set(j, b);
            this.fireContentsChanged(this, Math.min(i, j), Math.max(i, j));
        }

        public void delete(int i) {
            this.list.remove(i);
            this.fireIntervalRemoved(this, i, i);
        }

        public List<Bookmark> get() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

