/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.tree.Bookmark;
import genj.tree.GridCache;
import genj.tree.ModelListener;
import genj.tree.Parser;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import gj.layout.LayoutException;
import gj.layout.tree.TreeLayout;
import gj.model.Node;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

class Model {
    private Callback callback = new Callback();
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private Collection<TreeArc> arcs = new ArrayList<TreeArc>(100);
    private Map<Entity, TreeNode> entities2nodes = new HashMap<Entity, TreeNode>(100);
    private Collection<TreeNode> nodes = new ArrayList<TreeNode>(100);
    private Rectangle bounds = new Rectangle();
    private GridCache cache = null;
    private boolean isVertical = true;
    private boolean isFamilies = true;
    private boolean isBendArcs = true;
    private boolean isMarrSymbols = true;
    private boolean isFoldSymbols = true;
    private Set<String> hideAncestors = new HashSet<String>();
    private Set<String> hideDescendants = new HashSet<String>();
    private Map<Indi, Fam> indi2fam = new HashMap<Indi, Fam>();
    private Entity root;
    private TreeMetrics metrics = new TreeMetrics(66, 40, 80, 7, 10);
    private LinkedList<Bookmark> bookmarks = new LinkedList();

    public void setRoot(Entity entity) {
        if (this.root == entity) {
            return;
        }
        if (this.root != null) {
            this.root.getGedcom().removeGedcomListener((GedcomListener)this.callback);
            this.root = null;
        }
        if (entity instanceof Indi || entity instanceof Fam) {
            this.root = entity;
            this.root.getGedcom().addGedcomListener((GedcomListener)this.callback);
        }
        this.bookmarks.clear();
        this.update();
    }

    public Entity getRoot() {
        return this.root;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean set) {
        if (this.isVertical == set) {
            return;
        }
        this.isVertical = set;
        this.update();
    }

    public boolean isBendArcs() {
        return this.isBendArcs;
    }

    public void setBendArcs(boolean set) {
        if (this.isBendArcs == set) {
            return;
        }
        this.isBendArcs = set;
        this.update();
    }

    public boolean isFamilies() {
        return this.isFamilies;
    }

    public void setFamilies(boolean set) {
        if (this.isFamilies == set) {
            return;
        }
        this.isFamilies = set;
        this.update();
    }

    public boolean isMarrSymbols() {
        return this.isMarrSymbols;
    }

    public void setMarrSymbols(boolean set) {
        if (this.isMarrSymbols == set) {
            return;
        }
        this.isMarrSymbols = set;
        this.update();
    }

    public void setFoldSymbols(boolean set) {
        if (this.isFoldSymbols == set) {
            return;
        }
        this.isFoldSymbols = set;
        this.update();
    }

    public boolean isFoldSymbols() {
        return this.isFoldSymbols;
    }

    public TreeMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(TreeMetrics set) {
        if (this.metrics.equals(set)) {
            return;
        }
        this.metrics = set;
        this.update();
    }

    public void addListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public Collection<? extends TreeNode> getNodesIn(Rectangle range) {
        if (this.cache == null) {
            return new HashSet();
        }
        return this.cache.get(range);
    }

    public Collection<TreeArc> getArcsIn(Rectangle range) {
        ArrayList<TreeArc> result = new ArrayList<TreeArc>(this.arcs.size());
        for (TreeArc arc : this.arcs) {
            if (arc.getPath() == null || !arc.getPath().intersects((Rectangle2D)range)) continue;
            result.add(arc);
        }
        return result;
    }

    public TreeNode getNodeAt(int x, int y) {
        if (this.cache == null) {
            return null;
        }
        int w = Math.max(this.metrics.wIndis, this.metrics.wFams);
        int h = Math.max(this.metrics.hIndis, this.metrics.hFams);
        Rectangle range = new Rectangle(x - w / 2, y - h / 2, w, h);
        for (TreeNode node : this.cache.get(range)) {
            Shape shape = node.getShape();
            if (shape == null || !shape.getBounds2D().contains(x - node.pos.x, y - node.pos.y)) continue;
            return node;
        }
        return null;
    }

    public Object getContentAt(int x, int y) {
        TreeNode node = this.getNodeAt(x, y);
        return node != null ? node.getContent() : null;
    }

    public Entity getEntityAt(int x, int y) {
        Object content = this.getContentAt(x, y);
        return content instanceof Entity ? (Entity)content : null;
    }

    public TreeNode getNode(Entity e) {
        return this.entities2nodes.get(e);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void addBookmark(Bookmark b) {
        this.bookmarks.addFirst(b);
        if (this.bookmarks.size() > 16) {
            this.bookmarks.removeLast();
        }
    }

    public List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public void setBookmarks(List<Bookmark> set) {
        this.bookmarks.clear();
        this.bookmarks.addAll(set);
    }

    public Collection<String> getHideAncestorsIDs() {
        return this.hideAncestors;
    }

    public void setHideAncestorsIDs(Collection<String> ids) {
        this.hideAncestors.clear();
        this.hideAncestors.addAll(ids);
    }

    public Collection<String> getHideDescendantsIDs() {
        return this.hideDescendants;
    }

    public void setHideDescendantsIDs(Collection<String> ids) {
        this.hideDescendants.clear();
        this.hideDescendants.addAll(ids);
    }

    private Collection<String> getIds(Collection<Entity> entities) {
        ArrayList<String> result = new ArrayList<String>();
        for (Entity e : entities) {
            result.add(e.getId());
        }
        return result;
    }

    boolean isHideDescendants(Indi indi) {
        return this.hideDescendants.contains(indi.getId());
    }

    boolean isHideAncestors(Indi indi) {
        return this.hideAncestors.contains(indi.getId());
    }

    Fam getFamily(Indi indi, Fam[] fams, boolean next) {
        if (fams.length > 0) {
            Fam fam = this.indi2fam.get(indi);
            if (fam == null) {
                fam = fams[0];
            }
            for (int f = 0; f < fams.length; ++f) {
                if (fams[f] != fam) continue;
                return fams[(f + (next ? 1 : 0)) % fams.length];
            }
            this.indi2fam.remove(indi);
        }
        return fams[0];
    }

    TreeNode add(TreeNode node) {
        Object content = node.getContent();
        if (content instanceof Entity) {
            this.entities2nodes.put((Entity)content, node);
        }
        this.nodes.add(node);
        return node;
    }

    TreeArc add(TreeArc arc) {
        this.arcs.add(arc);
        return arc;
    }

    Set getEntities() {
        return this.entities2nodes.keySet();
    }

    private void update() {
        this.arcs.clear();
        this.nodes.clear();
        this.entities2nodes.clear();
        this.bounds.setFrame(0.0, 0.0, 0.0, 0.0);
        if (this.root == null) {
            this.fireStructureChanged();
            return;
        }
        try {
            boolean isFams = this.isFamilies || this.root instanceof Fam;
            Parser descendants = Parser.getInstance(false, isFams, this, this.metrics);
            this.bounds.add(this.layout(descendants.parse(this.root), true));
            this.bounds.add(this.layout(descendants.align(Parser.getInstance(true, isFams, this, this.metrics).parse(this.root)), false));
        }
        catch (LayoutException e) {
            e.printStackTrace();
            this.root = null;
            this.update();
            return;
        }
        this.cache = new GridCache(this.bounds, 3 * this.metrics.calcMax());
        for (TreeNode n : this.nodes) {
            if (n.shape == null) continue;
            this.cache.put((Object)n, n.shape.getBounds(), n.pos);
        }
        this.fireStructureChanged();
    }

    private Rectangle layout(TreeNode root, boolean isTopDown) throws LayoutException {
        double theta = 0.0;
        if (!isTopDown) {
            theta += 180.0;
        }
        if (!this.isVertical) {
            theta -= 90.0;
        }
        TreeLayout layout = new TreeLayout();
        layout.setBendArcs(this.isBendArcs);
        layout.setDebug(false);
        layout.setIgnoreUnreachables(true);
        layout.setBalanceChildren(false);
        layout.setRoot((Node)root);
        layout.setOrientation(theta);
        return layout.layout((Node)root, this.nodes.size()).getBounds();
    }

    private void fireStructureChanged() {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            this.listeners.get(l).structureChanged(this);
        }
    }

    private void fireNodesChanged(Collection nodes) {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            this.listeners.get(l).nodesChanged(this, nodes);
        }
    }

    private class Callback
    extends GedcomListenerAdapter
    implements GedcomMetaListener {
        private Set repaint = new HashSet();
        private boolean update = false;
        private Entity added;

        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            this.added = null;
            this.repaint.clear();
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (Model.this.root == null) {
                if (this.added == null || !gedcom.contains(this.added)) {
                    this.added = gedcom.getFirstEntity("INDI");
                }
                Model.this.root = this.added;
                Model.this.update();
                return;
            }
            if (this.update) {
                Model.this.update();
                return;
            }
            if (!this.repaint.isEmpty()) {
                Model.this.fireNodesChanged(this.repaint);
            }
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity added) {
            if ((added instanceof Fam || added instanceof Indi) && (!(this.added instanceof Indi) || added instanceof Indi)) {
                this.added = added;
            }
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (entity == Model.this.root) {
                Model.this.root = null;
            }
            ListIterator it = Model.this.bookmarks.listIterator();
            while (it.hasNext()) {
                Bookmark b = (Bookmark)it.next();
                if (entity != b.getEntity()) continue;
                it.remove();
            }
            Model.this.indi2fam.keySet().remove(entity);
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.gedcomPropertyChanged(gedcom, added);
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (property instanceof PropertyXRef) {
                this.update = true;
                return;
            }
            TreeNode node = Model.this.getNode(property.getEntity());
            if (node != null) {
                Model.this.fireNodesChanged(Collections.singletonList(node));
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            if (deleted instanceof PropertyXRef) {
                this.update = true;
            }
            if (Model.this.root != null) {
                this.repaint.add(Model.this.getNode(property.getEntity()));
            }
        }
    }

    class FoldUnfold
    implements Runnable {
        private Indi indi;
        private Set<String> set;

        protected FoldUnfold(Indi individual, boolean ancestors) {
            this.indi = individual;
            this.set = ancestors ? Model.this.hideAncestors : Model.this.hideDescendants;
        }

        @Override
        public void run() {
            if (!this.set.remove(this.indi.getId())) {
                this.set.add(this.indi.getId());
            }
            Model.this.update();
        }
    }

    class NextFamily
    implements Runnable {
        private Indi indi;
        private Fam fam;

        protected NextFamily(Indi individual, Fam[] fams) {
            this.indi = individual;
            this.fam = Model.this.getFamily(this.indi, fams, true);
        }

        @Override
        public void run() {
            Model.this.indi2fam.put(this.indi, this.fam);
            Model.this.update();
        }
    }
}

