/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import javax.swing.Icon;

public class CreateSpouse
extends CreateRelationship {
    private Indi spouse;

    public CreateSpouse() {
        this(null);
    }

    public CreateSpouse(Indi spouse) {
        super(resources.getString("create.spouse"), "INDI");
        this.setImage((Icon)Indi.IMG_UNKNOWN);
        this.setContextProperties((Property)spouse);
        this.contextChanged();
    }

    protected final void contextChanged() {
        this.spouse = null;
        if (this.contextProperties.size() == 1 && this.contextProperties.get(0) instanceof Indi) {
            this.spouse = (Indi)this.contextProperties.get(0);
        }
        if (this.spouse != null) {
            this.setEnabled(true);
            this.setTip(this.getDescription());
        } else {
            this.setEnabled(false);
            this.setTip(null);
        }
    }

    @Override
    public String getWarning(Entity target) {
        int n = this.spouse.getNoOfFams();
        if (n > 0) {
            return resources.getString("create.spouse.warning", new Object[]{this.spouse.toString(), "" + n});
        }
        return null;
    }

    @Override
    public String getDescription() {
        return resources.getString("create.spouse.of", new Object[]{this.spouse});
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        Fam[] fams = this.spouse.getFamiliesWhereSpouse();
        Fam fam = null;
        if (fams.length > 0) {
            fam = fams[0];
        }
        if (fam == null || fam.getNoOfSpouses() >= 2) {
            fam = (Fam)this.spouse.getGedcom().createEntity("FAM").addDefaultProperties();
            fam.setSpouse(this.spouse);
        }
        return fam.setSpouse((Indi)target).getTarget();
    }
}

