/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import java.awt.AWTEvent;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractChange
extends AbstractAncestrisContextAction {
    static final Resources resources = Resources.get(AbstractChange.class);
    private Context selection;
    protected static final ImageIcon imgNew = Images.imgNew;
    private JTextArea confirm;

    protected String getConfirmMessage() {
        return null;
    }

    protected JPanel getDialogContent() {
        JPanel result = new JPanel((LayoutManager)new NestedBlockLayout("<col><text wx=\"1\" wy=\"1\"/></col>"));
        result.add(this.getConfirmComponent());
        return result;
    }

    protected JComponent getConfirmComponent() {
        if (this.confirm == null) {
            this.confirm = new TextAreaWidget(this.getConfirmMessage(), 7, 40);
            this.confirm.setWrapStyleWord(true);
            this.confirm.setLineWrap(true);
            this.confirm.setEditable(false);
        }
        return new JScrollPane(this.confirm);
    }

    protected void refresh() {
        if (this.confirm != null) {
            this.confirm.setText(this.getConfirmMessage());
        }
    }

    public void actionPerformedImpl(final ActionEvent event) {
        this.confirm = null;
        String msg = this.getConfirmMessage();
        if (msg != null) {
            String confirmButton = resources.getString("confirm.proceed", new Object[]{this.getText()});
            Object rc = DialogManager.create((String)this.getText(), (JComponent)this.getDialogContent()).setOptions(new Object[]{confirmButton, DialogManager.CANCEL_OPTION}).show();
            if (rc != confirmButton) {
                return;
            }
        }
        try {
            this.getGedcom().doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    AbstractChange.this.selection = AbstractChange.this.execute(gedcom, event);
                }
            });
        }
        catch (Throwable t) {
            DialogManager.createError(null, (String)t.getMessage()).show();
        }
        if (this.selection != null) {
            SelectionDispatcher.fireSelection((AWTEvent)event, (Context)this.selection);
        }
    }

    protected abstract Context execute(Gedcom var1, ActionEvent var2) throws GedcomException;
}

