/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.ArrayList;

public class ReportTopNames
extends Report {
    public boolean showAllNames = true;
    private String textTitle = this.translate("title");
    private String textFileName = this.translate("filename");
    private String textDate = this.translate("date");
    private String textGivenNames = this.translate("givennames");
    private String textSurnames = this.translate("surnames");

    public void start(Gedcom gedcom) {
        this.displayHeader(gedcom.getName());
        this.outputReport(gedcom);
    }

    public void displayHeader(String strSubject) {
        String strULine = "";
        this.println(this.textTitle);
        for (int loop = 0; loop < this.textTitle.length(); ++loop) {
            strULine = strULine + "=";
        }
        this.println(strULine);
        this.println();
        this.println(this.textFileName + ": " + strSubject);
        this.println(this.textDate + ": " + PointInTime.getNow().toString());
        this.println();
    }

    public void outputReport(Gedcom gedcom) {
        float percent;
        boolean flagSwapped;
        class ObjRec {
            String strName;
            int count;

            public ObjRec(String str, int i) {
                this.strName = str;
                this.count = i;
            }

            public void inccounter() {
                ++this.count;
            }
        }
        ObjRec objTemp;
        int loop;
        ArrayList<ObjRec> alGiven = new ArrayList<ObjRec>();
        ArrayList<ObjRec> alSurname = new ArrayList<ObjRec>();
        Entity[] individuals = gedcom.getEntities("INDI", "");
        int numIndis = individuals.length;
        for (loop = 0; loop < individuals.length; ++loop) {
            int loop2;
            boolean flagFound;
            Indi person = (Indi)individuals[loop];
            String strGiven = person.getFirstName();
            String strSurname = person.getLastName();
            int firstSpace = strGiven.indexOf(" ");
            if (firstSpace != -1) {
                strGiven = strGiven.substring(0, firstSpace);
            }
            if (alGiven.isEmpty()) {
                objTemp = new ObjRec(strGiven, 1);
                alGiven.add(objTemp);
            } else {
                flagFound = false;
                for (loop2 = 0; loop2 < alGiven.size(); ++loop2) {
                    if (!((ObjRec)alGiven.get((int)loop2)).strName.equals(strGiven)) continue;
                    ((ObjRec)alGiven.get(loop2)).inccounter();
                    flagFound = true;
                }
                if (!flagFound) {
                    objTemp = new ObjRec(strGiven, 1);
                    alGiven.add(objTemp);
                }
            }
            if (alSurname.isEmpty()) {
                objTemp = new ObjRec(strSurname, 1);
                alSurname.add(objTemp);
                continue;
            }
            flagFound = false;
            for (loop2 = 0; loop2 < alSurname.size(); ++loop2) {
                if (!((ObjRec)alSurname.get((int)loop2)).strName.equals(strSurname)) continue;
                ((ObjRec)alSurname.get(loop2)).inccounter();
                flagFound = true;
            }
            if (flagFound) continue;
            objTemp = new ObjRec(strSurname, 1);
            alSurname.add(objTemp);
        }
        do {
            flagSwapped = false;
            for (loop = 1; loop < alGiven.size(); ++loop) {
                if (((ObjRec)alGiven.get((int)loop)).count <= ((ObjRec)alGiven.get((int)(loop - 1))).count) continue;
                objTemp = (ObjRec)alGiven.get(loop - 1);
                alGiven.set(loop - 1, (ObjRec)alGiven.get(loop));
                alGiven.set(loop, objTemp);
                flagSwapped = true;
            }
        } while (flagSwapped);
        do {
            flagSwapped = false;
            for (loop = 1; loop < alSurname.size(); ++loop) {
                if (((ObjRec)alSurname.get((int)loop)).count <= ((ObjRec)alSurname.get((int)(loop - 1))).count) continue;
                objTemp = (ObjRec)alSurname.get(loop - 1);
                alSurname.set(loop - 1, (ObjRec)alSurname.get(loop));
                alSurname.set(loop, objTemp);
                flagSwapped = true;
            }
        } while (flagSwapped);
        this.println(this.textGivenNames);
        String strULine = "";
        for (loop = 0; loop < this.textGivenNames.length(); ++loop) {
            strULine = strULine + "-";
        }
        this.println(strULine);
        int maxNames = this.showAllNames ? alGiven.size() : (alGiven.size() < 20 ? alGiven.size() : 20);
        for (loop = 0; loop < maxNames; ++loop) {
            percent = (float)((ObjRec)alGiven.get((int)loop)).count / (float)numIndis * 100.0f;
            this.println(ReportTopNames.align((String)((ObjRec)alGiven.get((int)loop)).strName, (int)20, (int)3) + ReportTopNames.align((String)Integer.toString(((ObjRec)alGiven.get((int)loop)).count), (int)6, (int)2) + "  -  " + Float.toString(percent).substring(0, 4) + "%");
        }
        this.println();
        this.println(this.textSurnames);
        strULine = "";
        for (loop = 0; loop < this.textSurnames.length(); ++loop) {
            strULine = strULine + "-";
        }
        this.println(strULine);
        maxNames = this.showAllNames ? alSurname.size() : (alSurname.size() < 20 ? alSurname.size() : 20);
        for (loop = 0; loop < maxNames; ++loop) {
            percent = (float)((ObjRec)alSurname.get((int)loop)).count / (float)numIndis * 100.0f;
            this.println(ReportTopNames.align((String)((ObjRec)alSurname.get((int)loop)).strName, (int)20, (int)3) + ReportTopNames.align((String)Integer.toString(((ObjRec)alSurname.get((int)loop)).count), (int)6, (int)2) + "  -  " + Float.toString(percent).substring(0, 4) + "%");
        }
    }
}

