/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.fo.Document;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ReportFlashList
extends Report {
    private static final TagPath CITY = new TagPath(".:ADDR:CITY");
    private static final String FORMAT_LNORMAL = "font-weight=normal,text-align=left";
    private static final String FORMAT_CNORMAL = "font-weight=normal,text-align=center";
    private static final String FORMAT_RNORMAL = "font-weight=normal,text-align=right";
    private static final String FORMAT_LSTRONG = "font-weight=bold,text-align=left";
    private static final String FORMAT_CSTRONG = "font-weight=bold,text-align=center";
    private static final String FORMAT_RSTRONG = "font-weight=bold,text-align=right";
    private static final String FORMAT_CBACKGROUND = "background-color=#ffffcc,font-weight=bold,text-align=center";
    private static final String FORMAT_RBACKGROUND = "background-color=#ffffcc,font-weight=bold,text-align=right";
    public boolean weAddaTOC = true;
    public int displayLegend = 2;
    private static final int LEGEND_NO = 0;
    private static final int LEGEND_TOP = 1;
    private static final int LEGEND_BOT = 2;
    public String[] displayLegends = new String[]{this.translate("legendNone"), this.translate("legendTop"), this.translate("legendBot")};
    public String FilterKey1 = "*";
    public String FilterKey2 = "*";
    public String FilterKey3 = "*";
    public boolean repeatHeader = true;
    public boolean repeatKeys = false;
    public boolean displayZeros = false;
    public int nbEvents = 3;
    public int yearSpan = 50;
    public int minSosa = 1;
    public int counterIncrement = 2;
    public String[] counterIncrements = new String[]{this.translate("DoNotShow"), "10", "100", "1000", "10000"};
    private int posLoc1 = 0;
    private int posLoc2 = 2;
    private int posLoc3 = 4;
    private boolean existPLACTag = true;
    private static final int LOC12_SURN_LOC3 = 0;
    private static final int LOC12_LOC3_SURN = 1;
    private static final int SURN_LOC12_LOC3 = 2;
    private static final int SURN_LOC1_LOC23 = 3;
    private static final int LOC1_LOC23_SURN = 4;
    private static final int LOC1_SURN_LOC23 = 5;
    private int recordKey = 0;
    private String recordKeyText = "";

    public Document start(Gedcom gedcom) {
        return this.start(gedcom, gedcom.getEntities("INDI"), null);
    }

    public Document start(Indi[] indis) {
        return this.start(indis[0].getGedcom(), Arrays.asList(indis), null);
    }

    public Document start(Indi indi) {
        return this.start(indi.getGedcom(), indi.getGedcom().getEntities("INDI"), indi);
    }

    private Document start(Gedcom gedcom, Collection indis, Indi indiDeCujus) {
        String msg;
        if (!this.getFlashOptions(gedcom)) {
            return null;
        }
        if (indiDeCujus == null && (indiDeCujus = (Indi)this.getEntityFromUser(msg = this.translate("AskDeCujus"), gedcom, "INDI")) == null) {
            return null;
        }
        TreeMap<String, Object> primary = new TreeMap<String, Object>();
        int countIndiv = 0;
        this.counterIncrement = (int)Math.pow(10.0, this.counterIncrement);
        this.println(this.translate("StartingAnalysis"));
        Iterator it = indis.iterator();
        while (it.hasNext()) {
            this.analyze((Indi)it.next(), primary, indiDeCujus);
            if (this.counterIncrement <= 1 || (int)Math.floor(++countIndiv / this.counterIncrement) * this.counterIncrement != countIndiv) continue;
            this.println(String.valueOf(countIndiv));
        }
        if (this.counterIncrement > 1) {
            this.println(this.translate("NowWriting") + "...");
        }
        Document doc = new Document(this.getName());
        if (this.weAddaTOC) {
            doc.addTOC();
            if (primary.size() > 10) {
                doc.nextPage();
            }
        }
        if (this.displayLegend == 1) {
            this.displayLegend(doc);
        }
        if (!this.repeatHeader) {
            this.displayHeader(doc, null, true);
            doc.endTable();
        }
        for (String p : primary.keySet()) {
            doc.startSection(p, p.replaceAll(" ", "%").replaceAll("/", "%").replaceAll(",", "%"));
            this.displayHeader(doc, p, this.repeatHeader);
            String secondaryKey = "";
            Map secondary = (Map)this.lookup(primary, p, null);
            for (String s : secondary.keySet()) {
                Map tertiary = (Map)this.lookup(secondary, s, null);
                for (String t : tertiary.keySet()) {
                    Range range = (Range)this.lookup(tertiary, t, null);
                    String lformat = FORMAT_LNORMAL;
                    String cformat = FORMAT_CNORMAL;
                    String rformat = FORMAT_RNORMAL;
                    if (range.getNbEvents() >= this.nbEvents || range.getYearSpan() >= this.yearSpan || range.getValueSosa() >= this.minSosa) {
                        lformat = FORMAT_LSTRONG;
                        cformat = FORMAT_CSTRONG;
                        rformat = FORMAT_RSTRONG;
                    }
                    doc.nextTableRow(lformat);
                    if (this.repeatKeys || secondaryKey != s) {
                        doc.addText(s);
                    } else {
                        doc.addText(" ");
                    }
                    if (secondaryKey != s) {
                        secondaryKey = s;
                    }
                    doc.nextTableCell(lformat);
                    doc.addText(t);
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbSosa == 0 ? "-" : range.getNbSosa());
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbBirth == 0 ? "-" : range.getNbBirth());
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbChris == 0 ? "-" : range.getNbChris());
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbMarr == 0 ? "-" : range.getNbMarr());
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbDeath == 0 ? "-" : range.getNbDeath());
                    doc.nextTableCell(rformat);
                    doc.addText(!this.displayZeros && range.nbOther == 0 ? "-" : range.getNbOther());
                    doc.nextTableCell(cformat);
                    doc.addText(range.getFirst());
                    doc.nextTableCell(cformat);
                    doc.addText(range.getLast());
                }
            }
            doc.endTable();
        }
        if (this.displayLegend == 2) {
            this.displayLegend(doc);
        }
        this.println(this.translate("Completed"));
        return doc;
    }

    private boolean getFlashOptions(Gedcom gedcom) {
        if (gedcom.getPlaceFormat() == "") {
            Object[] choices = new String[]{this.translate("SurnLoc"), this.translate("LocSurn")};
            this.recordKeyText = (String)this.getValueFromUser(this.translate("recordKey"), choices, choices[0]);
            this.existPLACTag = false;
            if (this.recordKeyText == null) {
                return false;
            }
            this.recordKey = this.recordKeyText.compareTo(this.translate("LocSurn")) == 0 ? 5 : 3;
        } else {
            Object[] recordKeys = new String[]{this.translate("loc1") + "/" + this.translate("loc2") + " > " + this.translate("surname") + " > " + this.translate("loc3"), this.translate("loc1") + "/" + this.translate("loc2") + " > " + this.translate("loc3") + " > " + this.translate("surname"), this.translate("surname") + " > " + this.translate("loc1") + "/" + this.translate("loc2") + " > " + this.translate("loc3"), this.translate("surname") + " > " + this.translate("loc1") + " > " + this.translate("loc2") + "/" + this.translate("loc3"), this.translate("loc1") + " -> " + this.translate("loc2") + "/" + this.translate("loc3") + " > " + this.translate("surname"), this.translate("loc1") + " -> " + this.translate("surname") + " > " + this.translate("loc2") + "/" + this.translate("loc3")};
            this.recordKeyText = (String)this.getValueFromUser(this.translate("recordKey"), recordKeys, recordKeys[0]);
            if (this.recordKeyText == null) {
                return false;
            }
            List<Object> table = Arrays.asList(recordKeys);
            this.recordKey = table.indexOf(this.recordKeyText);
            List<String> tag = Arrays.asList(gedcom.getPlaceFormat().split("\\,"));
            ArrayList<String> choices = new ArrayList<String>(Arrays.asList(gedcom.getPlaceFormat().split("\\,")));
            this.recordKeyText = this.recordKeyText.replaceAll(this.translate("loc1"), "XXX");
            String selection1 = (String)this.getValueFromUser(this.translate("recordKey1") + " " + this.recordKeyText, choices.toArray(), choices.get(0));
            if (selection1 == null) {
                return false;
            }
            choices.remove(choices.indexOf(selection1));
            this.recordKeyText = this.recordKeyText.replaceAll("XXX", selection1);
            this.recordKeyText = this.recordKeyText.replaceAll(this.translate("loc2"), "XXX");
            String selection2 = (String)this.getValueFromUser(this.translate("recordKey2") + " " + this.recordKeyText, choices.toArray(), choices.get(0));
            if (selection2 == null) {
                return false;
            }
            choices.remove(choices.indexOf(selection2));
            this.recordKeyText = this.recordKeyText.replaceAll("XXX", selection2);
            this.recordKeyText = this.recordKeyText.replaceAll(this.translate("loc3"), "XXX");
            String selection3 = (String)this.getValueFromUser(this.translate("recordKey3") + " " + this.recordKeyText, choices.toArray(), choices.get(0));
            if (selection3 == null) {
                return false;
            }
            choices.remove(choices.indexOf(selection3));
            this.recordKeyText = this.recordKeyText.replaceAll("XXX", selection3);
            int[] list = new int[]{tag.indexOf(selection1), tag.indexOf(selection2), tag.indexOf(selection3)};
            this.posLoc1 = list[0];
            this.posLoc2 = list[1];
            this.posLoc3 = list[2];
            this.existPLACTag = true;
        }
        return true;
    }

    private void displayLegend(Document doc) {
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.startSection(this.translate("legendText"), "legend");
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(this.translate("recordKey") + " " + this.recordKeyText);
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(this.translate("legendS"));
        doc.nextParagraph();
        doc.addText(this.translate("legendB"));
        doc.nextParagraph();
        doc.addText(this.translate("legendC"));
        doc.nextParagraph();
        doc.addText(this.translate("legendM"));
        doc.nextParagraph();
        doc.addText(this.translate("legendD"));
        doc.nextParagraph();
        doc.addText(this.translate("legendO"));
        doc.nextParagraph();
        doc.addText(this.translate("legendMin"));
        doc.nextParagraph();
        doc.addText(this.translate("legendMax"));
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
    }

    private void displayHeader(Document doc, String name, boolean dHeader) {
        if (name != null) {
            doc.startTable("genj:csv=true,genj:csvprefix=" + name + ",width=100%");
        } else {
            doc.startTable("width=100%");
        }
        doc.addTableColumn("column-width=30%");
        doc.addTableColumn("column-width=23%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=10%");
        doc.addTableColumn("column-width=7%");
        if (dHeader) {
            doc.nextTableRow();
            doc.addText(" ");
            doc.nextTableCell();
            doc.addText(" ");
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colS"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colB"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colC"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colM"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colD"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(this.translate("colO"));
            doc.nextTableCell(FORMAT_CBACKGROUND);
            doc.addText(this.translate("colMin"));
            doc.nextTableCell(FORMAT_CBACKGROUND);
            doc.addText(this.translate("colMax"));
        }
    }

    private void analyze(Indi indi, Map primary, Indi indiDeCujus) {
        String name = indi.getLastName();
        if (name.length() == 0) {
            return;
        }
        name = name.trim();
        boolean isSosa = indi.isAncestorOf(indiDeCujus);
        if (indi == indiDeCujus) {
            isSosa = true;
        }
        try {
            for (PropertyDate date : indi.getProperties(PropertyDate.class)) {
                int end;
                if (!date.isValid()) continue;
                int start = 0;
                start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                int n = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : start;
                if (start > end) continue;
                this.analyzePlaces(name, start, end, date.getParent(), primary, isSosa);
                this.analyzeCities(name, start, end, date.getParent(), primary, isSosa);
            }
            for (Fam family : Arrays.asList(indi.getFamiliesWhereSpouse())) {
                for (PropertyDate date : family.getProperties(PropertyDate.class)) {
                    int end;
                    if (!date.isValid()) continue;
                    int start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    int n = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : start;
                    if (start > end) continue;
                    this.analyzePlaces(name, start, end, date.getParent(), primary, isSosa);
                    this.analyzeCities(name, start, end, date.getParent(), primary, isSosa);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void analyzeCities(String name, int start, int end, Property prop, Map primary, boolean isSosa) {
        if (!this.isEvent(prop)) {
            return;
        }
        Property[] cities = prop.getProperties(CITY);
        for (int c = 0; c < cities.length; ++c) {
            String loc1 = cities[c].getDisplayValue().trim();
            if (loc1.length() == 0) continue;
            String loc2 = "";
            String loc3 = "";
            if (this.existPLACTag) {
                loc2 = "-";
                loc3 = "-";
            }
            this.keep(loc1, loc2, loc3, name, start, end, primary, prop, isSosa);
        }
    }

    private void analyzePlaces(String name, int start, int end, Property prop, Map primary, boolean isSosa) {
        if (!this.isEvent(prop)) {
            return;
        }
        for (PropertyPlace place : prop.getProperties(PropertyPlace.class)) {
            String loc1 = "";
            String loc2 = "";
            String loc3 = "";
            if (this.existPLACTag) {
                loc1 = place.getJurisdiction(this.posLoc1);
                loc2 = place.getJurisdiction(this.posLoc2);
                loc3 = place.getJurisdiction(this.posLoc3);
                if (loc1 != null) {
                    loc1 = loc1.trim();
                }
                if (loc2 != null) {
                    loc2 = loc2.trim();
                }
                if (loc3 != null) {
                    loc3 = loc3.trim();
                }
                if (loc1 == null || loc1.length() == 0) {
                    loc1 = "-";
                }
                if (loc2 == null || loc2.length() == 0) {
                    loc2 = "-";
                }
                if (loc3 == null || loc3.length() == 0) {
                    loc3 = "-";
                }
                if (loc1 == "-" && loc2 == "-" && loc3 == "-") {
                    continue;
                }
            } else {
                loc1 = place.getFirstAvailableJurisdiction().trim();
                if (loc1.length() == 0) continue;
            }
            this.keep(loc1, loc2, loc3, name, start, end, primary, prop, isSosa);
        }
    }

    private boolean isEvent(Property prop) {
        String[] strTable = new String[]{"ADOP", "ANUL", "BIRT", "BAPM", "BARM", "BASM", "BLES", "BURI", "CENS", "CHR", "CHRA", "CONF", "CREM", "DEAT", "DIV", "DIVF", "EMIG", "ENGA", "EVEN", "FCOM", "GRAD", "IMMI", "MARR", "MARB", "MARC", "MARL", "MARS", "NATU", "ORDN", "RETI", "PROB", "WILL"};
        List<String> listOfEvents = Arrays.asList(strTable);
        return listOfEvents.contains(prop.getTag());
    }

    private void keep(String loc1, String loc2, String loc3, String name, int start, int end, Map primary, Property prop, boolean isSosa) {
        String ts;
        String ss;
        String ps;
        switch (this.recordKey) {
            case 0: {
                ps = loc1 + "/" + loc2;
                ss = name;
                ts = loc3;
                break;
            }
            case 1: {
                ps = loc1 + "/" + loc2;
                ss = loc3;
                ts = name;
                break;
            }
            case 2: {
                ps = name;
                ss = loc1 + "/" + loc2;
                ts = loc3;
                break;
            }
            case 3: {
                ps = name;
                ss = loc1;
                ts = loc2 + "/" + loc3;
                break;
            }
            case 4: {
                ps = loc1;
                ss = loc2 + "/" + loc3;
                ts = name;
                break;
            }
            case 5: {
                ps = loc1;
                ss = name;
                ts = loc2 + "/" + loc3;
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        if (this.FilterKey1.trim().compareTo("*") != 0 && ps.toUpperCase().indexOf(this.FilterKey1.toUpperCase()) == -1) {
            return;
        }
        if (this.FilterKey2.trim().compareTo("*") != 0 && ss.toUpperCase().indexOf(this.FilterKey2.toUpperCase()) == -1) {
            return;
        }
        if (this.FilterKey3.trim().compareTo("*") != 0 && ts.toUpperCase().indexOf(this.FilterKey3.toUpperCase()) == -1) {
            return;
        }
        if (!this.existPLACTag) {
            ts = "";
        }
        Map secondary = (Map)this.lookup(primary, ps, TreeMap.class);
        Map tertiary = (Map)this.lookup(secondary, ss, TreeMap.class);
        Range range = (Range)this.lookup(tertiary, ts, Range.class);
        range.add(start, end, isSosa, prop.getTag());
    }

    private Object lookup(Map<String, Object> index, String key, Class fallback) {
        Object result = index.get(key);
        if (result == null) {
            try {
                result = fallback.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IllegalArgumentException("can't instantiate fallback " + fallback);
            }
            index.put(key, result);
        }
        return result;
    }

    static class Range {
        int firstYear = Integer.MAX_VALUE;
        int lastYear = -2147483647;
        int nbSosa = 0;
        int nbBirth = 0;
        int nbChris = 0;
        int nbMarr = 0;
        int nbDeath = 0;
        int nbOther = 0;
        double geoLat = 0.0;
        double geoLon = 0.0;

        Range() {
        }

        void add(int start, int end, boolean isSosa, String tag) {
            if (start != Integer.MAX_VALUE) {
                this.firstYear = Math.min(this.firstYear, start);
            }
            if (end != Integer.MAX_VALUE) {
                this.lastYear = Math.max(this.lastYear, end);
            }
            if (isSosa) {
                ++this.nbSosa;
            }
            if (tag == "BIRT") {
                ++this.nbBirth;
            } else if (tag == "CHR") {
                ++this.nbChris;
            } else if (tag == "MARR") {
                ++this.nbMarr;
            } else if (tag == "DEAT") {
                ++this.nbDeath;
            } else {
                ++this.nbOther;
            }
        }

        void add(Range rangeElt) {
            this.firstYear = Math.min(this.firstYear, rangeElt.getValueFirst());
            this.lastYear = Math.max(this.lastYear, rangeElt.getValueLast());
            this.nbSosa += rangeElt.getValueSosa();
            this.nbBirth += rangeElt.getValueBirth();
            this.nbChris += rangeElt.getValueChris();
            this.nbMarr += rangeElt.getValueMarr();
            this.nbDeath += rangeElt.getValueDeath();
            this.nbOther += rangeElt.getValueOther();
        }

        void setGeo(double lat, double lon) {
            this.geoLat = lat;
            this.geoLon = lon;
        }

        String getFirst() {
            if (this.firstYear == Integer.MAX_VALUE || this.lastYear == Integer.MAX_VALUE) {
                return "";
            }
            return Integer.toString(this.firstYear);
        }

        String getLast() {
            return Integer.toString(this.lastYear);
        }

        String getNbSosa() {
            return Integer.toString(this.nbSosa);
        }

        String getNbBirth() {
            return Integer.toString(this.nbBirth);
        }

        String getNbChris() {
            return Integer.toString(this.nbChris);
        }

        String getNbMarr() {
            return Integer.toString(this.nbMarr);
        }

        String getNbDeath() {
            return Integer.toString(this.nbDeath);
        }

        String getNbOther() {
            return Integer.toString(this.nbOther);
        }

        int getNbEvents() {
            return this.nbBirth + this.nbChris + this.nbMarr + this.nbDeath + this.nbOther;
        }

        int getYearSpan() {
            return this.lastYear - this.firstYear;
        }

        int getValueFirst() {
            return this.firstYear;
        }

        int getValueLast() {
            return this.lastYear;
        }

        int getValueSosa() {
            return this.nbSosa;
        }

        int getValueBirth() {
            return this.nbBirth;
        }

        int getValueChris() {
            return this.nbChris;
        }

        int getValueMarr() {
            return this.nbMarr;
        }

        int getValueDeath() {
            return this.nbDeath;
        }

        int getValueOther() {
            return this.nbOther;
        }

        double getValueLat() {
            return this.geoLat;
        }

        double getValueLon() {
            return this.geoLon;
        }
    }
}

