/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.servlet.ServletContextURIResolver;

public class FopServlet
extends HttpServlet {
    protected static final String FO_REQUEST_PARAM = "fo";
    protected static final String XML_REQUEST_PARAM = "xml";
    protected static final String XSLT_REQUEST_PARAM = "xslt";
    protected SimpleLog log = null;
    protected TransformerFactory transFactory = null;
    protected URIResolver uriResolver;

    public void init() throws ServletException {
        this.log = new SimpleLog("FOP/Servlet");
        this.log.setLevel(4);
        this.uriResolver = new ServletContextURIResolver(this.getServletContext());
        this.transFactory = TransformerFactory.newInstance();
        this.transFactory.setURIResolver(this.uriResolver);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String foParam = request.getParameter(FO_REQUEST_PARAM);
            String xmlParam = request.getParameter(XML_REQUEST_PARAM);
            String xsltParam = request.getParameter(XSLT_REQUEST_PARAM);
            byte[] content = null;
            if (foParam != null) {
                content = this.renderFO(foParam);
            } else if (xmlParam != null && xsltParam != null) {
                content = this.renderXML(xmlParam, xsltParam);
            } else {
                PrintWriter out = response.getWriter();
                out.println("<html><head><title>Error</title></head>\n<body><h1>FopServlet Error</h1><h3>No 'fo' request param given.</body></html>");
            }
            if (content != null) {
                response.setContentType("application/pdf");
                response.setContentLength(content.length);
                response.getOutputStream().write(content);
                response.getOutputStream().flush();
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected Source convertString2Source(String param) {
        return new StreamSource(new File(param));
    }

    protected byte[] renderFO(String fo) throws FOPException, TransformerException {
        Source foSrc = this.convertString2Source(fo);
        Transformer transformer = this.transFactory.newTransformer();
        transformer.setURIResolver(this.uriResolver);
        return this.render(foSrc, transformer);
    }

    protected byte[] renderXML(String xml, String xslt) throws FOPException, TransformerException {
        Source xmlSrc = this.convertString2Source(xml);
        Source xsltSrc = this.convertString2Source(xslt);
        Transformer transformer = this.transFactory.newTransformer(xsltSrc);
        transformer.setURIResolver(this.uriResolver);
        return this.render(xmlSrc, transformer);
    }

    protected byte[] render(Source src, Transformer transformer) throws FOPException, TransformerException {
        Fop fop = new Fop("application/pdf", this.getFOUserAgent());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        fop.setOutputStream((OutputStream)out);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        return out.toByteArray();
    }

    protected FOUserAgent getFOUserAgent() {
        FOUserAgent userAgent = new FOUserAgent();
        userAgent.setURIResolver(this.uriResolver);
        return userAgent;
    }
}

