/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.beans.ADateBean;
import ancestris.modules.editors.genealogyeditor.editors.SourceEditor;
import ancestris.modules.editors.genealogyeditor.models.ConfidenceLevelComboBoxModel;
import ancestris.modules.editors.genealogyeditor.models.EventsRoleComboBoxModel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourcesTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SourceCitationEditorPanel
extends JPanel {
    private Property mRoot;
    private Source mReferencedSource = null;
    private Property mSourceCitation = null;
    private boolean mEventTypeModified = false;
    private boolean mEventRoleModified = false;
    private boolean mDataQualityModified = false;
    private boolean mSourceTextModified = false;
    private boolean mSourceReferencedTitleModified = false;
    private boolean mPageModified = false;
    private final String[] mEventsTags = new String[]{"ADOP", "BIRT", "BAPM", "BARM", "BASM", "BLES", "BURI", "CENS", "CHR", "CHRA", "CONF", "CREM", "DEAT", "EMIG", "FCOM", "GRAD", "IMMI", "NATU", "ORDN", "RETI", "PROB", "WILL", "ANUL", "CENS", "DIV", "DIVF", "ENGA", "MARR", "MARB", "MARC", "MARL", "MARS", "EVEN"};
    private final DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel<String>(new String[0]);
    private JPanel SourceDataPanel;
    private JPanel SourceReferencePanel;
    private JButton addSourceButton;
    private JComboBox<String> dataQualityComboBox;
    private JButton editSourceButton;
    private JComboBox<String> eventRoleComboBox;
    private JLabel eventRoleLabel;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton linkToSourceButton;
    private JPanel multiMediaPanel;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JLabel pageLabel;
    private JTextField pageTextField;
    private ADateBean recordingDate;
    private JLabel recordingDateLabel;
    private JComboBox referencedEventComboBox;
    private JLabel referencedEventLabel;
    private JTabbedPane sourceCitationTabbedPane;
    private JScrollPane sourceDataScrollPane;
    private JTextArea sourceDataTextArea;
    private JLabel sourceReferencedTitleLabel;
    private JTextArea sourceReferencedTitleTextArea;

    public SourceCitationEditorPanel() {
        ArrayList<String> localizedEventsList = new ArrayList<String>();
        for (String tag : this.mEventsTags) {
            localizedEventsList.add(PropertyTag2Name.getTagName(tag));
        }
        Collections.sort(localizedEventsList);
        this.mEventsModel.removeAllElements();
        this.mEventsModel.addElement("");
        for (String tag : localizedEventsList) {
            this.mEventsModel.addElement(tag);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.SourceReferencePanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.sourceReferencedTitleLabel = new JLabel();
        this.addSourceButton = new JButton();
        this.editSourceButton = new JButton();
        this.linkToSourceButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sourceReferencedTitleTextArea = new JTextArea();
        this.referencedEventComboBox = new JComboBox();
        this.referencedEventLabel = new JLabel();
        this.pageLabel = new JLabel();
        this.pageTextField = new JTextField();
        this.eventRoleLabel = new JLabel();
        this.eventRoleComboBox = new JComboBox();
        this.recordingDateLabel = new JLabel();
        this.recordingDate = new ADateBean();
        this.jLabel5 = new JLabel();
        this.dataQualityComboBox = new JComboBox();
        this.sourceCitationTabbedPane = new JTabbedPane();
        this.SourceDataPanel = new JPanel();
        this.sourceDataScrollPane = new JScrollPane();
        this.sourceDataTextArea = new JTextArea();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.multiMediaPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.sourceReferencedTitleLabel.setHorizontalAlignment(0);
        this.sourceReferencedTitleLabel.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.sourceReferencedTitleLabel.text"));
        this.addSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourceCitationEditorPanel.addSourceButton.toolTipText"), new Object[0]));
        this.addSourceButton.setFocusable(false);
        this.addSourceButton.setHorizontalTextPosition(0);
        this.addSourceButton.setMaximumSize(new Dimension(26, 26));
        this.addSourceButton.setMinimumSize(new Dimension(26, 26));
        this.addSourceButton.setPreferredSize(new Dimension(26, 26));
        this.addSourceButton.setVerticalTextPosition(3);
        this.addSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.addSourceButtonActionPerformed(evt);
            }
        });
        this.editSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourceCitationEditorPanel.editSourceButton.toolTipText"), new Object[0]));
        this.editSourceButton.setFocusable(false);
        this.editSourceButton.setHorizontalTextPosition(0);
        this.editSourceButton.setMaximumSize(new Dimension(26, 26));
        this.editSourceButton.setMinimumSize(new Dimension(26, 26));
        this.editSourceButton.setPreferredSize(new Dimension(26, 26));
        this.editSourceButton.setVerticalTextPosition(3);
        this.editSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.editSourceButtonActionPerformed(evt);
            }
        });
        this.linkToSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourceCitationEditorPanel.linkToSourceButton.toolTipText"), new Object[0]));
        this.linkToSourceButton.setFocusable(false);
        this.linkToSourceButton.setHorizontalTextPosition(0);
        this.linkToSourceButton.setMaximumSize(new Dimension(26, 26));
        this.linkToSourceButton.setMinimumSize(new Dimension(26, 26));
        this.linkToSourceButton.setPreferredSize(new Dimension(26, 26));
        this.linkToSourceButton.setVerticalTextPosition(3);
        this.linkToSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.linkToSourceButtonActionPerformed(evt);
            }
        });
        this.sourceReferencedTitleTextArea.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.sourceReferencedTitleTextArea.setColumns(20);
        this.sourceReferencedTitleTextArea.setLineWrap(true);
        this.sourceReferencedTitleTextArea.setRows(2);
        this.sourceReferencedTitleTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.sourceReferencedTitleTextArea);
        this.referencedEventComboBox.setModel(this.mEventsModel);
        this.referencedEventComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.referencedEventComboBoxActionPerformed(evt);
            }
        });
        this.referencedEventLabel.setHorizontalAlignment(4);
        this.referencedEventLabel.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.referencedEventLabel.text"));
        this.pageLabel.setHorizontalAlignment(4);
        this.pageLabel.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.pageLabel.text"));
        this.pageTextField.setColumns(4);
        this.pageTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mPageModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mPageModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mPageModified = true;
            }
        });
        this.pageTextField.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.pageTextField.toolTipText"));
        this.eventRoleLabel.setHorizontalAlignment(4);
        this.eventRoleLabel.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.eventRoleLabel.text"));
        this.eventRoleComboBox.setEditable(true);
        this.eventRoleComboBox.setModel(new EventsRoleComboBoxModel());
        this.eventRoleComboBox.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.eventRoleComboBox.toolTipText"));
        this.eventRoleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.eventRoleComboBoxActionPerformed(evt);
            }
        });
        this.recordingDateLabel.setHorizontalAlignment(4);
        this.recordingDateLabel.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.recordingDateLabel.text"));
        this.recordingDate.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.recordingDate.toolTipText"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.jLabel5.text"));
        this.dataQualityComboBox.setModel(new ConfidenceLevelComboBoxModel());
        this.dataQualityComboBox.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.dataQualityComboBox.toolTipText"));
        this.dataQualityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceCitationEditorPanel.this.dataQualityComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sourceReferencedTitleLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addSourceButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linkToSourceButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editSourceButton, -2, -1, -2)).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.referencedEventLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.eventRoleLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventRoleComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.referencedEventComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.dataQualityComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.recordingDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.pageLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.recordingDate, -1, -1, Short.MAX_VALUE).addComponent(this.pageTextField))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sourceReferencedTitleLabel).addComponent(this.linkToSourceButton, -2, -1, -2).addComponent(this.editSourceButton, -2, -1, -2).addComponent(this.addSourceButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.referencedEventLabel).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pageTextField, -2, -1, -2).addComponent(this.referencedEventComboBox, -2, -1, -2).addComponent(this.pageLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eventRoleLabel).addComponent(this.eventRoleComboBox, -2, -1, -2).addComponent(this.recordingDateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.dataQualityComboBox, -2, -1, -2))).addComponent((Component)this.recordingDate, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout SourceReferencePanelLayout = new GroupLayout(this.SourceReferencePanel);
        this.SourceReferencePanel.setLayout(SourceReferencePanelLayout);
        SourceReferencePanelLayout.setHorizontalGroup(SourceReferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        SourceReferencePanelLayout.setVerticalGroup(SourceReferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SourceReferencePanelLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.sourceCitationTabbedPane.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.sourceCitationTabbedPane.toolTipText"));
        this.SourceDataPanel.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.SourceDataPanel.toolTipText"));
        this.sourceDataTextArea.setColumns(20);
        this.sourceDataTextArea.setLineWrap(true);
        this.sourceDataTextArea.setRows(5);
        this.sourceDataTextArea.setWrapStyleWord(true);
        this.sourceDataTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mSourceTextModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mSourceTextModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceCitationEditorPanel.this.mSourceTextModified = true;
            }
        });
        this.sourceDataScrollPane.setViewportView(this.sourceDataTextArea);
        GroupLayout SourceDataPanelLayout = new GroupLayout(this.SourceDataPanel);
        this.SourceDataPanel.setLayout(SourceDataPanelLayout);
        SourceDataPanelLayout.setHorizontalGroup(SourceDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceDataScrollPane));
        SourceDataPanelLayout.setVerticalGroup(SourceDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceDataScrollPane));
        this.sourceCitationTabbedPane.addTab(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.SourceDataPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/source.png")), this.SourceDataPanel);
        this.noteCitationsTablePanel.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.noteCitationsTablePanel.toolTipText"));
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.sourceCitationTabbedPane.addTab(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.notesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Note.png")), this.notesPanel);
        this.multiMediaPanel.setToolTipText(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.multiMediaPanel.toolTipText"));
        GroupLayout multiMediaPanelLayout = new GroupLayout(this.multiMediaPanel);
        this.multiMediaPanel.setLayout(multiMediaPanelLayout);
        multiMediaPanelLayout.setHorizontalGroup(multiMediaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        multiMediaPanelLayout.setVerticalGroup(multiMediaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.sourceCitationTabbedPane.addTab(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.multiMediaPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png")), this.multiMediaPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationTabbedPane).addComponent(this.SourceReferencePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.SourceReferencePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceCitationTabbedPane).addContainerGap()));
    }

    private void addSourceButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    SourceCitationEditorPanel.this.mReferencedSource = (Source)gedcom.createEntity("SOUR");
                }
            });
            SourceEditor sourceEditor = new SourceEditor();
            sourceEditor.setContext(new Context((Entity)this.mReferencedSource));
            if (sourceEditor.showPanel()) {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        SourceCitationEditorPanel.this.mSourceCitation.setValue('@' + SourceCitationEditorPanel.this.mReferencedSource.getId() + '@');
                        ((PropertySource)SourceCitationEditorPanel.this.mSourceCitation).link();
                    }
                });
                this.sourceReferencedTitleTextArea.setText(this.mReferencedSource.getTitle());
                this.addSourceButton.setVisible(false);
                this.editSourceButton.setVisible(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editSourceButtonActionPerformed(ActionEvent evt) {
        if (this.mReferencedSource != null) {
            Gedcom gedcom = this.mRoot.getGedcom();
            SourceEditor sourceEditor = new SourceEditor();
            sourceEditor.setContext(new Context((Entity)this.mReferencedSource));
            sourceEditor.showPanel();
        }
    }

    private void linkToSourceButtonActionPerformed(ActionEvent evt) {
        SourcesTablePanel sourcesTablePanel = new SourcesTablePanel(this.mRoot.getGedcom());
        sourcesTablePanel.setToolBarVisible(false);
        DialogManager.ADialog sourcesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(SourceCitationEditorPanel.class, (String)"SourceCitationEditorPanel.linkTo.title"), (JComponent)sourcesTablePanel);
        sourcesTableDialog.setDialogId(SourcesTablePanel.class.getName());
        if (sourcesTableDialog.show() == DialogDescriptor.OK_OPTION && sourcesTablePanel.getSelectedSource() != null) {
            if (this.mReferencedSource != null && this.mReferencedSource.isConnected()) {
                ((PropertySource)this.mSourceCitation).unlink();
            }
            this.mReferencedSource = sourcesTablePanel.getSelectedSource();
            this.sourceReferencedTitleTextArea.setText(this.mReferencedSource.getTitle());
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        SourceCitationEditorPanel.this.mSourceCitation.setValue('@' + SourceCitationEditorPanel.this.mReferencedSource.getId() + '@');
                        ((PropertySource)SourceCitationEditorPanel.this.mSourceCitation).link();
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.addSourceButton.setVisible(false);
            this.editSourceButton.setVisible(true);
        }
    }

    private void eventRoleComboBoxActionPerformed(ActionEvent evt) {
        this.mEventRoleModified = true;
    }

    private void dataQualityComboBoxActionPerformed(ActionEvent evt) {
        this.mDataQualityModified = true;
    }

    private void referencedEventComboBoxActionPerformed(ActionEvent evt) {
        this.mEventTypeModified = true;
    }

    public void set(Property root, Property sourceCitation) {
        this.mRoot = root;
        this.mSourceCitation = sourceCitation;
        if (sourceCitation instanceof PropertySource) {
            this.mReferencedSource = (Source)((PropertySource)sourceCitation).getTargetEntity();
            this.sourceReferencedTitleTextArea.setEditable(false);
            if (this.mReferencedSource != null) {
                this.addSourceButton.setVisible(false);
                this.sourceReferencedTitleTextArea.setText(this.mReferencedSource.getTitle());
                this.mSourceReferencedTitleModified = false;
            } else {
                this.editSourceButton.setVisible(false);
                this.sourceReferencedTitleTextArea.setText("");
            }
            Property page = sourceCitation.getProperty("PAGE");
            if (page != null) {
                this.pageTextField.setText(page.getValue());
            } else {
                this.pageTextField.setText("");
            }
            Property eventType = sourceCitation.getProperty("EVEN");
            if (eventType != null) {
                this.referencedEventComboBox.setSelectedItem(PropertyTag2Name.getTagName(eventType.getValue()));
                Property eventRole = eventType.getProperty("ROLE");
                if (eventRole != null) {
                    if (eventRole.getValue().equals("CHIL")) {
                        this.eventRoleComboBox.setSelectedIndex(1);
                    } else if (eventRole.getValue().equals("HUSB")) {
                        this.eventRoleComboBox.setSelectedIndex(2);
                    } else if (eventRole.getValue().equals("WIFE")) {
                        this.eventRoleComboBox.setSelectedIndex(3);
                    } else if (eventRole.getValue().equals("MOTH")) {
                        this.eventRoleComboBox.setSelectedIndex(4);
                    } else if (eventRole.getValue().equals("FATH")) {
                        this.eventRoleComboBox.setSelectedIndex(5);
                    } else if (eventRole.getValue().equals("SPOU")) {
                        this.eventRoleComboBox.setSelectedIndex(6);
                    } else {
                        this.eventRoleComboBox.setSelectedItem(eventRole.getValue());
                    }
                } else {
                    this.eventRoleComboBox.setSelectedIndex(0);
                }
            } else {
                this.referencedEventComboBox.setSelectedItem("");
                this.eventRoleComboBox.setSelectedIndex(0);
            }
            this.mEventTypeModified = false;
            this.mEventRoleModified = false;
            Property sourceData = sourceCitation.getProperty("DATA");
            if (sourceData != null) {
                Property p = sourceData.getProperty("DATE", false);
                PropertyDate date = (PropertyDate)(p instanceof PropertyDate ? p : null);
                if (date == null) {
                    this.recordingDate.setContext(sourceData, null);
                } else {
                    this.recordingDate.setContext((Property)date);
                }
                Property sourceText = sourceData.getProperty("TEXT");
                if (sourceText != null) {
                    this.sourceDataTextArea.setText(sourceText.getValue());
                    this.mSourceTextModified = false;
                } else {
                    this.mSourceTextModified = false;
                }
            } else {
                this.recordingDate.setContext(sourceCitation, new TagPath(".:DATA"), (Property)null, (String)null);
            }
        } else {
            this.addSourceButton.setVisible(false);
            this.linkToSourceButton.setVisible(false);
            this.editSourceButton.setVisible(false);
            this.pageLabel.setVisible(false);
            this.pageTextField.setVisible(false);
            this.referencedEventLabel.setVisible(false);
            this.referencedEventComboBox.setVisible(false);
            this.eventRoleLabel.setVisible(false);
            this.eventRoleComboBox.setVisible(false);
            this.recordingDateLabel.setVisible(false);
            this.recordingDate.setVisible(false);
            this.sourceReferencedTitleTextArea.setText(sourceCitation.getValue());
            this.mSourceReferencedTitleModified = false;
            Property sourceText = sourceCitation.getProperty("TEXT");
            if (sourceText != null) {
                this.sourceDataTextArea.setText(sourceText.getValue());
                this.mSourceTextModified = false;
            } else {
                this.sourceDataTextArea.setText("");
                this.mSourceTextModified = false;
            }
        }
        Property propertyQuality = sourceCitation.getProperty("QUAY");
        int qualityIndex = 0;
        if (propertyQuality != null) {
            try {
                qualityIndex = Integer.parseInt(propertyQuality.getValue()) + 1;
            }
            catch (NumberFormatException ex) {
                qualityIndex = 0;
            }
        }
        if (qualityIndex < this.dataQualityComboBox.getItemCount()) {
            this.dataQualityComboBox.setSelectedIndex(qualityIndex);
        } else {
            this.dataQualityComboBox.setSelectedIndex(0);
        }
        this.mDataQualityModified = false;
        this.noteCitationsTablePanel.set(this.mSourceCitation, Arrays.asList(this.mSourceCitation.getProperties("NOTE")));
        this.multimediaObjectCitationsTablePanel.set(this.mSourceCitation, Arrays.asList(this.mSourceCitation.getProperties("OBJE")));
    }

    public void commit() {
        if (this.mSourceCitation != null && this.mSourceCitation instanceof PropertySource) {
            Property eventType;
            if (this.mEventTypeModified || this.mEventRoleModified) {
                this.mEventTypeModified = false;
                eventType = this.mSourceCitation.getProperty("EVEN");
                if (eventType == null) {
                    this.mSourceCitation.addProperty("EVEN", PropertyTag2Name.getPropertyTag(this.referencedEventComboBox.getSelectedItem().toString()));
                } else {
                    eventType.setValue(PropertyTag2Name.getPropertyTag(this.referencedEventComboBox.getSelectedItem().toString()));
                }
            }
            if (this.mEventRoleModified) {
                this.mEventRoleModified = false;
                eventType = this.mSourceCitation.getProperty("EVEN");
                Property eventRole = eventType.getProperty("ROLE");
                if (eventRole == null) {
                    if (this.eventRoleComboBox.getSelectedIndex() == 0) {
                        eventType.addProperty("ROLE", this.eventRoleComboBox.getSelectedItem().toString());
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 1) {
                        eventType.addProperty("ROLE", "CHIL");
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 2) {
                        eventType.addProperty("ROLE", "HUSB");
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 3) {
                        eventType.addProperty("ROLE", "WIFE");
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 4) {
                        eventType.addProperty("ROLE", "MOTH");
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 5) {
                        eventType.addProperty("ROLE", "FATH");
                    } else if (this.eventRoleComboBox.getSelectedIndex() == 6) {
                        eventType.addProperty("ROLE", "SPOU");
                    }
                } else if (this.eventRoleComboBox.getSelectedIndex() == 0) {
                    eventRole.setValue(this.eventRoleComboBox.getSelectedItem().toString());
                } else if (this.eventRoleComboBox.getSelectedIndex() == 1) {
                    eventRole.setValue("CHIL");
                } else if (this.eventRoleComboBox.getSelectedIndex() == 2) {
                    eventRole.setValue("HUSB");
                } else if (this.eventRoleComboBox.getSelectedIndex() == 3) {
                    eventRole.setValue("WIFE");
                } else if (this.eventRoleComboBox.getSelectedIndex() == 4) {
                    eventRole.setValue("MOTH");
                } else if (this.eventRoleComboBox.getSelectedIndex() == 5) {
                    eventRole.setValue("FATH");
                } else if (this.eventRoleComboBox.getSelectedIndex() == 6) {
                    eventRole.setValue("SPOU");
                }
            }
            if (this.mPageModified) {
                this.mPageModified = false;
                Property page = this.mSourceCitation.getProperty("PAGE");
                if (page == null) {
                    this.mSourceCitation.addProperty("PAGE", this.pageTextField.getText());
                } else {
                    page.setValue(this.pageTextField.getText());
                }
            }
            if (this.mSourceTextModified) {
                this.mSourceTextModified = false;
                try {
                    this.recordingDate.commit();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                Property sourceData = this.mSourceCitation.getProperty("DATA");
                if (sourceData == null) {
                    sourceData = this.mSourceCitation.addProperty("DATA", "");
                    sourceData.addProperty("TEXT", this.sourceDataTextArea.getText());
                } else {
                    Property sourceText = sourceData.getProperty("TEXT");
                    if (sourceText == null) {
                        sourceData.addProperty("TEXT", this.sourceDataTextArea.getText());
                    } else {
                        sourceText.setValue(this.sourceDataTextArea.getText());
                    }
                }
            }
        } else {
            this.mSourceCitation = this.mRoot.addProperty("SOUR", "");
            if (this.mSourceReferencedTitleModified) {
                this.mSourceReferencedTitleModified = false;
                this.mSourceCitation.setValue(this.sourceReferencedTitleTextArea.getText());
            }
            if (this.mSourceTextModified) {
                this.mSourceTextModified = false;
                Property sourceText = this.mSourceCitation.getProperty("TEXT");
                if (sourceText == null) {
                    this.mSourceCitation.addProperty("TEXT", this.sourceDataTextArea.getText());
                } else {
                    sourceText.setValue(this.sourceDataTextArea.getText());
                }
            }
        }
        if (this.mDataQualityModified) {
            this.mDataQualityModified = false;
            if (this.dataQualityComboBox.getSelectedIndex() > 0) {
                Property dataQuality = this.mSourceCitation.getProperty("QUAY");
                if (dataQuality == null) {
                    this.mSourceCitation.addProperty("QUAY", Integer.toString(this.dataQualityComboBox.getSelectedIndex() - 1));
                } else {
                    dataQuality.setValue(Integer.toString(this.dataQualityComboBox.getSelectedIndex() - 1));
                }
            }
        }
    }
}

