/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class SourceRecordedEventsTableModel
extends AbstractTableModel {
    List<Property> mEventTypesList = new ArrayList<Property>();
    String[] columnsName = new String[]{NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.eventType"), NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.date"), NbBundle.getMessage(SourceRecordedEventsTableModel.class, (String)"EventsTableModel.column.ID.place")};

    @Override
    public int getRowCount() {
        return this.mEventTypesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.mEventTypesList.size()) {
            Property eventType = this.mEventTypesList.get(row);
            if (column == 0) {
                String result = "";
                for (String tag : eventType.getValue().replaceAll(" ", "").split(",")) {
                    result = result.isEmpty() ? result + PropertyTag2Name.getTagName(tag) : result + ", " + PropertyTag2Name.getTagName(tag);
                }
                return result;
            }
            if (column == 1) {
                Property date = eventType.getProperty("DATE");
                if (date != null) {
                    return date.getDisplayValue();
                }
                return "";
            }
            if (column == 2) {
                PropertyPlace place = (PropertyPlace)eventType.getProperty("PLAC");
                if (place != null) {
                    return place.format("all");
                }
                return "";
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void addAll(List<Property> eventTypesList) {
        this.mEventTypesList.addAll(eventTypesList);
        this.fireTableDataChanged();
    }

    public void add(Property eventType) {
        this.mEventTypesList.add(eventType);
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.mEventTypesList.get(row);
    }

    public Property remove(int row) {
        Property event = this.mEventTypesList.remove(row);
        this.fireTableDataChanged();
        return event;
    }

    public void clear() {
        this.mEventTypesList.clear();
    }
}

