/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class NoteCitationsTableModel
extends AbstractTableModel {
    List<Property> notesList = new ArrayList<Property>();
    private String[] columnsName = new String[]{NbBundle.getMessage(NoteCitationsTableModel.class, (String)"NoteCitationsTableModel.column.ID.title"), NbBundle.getMessage(NoteCitationsTableModel.class, (String)"NoteCitationsTableModel.column.noteText.title")};

    @Override
    public int getRowCount() {
        return this.notesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.notesList.size()) {
            Property note = this.notesList.get(row);
            if (note instanceof PropertyNote) {
                if (((PropertyNote)note).getTargetEntity() != null) {
                    if (column == 0) {
                        return ((Note)((PropertyNote)note).getTargetEntity()).getId();
                    }
                    return ((Note)((PropertyNote)note).getTargetEntity()).getValue();
                }
                return "";
            }
            if (column == 0) {
                return "";
            }
            return note.getValue();
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(Property notes) {
        this.notesList.add(notes);
        this.fireTableDataChanged();
    }

    public void addAll(List<Property> notesList) {
        this.notesList.addAll(notesList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.notesList.clear();
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.notesList.get(row);
    }

    public Property remove(int row) {
        Property note = this.notesList.remove(row);
        this.fireTableDataChanged();
        return note;
    }
}

