/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ProblemPanel
extends JPanel {
    private String problem;
    private JButton[] buttons = null;
    private boolean isWarning = false;
    private OperationException ex;
    JCheckBox cbShowAgain;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    JTextPane taTitle;
    JTextPane tpMessage;

    public ProblemPanel(OperationException ex, boolean warning, JButton ... buttons) {
        this(ex, null, null, warning, buttons);
    }

    public ProblemPanel(OperationException ex, UpdateElement culprit, boolean warning, JButton ... buttons) {
        this(ex, culprit, null, warning, buttons);
    }

    public ProblemPanel(String problemDescription, JButton ... buttons) {
        this(null, null, problemDescription, true, buttons);
    }

    private ProblemPanel(OperationException ex, UpdateElement culprit, String problemDescription, boolean warning, JButton ... buttons) {
        this.ex = ex;
        this.buttons = buttons;
        this.isWarning = warning;
        if (ex == null) {
            this.initProxyProblem(problemDescription);
        } else {
            switch (ex.getErrorType()) {
                case PROXY: {
                    this.initProxyProblem(problemDescription);
                    break;
                }
                case WRITE_PERMISSION: {
                    this.initWriteProblem(culprit, problemDescription);
                    break;
                }
                case INSTALL: {
                    this.initInstallProblem(ex);
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + ex;
                    break;
                }
            }
        }
        for (JButton b : buttons) {
            b.getAccessibleContext().setAccessibleDescription(b.getText());
        }
    }

    private void initProxyProblem(String problemDescription) {
        if (this.ex != null) {
            problemDescription = this.ex.getLocalizedMessage();
        }
        this.problem = problemDescription == null ? Bundle.proxy_taTitle_Text() : problemDescription;
        this.enhancedInitComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        if (this.isWarning) {
            if (this.buttons.length == 2) {
                this.tpMessage.setText(Bundle.proxy_taMessage_WarningTextWithReload());
            } else {
                this.tpMessage.setText(Bundle.proxy_taMessage_WarningText());
            }
        } else {
            this.tpMessage.setText(Bundle.proxy_taMessage_ErrorText());
        }
    }

    private void initWriteProblem(UpdateElement culprit, String problemDescription) {
        this.problem = problemDescription == null ? Bundle.write_taTitle_Text(culprit.getDisplayName()) : problemDescription;
        this.enhancedInitComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        this.tpMessage.setText(Bundle.write_taMessage_WarningText());
    }

    private void initInstallProblem(OperationException ex) {
        this.problem = Bundle.install_taTitle_Text();
        this.enhancedInitComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        this.tpMessage.setText(Bundle.install_taMessage_ErrorText(ex.getLocalizedMessage()));
    }

    private void initComponents() {
        this.cbShowAgain = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.tpMessage = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.taTitle = new JTextPane();
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowAgain, (String)NbBundle.getMessage(ProblemPanel.class, (String)"ProblemPanel.cbShowAgain.text"));
        this.cbShowAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProblemPanel.this.cbShowAgainActionPerformed(evt);
            }
        });
        this.tpMessage.setEditable(false);
        this.tpMessage.setContentType("text/html");
        this.tpMessage.setOpaque(false);
        this.tpMessage.setPreferredSize(new Dimension(400, 100));
        this.jScrollPane1.setViewportView(this.tpMessage);
        this.taTitle.setEditable(false);
        this.taTitle.setContentType("text/html");
        this.taTitle.setOpaque(false);
        this.taTitle.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane2.setViewportView(this.taTitle);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowAgain, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 425, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 106, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowAgain)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProblemPanel.class, (String)"NetworkProblemPanel_ACD"));
    }

    private void cbShowAgainActionPerformed(ActionEvent evt) {
        ProblemPanel.getPreferences().putBoolean(Utilities.PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION, this.cbShowAgain.isSelected());
    }

    public Object showNetworkProblemDialog() {
        DialogDescriptor dd = this.getNetworkProblemDescriptor();
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        return dd.getValue();
    }

    public Object showWriteProblemDialog() {
        DialogDescriptor dd = this.getWriteProblemDescriptor();
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        return dd.getValue();
    }

    private DialogDescriptor getNetworkProblemDescriptor() {
        Object[] options = this.buttons == null || this.buttons.length == 0 ? new Object[]{DialogDescriptor.OK_OPTION} : this.buttons;
        JButton showProxyOptions = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)showProxyOptions, (String)NbBundle.getMessage(ProblemPanel.class, (String)"CTL_ShowProxyOptions"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, this.isWarning ? NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Warning") : NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Error"), true, options, null, 0, null, null);
        showProxyOptions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProblemPanel.class, (String)"ACSD_ShowProxyOptions"));
        showProxyOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsDisplayer.getDefault().open("General");
            }
        });
        descriptor.setMessageType(this.isWarning ? 2 : 0);
        if (this.isWarning) {
            descriptor.setAdditionalOptions(new Object[]{showProxyOptions});
        }
        descriptor.setClosingOptions(options);
        return descriptor;
    }

    private DialogDescriptor getWriteProblemDescriptor() {
        Object[] options = this.buttons == null || this.buttons.length == 0 ? new Object[]{DialogDescriptor.OK_OPTION} : this.buttons;
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, this.isWarning ? NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Warning") : Bundle.CTL_WriteError(), true, options, null, 0, null, null);
        descriptor.setMessageType(this.isWarning ? 2 : 0);
        descriptor.setClosingOptions(null);
        return descriptor;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    private void enhancedInitComponents() {
        this.initComponents();
        this.taTitle.setBackground(new Color(0, 0, 0, 0));
        this.taTitle.setOpaque(false);
        this.taTitle.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.tpMessage.setBackground(new Color(0, 0, 0, 0));
        this.tpMessage.setOpaque(false);
        this.tpMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }
}

