/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DefaultValueMap<Key, Value>
implements Map<Key, Value> {
    private Object defaultValue;
    private Map<Key, Value> delegate;

    public DefaultValueMap(Map<Key, Value> delegate, Value defaultValue) {
        this.delegate = delegate;
        this.defaultValue = defaultValue;
        this.getDefault();
    }

    protected Value getDefault() {
        try {
            return (Value)this.defaultValue.getClass().getMethod("clone", new Class[0]).invoke(this.defaultValue, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("default value must be cloneable", t);
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Value get(Object key) {
        Value val = this.delegate.get(key);
        if (val == null) {
            val = this.getDefault();
            this.delegate.put(key, val);
        }
        return val;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<Key> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Value put(Key key, Value value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        this.delegate.putAll(m);
    }

    @Override
    public Value remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<Value> values() {
        return this.delegate.values();
    }
}

