/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.util.swing.ImageIcon;

public class PropertyEvent
extends Property {
    public static ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:EVEN")).getImage();
    private boolean knownToHaveHappened;

    public PropertyEvent(String tag) {
        super(tag);
    }

    public PropertyDate getDate() {
        return this.getDate(true);
    }

    public PropertyDate getDate(boolean valid) {
        Property prop = this.getProperty("DATE", valid);
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop;
    }

    public String getDateAsString() {
        Property date = this.getProperty("DATE");
        return date != null ? date.getValue() : "";
    }

    @Override
    public String getValue() {
        return this.knownToHaveHappened ? "Y" : "";
    }

    @Override
    public void setValue(String value) {
        this.setKnownToHaveHappened(value.toLowerCase().equals("y"));
    }

    @Override
    void propagatePropertyChanged(Property property, String oldValue) {
        super.propagatePropertyChanged(property, oldValue);
        if (property instanceof PropertyDate && this.getProperty("DATE") == property && this.getParent() instanceof Indi) {
            if (this.getParent().getProperty("BIRT") == this) {
                for (PropertyEvent event : this.getParent().getProperties(PropertyEvent.class)) {
                    if (event == this) continue;
                    event.updateAge((PropertyDate)property);
                }
            } else if (!"BIRT".equals(this.getTag())) {
                this.updateAge();
            }
        }
    }

    public void updateAge() {
        if (!(this.getParent() instanceof Indi)) {
            return;
        }
        this.updateAge(((Indi)this.getParent()).getBirthDate());
    }

    void updateAge(PropertyDate birt) {
        PropertyDate date = this.getDate(true);
        if (date == birt) {
            return;
        }
        PropertyAge age = (PropertyAge)this.getProperty("AGE");
        if (age == null) {
            if (date == null || !GedcomOptions.getInstance().isAddAge()) {
                return;
            }
            age = (PropertyAge)this.addProperty("AGE", "");
        }
        if (date == null || birt == null || !birt.isValid()) {
            return;
        }
        if (birt.getStart().compareTo(date.getStart()) >= 0) {
            age.setValue("");
        } else {
            age.setValue(Delta.get(birt.getStart(), date.getStart()));
        }
    }

    public static TagPath[] getTagPaths(Gedcom gedcom) {
        return gedcom.getGrammar().getAllPaths(null, PropertyEvent.class);
    }

    public Boolean isKnownToHaveHappened() {
        if (this.getTag().equals("EVEN")) {
            return null;
        }
        return new Boolean(this.knownToHaveHappened);
    }

    public void setKnownToHaveHappened(boolean set) {
        String old = this.getValue();
        this.knownToHaveHappened = set;
        this.propagatePropertyChanged(this, old);
    }
}

