/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.CommonActions;
import ancestris.gedcom.PropertyNode;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class ExplorerHelper {
    private final Component source;
    private ExplorerManager manager;
    transient PopupAdapter popupListener;

    public ExplorerHelper(Component source) {
        this.source = source;
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null) {
            this.popupListener = new PopupAdapter();
        }
        if (value) {
            this.addPopupListener((MouseListener)((Object)this.popupListener));
        } else {
            this.removePopupListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
        }
    }

    public void addPopupListener(MouseListener pl) {
        if (this.manager == null) {
            this.manager = this.lookupExplorerManager(this.source);
        }
        this.source.addMouseListener(pl);
    }

    public void removePopupListener(MouseListener pl) {
        this.source.removeMouseListener(pl);
    }

    private ExplorerManager lookupExplorerManager(Component source) {
        ExplorerManager newManager = ExplorerManager.find((Component)source);
        return newManager;
    }

    protected void createPopup(Component clickedComponent, Point p, Node[] selNodes) {
        if (!this.isPopupAllowed()) {
            return;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        List<AncestrisActionProvider> providers = AncestrisActionProvider.Lookup.lookupAll(clickedComponent);
        for (AncestrisActionProvider ancestrisActionProvider : providers) {
            actions.addAll(ancestrisActionProvider.getActions(true, selNodes));
            actions.add(null);
        }
        if (selNodes.length > 0) {
            actions.addAll(Arrays.asList(NodeOp.findActions((Node[])selNodes)));
        }
        ArrayList<Action> aactions = new ArrayList<Action>();
        for (AncestrisActionProvider aap : Lookup.getDefault().lookupAll(AncestrisActionProvider.class)) {
            aactions.addAll(aap.getActions(false, selNodes));
        }
        actions.addAll(aactions);
        if (actions.size() > 0) {
            JPopupMenu popup;
            String string = ExplorerHelper.getTitleFromNodes(selNodes);
            if (string != null) {
                Action menuTitle;
                if (string.length() > 40) {
                    menuTitle = CommonActions.createSeparatorAction(string.substring(0, 36) + "...");
                    menuTitle.putValue("ShortDescription", string);
                } else {
                    menuTitle = CommonActions.createSeparatorAction(string);
                }
                actions.add(0, menuTitle);
                actions.add(1, null);
            }
            if ((popup = Utilities.actionsToPopup((Action[])actions.toArray(new Action[0]), (Component)clickedComponent)).getSubElements().length > 0) {
                popup.show(this.source, p.x, p.y);
            }
        }
    }

    private static String getTitleFromNodes(Node[] nodes) {
        String result = null;
        if (nodes != null && nodes.length == 1 && nodes[0] instanceof PropertyNode) {
            Property prop = ((PropertyNode)nodes[0]).getProperty();
            result = prop.getDisplayValue();
            if (!result.isEmpty()) {
                result = prop.getPropertyName() + ": " + result;
            }
            if (result.isEmpty() && prop instanceof Entity) {
                result = ((Entity)prop).toString(false);
            }
            if (result.isEmpty()) {
                result = prop.getEntity().toString(false) + " (" + prop.getPropertyName() + ")";
            }
        }
        return result;
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            Component c = e.getComponent();
            Node[] selNodes = ExplorerHelper.this.manager.getSelectedNodes();
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ExplorerHelper.this.source);
            ExplorerHelper.this.createPopup(e.getComponent(), p, selNodes);
        }
    }
}

