/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisContextAction;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.util.Resources;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.LookupEvent;

public class RunExternal
extends AbstractAncestrisContextAction {
    private File file;
    private static final Resources RESOURCES = Resources.get(RunExternal.class);

    public RunExternal() {
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        if (this.lkpInfo != null) {
            this.file = null;
            for (Property prop : this.lkpInfo.allInstances()) {
                if (!(prop instanceof PropertyFile)) continue;
                this.file = ((PropertyFile)prop).getFile();
            }
            super.resultChanged(ev);
        }
    }

    @Override
    protected void contextChanged() {
        super.contextChanged();
        this.setImage(PropertyFile.DEFAULT_IMAGE);
        this.setText(RESOURCES.getString("file.open"));
        this.setEnabled(this.file != null && this.file.exists());
    }

    public RunExternal(File file) {
        this.file = file;
        super.setImage(PropertyFile.DEFAULT_IMAGE);
        super.setText(RESOURCES.getString("file.open"));
        this.setEnabled(file != null && file.exists());
    }

    @Override
    protected void actionPerformedImpl(ActionEvent event) {
        if (this.file == null) {
            return;
        }
        try {
            Desktop.getDesktop().open(this.file);
        }
        catch (Throwable t) {
            Logger.getLogger("ancestris.edit.actions").log(Level.INFO, "can't open " + this.file, t);
        }
    }
}

