/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.modules.place.geonames.GeonamesPlacesList;
import java.util.logging.Logger;
import org.geonames.InsufficientStyleException;
import org.geonames.PostalCode;
import org.geonames.Toponym;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GeonamesPlace
implements Place {
    private PostalCode postalCode = null;
    private Toponym toponym = null;
    private static final Logger logger = Logger.getLogger(GeonamesPlacesList.class.getName(), null);

    public GeonamesPlace(Toponym toponym, PostalCode postalCode) {
        this.postalCode = postalCode;
        this.toponym = toponym;
    }

    public int compareTo(Place that) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getCity() {
        return this.postalCode == null ? this.toponym.getName() : this.postalCode.getPlaceName();
    }

    public String getFirstAvailableJurisdiction() {
        return this.postalCode == null ? this.toponym.getName() : this.postalCode.getAdminCode1();
    }

    public String[] getFormat() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getFormatAsString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getJurisdiction(int hierarchyLevel) {
        return this.getJurisdictions()[hierarchyLevel];
    }

    public String[] getJurisdictions() {
        String[] jurisdictions = new String[6];
        try {
            int index = 0;
            jurisdictions[index++] = this.toponym.getName();
            jurisdictions[index++] = this.postalCode != null ? this.postalCode.getPostalCode() : "";
            jurisdictions[index++] = this.toponym.getAdminCode4();
            jurisdictions[index++] = this.toponym.getAdminName2();
            jurisdictions[index++] = this.toponym.getAdminName1();
            jurisdictions[index++] = this.toponym.getCountryName();
        }
        catch (InsufficientStyleException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return jurisdictions;
    }

    public String getValueStartingWithCity() {
        return this.toString();
    }

    public void setFormatAsString(boolean global, String format) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Double getLongitude() {
        return this.toponym.getLongitude();
    }

    public Double getLatitude() {
        return this.toponym.getLatitude();
    }

    public String toString() {
        try {
            return this.toponym.getName() + (this.postalCode != null ? this.postalCode.getPostalCode() : "") + this.toponym.getAdminCode4() + this.toponym.getAdminName2() + this.toponym.getAdminName1() + this.toponym.getCountryName();
        }
        catch (InsufficientStyleException ex) {
            return "";
        }
    }

    public static String getPlaceFormat() {
        return NbBundle.getMessage(GeonamesPlace.class, (String)"GeoNamesPlaceFormat");
    }
}

