/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.swing.ToolBar;
import ancestris.swing.atable.ATableFilterWidget;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.ExplorerHelper;
import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.table.Bundle;
import genj.table.TableViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.SettingsAction;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class TableView
extends View {
    private static final Logger LOG = Logger.getLogger("ancestris.table");
    private static final Registry REGISTRY = Registry.get(TableView.class);
    private final Resources resources = Resources.get((Object)((Object)this));
    PropertyTableWidget propertyTable;
    private final Map<String, Mode> modes = new HashMap<String, Mode>();
    private final JPanel panelShortcuts;
    private final Map<String, String> defaultLayouts;
    private Mode currentMode;
    private final Sticky sticky;
    private final ATableFilterWidget filter;

    public static boolean getFollowEntity() {
        return REGISTRY.get("entity.follow", false);
    }

    public static void setFollowEntity(boolean followEntity) {
        REGISTRY.put("entity.follow", Boolean.valueOf(followEntity));
    }

    public TableView() {
        this.modes.put("INDI", new Mode("INDI", new String[]{"INDI", "INDI:SEX", "INDI:NAME", "INDI:BIRT:DATE", "INDI:BIRT:PLAC", "INDI:DEAT:DATE", "INDI:DEAT:PLAC", "INDI:FAMS", "INDI:FAMC", "INDI:RESI:ADDR", "INDI:RESI:ADDR:CTRY", "INDI:DEAT:AGE", "INDI:ASSO", "INDI:ASSO:RELA", "INDI:CHAN", "INDI:NAME:GIVN", "INDI:NAME:SURN"}));
        this.modes.put("FAM", new Mode("FAM", new String[]{"FAM", "FAM:MARR:DATE", "FAM:MARR:PLAC", "FAM:HUSB", "FAM:WIFE", "FAM:MARR:HUSB:AGE", "FAM:MARR:WIFE:AGE", "FAM:DIV:DATE", "FAM:NOTE", "FAM:MARC:DATE", "FAM:MARC:AGNC", "FAM:MARC:PLAC", "FAM:CHAN"}));
        this.modes.put("OBJE", new Mode("OBJE", new String[]{"OBJE", "OBJE:FILE:TITL"}));
        this.modes.put("NOTE", new Mode("NOTE", new String[]{"NOTE", "NOTE:NOTE", "NOTE:CHAN"}));
        this.modes.put("SOUR", new Mode("SOUR", new String[]{"SOUR", "SOUR:TITL", "SOUR:DATA:EVEN:DATE", "SOUR:REPO", "SOUR:REPO:CALN", "SOUR:REPO:CALN:MEDI", "SOUR:CHAN"}));
        this.modes.put("SUBM", new Mode("SUBM", new String[]{"SUBM", "SUBM:NAME", "SUBM:ADDR", "SUBM:ADDR:CITY", "SUBM:ADDR:POST", "SUBM:ADDR:CTRY", "SUBM:PHON", "SUBM:CHAN"}));
        this.modes.put("REPO", new Mode("REPO", new String[]{"REPO", "REPO:NAME", "REPO:ADDR", "REPO:ADDR:CITY", "REPO:ADDR:POST", "REPO:ADDR:CTRY", "REPO:PHON", "REPO:NOTE", "REPO:CHAN"}));
        this.defaultLayouts = new HashMap<String, String>();
        this.defaultLayouts.put("INDI", "17,52,24,310,96,163,94,156,356,397,224,113,99,388,218,167,254,172,2,1");
        this.defaultLayouts.put("FAM", "13,52,99,375,296,323,93,92,116,283,100,250,429,154,2,1");
        this.defaultLayouts.put("OBJE", "2,149,1529,0,1");
        this.defaultLayouts.put("NOTE", "3,55,1425,173,1,1");
        this.defaultLayouts.put("SOUR", "7,75,578,227,381,287,115,174,0,1");
        this.defaultLayouts.put("SUBM", "8,75,385,458,202,84,152,149,174,0,1");
        this.defaultLayouts.put("REPO", "9,60,283,530,174,75,75,120,202,144,1,1");
        this.sticky = new Sticky();
        this.filter = new ATableFilterWidget();
        this.panelShortcuts = new JPanel();
        this.panelShortcuts.setLayout((LayoutManager)new MigLayout("flowx, insets 0, gap 0, right"));
        for (Mode mode : this.modes.values()) {
            mode.load();
        }
        this.propertyTable = new PropertyTableWidget();
        this.setExplorerHelper(new ExplorerHelper(this.propertyTable.getTableComponent()));
        this.propertyTable.setAutoResize(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertyTable, "Center");
        this.currentMode = this.getMode("INDI");
        String tag = REGISTRY.get("mode", "");
        if (this.modes.containsKey(tag)) {
            this.currentMode = this.getMode(tag);
        }
        this.propertyTable.setFilterWidget(this.filter);
        this.propertyTable.setShortcut(this.panelShortcuts);
    }

    public Gedcom getGedcom() {
        try {
            return this.propertyTable.getModel().getGedcom();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    PropertyTableWidget getTable() {
        return this.propertyTable;
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 320);
    }

    Mode getMode() {
        return this.currentMode;
    }

    final Mode getMode(String tag) {
        Mode mode = this.modes.get(tag);
        if (mode == null) {
            mode = new Mode(tag, new String[0]);
            this.modes.put(tag, mode);
        }
        return mode;
    }

    void setMode(Mode set, boolean reset) {
        REGISTRY.put("mode", set.getTag());
        if (this.currentMode != null) {
            this.currentMode.save();
        }
        this.currentMode = set;
        PropertyTableModel currentModel = this.propertyTable.getModel();
        if (currentModel != null) {
            this.propertyTable.setModel(this.currentMode.getModel(), reset);
            this.propertyTable.setColumnLayout(this.currentMode.layout);
            this.filter.setColumn(this.currentMode.getColFilter());
            this.filter.refresh();
        }
        System.gc();
    }

    public void setContext(Context context) {
        if (this.sticky.isSelected()) {
            return;
        }
        this.currentMode.save();
        PropertyTableModel old = this.propertyTable.getModel();
        if (context.getGedcom() == null) {
            if (old != null) {
                this.eraseAll();
                System.gc();
            }
            return;
        }
        if (old == null) {
            for (Mode mode : this.modes.values()) {
                mode.load(context.getGedcom());
            }
            this.propertyTable.setModel(this.currentMode.getModel(), false);
            this.propertyTable.setColumnLayout(this.currentMode.layout);
            this.filter.setColumn(this.currentMode.getColFilter());
        }
        Mode mode = this.getModeFor(context);
        if (TableView.getFollowEntity() && mode != this.currentMode) {
            mode.setSelected(true);
        }
        if (mode == this.currentMode) {
            this.propertyTable.select(context);
        }
    }

    private Mode getModeFor(Context context) {
        for (Entity entity : context.getEntities()) {
            if (!this.currentMode.tag.equals(entity.getTag())) continue;
            return this.currentMode;
        }
        for (Entity entity : context.getEntities()) {
            Mode m = this.modes.get(entity.getTag());
            if (m == null) continue;
            return m;
        }
        return this.currentMode;
    }

    public void populate(ToolBar toolbar) {
        ButtonGroup group = new ButtonGroup();
        boolean j = true;
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            String tag = Gedcom.ENTITIES[i];
            Mode mode = this.getMode(tag);
            JToggleButton b = new JToggleButton((Action)((Object)mode));
            toolbar.add((JComponent)b);
            group.add(b);
            if (this.currentMode != mode) continue;
            mode.setSelected(true);
        }
        toolbar.add((Presenter.Toolbar)this.filter);
        toolbar.add((Component)this.panelShortcuts, (Object)"growx, pushx");
        toolbar.addSeparator();
        toolbar.add((Action)((Object)new Download()));
        toolbar.add((JComponent)new JToggleButton((Action)((Object)this.sticky)));
        toolbar.add((Action)((Object)new Settings()));
        toolbar.setFloatable(false);
    }

    public void removeNotify() {
        for (Mode mode : this.modes.values()) {
            mode.save();
        }
        super.removeNotify();
    }

    public void eraseAll() {
        for (Mode mode : this.modes.values()) {
            mode.eraseAll();
        }
    }

    private class Model
    extends AbstractPropertyTableModel {
        private final Mode mode;
        private List<Entity> rows;

        private Model(Gedcom gedcom, Mode set) {
            super(gedcom);
            this.mode = set;
        }

        public int getNumCols() {
            return this.mode.getPaths().length;
        }

        public int getNumRows() {
            if (this.rows == null) {
                this.rows = Collections.synchronizedList(new ArrayList(super.getGedcom().getEntities(this.mode.getTag())));
            }
            return this.rows.size();
        }

        public TagPath getColPath(int col) {
            return this.mode.getPaths()[col];
        }

        public Property getRowRoot(int row) {
            this.getNumRows();
            Property result = (Property)this.rows.get(row);
            if (result == null) {
                return result;
            }
            if (result.getEntity() == null) {
                result = null;
                this.rows.set(row, null);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            List<Entity> list = this.rows;
            synchronized (list) {
                this.rows.add(entity);
                this.fireRowsAdded(this.rows.size() - 1, this.rows.size() - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            List<Entity> list = this.rows;
            synchronized (list) {
                for (int i = 0; i < this.rows.size(); ++i) {
                    if (this.rows.get(i) != entity) continue;
                    this.rows.remove(i);
                    this.fireRowsDeleted(i, i);
                    return;
                }
            }
            LOG.log(Level.WARNING, "got notified that entity {0} was deleted but it wasn''t in rows in the first place", entity.getId());
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.invalidate(gedcom, property.getEntity(), added.getPath());
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.invalidate(gedcom, property.getEntity(), property.getPath());
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            this.invalidate(gedcom, property.getEntity(), new TagPath(property.getPath(), deleted.getTag()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate(Gedcom gedcom, Entity entity, TagPath path) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            List<Entity> list = this.rows;
            synchronized (list) {
                TagPath[] paths = this.mode.getPaths();
                for (int i = 0; i < paths.length; ++i) {
                    if (!paths[i].equals((Object)path)) continue;
                    for (int j = 0; j < this.rows.size(); ++j) {
                        if (this.rows.get(j) != entity) continue;
                        this.fireRowsChanged(j, j, i);
                        return;
                    }
                }
            }
        }

        private void eraseAll() {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = Model.this.rows;
                    synchronized (list) {
                        int s = Model.this.rows.size() - 1;
                        Iterator it = Model.this.rows.iterator();
                        while (it.hasNext()) {
                            it.next();
                            it.remove();
                        }
                        Model.this.fireRowsDeleted(0, s);
                        TableView.this.propertyTable.eraseAll();
                        System.gc();
                    }
                }
            };
            new RequestProcessor("interruptible tasks", 1, true).create(runnable).schedule(0);
        }
    }

    class Mode
    extends AbstractAncestrisAction {
        private String tag;
        private final String[] defaults;
        private TagPath[] paths;
        private String layout;
        private int colFilter;
        private Gedcom gedcom;
        private Model model;

        private Mode(String t, String[] d) {
            this.tag = t;
            this.defaults = d;
            this.paths = TagPath.toArray((String[])this.defaults);
            this.colFilter = 0;
            this.setTip(TableView.this.resources.getString("mode.tip", new Object[]{Gedcom.getName((String)this.tag, (boolean)true)}));
            this.setImage((Icon)Gedcom.getEntityImage((String)this.tag));
        }

        private PropertyTableModel getModel() {
            if (this.model == null) {
                this.model = new Model(this.gedcom, this);
            }
            return this.model;
        }

        public int getColFilter() {
            return this.colFilter;
        }

        public void setColFilter(int colFilter) {
            this.colFilter = colFilter;
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(true);
        }

        public boolean setSelected(boolean selected) {
            if (selected) {
                TableView.this.setMode(this, false);
            }
            return super.setSelected(selected);
        }

        private void load() {
            this.load(TableView.this.getGedcom());
        }

        private void load(Gedcom gedcom) {
            this.gedcom = gedcom;
            Registry r = gedcom == null ? REGISTRY : gedcom.getRegistry();
            String[] ps = r.get(this.tag + ".paths", (String[])null);
            if (ps != null) {
                this.paths = TagPath.toArray((String[])ps);
            }
            this.layout = r.get(this.tag + ".layout", (String)TableView.this.defaultLayouts.get(this.tag));
            this.setColFilter(r.get(this.tag + ".colfilter", 0));
        }

        void setPaths(TagPath[] set) {
            if (this.areDifferent(set, this.paths)) {
                this.paths = set;
                if (TableView.this.currentMode == this) {
                    TableView.this.setMode(TableView.this.currentMode, true);
                }
            }
        }

        TagPath[] getPaths() {
            return this.paths;
        }

        private boolean areDifferent(TagPath[] set1, TagPath[] set2) {
            if (set1.length != set2.length) {
                return true;
            }
            for (int i = 0; i < set1.length; ++i) {
                if (set1[i].compareTo((Object)set2[i]) == 0) continue;
                return true;
            }
            return false;
        }

        private void save() {
            Registry r;
            Registry registry = r = this.gedcom == null ? REGISTRY : this.gedcom.getRegistry();
            if (TableView.this.currentMode == this && TableView.this.propertyTable.getModel() != null) {
                this.layout = TableView.this.propertyTable.getColumnLayout();
                this.colFilter = TableView.this.filter.getColFilter();
            }
            r.put(this.tag + ".paths", (Object[])this.paths);
            r.put(this.tag + ".layout", this.layout);
            r.put(this.tag + ".colfilter", this.getColFilter());
        }

        String getTag() {
            return this.tag;
        }

        private void eraseAll() {
            if (this.model != null) {
                this.model.eraseAll();
            }
        }
    }

    private class Download
    extends AbstractAncestrisAction {
        protected Download() {
            super.setImage((Icon)Images.imgDownload);
            super.setTip(TableView.this.resources.getString("tableview.action.export.tip"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            File file = new FileChooserBuilder(TableView.class).setTitle(Bundle.tableview_export_dialog_title()).setApproveText(Bundle.tableview_action_export()).setFileHiding(true).setParent((Component)event.getSource()).setFileFilter((FileFilter)new FileNameExtensionFilter(Bundle.filter_txt_file(), "txt", "csv")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setDefaultBadgeProvider().setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showSaveDialog(true);
            if (file == null) {
                return;
            }
            try {
                TableView.this.propertyTable.tsvExport(file);
            }
            catch (IOException e) {
                DialogManager.createError((String)"table", (String)Bundle.tableview_export_error(file.getAbsolutePath())).show();
            }
        }
    }

    private class Sticky
    extends AbstractAncestrisAction {
        protected Sticky() {
            super.setImage((Icon)Images.imgStickOff);
            super.setTip(TableView.this.resources.getString("action.stick.tip"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean selected) {
            super.setImage((Icon)(selected ? Images.imgStickOn : Images.imgStickOff));
            return super.setSelected(selected);
        }
    }

    private class NextMode
    extends AbstractAncestrisAction {
        private final int dir;

        private NextMode(boolean left) {
            this.dir = left ? -1 : 1;
        }

        public void actionPerformed(ActionEvent event) {
            int next = -1;
            int j = Gedcom.ENTITIES.length;
            for (int i = 0; i < j; ++i) {
                next = (i + j + this.dir) % Gedcom.ENTITIES.length;
                if (TableView.this.currentMode == TableView.this.getMode(Gedcom.ENTITIES[i])) break;
            }
            TableView.this.getMode(Gedcom.ENTITIES[next]).setSelected(true);
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TableViewSettings getEditor() {
            return new TableViewSettings(TableView.this);
        }
    }
}

