/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.GraphicsHelper;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class HeadlessLabel
extends JComponent {
    private int iconTextGap = 4;
    private int padding = 0;
    private String txt = "";
    private Icon icon;
    private float iconLocation = 0.0f;
    private boolean isOpaque = false;
    private Font font;
    private int horizontalAlignment = 2;

    public HeadlessLabel() {
    }

    public HeadlessLabel(Font font) {
        this.setFont(font);
    }

    public void setHorizontalAlignment(int swingConstantAlignment) {
        switch (swingConstantAlignment) {
            case 2: {
                this.horizontalAlignment = 2;
                break;
            }
            case 4: {
                this.horizontalAlignment = 4;
                this.icon = null;
                break;
            }
            case 0: {
                this.horizontalAlignment = 0;
                this.icon = null;
            }
        }
    }

    @Override
    public void setFont(Font set) {
        this.font = set;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public void setText(String set) {
        this.txt = set != null ? set : "";
    }

    @Override
    public void setBorder(Border border) {
        throw new IllegalArgumentException("don't set border on headless label");
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setIcon(Icon icOn) {
        this.icon = icOn;
        this.horizontalAlignment = 2;
    }

    @Override
    public boolean isOpaque() {
        return this.isOpaque;
    }

    @Override
    public void setOpaque(boolean set) {
        this.isOpaque = set;
    }

    public void setIconLocation(float set) {
        this.iconLocation = set;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(this.txt);
        int height = fm.getHeight();
        if (this.icon != null) {
            width += this.icon.getIconWidth();
            height = Math.max(height, this.icon.getIconHeight());
        }
        if (this.txt.length() > 0 && this.icon != null) {
            width += this.iconTextGap;
        }
        return new Dimension(width += this.padding + this.padding, height += this.padding + this.padding);
    }

    @Override
    public void paint(Graphics g) {
        Font font = this.getFont();
        Rectangle box = new Rectangle(new Point(), this.getSize());
        if (this.isOpaque) {
            g.setColor(this.getBackground());
            g.fillRect(box.x, box.y, box.width, box.height);
        }
        if (this.padding > 0) {
            box.x += this.padding;
            box.y += this.padding;
            box.width -= this.padding + this.padding;
            box.height -= this.padding + this.padding;
        }
        if (this.icon != null) {
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            this.icon.paintIcon(null, g, 0, (int)(this.iconLocation * (float)(box.height - h)));
            box.x += w + this.iconTextGap;
            box.width -= w + this.iconTextGap;
        }
        g.setColor(this.getForeground());
        g.setFont(font);
        switch (this.horizontalAlignment) {
            case 4: {
                GraphicsHelper.render((Graphics2D)g, this.txt, box.getMaxX(), box.getCenterY(), 1.0, 0.5);
                break;
            }
            case 2: {
                GraphicsHelper.render((Graphics2D)g, this.txt, box.getMinX(), box.getCenterY(), 0.0, 0.5);
                break;
            }
            case 0: {
                GraphicsHelper.render((Graphics2D)g, this.txt, box.getCenterX(), box.getCenterY(), 0.5, 0.5);
            }
        }
    }

    @Override
    public float getAlignmentY() {
        return 0.0f;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

