/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.util.Registry;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public abstract class MultipleChoiceOption
extends PropertyOption {
    private PropertyOption option;

    protected MultipleChoiceOption(PropertyOption option) {
        super(option.instance, option.getProperty());
        this.option = option;
    }

    @Override
    public void restore(Registry r) {
        this.option.restore(r);
    }

    @Override
    public void restore() {
        this.option.restore();
    }

    @Override
    public void persist(Registry r) {
        this.option.persist(r);
    }

    @Override
    public void persist() {
        this.option.persist();
    }

    @Override
    public String getName() {
        return this.option.getName();
    }

    @Override
    public void setName(String set) {
        this.option.setName(set);
    }

    @Override
    public String getToolTip() {
        return this.option.getToolTip();
    }

    @Override
    public void setToolTip(String set) {
        this.option.setToolTip(set);
    }

    @Override
    public Object getValue() {
        return this.option.getValue();
    }

    @Override
    public void setValue(Object set) {
        this.option.setValue(set);
    }

    @Override
    public OptionUI getUI(OptionsWidget widget) {
        return new UI();
    }

    protected int getIndex() {
        return (Integer)this.option.getValue();
    }

    protected void setIndex(int i) {
        this.option.setValue(new Integer(i));
    }

    protected Object getChoice() {
        Object[] choices = this.getChoices();
        int i = this.getIndex();
        return i < 0 || i > choices.length - 1 ? null : choices[i];
    }

    public final Object[] getChoices() {
        try {
            return this.getChoicesImpl();
        }
        catch (Throwable t) {
            return new Object[0];
        }
    }

    protected abstract Object[] getChoicesImpl() throws Throwable;

    public class UI
    extends JComboBox
    implements OptionUI {
        private UI() {
            Object[] choices = MultipleChoiceOption.this.getChoices();
            this.setModel(new DefaultComboBoxModel<Object>(choices));
            int index = MultipleChoiceOption.this.getIndex();
            if (index < 0 || index > choices.length - 1) {
                index = -1;
            }
            this.setSelectedIndex(index);
        }

        @Override
        public JComponent getComponentRepresentation() {
            return this;
        }

        @Override
        public String getTextRepresentation() {
            Object result = MultipleChoiceOption.this.getChoice();
            return result != null ? result.toString() : "";
        }

        @Override
        public void endRepresentation() {
            MultipleChoiceOption.this.setIndex(this.getSelectedIndex());
        }
    }
}

