/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.DirectAccessTokenizer;
import genj.util.WordBuffer;

public class PropertyDate
extends Property {
    private final PIT start = new PIT();
    private final PIT end = new PIT();
    private boolean isAdjusting = false;
    private String valueAsString = null;
    private Format format = DATE;
    private String phrase = "";
    public static final Format DATE = new Format("", "");
    public static final Format FROM_TO = new Format("FROM", "TO");
    public static final Format FROM = new Format("FROM", "");
    public static final Format TO = new Format("TO", "");
    public static final Format BETWEEN_AND = new Format("BET", "AND");
    public static final Format BEFORE = new Format("BEF", "");
    public static final Format AFTER = new Format("AFT", "");
    public static final Format ABOUT = new Format("ABT", "");
    public static final Format CALCULATED = new Format("CAL", "");
    public static final Format ESTIMATED = new Format("EST", "");
    public static final Format INTERPRETED = new Interpreted();
    public static final Format[] FORMATS = new Format[]{DATE, FROM_TO, FROM, TO, BETWEEN_AND, BEFORE, AFTER, ABOUT, CALCULATED, ESTIMATED, INTERPRETED};

    public PropertyDate(String tag) {
        super(tag);
    }

    public PropertyDate() {
        super("DATE");
    }

    public PropertyDate(int year) {
        super("DATE");
        this.getStart().set(Integer.MAX_VALUE, Integer.MAX_VALUE, year);
    }

    @Override
    public int compareTo(Property other) {
        return this.start.compareTo(((PropertyDate)other).start);
    }

    @Override
    public PropertyComparator2 getComparator() {
        return DATEComparator.getInstance();
    }

    public String getPhrase() {
        return this.phrase;
    }

    public PointInTime getStart() {
        return this.start;
    }

    public PointInTime getEnd() {
        return this.end;
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public String getValue() {
        return this.valueAsString != null ? this.valueAsString : this.format.getValue(this);
    }

    public boolean isRange() {
        return this.format.isRange();
    }

    @Override
    public boolean isValid() {
        return this.valueAsString == null && this.format.isValid(this);
    }

    public boolean isComparable() {
        return this.start.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Format newFormat, PointInTime newStart, PointInTime newEnd, String newPhrase) {
        String old = this.getValue();
        this.isAdjusting = true;
        try {
            if (newStart == null) {
                this.start.reset();
            } else {
                this.start.set(newStart);
            }
            if (newEnd == null) {
                this.end.reset();
            } else {
                this.end.set(newEnd);
            }
            this.phrase = newPhrase;
            this.valueAsString = null;
            this.format = newFormat.needsValidStart() && !this.start.isValid() || newFormat.needsValidEnd() && !this.end.isValid() ? DATE : newFormat;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, old);
    }

    public void setFormat(Format set) {
        String old = this.getValue();
        this.isAdjusting = true;
        try {
            if (!this.isRange() && set.isRange()) {
                this.end.set(this.start);
            }
            this.format = set;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String newValue) {
        String old;
        block5: {
            old = this.getParent() == null ? null : this.getValue();
            this.isAdjusting = true;
            try {
                this.start.reset();
                this.end.reset();
                this.format = DATE;
                this.phrase = "";
                this.valueAsString = newValue.trim();
                if (this.valueAsString.length() <= 0) break block5;
                for (Format FORMATS1 : FORMATS) {
                    if (!FORMATS1.setValue(newValue, this)) continue;
                    this.format = FORMATS1;
                    this.valueAsString = null;
                    break;
                }
            }
            finally {
                this.isAdjusting = false;
            }
        }
        if (old != null) {
            this.propagatePropertyChanged(this, old);
        }
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(null);
    }

    public String getDisplayValue(Calendar calendar) {
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        return this.format.getDisplayValue(this, calendar);
    }

    @Override
    public String getPropertyInfo() {
        WordBuffer result = new WordBuffer();
        result.append(super.getPropertyInfo());
        result.append("<br>");
        result.append(this.getDisplayValue());
        if (!this.getStart().isGregorian() || !this.getEnd().isGregorian()) {
            result.append("<br>");
            result.append(this.getDisplayValue(PointInTime.GREGORIAN));
            result.append("(" + PointInTime.GREGORIAN.getName() + ")");
        }
        return result.toString();
    }

    public Delta getAnniversary() {
        return this.getAnniversary(PointInTime.getNow());
    }

    public Delta getAnniversary(PointInTime now) {
        PointInTime pit;
        if (!this.isValid()) {
            return null;
        }
        PointInTime pointInTime = pit = this.isRange() ? this.getEnd() : this.getStart();
        if (now.compareTo(pit) < 0) {
            return null;
        }
        return Delta.get(pit, now);
    }

    private static class Interpreted
    extends Format {
        private Interpreted() {
            super("INT", "");
        }

        @Override
        public boolean usesPhrase() {
            return true;
        }

        @Override
        public boolean isRange() {
            return false;
        }

        @Override
        protected boolean needsValidStart() {
            return false;
        }

        @Override
        protected boolean needsValidEnd() {
            return false;
        }

        @Override
        protected boolean isValid(PropertyDate date) {
            return true;
        }

        @Override
        protected boolean setValue(String text, PropertyDate date) {
            if (text.length() > this.start.length() && text.substring(0, this.start.length()).equalsIgnoreCase(this.start)) {
                int bracket = text.indexOf(40);
                if (bracket > 0 && date.start.set(text.substring(this.start.length(), bracket))) {
                    date.phrase = text.substring(bracket + 1, text.endsWith(")") ? text.length() - 1 : text.length());
                    return true;
                }
                if (date.start.set(text.substring(this.start.length()))) {
                    date.phrase = "";
                    return true;
                }
            }
            if (!text.startsWith("(") || !text.endsWith(")")) {
                return false;
            }
            date.phrase = text.substring(1, text.length() - 1).trim();
            return true;
        }

        @Override
        protected String getDisplayValue(PropertyDate date, Calendar calendar) {
            try {
                WordBuffer result = new WordBuffer();
                if (date.start.isValid()) {
                    if (calendar == null || date.start.getCalendar() == calendar) {
                        date.start.toString(result);
                    } else {
                        date.start.getPointInTime(calendar).toString(result);
                    }
                }
                result.append("(" + date.phrase + ")");
                return result.toString();
            }
            catch (GedcomException e) {
                return "";
            }
        }

        @Override
        protected String getValue(PropertyDate date) {
            WordBuffer result = new WordBuffer();
            if (date.start.isValid()) {
                result.append(this.start);
                date.start.getValue(result);
            }
            result.append("(" + date.phrase + ")");
            return result.toString();
        }
    }

    public static class Format {
        protected String start;
        protected String end;

        private Format(String s, String e) {
            this.start = s;
            this.end = e;
        }

        public String toString() {
            return this.start + this.end;
        }

        public boolean usesPhrase() {
            return false;
        }

        public boolean isRange() {
            return this.end.length() > 0;
        }

        protected boolean needsValidStart() {
            return true;
        }

        protected boolean needsValidEnd() {
            return this.isRange();
        }

        public String getName() {
            String key = (this.start + this.end).toLowerCase();
            if (key.length() == 0) {
                key = "date";
            }
            return Property.resources.getString("prop.date." + key);
        }

        public String getPrefix1Name() {
            if (this.start.length() == 0) {
                return null;
            }
            return Property.resources.getString("prop.date.mod." + this.start, false);
        }

        public String getPrefix2Name() {
            if (this.end.length() == 0) {
                return null;
            }
            return Property.resources.getString("prop.date.mod." + this.end, false);
        }

        protected boolean isValid(PropertyDate date) {
            return date.start.isValid() && (!this.isRange() || date.end.isValid());
        }

        protected String getValue(PropertyDate date) {
            WordBuffer result = new WordBuffer();
            result.append(this.start);
            date.start.getValue(result);
            if (this.isRange()) {
                result.append(this.end);
                date.end.getValue(result);
            }
            return result.toString();
        }

        protected String getDisplayValue(PropertyDate date, Calendar calendar) {
            try {
                WordBuffer result = new WordBuffer();
                if (this.start.length() > 0) {
                    result.append(Gedcom.getResources().getString("prop.date.mod." + this.start));
                }
                if (calendar == null || date.start.getCalendar() == calendar) {
                    date.start.toString(result);
                } else {
                    date.start.getPointInTime(calendar).toString(result);
                }
                if (this.isRange()) {
                    result.append(Gedcom.getResources().getString("prop.date.mod." + this.end));
                    if (calendar == null || date.end.getCalendar() == calendar) {
                        date.end.toString(result);
                    } else {
                        date.end.getPointInTime(calendar).toString(result);
                    }
                }
                return result.toString();
            }
            catch (GedcomException e) {
                return "";
            }
        }

        protected boolean setValue(String text, PropertyDate date) {
            String token;
            DirectAccessTokenizer tokens = new DirectAccessTokenizer(text, " ", true);
            int afterFirst = 0;
            if (this.start.length() > 0) {
                String first = tokens.get(0);
                afterFirst = tokens.getEnd();
                if (!first.equalsIgnoreCase(this.start)) {
                    return false;
                }
            }
            if (!this.isRange()) {
                return date.start.set(text.substring(afterFirst));
            }
            int pos = 1;
            while ((token = tokens.get(pos)) != null) {
                if (token.equalsIgnoreCase(this.end)) {
                    return date.start.set(text.substring(afterFirst, tokens.getStart())) && date.end.set(text.substring(tokens.getEnd()));
                }
                ++pos;
            }
            return false;
        }
    }

    private final class PIT
    extends PointInTime {
        private PIT() {
        }

        @Override
        public void set(int d, int m, int y) {
            if (PropertyDate.this.isAdjusting) {
                super.set(d, m, y);
            } else {
                String old = super.getValue();
                super.set(d, m, y);
                PropertyDate.this.propagatePropertyChanged(PropertyDate.this, old);
            }
        }
    }

    private static class DATEComparator
    extends PropertyComparator2.Default<PropertyDate> {
        private static final DATEComparator INSTANCE = new DATEComparator();

        private DATEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(PropertyDate d1, PropertyDate d2) {
            return d1.start.compareTo(d2.start);
        }

        @Override
        public String getSortGroup(PropertyDate p) {
            if (!p.isValid()) {
                return "";
            }
            String value = "0000" + String.valueOf(p.start.getYear());
            return value.substring(value.length() - 4);
        }
    }
}

