/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyNumericValue;
import genj.gedcom.PropertySex;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import spin.Spin;

public abstract class AbstractPropertyTableModel
implements PropertyTableModel,
GedcomListener {
    protected static final int LEFT = 2;
    protected static final int CENTER = 0;
    protected static final int RIGHT = 4;
    private List<PropertyTableModelListener> listeners = new CopyOnWriteArrayList<PropertyTableModelListener>();
    private Gedcom gedcom = null;
    private GedcomListener callback;

    protected AbstractPropertyTableModel(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    @Override
    public final Gedcom getGedcom() {
        return this.gedcom;
    }

    @Override
    public void addListener(PropertyTableModelListener listener) {
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)this));
        }
    }

    @Override
    public void removeListener(PropertyTableModelListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)this));
        }
    }

    @Override
    public String getColName(int col) {
        return this.getColPath(col).getName();
    }

    protected void fireRowsChanged(int rowStart, int rowEnd, int col) {
        for (PropertyTableModelListener listener : this.listeners) {
            listener.handleRowsChanged(this, rowStart, rowEnd, col);
        }
    }

    protected void fireRowsAdded(int rowStart, int rowEnd) {
        for (PropertyTableModelListener listener : this.listeners) {
            listener.handleRowsAdded(this, rowStart, rowEnd);
        }
    }

    protected void fireRowsDeleted(int rowStart, int rowEnd) {
        for (PropertyTableModelListener listener : this.listeners) {
            listener.handleRowsDeleted(this, rowStart, rowEnd);
        }
    }

    @Override
    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
    }

    @Override
    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
    }

    @Override
    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
    }

    @Override
    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
    }

    @Override
    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
    }

    public String getCellValue(Property property, int row, int col) {
        return AbstractPropertyTableModel.getDefaultCellValue(property, row, col);
    }

    static String getDefaultCellValue(Property property, int ro, int col) {
        if (property == null) {
            return "";
        }
        if (property instanceof Entity) {
            return ((Entity)property).getId();
        }
        if (property instanceof PropertySex) {
            return Character.toString(((PropertySex)property).getDisplayValue().charAt(0));
        }
        return property.getDisplayValue();
    }

    public int getCellAlignment(Property property, int row, int col) {
        return AbstractPropertyTableModel.getDefaultCellAlignment(property, row, col);
    }

    static int getDefaultCellAlignment(Property property, int row, int col) {
        if (property instanceof Entity) {
            return 4;
        }
        if (property instanceof PropertyDate) {
            return 4;
        }
        if (property instanceof PropertyNumericValue) {
            return 4;
        }
        if (property instanceof PropertySex) {
            return 0;
        }
        return 2;
    }

    public int compare(Property valueA, Property valueB, int col) {
        return AbstractPropertyTableModel.defaultCompare(valueA, valueB, col);
    }

    static int defaultCompare(Property valueA, Property valueB, int col) {
        return valueA.compareTo(valueB);
    }
}

