/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.editor;

import ancestris.view.ExplorerHelper;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import genj.util.ChangeSupport;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public abstract class Editor
extends JPanel {
    protected ChangeSupport changes = new ChangeSupport(this);
    protected List<Action> actions = new ArrayList<Action>();
    private String title = null;
    private ExplorerHelper helper;

    public abstract ViewContext getContext();

    public abstract Component getEditorComponent();

    public abstract Entity getEditedEntity();

    public ExplorerHelper getExplorerHelper() {
        if (this.helper == null) {
            this.helper = new ExplorerHelper(this.getEditorComponent());
        }
        return this.helper;
    }

    public void setContext(Context context) {
        this.getExplorerHelper();
        if (context == null) {
            return;
        }
        if (this.changes != null) {
            this.changes.mute();
        }
        this.setContextImpl(context);
        if (this.changes != null) {
            this.changes.unmute();
        }
    }

    protected abstract void setContextImpl(Context var1);

    public void setGedcomHasChanged(boolean flag) {
    }

    public abstract void commit() throws GedcomException;

    public List<Action> getActions() {
        return this.actions;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getTitleImpl();
    }

    protected String getTitleImpl() {
        return this.getContext() == null ? "" : this.getContext().getText();
    }

    public Image getImageIcon() {
        return null;
    }

    public boolean showPanel() {
        NotifyDescriptor nd = new NotifyDescriptor((Object)new JScrollPane(this), this.getTitle(), 2, -1, null, null);
        DialogDisplayer.getDefault().notify(nd);
        if (!nd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            return false;
        }
        try {
            this.getContext().getGedcom().doUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    Editor.this.commit();
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }
}

