/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.common.SelectEntityWidget;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.util.WordBuffer;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CreateRelationship
extends AbstractChange {
    protected Registry REGISTRY = Registry.get(CreateRelationship.class);
    private Entity existing;
    private Entity created;
    private JCheckBox checkID;
    private JTextField requestID;
    protected String targetType;
    private boolean isNew;

    public CreateRelationship() {
    }

    public CreateRelationship(String name, String targetType) {
        this();
        this.setTargetType(targetType);
        this.setText(name);
    }

    public final void setTargetType(String targetType) {
        if (targetType != null) {
            this.setImage((Icon)Gedcom.getEntityImage((String)targetType));
        }
        this.targetType = targetType;
    }

    @Override
    protected String getConfirmMessage() {
        WordBuffer result = new WordBuffer("\n");
        result.append(this.existing == null ? resources.getString("confirm.new", new Object[]{Gedcom.getName((String)this.targetType, (boolean)false), this.getGedcom()}) : resources.getString("confirm.use", new Object[]{this.existing.getId(), this.getGedcom()}));
        result.append(resources.getString("confirm.new.related", new Object[]{this.getDescription()}));
        String warning = this.getWarning(this.existing);
        if (warning != null) {
            result.append("**Note**: " + warning);
        }
        return result.toString();
    }

    public abstract String getDescription();

    public String getWarning(Entity target) {
        return null;
    }

    @Override
    protected JPanel getDialogContent() {
        JPanel result = new JPanel((LayoutManager)new NestedBlockLayout("<col><row><select wx=\"1\"/></row><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        final SelectEntityWidget select = new SelectEntityWidget(this.getGedcom(), this.targetType, SelectEntityWidget.NEW);
        this.existing = select.getSelection();
        this.requestID = new JTextField(this.getGedcom().getNextAvailableID(this.targetType), 8);
        this.requestID.setEditable(false);
        this.checkID = new JCheckBox(resources.getString("assign_id"));
        this.checkID.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateRelationship.this.requestID.setEditable(CreateRelationship.this.checkID.isSelected());
                if (CreateRelationship.this.checkID.isSelected()) {
                    CreateRelationship.this.requestID.requestFocusInWindow();
                }
            }
        });
        result.add((Component)select);
        result.add(this.getConfirmComponent());
        result.add(this.checkID);
        result.add(this.requestID);
        select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRelationship.this.existing = select.getSelection();
                if (CreateRelationship.this.existing != null) {
                    CreateRelationship.this.checkID.setSelected(false);
                }
                CreateRelationship.this.checkID.setEnabled(CreateRelationship.this.existing == null);
                CreateRelationship.this.refresh();
            }
        });
        if (!this.targetType.equals("INDI") && !this.targetType.equals("FAM")) {
            select.setSelection(this.getGedcom().getEntity(this.REGISTRY.get("select." + this.getGedcom().getName() + "." + this.targetType, (String)null)));
        }
        return result;
    }

    @Override
    protected final Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        Entity change;
        if (this.existing != null) {
            change = this.existing;
        } else {
            String id = null;
            if (this.requestID.isEditable() && gedcom.getEntity(this.targetType, id = this.requestID.getText()) != null) {
                throw new GedcomException(resources.getString("assign_id_error", new Object[]{id}));
            }
            change = gedcom.createEntity(this.targetType, id);
            change.addDefaultProperties();
        }
        this.isNew = change != this.existing;
        this.created = change;
        Property focus = this.change(change, change != this.existing);
        this.REGISTRY.put("select." + gedcom.getName() + "." + this.targetType, change.getId());
        return new Context(focus.getEntity());
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Entity getCreated() {
        return this.created;
    }

    protected abstract Property change(Entity var1, boolean var2) throws GedcomException;
}

