/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import genj.util.swing.ImageIcon;
import javax.swing.Icon;

public class CreateParent
extends CreateRelationship {
    private static final ImageIcon IMG = new ImageIcon(CreateParent.class, "Parents.png");
    private Entity entity;
    private Indi child;
    private Fam family;
    private int sex = -1;

    public CreateParent() {
        super(resources.getString("create.parent"), "INDI");
        this.setImage((Icon)IMG);
    }

    public CreateParent(Entity entity) {
        this(entity, -1);
    }

    public CreateParent(Entity entity, int sex) {
        this();
        this.entity = entity;
        this.contextChanged();
    }

    private boolean initialize(Entity entity, int sex) {
        boolean success = false;
        if (entity == null) {
            return false;
        }
        if (entity instanceof Fam) {
            this.family = (Fam)entity;
            this.child = null;
            this.sex = sex;
            if (this.family.getNoOfSpouses() < 2) {
                success = true;
            }
        }
        if (entity instanceof Indi) {
            this.child = (Indi)entity;
            this.family = null;
            this.sex = sex;
            Fam[] fams = this.child.getFamiliesWhereChild();
            for (int f = 0; f < fams.length; ++f) {
                if (fams[f].getNoOfSpouses() >= 2) continue;
                this.family = fams[f];
                break;
            }
            success = true;
        }
        return success;
    }

    protected final void contextChanged() {
        this.entity = null;
        if (this.contextProperties.size() == 1 && this.contextProperties.get(0) instanceof Entity) {
            this.entity = (Entity)this.contextProperties.get(0);
        }
        if (this.entity != null && this.initialize(this.entity, -1)) {
            this.setEnabled(true);
            this.setTip(resources.getString("link", new Object[]{this.getDescription()}));
        } else {
            this.setEnabled(false);
            this.setTip(resources.getString("create.parent"));
        }
    }

    @Override
    public String getDescription() {
        if (this.child != null) {
            return resources.getString("create.parent.of", new Object[]{this.child});
        }
        return resources.getString("create.parent.in", new Object[]{this.family});
    }

    @Override
    public String getWarning(Entity indi) {
        Fam fam;
        if (this.child != null && this.family == null && (fam = this.child.getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily((Indi)this.child, (Fam)fam);
        }
        return null;
    }

    @Override
    protected Property change(Entity parent, boolean parentIsNew) throws GedcomException {
        String lastname;
        PropertyXRef FAMS;
        Gedcom ged = parent.getGedcom();
        if (parentIsNew && this.sex >= 0) {
            ((Indi)parent).setSex(this.sex);
        }
        if (this.family != null) {
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            Indi other = this.family.getOtherSpouse((Indi)parent);
            lastname = other != null ? other.getLastName() : "";
        } else {
            lastname = this.child.getLastName();
            this.family = (Fam)ged.createEntity("FAM");
            this.family.addChild(this.child);
            this.family.addDefaultProperties();
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            if (GedcomOptions.getInstance().getCreateSpouse() && this.family.getNoOfSpouses() < 2) {
                Indi spouse = (Indi)ged.createEntity("INDI");
                spouse.addDefaultProperties();
                this.family.setSpouse(spouse);
                if (GedcomOptions.getInstance().isSetWifeLastname() || spouse.getSex() == 1) {
                    spouse.setName("", lastname);
                }
            }
        }
        if (parentIsNew && (((Indi)parent).getSex() == 1 || GedcomOptions.getInstance().isSetWifeLastname())) {
            ((Indi)parent).setName("", lastname);
        }
        return FAMS;
    }
}

