/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAlias;
import java.util.Collection;
import org.openide.util.LookupEvent;

public class CreateAlias
extends CreateRelationship {
    private Indi source;

    public CreateAlias() {
        this(null);
    }

    public CreateAlias(Indi source) {
        super(resources.getString("create.alias"), "INDI");
        this.setContextProperties((Property)source);
        this.contextChanged();
    }

    public void resultChanged(LookupEvent ev) {
        Property prop;
        this.source = null;
        Collection props = this.lkpInfo.allInstances();
        if (!props.isEmpty() && (prop = (Property)props.iterator().next()) instanceof Indi) {
            this.source = (Indi)prop;
        }
        super.resultChanged(ev);
    }

    protected final void contextChanged() {
        if (this.source != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public String getDescription() {
        return resources.getString("create.alias.of", new Object[]{this.source.toString()});
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyAlias alias = (PropertyAlias)this.source.addProperty("ALIA", '@' + target.getEntity().getId() + '@');
        try {
            alias.link();
        }
        catch (GedcomException e) {
            this.source.delProperty((Property)alias);
            throw e;
        }
        return alias;
    }
}

