/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.IndiPanel;
import ancestris.modules.editors.standard.tools.Utils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.openide.windows.WindowManager;

public class ImagePanel
extends JPanel {
    private IndiPanel callingPanel = null;
    private BufferedImage IMG_DEFAULT = null;
    private int default_width = 197;
    private int default_height = 140;
    private BufferedImage image = null;
    private File file = null;
    private int x;
    private int y;
    private static int startX;
    private static int startY;
    private double sourceZoom;
    private boolean ready;
    private static final RenderingHints textRenderHints;
    private static final RenderingHints imageRenderHints;
    private static final RenderingHints renderHints;

    public ImagePanel(IndiPanel callingPanel) {
        this.callingPanel = callingPanel;
        this.x = 0;
        this.y = 0;
        startX = 0;
        startY = 0;
        this.ready = false;
        this.initComponents();
    }

    public void setMedia(File file, BufferedImage defaultImage) {
        this.file = file;
        this.IMG_DEFAULT = defaultImage;
        this.image = file != null && file.exists() ? Utils.getImageFromFile(file, this.getClass()) : defaultImage;
        final ImagePanel ip = this;
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                ImagePanel.this.sourceZoom = (double)ip.getWidth() / (double)ImagePanel.this.image.getWidth();
                double s2 = (double)ip.getHeight() / (double)ImagePanel.this.image.getHeight();
                if (s2 < ImagePanel.this.sourceZoom) {
                    ImagePanel.this.sourceZoom = s2;
                }
                if (ImagePanel.this.sourceZoom > 20.0) {
                    ImagePanel.this.sourceZoom = 20.0;
                }
                if (ImagePanel.this.sourceZoom < 0.1) {
                    ImagePanel.this.sourceZoom = 0.1;
                }
                ImagePanel.this.x = (int)((double)(ip.getWidth() / 2 - (int)((double)ImagePanel.this.image.getWidth() * ImagePanel.this.sourceZoom / 2.0)) / ImagePanel.this.sourceZoom);
                ImagePanel.this.y = (int)((double)(ip.getHeight() / 2 - (int)((double)ImagePanel.this.image.getHeight() * ImagePanel.this.sourceZoom / 2.0)) / ImagePanel.this.sourceZoom);
                ImagePanel.this.ready = true;
                ImagePanel.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics grphcs) {
        super.paintComponent(grphcs);
        if (!this.ready) {
            return;
        }
        Graphics2D g2d = (Graphics2D)grphcs;
        ImagePanel.applyRenderHints(g2d);
        g2d.scale(this.sourceZoom, this.sourceZoom);
        g2d.drawImage((Image)this.image, this.x, this.y, null);
        this.ready = true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.default_width, this.default_height);
    }

    public static void applyRenderHints(Graphics2D g2d) {
        g2d.setRenderingHints(textRenderHints);
        g2d.setRenderingHints(imageRenderHints);
        g2d.setRenderingHints(renderHints);
    }

    private void initComponents() {
        this.setBorder(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ImagePanel.this.formMouseDragged(evt);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                ImagePanel.this.formMouseWheelMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ImagePanel.this.formMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                ImagePanel.this.formMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if (this.callingPanel == null || evt.getButton() != 1) {
            if (this.callingPanel != null && evt.getButton() == 3 && this.file != null && this.file.exists()) {
                try {
                    Desktop.getDesktop().open(this.file);
                }
                catch (IOException iOException) {}
            } else if (this.callingPanel == null && evt.getButton() == 1 && this.file != null && this.file.exists()) {
                try {
                    Desktop.getDesktop().open(this.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void formMousePressed(MouseEvent evt) {
        startX = (int)((double)evt.getX() - (double)this.x * this.sourceZoom);
        startY = (int)((double)evt.getY() - (double)this.y * this.sourceZoom);
    }

    private void formMouseDragged(MouseEvent evt) {
        this.x = (int)((double)(evt.getX() - startX) / this.sourceZoom);
        this.y = (int)((double)(evt.getY() - startY) / this.sourceZoom);
        this.repaint();
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        int notches = evt.getWheelRotation();
        double zoom = Math.pow(1.1f, -notches);
        double pointX = evt.getX();
        double pointY = evt.getY();
        double zoomafter = this.sourceZoom * zoom;
        if (zoomafter > 20.0) {
            zoomafter = 20.0;
        }
        if (zoomafter < 0.1) {
            zoomafter = 0.1;
        }
        this.x = (int)((double)this.x - (pointX / this.sourceZoom - pointX / zoomafter));
        this.y = (int)((double)this.y - (pointY / this.sourceZoom - pointY / zoomafter));
        this.sourceZoom = zoomafter;
        this.repaint();
    }

    public void redraw() {
        this.setMedia(this.file, this.IMG_DEFAULT);
    }

    public File getFile() {
        return this.file;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    static {
        textRenderHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        imageRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

