/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTransferable
implements Transferable {
    public static DataFlavor serializedFlavor = new DataFlavor(Serializable.class, "Object");
    public static DataFlavor localFlavor;
    private List<DataFlavor> flavors;
    private Object object;

    static {
        try {
            localFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    public ObjectTransferable(Object object) {
        this.object = object;
        this.flavors = this.createFlavors(object);
    }

    protected List<DataFlavor> createFlavors(Object object) {
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        flavors.add(localFlavor);
        boolean serializable = true;
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            int n = 0;
            while (n < array.length) {
                serializable = serializable && array[n] instanceof Serializable;
                ++n;
            }
        } else {
            serializable = object instanceof Serializable;
        }
        if (serializable) {
            flavors.add(serializedFlavor);
        }
        return flavors;
    }

    public void clear() {
        this.object = null;
    }

    private boolean hasObject() {
        return this.object != null;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (this.hasObject()) {
            if (localFlavor.equals(flavor)) {
                return this.object;
            }
            if (serializedFlavor.equals(flavor)) {
                return this.object;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.hasObject()) {
            return this.flavors.toArray(new DataFlavor[this.flavors.size()]);
        }
        return new DataFlavor[0];
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.hasObject()) {
            return this.flavors.contains(flavor);
        }
        return false;
    }

    public static Object getObject(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable.isDataFlavorSupported(localFlavor)) {
            return transferable.getTransferData(localFlavor);
        }
        if (transferable.isDataFlavorSupported(serializedFlavor)) {
            return transferable.getTransferData(serializedFlavor);
        }
        throw new IOException();
    }
}

