/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.place;

import ancestris.api.place.Place;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class PlaceFactory
implements Place {
    private PropertyPlace propertyPlace = null;
    private Double latitude;
    private Double longitude = 0.0;

    public PlaceFactory(PropertyPlace place) {
        this.propertyPlace = place;
        if (this.propertyPlace != null) {
            PropertyLongitude pLon = this.propertyPlace.getLongitude(true);
            this.longitude = pLon != null ? pLon.getDoubleValue() : null;
            PropertyLatitude pLat = this.propertyPlace.getLatitude(true);
            this.latitude = pLat != null ? pLat.getDoubleValue() : null;
        }
    }

    public PlaceFactory(PropertyPlace place, GeoPosition geoPoint) {
        this.propertyPlace = place;
        this.latitude = geoPoint.getLatitude();
        this.longitude = geoPoint.getLongitude();
    }

    @Override
    public int compareTo(Place that) {
        if (this.propertyPlace == null) {
            return -1;
        }
        return that.getValueStartingWithCity().compareToIgnoreCase(this.propertyPlace.getValueStartingWithCity());
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public String getCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getCity();
    }

    @Override
    public String getFirstAvailableJurisdiction() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFirstAvailableJurisdiction();
    }

    @Override
    public String[] getFormat() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getFormat();
    }

    @Override
    public String getFormatAsString() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFormatAsString();
    }

    @Override
    public String getJurisdiction(int hierarchyLevel) {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getJurisdiction(hierarchyLevel);
    }

    @Override
    public String[] getJurisdictions() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getJurisdictions();
    }

    @Override
    public String getValueStartingWithCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getValueStartingWithCity();
    }

    @Override
    public void setFormatAsString(boolean global, String format) {
        if (this.propertyPlace == null) {
            return;
        }
        this.propertyPlace.setFormatAsString(global, format);
    }
}

