/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.core.TextOptions;
import ancestris.modules.editors.standard.tools.IndiCreator;
import ancestris.modules.editors.standard.tools.NodeWrapper;
import ancestris.modules.editors.standard.tools.SourceChooser;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class Utils {
    private static BufferedImage IMG_INVALID_PHOTO = null;
    private static BufferedImage IMG_VIDEO = null;
    private static BufferedImage IMG_SOUND = null;
    private static BufferedImage IMG_PDF = null;
    private static BufferedImage IMG_NO_SOURCE_MEDIA = null;
    private static BufferedImage IMG_JUST_TEXT_MEDIA = null;

    public static boolean parentTagsContains(Property prop, String tag) {
        if (prop == null) {
            return false;
        }
        Property parent = prop instanceof PropertyXRef ? ((PropertyXRef)prop).getTargetParent() : prop.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getTag().equals(tag)) {
            return true;
        }
        return Utils.parentTagsContains(parent, tag);
    }

    public static BufferedImage getImageFromFile(File file, Class clazz) {
        return Utils.getImageFromFile(file, clazz, false);
    }

    public static BufferedImage getImageFromFile(File file, Class clazz, boolean noText) {
        if (clazz != null) {
            try {
                IMG_INVALID_PHOTO = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/invalid_photo.png"));
                IMG_VIDEO = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/video.png"));
                IMG_SOUND = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/sound.png"));
                IMG_PDF = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/pdf.png"));
                IMG_NO_SOURCE_MEDIA = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/source_dummy_small.png"));
                IMG_JUST_TEXT_MEDIA = ImageIO.read(clazz.getResourceAsStream("/ancestris/modules/editors/standard/images/source_text_only_small.png"));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        BufferedImage image = null;
        if (file == null) {
            return clazz == SourceChooser.SourceThumb.class && !noText ? IMG_JUST_TEXT_MEDIA : IMG_NO_SOURCE_MEDIA;
        }
        if (Arrays.asList(FileChooserBuilder.imgExtensions).contains(FileChooserBuilder.getExtension((File)file))) {
            try {
                image = ImageIO.read(new FileInputStream(file));
            }
            catch (Exception ex) {
                image = IMG_INVALID_PHOTO;
            }
        } else {
            image = Arrays.asList(FileChooserBuilder.vidExtensions).contains(FileChooserBuilder.getExtension((File)file)) ? IMG_VIDEO : (Arrays.asList(FileChooserBuilder.sndExtensions).contains(FileChooserBuilder.getExtension((File)file)) ? IMG_SOUND : (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(FileChooserBuilder.getExtension((File)file)) ? IMG_PDF : IMG_INVALID_PHOTO));
        }
        if (image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return IMG_INVALID_PHOTO;
        }
        return image;
    }

    public static void getPropertiesRecursively(Property parent, String tag, List props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            if (child.getTag().equals(tag)) {
                props.add(child);
            }
            Utils.getPropertiesRecursively(child, tag, props);
        }
    }

    public static Image scaleImage(File f, Class clazz, int width, int height) {
        return Utils.scaleImage(f, clazz, width, height, false);
    }

    public static Image scaleImage(File f, Class clazz, int width, int height, boolean noText) {
        BufferedImage image = Utils.getImageFromFile(f, clazz, noText);
        return Utils.scaleImage(image, width, height);
    }

    public static ImageIcon getResizedIcon(ImageIcon imageIcon, int targetWidth, int targetHeight) {
        return new ImageIcon(Utils.scaleImage(imageIcon.getImage(), targetWidth, targetHeight));
    }

    private static BufferedImage scaleImage(Image image, int targetWidth, int targetHeight) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth <= 0 || imageHeight <= 0) {
            image.flush();
            return null;
        }
        double targetRatio = (double)targetWidth / (double)targetHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (targetRatio < imageRatio) {
            targetHeight = (int)((double)targetWidth / imageRatio);
        } else {
            targetWidth = (int)((double)targetHeight * imageRatio);
        }
        return Utils.resizeImage(image, targetWidth, targetHeight);
    }

    private static BufferedImage resizeImage(Image img, int width, int height) {
        BufferedImage dimg = new BufferedImage(width, height, 1);
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return dimg;
    }

    public static void replaceRef(PropertyXRef pe, Entity oldEntity, Entity newEntity) {
        PropertyXRef xref = pe.getTarget();
        pe.unlink();
        pe.setValue(newEntity.getId());
        try {
            pe.link();
        }
        catch (GedcomException e) {
            return;
        }
        oldEntity.delProperty((Property)xref);
    }

    public static Indi[] getPotentialFamilyMembers(Indi indi, int relation) {
        ArrayList<Indi> l = new ArrayList<Indi>();
        for (Indi i : indi.getGedcom().getIndis()) {
            if (i == indi) continue;
            if (Utils.isLikely(i, relation, indi, l.size())) {
                l.add(i);
            }
            if (l.size() < 15) continue;
            break;
        }
        l.add(null);
        Indi[] result = new Indi[l.size()];
        l.toArray(result);
        return result;
    }

    public static boolean isLikely(Indi i, int relation, Indi indi, int n) {
        return Utils.likelyResult(i, relation, indi, n) == 0;
    }

    public static int likelyResult(Indi i, int relation, Indi indi, int n) {
        if (i == indi) {
            return 98;
        }
        Preferences modulePreferences = NbPreferences.forModule(Gedcom.class);
        int maxAgeFather = modulePreferences.getInt("maxAgeFather", 64);
        int minAgeFather = modulePreferences.getInt("minAgeFather", 14);
        int maxAgeMother = modulePreferences.getInt("maxAgeMother", 48);
        int minAgeMother = modulePreferences.getInt("minAgeMother", 10);
        int maxDiffAgeSibling = modulePreferences.getInt("maxDiffAgeSibling", 21);
        int maxDiffAgeSpouses = modulePreferences.getInt("maxDiffAgeSpouses", 20);
        PropertyDate bd = null;
        PropertyDate ibd = null;
        PropertyDate dd = null;
        PropertyDate idd = null;
        long t = 0L;
        long it = 0L;
        long diffb = 0L;
        long diffbd = 0L;
        long diffdb = 0L;
        t = 0L;
        it = 0L;
        diffb = 0L;
        diffbd = 0L;
        diffdb = 0L;
        bd = indi.getBirthDate();
        ibd = i.getBirthDate();
        dd = indi.getDeathDate();
        idd = i.getDeathDate();
        if (ibd != null && bd != null && ibd.isComparable() && bd.isComparable()) {
            try {
                t = bd.getStart().getJulianDay();
                it = ibd.getStart().getJulianDay();
                diffb = (it - t) / 365L;
            }
            catch (GedcomException ex) {
                diffb = 0L;
            }
        }
        if (idd != null && bd != null && idd.isComparable() && bd.isComparable()) {
            try {
                t = bd.getStart().getJulianDay();
                it = idd.getStart().getJulianDay();
                diffbd = (it - t) / 365L;
            }
            catch (GedcomException ex) {
                diffbd = 0L;
            }
        }
        if (ibd != null && dd != null && ibd.isComparable() && dd.isComparable()) {
            try {
                t = dd.getStart().getJulianDay();
                it = ibd.getStart().getJulianDay();
                diffdb = (it - t) / 365L;
            }
            catch (GedcomException ex) {
                diffdb = 0L;
            }
        }
        if (relation == IndiCreator.REL_FATHER) {
            boolean notDead;
            boolean youngEnough;
            boolean oldEnough;
            if (i.getSex() != 1) {
                return 1;
            }
            if (!indi.getLastName().equals(i.getLastName())) {
                return 2;
            }
            boolean bl = oldEnough = diffb < (long)(-minAgeFather);
            if (!oldEnough) {
                return 3;
            }
            boolean bl2 = youngEnough = diffb > (long)(-maxAgeFather);
            if (!youngEnough) {
                return 4;
            }
            boolean bl3 = notDead = diffbd >= 0L;
            if (!notDead) {
                return 5;
            }
            return 0;
        }
        if (relation == IndiCreator.REL_MOTHER) {
            Fam[] fams;
            boolean notDead;
            boolean youngEnough;
            boolean oldEnough;
            if (i.getSex() != 2) {
                return 6;
            }
            boolean bl = oldEnough = diffb < (long)(-minAgeMother);
            if (!oldEnough) {
                return 8;
            }
            boolean bl4 = youngEnough = diffb > (long)(-maxAgeMother);
            if (!youngEnough) {
                return 9;
            }
            boolean bl5 = notDead = diffbd >= 0L;
            if (!notDead) {
                return 10;
            }
            for (Fam fam : fams = i.getFamiliesWhereSpouse()) {
                Indi husb;
                if (fam == null || (husb = fam.getHusband()) == null) continue;
                if (!indi.getLastName().equals(husb.getLastName())) {
                    return 7;
                }
                return 0;
            }
            if (fams.length == 0 && n >= 10) {
                return 99;
            }
            return 0;
        }
        if (relation == IndiCreator.REL_BROTHER) {
            boolean youngEnough;
            boolean oldEnough;
            if (i.getSex() != 1) {
                return 11;
            }
            if (!indi.getLastName().equals(i.getLastName())) {
                return 12;
            }
            boolean bl = oldEnough = diffb < (long)maxDiffAgeSibling;
            if (!oldEnough) {
                return 13;
            }
            boolean bl6 = youngEnough = diffb > (long)(-maxDiffAgeSibling);
            if (!youngEnough) {
                return 14;
            }
            Fam fam1 = i.getFamilyWhereBiologicalChild();
            Fam fam2 = indi.getFamilyWhereBiologicalChild();
            if (fam1 != null && fam1 == fam2) {
                return 15;
            }
            if (i.isAncestorOf(indi)) {
                return 16;
            }
            return 0;
        }
        if (relation == IndiCreator.REL_SISTER) {
            boolean youngEnough;
            boolean oldEnough;
            if (i.getSex() != 2) {
                return 21;
            }
            if (!indi.getLastName().equals(i.getLastName())) {
                return 22;
            }
            boolean bl = oldEnough = diffb < (long)maxDiffAgeSibling;
            if (!oldEnough) {
                return 23;
            }
            boolean bl7 = youngEnough = diffb > (long)(-maxDiffAgeSibling);
            if (!youngEnough) {
                return 24;
            }
            Fam fam1 = i.getFamilyWhereBiologicalChild();
            Fam fam2 = indi.getFamilyWhereBiologicalChild();
            if (fam1 != null && fam1 == fam2) {
                return 25;
            }
            if (i.isAncestorOf(indi)) {
                return 26;
            }
            return 0;
        }
        if (relation == IndiCreator.REL_PARTNER) {
            boolean youngEnough;
            boolean oldEnough;
            if (i.getSex() == indi.getSex()) {
                return 31;
            }
            if (indi.getLastName().equals(i.getLastName())) {
                return 32;
            }
            boolean bl = oldEnough = diffb < (long)maxDiffAgeSpouses;
            if (!oldEnough) {
                return 33;
            }
            boolean bl8 = youngEnough = diffb > (long)(-maxDiffAgeSpouses);
            if (!youngEnough) {
                return 34;
            }
            Fam[] fams = i.getFamiliesWhereSpouse();
            if (fams != null && fams.length != 0) {
                return 35;
            }
            if (i.isAncestorOf(indi)) {
                return 36;
            }
            return 0;
        }
        if (relation == IndiCreator.REL_CHILD) {
            boolean youngEnough;
            boolean oldEnough;
            if (diffdb > 0L) {
                return 41;
            }
            if (indi.getSex() == 1 && !indi.getLastName().equals(i.getLastName())) {
                return 42;
            }
            if (indi.getSex() == 2) {
                Fam[] fams;
                boolean husbFound = false;
                boolean husbDiff = false;
                for (Fam fam : fams = indi.getFamiliesWhereSpouse()) {
                    Indi husb = fam.getHusband();
                    if (husb == null) continue;
                    husbFound = true;
                    if (husb.getLastName().equals(i.getLastName())) continue;
                    husbDiff = true;
                }
                if (husbFound && husbDiff) {
                    return 43;
                }
            }
            boolean bl = oldEnough = diffb > (long)minAgeMother;
            if (!oldEnough) {
                return 44;
            }
            boolean bl9 = youngEnough = diffb < (long)maxAgeMother;
            if (!youngEnough) {
                return 45;
            }
            Fam fam1 = i.getFamilyWhereBiologicalChild();
            if (fam1 != null) {
                Fam[] fams;
                for (Fam fam : fams = indi.getFamiliesWhereSpouse()) {
                    if (fam1 != fam) continue;
                    return 46;
                }
            }
            if (i.isAncestorOf(indi)) {
                return 47;
            }
            return 0;
        }
        return 99;
    }

    public static String getDetails(Indi indi) {
        PropertyDate death;
        String ret = "";
        if (indi == null) {
            return ret;
        }
        ret = ret + indi.toString(true);
        Preferences modulePreferences = NbPreferences.forModule(Gedcom.class);
        int maxYear = modulePreferences.getInt("maxYear", 3000);
        PropertyDate birth = indi.getBirthDate();
        if (birth != null && birth.getStart() != null && birth.getStart().getYear() < maxYear) {
            ret = ret + " " + TextOptions.getInstance().getBirthSymbol() + birth.getStart().getYear();
        }
        if ((death = indi.getDeathDate()) != null && death.getStart() != null && death.getStart().getYear() < maxYear) {
            ret = ret + " " + TextOptions.getInstance().getDeathSymbol() + death.getStart().getYear();
        }
        return ret;
    }

    public static Fam getCurrentFamily(Indi indi, JTree familyTree) {
        Fam[] fams = indi.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0) {
            return null;
        }
        if (fams != null && fams.length == 1) {
            return fams[0];
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)familyTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return fams[0];
        }
        NodeWrapper node = (NodeWrapper)selectedNode.getUserObject();
        Fam fam = node.getCurrentFamily(indi);
        if (fam == null) {
            return fams[0];
        }
        return fam;
    }
}

