/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard;

import ancestris.api.editor.Editor;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.modules.editors.standard.BlankPanel;
import ancestris.modules.editors.standard.IndiPanel;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.UnitOfWork;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.UndoRedo;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;

@RetainLocation(value="ancestris-editor")
public class EditorTopComponent
extends AncestrisTopComponent
implements TopComponent.Cloneable,
ConfirmChangeWidget.ConfirmChangeCallBack {
    private static final String PREFERRED_ID = "AncestrisEditor";
    static final Logger LOG = Logger.getLogger("ancestris.cygnuseditor");
    private Gedcom gedcom = null;
    private Editor editor = null;
    private Context context = null;
    private boolean isBusyCommitting = false;
    private final Callback callback = new Callback();
    private boolean isChangeSource = false;
    private int undoNb;
    private UndoRedoListener undoRedoListener;
    private JScrollPane editorContainer;
    private ConfirmChangeWidget confirmPanel;

    public void setName() {
        if (this.editor != null && this.editor.getName() != null) {
            this.setName(this.editor.getName());
        } else {
            super.setName();
        }
    }

    public void setToolTipText() {
        if (this.editor != null && this.editor.getToolTipText() != null) {
            this.setToolTipText(this.editor.getToolTipText());
        } else {
            super.setToolTipText();
        }
    }

    public void setContextImpl(Context newContext) {
        if (newContext == null || newContext.getEntity() == null) {
            return;
        }
        if (newContext.equals((Object)this.context)) {
            return;
        }
        newContext = this.adjustContext(newContext);
        if (this.context != null && !newContext.equals((Object)this.context) && newContext.getEntity().equals(this.context.getEntity()) && this.editor != null) {
            this.context = newContext;
            this.editor.setContext(newContext);
            return;
        }
        this.context = newContext;
        if (newContext.getGedcom() != this.gedcom) {
            if (this.gedcom != null) {
                this.gedcom.removeGedcomListener((GedcomListener)this.callback);
            }
            this.gedcom = newContext.getGedcom();
            this.gedcom.addGedcomListener((GedcomListener)this.callback);
        }
        this.commit(true);
        if (this.confirmPanel == null) {
            this.confirmPanel = new ConfirmChangeWidget((ConfirmChangeWidget.ConfirmChangeCallBack)this);
            this.confirmPanel.setChanged(false);
        }
        if (this.editor != null && !this.editor.getContext().getEntity().getTag().equals(newContext.getEntity().getTag())) {
            this.editor.getExplorerHelper().setPopupAllowed(false);
            this.editor.removeChangeListener((ChangeListener)this.confirmPanel);
            this.editor = null;
        }
        if (this.editor == null) {
            this.editor = newContext != null && newContext.getEntity().getTag().equals("INDI") ? new IndiPanel() : new BlankPanel();
            if (this.editor != null) {
                this.editor.addChangeListener((ChangeListener)this.confirmPanel);
            }
        }
        this.editor.setContext(newContext);
        if (this.editorContainer != null) {
            this.editorContainer.setViewportView((Component)this.editor);
        }
        this.undoNb = this.gedcom.getUndoNb();
        this.revalidate();
        this.repaint();
    }

    public Image getImageIcon() {
        Image icon = null;
        if (this.editor != null) {
            icon = this.editor.getImageIcon();
        }
        if (icon == null) {
            icon = this.getImageIcon("ancestris/modules/editors/standard/editeur_standard.png");
        }
        if (icon == null) {
            icon = super.getImageIcon();
        }
        return icon;
    }

    public boolean createPanel() {
        if (this.editor == null) {
            return false;
        }
        JPanel panel = new JPanel(new BorderLayout());
        this.editorContainer = new JScrollPane((Component)this.editor);
        this.editorContainer.getVerticalScrollBar().setUnitIncrement(50);
        panel.add((Component)this.editorContainer, "Center");
        panel.add((Component)this.confirmPanel, "Last");
        this.setPanel(panel);
        this.editor.getExplorerHelper().setPopupAllowed(true);
        return true;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void componentOpened() {
        this.undoRedoListener = new UndoRedoListener();
        UndoRedo undoRedo = this.getUndoRedo();
        undoRedo.addChangeListener((ChangeListener)this.undoRedoListener);
    }

    public void commit() {
        this.commit(true);
    }

    private void commit(boolean ask) {
        if (this.isBusyCommitting) {
            return;
        }
        if (this.confirmPanel == null || !this.confirmPanel.hasChanged()) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        if (ask && !this.confirmPanel.isCommitChanges()) {
            this.cancel();
            this.confirmPanel.setChanged(false);
            return;
        }
        this.isBusyCommitting = true;
        try {
            this.isChangeSource = true;
            if (this.gedcom.isWriteLocked()) {
                this.editor.commit();
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        EditorTopComponent.this.editor.commit();
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error committing editor", t);
        }
        finally {
            this.isChangeSource = false;
            this.confirmPanel.setChanged(false);
            this.isBusyCommitting = false;
        }
    }

    private void cancel() {
        if (!this.isOpen) {
            return;
        }
        if (!this.gedcom.isWriteLocked()) {
            while (this.gedcom.getUndoNb() > this.undoNb && this.gedcom.canUndo()) {
                this.gedcom.undoUnitOfWork(false);
            }
        }
    }

    public void okCallBack(ActionEvent event) {
        this.commit(event == null);
    }

    public void cancelCallBack(ActionEvent event) {
        this.editor.setGedcomHasChanged(true);
        ViewContext ctx = this.editor.getContext();
        this.editor.setContext((Context)ctx);
    }

    public TopComponent cloneComponent() {
        if (this.getContext() == null) {
            return null;
        }
        EditorTopComponent topComponent = new EditorTopComponent();
        topComponent.init(this.getContext());
        return topComponent;
    }

    public Editor getEditor() {
        return this.editor;
    }

    private Context adjustContext(Context ctx) {
        Entity mainEnt;
        Context tmpCtx;
        Context newContext = ctx;
        String type = ctx.getEntity().getTag();
        if (type.equals("FAM")) {
            Fam fam = (Fam)ctx.getEntity();
            newContext = this.getIndiContextFromFam(fam, ctx);
        } else if (type.equals("SUBM")) {
            Submitter subm = (Submitter)ctx.getEntity();
            newContext = this.getIndiContextFromSubmitter(subm, ctx);
        } else if (type.equals("REPO")) {
            Repository repo = (Repository)ctx.getEntity();
            newContext = this.getIndiContextFromRepository(repo, ctx);
        } else if (type.equals("SOUR")) {
            Source source = (Source)ctx.getEntity();
            newContext = this.getIndiContextFromSource(source, ctx);
        } else if (type.equals("OBJE")) {
            Media media = (Media)ctx.getEntity();
            newContext = this.getIndiContextFromMedia(media, ctx);
        } else if (type.equals("NOTE")) {
            Note note = (Note)ctx.getEntity();
            newContext = this.getIndiContextFromNote(note, ctx);
        } else if ((type.equals("NOTE") || type.equals("SOUR") || type.equals("OBJE") || type.equals("REPO") || type.equals("SUBM")) && (tmpCtx = this.getIndiContextFromEntity(mainEnt = ctx.getEntity(), ctx)) != null) {
            newContext = tmpCtx;
        }
        return newContext;
    }

    private Context getIndiContextFromFam(Fam fam, Context ctx) {
        Context retCtx = null;
        Indi indi = fam.getHusband();
        if (indi == null) {
            indi = fam.getWife();
        }
        if (indi == null) {
            try {
                indi = fam.getChild(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (indi != null) {
            retCtx = new Context((Entity)indi);
            ArrayList<Indi> entities = new ArrayList<Indi>();
            entities.add(indi);
            ArrayList<Property> properties = ctx.getProperties();
            Property union = fam.getProperty("MARR");
            if ((properties == null || properties.isEmpty()) && union != null) {
                properties = new ArrayList<Property>();
                properties.add(union);
            }
            retCtx = new Context(ctx.getGedcom(), entities, properties);
        }
        return retCtx != null ? retCtx : ctx;
    }

    private Context getIndiContextFromEntity(Entity entity, Context ctx) {
        Context retCtx = null;
        Entity target = null;
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            target = xref.getTargetEntity();
            if (!(target instanceof Indi) && !(target instanceof Fam)) continue;
            retCtx = new Context(xref.getTargetParent());
            String type = retCtx.getEntity().getTag();
            if (!type.equals("FAM")) break;
            Fam fam = (Fam)retCtx.getEntity();
            retCtx = this.getIndiContextFromFam(fam, retCtx);
            break;
        }
        return retCtx;
    }

    private Context getIndiContextFromSubmitter(Submitter subm, Context ctx) {
        Context retCtx = null;
        retCtx = this.getIndiContextFromEntity((Entity)subm, ctx);
        return retCtx != null ? retCtx : ctx;
    }

    private Context getIndiContextFromRepository(Repository repo, Context ctx) {
        PropertyXRef xref;
        Context retCtx = null;
        Entity target = null;
        Iterator iterator = repo.getProperties(PropertyXRef.class).iterator();
        while (iterator.hasNext() && (!((target = (xref = (PropertyXRef)iterator.next()).getTargetEntity()) instanceof Source) || (retCtx = this.getIndiContextFromSource((Source)target, ctx)) == ctx)) {
        }
        return retCtx != null ? retCtx : ctx;
    }

    private Context getIndiContextFromSource(Source source, Context ctx) {
        Context retCtx;
        block1: {
            PropertyXRef xref;
            retCtx = null;
            retCtx = this.getIndiContextFromEntity((Entity)source, ctx);
            if (retCtx != null) break block1;
            Entity target = null;
            Iterator iterator = source.getProperties(PropertyXRef.class).iterator();
            while (iterator.hasNext() && !((target = (xref = (PropertyXRef)iterator.next()).getTargetEntity()) instanceof Note) && !(target instanceof Media)) {
            }
        }
        return retCtx != null ? retCtx : ctx;
    }

    private Context getIndiContextFromMedia(Media media, Context ctx) {
        Context retCtx;
        block1: {
            PropertyXRef xref;
            retCtx = null;
            retCtx = this.getIndiContextFromEntity((Entity)media, ctx);
            if (retCtx != null) break block1;
            Entity target = null;
            Iterator iterator = media.getProperties(PropertyXRef.class).iterator();
            while (iterator.hasNext() && !((target = (xref = (PropertyXRef)iterator.next()).getTargetEntity()) instanceof Submitter ? (retCtx = this.getIndiContextFromSubmitter((Submitter)target, ctx)) != ctx : target instanceof Source && (retCtx = this.getIndiContextFromSource((Source)target, ctx)) != ctx)) {
            }
        }
        return retCtx != null ? retCtx : ctx;
    }

    private Context getIndiContextFromNote(Note note, Context ctx) {
        Context retCtx;
        block1: {
            PropertyXRef xref;
            retCtx = null;
            retCtx = this.getIndiContextFromEntity((Entity)note, ctx);
            if (retCtx != null) break block1;
            Entity target = null;
            Iterator iterator = note.getProperties(PropertyXRef.class).iterator();
            while (iterator.hasNext() && !((target = (xref = (PropertyXRef)iterator.next()).getTargetEntity()) instanceof Media ? (retCtx = this.getIndiContextFromMedia((Media)target, ctx)) != ctx : (target instanceof Source ? (retCtx = this.getIndiContextFromSource((Source)target, ctx)) != ctx : (target instanceof Submitter ? (retCtx = this.getIndiContextFromSubmitter((Submitter)target, ctx)) != ctx : target instanceof Repository && (retCtx = this.getIndiContextFromRepository((Repository)target, ctx)) != ctx)))) {
            }
        }
        return retCtx != null ? retCtx : ctx;
    }

    private class UndoRedoListener
    implements ChangeListener {
        private UndoRedoListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (EditorTopComponent.this.editor != null) {
                EditorTopComponent.this.editor.setGedcomHasChanged(true);
                ViewContext ctx = EditorTopComponent.this.editor.getContext();
                EditorTopComponent.this.editor.setContext(EditorTopComponent.this.adjustContext((Context)ctx));
            }
        }
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            if (!EditorTopComponent.this.isChangeSource) {
                EditorTopComponent.this.commit(false);
            }
        }
    }
}

