/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome;

import ancestris.welcome.WelcomeOptions;
import ancestris.welcome.content.Constants;
import ancestris.welcome.ui.StartPageContent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class WelcomeComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712676L;
    private static WeakReference<WelcomeComponent> component = new WeakReference<Object>(null);
    private JComponent content;
    private boolean initialized = false;
    private static boolean firstTimeOpen = true;

    private WelcomeComponent() {
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage(WelcomeComponent.class, (String)"LBL_Tab_Title"));
        this.setToolTipText(NbBundle.getMessage(WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
        this.content = null;
        this.initialized = false;
        this.putClientProperty("activateAtStartup", Boolean.TRUE);
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected String preferredID() {
        return "Welcome";
    }

    private void doInitialize() {
        this.initAccessibility();
        this.setName(NbBundle.getMessage(WelcomeComponent.class, (String)"LBL_Tab_Title"));
        this.setToolTipText(NbBundle.getMessage(WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
        if (null == this.content) {
            WelcomeOptions.getDefault().incrementStartCounter();
            JScrollPane scroll = new JScrollPane(new StartPageContent());
            scroll.setBorder(BorderFactory.createEmptyBorder());
            scroll.getViewport().setOpaque(false);
            scroll.setOpaque(false);
            scroll.getViewport().setPreferredSize(new Dimension(600, 100));
            JScrollBar vertical = scroll.getVerticalScrollBar();
            if (null != vertical) {
                vertical.setBlockIncrement(30 * Constants.FONT_SIZE);
                vertical.setUnitIncrement(Constants.FONT_SIZE);
            }
            this.content = scroll;
            this.add(this.content, "Center");
            this.setFocusable(false);
        }
    }

    public static WelcomeComponent findComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("Welcome");
            if (tc != null) {
                if (tc instanceof WelcomeComponent) {
                    wc = (WelcomeComponent)tc;
                    component = new WeakReference<WelcomeComponent>(wc);
                } else {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + WelcomeComponent.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    wc = WelcomeComponent.createComp();
                }
            } else {
                wc = WelcomeComponent.createComp();
            }
        }
        return wc;
    }

    public static WelcomeComponent createComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            wc = new WelcomeComponent();
            component = new WeakReference<WelcomeComponent>(wc);
        }
        return wc;
    }

    public int getPersistenceType() {
        return 1;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        if (null != this.content && this.getComponentCount() == 0) {
            this.add(this.content, "Center");
        }
        super.componentShowing();
        this.setActivatedNodes(new Node[0]);
    }

    protected void componentOpened() {
        super.componentOpened();
        if (firstTimeOpen) {
            firstTimeOpen = false;
            if (!WelcomeOptions.getDefault().isShowOnStartup()) {
                this.close();
            }
        }
    }

    protected void componentClosed() {
        super.componentClosed();
        TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("InitialLayout");
        if (null != group) {
            TopComponent tc;
            group.open();
            boolean firstTimeClose = NbPreferences.forModule(WelcomeComponent.class).getBoolean("firstTimeClose", true);
            NbPreferences.forModule(WelcomeComponent.class).putBoolean("firstTimeClose", false);
            if (firstTimeClose && null != (tc = WindowManager.getDefault().findTopComponent("projectTabLogical_tc")) && tc.isOpened()) {
                tc.requestActive();
            }
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (null != this.content) {
            this.remove(this.content);
        }
    }

    public void requestFocus() {
        if (null != this.content) {
            this.content.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (null != this.content) {
            return this.content.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }
}

