/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.LinkButton;
import ancestris.welcome.content.Utils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.openide.awt.StatusDisplayer;

public class WebLink
extends LinkButton {
    private String url;

    public WebLink(String key, boolean showBorder) {
        this(BundleSupport.getLabel(key), BundleSupport.getURL(key), showBorder);
    }

    public WebLink(String label, String url, boolean showBorder) {
        super(label, showBorder, url);
        this.url = url;
        this.getAccessibleContext().setAccessibleName(BundleSupport.getAccessibilityName("WebLink", label));
        this.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("WebLink", url));
        this.setUsageTrackingId(url);
    }

    public WebLink(String label, String url, Color foreground, boolean showBorder) {
        super(label, foreground, showBorder, url);
        this.url = url;
        this.setUsageTrackingId(url);
    }

    public void actionPerformed(ActionEvent e) {
        this.logUsage();
        Utils.showURL(this.url);
    }

    protected void onMouseExited(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected void onMouseEntered(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(this.url);
    }
}

