/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.beans.ADateBean;
import ancestris.modules.editors.genealogyeditor.panels.AssociationEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import genj.gedcom.time.Delta;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IndividualEventPanel
extends JPanel {
    private final ArrayList<String> mIndividualAttributesTags = new ArrayList<String>(){
        {
            this.add("CAST");
            this.add("DSCR");
            this.add("EDUC");
            this.add("IDNO");
            this.add("NATI");
            this.add("NCHI");
            this.add("NMR");
            this.add("OCCU");
            this.add("PROP");
            this.add("RELI");
            this.add("RESI");
            this.add("SSN");
            this.add("TITL");
        }
    };
    private Property mEvent = null;
    private Property mRoot;
    private PropertyPlace mPlace;
    private PropertyDate mDate;
    private PropertyAssociation mAssociation;
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(IndividualEventPanel.class);
    private boolean mEventModified = false;
    private boolean mEventCauseModified = false;
    private boolean mIndividualAgeModified = false;
    private boolean mEventNameModified = false;
    private boolean mEventTypeModified = false;
    private boolean mPlaceModified = false;
    private boolean mResponsibleAgencyModified = false;
    private JPanel EventDetailEditorPanel;
    private JPanel EventDetailPanel;
    private JLabel IndividualAgeLabel;
    private ADateBean aDateBean;
    private JButton associateButton;
    private JLabel dateLabel;
    private JButton editPlaceButton;
    private JLabel eventCauseLabel;
    private JTextArea eventCauseTextArea;
    private JLabel eventDescriptorLabel;
    private JTextArea eventDescriptorTextArea;
    private JTabbedPane eventInformationTabbedPane;
    private ChoiceWidget eventNameChoiceWidget;
    private JLabel eventNameLabel;
    private JPanel galleryPanel;
    private JTextField individualAgeTextField;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JLabel placeLabel;
    private JTextField placeTextField;
    private JToggleButton privateRecordToggleButton;
    private JLabel responsibleAgencyLabel;
    private JTextField responsibleAgencyTextField;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;

    public IndividualEventPanel() {
        this.initComponents();
        this.aDateBean.setPreferHorizontal(true);
        this.aDateBean.addChangeListener((ChangeListener)this.changeListner);
        this.eventNameChoiceWidget.addChangeListener((ChangeListener)this.changeListner);
        this.eventCauseTextArea.getDocument().addDocumentListener(this.changeListner);
        this.eventCauseTextArea.getDocument().putProperty("name", "eventCauseTextArea");
        this.eventDescriptorTextArea.getDocument().addDocumentListener(this.changeListner);
        this.eventDescriptorTextArea.getDocument().putProperty("name", "eventDescriptorTextArea");
        this.individualAgeTextField.getDocument().addDocumentListener(this.changeListner);
        this.individualAgeTextField.getDocument().putProperty("name", "individualAgeTextField");
        this.placeTextField.getDocument().addDocumentListener(this.changeListner);
        this.placeTextField.getDocument().putProperty("name", "placeTextField");
        this.responsibleAgencyTextField.getDocument().addDocumentListener(this.changeListner);
        this.responsibleAgencyTextField.getDocument().putProperty("name", "responsibleAgencyTextField");
        this.sourceCitationsTablePanel.addChangeListener(this.changeListner);
        this.noteCitationsTablePanel.addChangeListener(this.changeListner);
        this.multimediaObjectCitationsTablePanel.addChangeListener(this.changeListner);
        this.privateRecordToggleButton.addActionListener(this.changeListner);
    }

    private void initComponents() {
        this.eventInformationTabbedPane = new JTabbedPane();
        this.EventDetailPanel = new JPanel();
        this.EventDetailEditorPanel = new JPanel();
        this.placeLabel = new JLabel();
        this.placeTextField = new JTextField();
        this.privateRecordToggleButton = new JToggleButton();
        this.IndividualAgeLabel = new JLabel();
        this.eventDescriptorLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.aDateBean = new ADateBean();
        this.eventCauseLabel = new JLabel();
        this.eventNameLabel = new JLabel();
        this.individualAgeTextField = new JTextField();
        this.editPlaceButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.eventDescriptorTextArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.eventCauseTextArea = new JTextArea();
        this.eventNameChoiceWidget = new ChoiceWidget();
        this.responsibleAgencyLabel = new JLabel();
        this.responsibleAgencyTextField = new JTextField();
        this.associateButton = new JButton();
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.galleryPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.EventDetailEditorPanel.setMinimumSize(new Dimension(634, 217));
        this.placeLabel.setHorizontalAlignment(4);
        this.placeLabel.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.placeLabel.text"));
        this.placeTextField.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.placeTextField.text"));
        this.privateRecordToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setMaximumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setMinimumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setPreferredSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        this.privateRecordToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        this.IndividualAgeLabel.setHorizontalAlignment(4);
        this.IndividualAgeLabel.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.IndividualAgeLabel.text"));
        this.eventDescriptorLabel.setHorizontalAlignment(4);
        this.eventDescriptorLabel.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.eventDescriptorLabel.text"));
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.dateLabel.text"), new Object[0]));
        this.eventCauseLabel.setHorizontalAlignment(4);
        this.eventCauseLabel.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.eventCauseLabel.text"));
        this.eventNameLabel.setHorizontalAlignment(4);
        this.eventNameLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.eventNameLabel.text"), new Object[0]));
        this.individualAgeTextField.setColumns(4);
        this.individualAgeTextField.setToolTipText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.IndividualAgeTextField.toolTipText"));
        this.editPlaceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Place.png")));
        this.editPlaceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.editPlaceButton.toolTipText"), new Object[0]));
        this.editPlaceButton.setFocusable(false);
        this.editPlaceButton.setHorizontalTextPosition(0);
        this.editPlaceButton.setMaximumSize(new Dimension(26, 26));
        this.editPlaceButton.setMinimumSize(new Dimension(26, 26));
        this.editPlaceButton.setPreferredSize(new Dimension(26, 26));
        this.editPlaceButton.setVerticalTextPosition(3);
        this.editPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEventPanel.this.editPlaceButtonActionPerformed(evt);
            }
        });
        this.eventDescriptorTextArea.setColumns(20);
        this.eventDescriptorTextArea.setLineWrap(true);
        this.eventDescriptorTextArea.setRows(2);
        this.eventDescriptorTextArea.setToolTipText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.eventDescriptorTextArea.toolTipText"));
        this.eventDescriptorTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.eventDescriptorTextArea);
        this.eventCauseTextArea.setColumns(20);
        this.eventCauseTextArea.setLineWrap(true);
        this.eventCauseTextArea.setRows(2);
        this.eventCauseTextArea.setToolTipText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.eventCauseTextArea.toolTipText"));
        this.eventCauseTextArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.eventCauseTextArea);
        this.responsibleAgencyLabel.setText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.responsibleAgencyLabel.text"));
        this.responsibleAgencyTextField.setToolTipText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.responsibleAgencyTextField.toolTipText"));
        this.associateButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")));
        this.associateButton.setToolTipText(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.associateButton.toolTipText"));
        this.associateButton.setMaximumSize(new Dimension(26, 26));
        this.associateButton.setMinimumSize(new Dimension(26, 26));
        this.associateButton.setPreferredSize(new Dimension(26, 26));
        this.associateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEventPanel.this.associateButtonActionPerformed(evt);
            }
        });
        GroupLayout EventDetailEditorPanelLayout = new GroupLayout(this.EventDetailEditorPanel);
        this.EventDetailEditorPanel.setLayout(EventDetailEditorPanelLayout);
        EventDetailEditorPanelLayout.setHorizontalGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(EventDetailEditorPanelLayout.createSequentialGroup().addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.responsibleAgencyLabel).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.eventCauseLabel, -1, -1, Short.MAX_VALUE).addComponent(this.placeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.eventNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.eventDescriptorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.IndividualAgeLabel, -2, 117, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, EventDetailEditorPanelLayout.createSequentialGroup().addComponent(this.placeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editPlaceButton, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, EventDetailEditorPanelLayout.createSequentialGroup().addComponent((Component)this.eventNameChoiceWidget, -2, 261, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 184, Short.MAX_VALUE).addComponent(this.associateButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.privateRecordToggleButton, -2, -1, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addComponent(this.responsibleAgencyTextField).addComponent((Component)this.aDateBean, -1, -1, Short.MAX_VALUE).addComponent(this.individualAgeTextField))));
        EventDetailEditorPanelLayout.setVerticalGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(EventDetailEditorPanelLayout.createSequentialGroup().addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eventNameLabel).addComponent((Component)this.eventNameChoiceWidget, -2, -1, -2).addComponent(this.associateButton, -2, -1, -2)).addComponent(this.privateRecordToggleButton, -2, -1, -2)).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(EventDetailEditorPanelLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.dateLabel)).addGroup(EventDetailEditorPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.aDateBean, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.editPlaceButton, -2, -1, -2).addComponent(this.placeTextField, -2, -1, -2).addComponent(this.placeLabel, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.responsibleAgencyLabel).addComponent(this.responsibleAgencyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventCauseLabel).addComponent(this.jScrollPane2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventDescriptorLabel).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(EventDetailEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.IndividualAgeLabel).addComponent(this.individualAgeTextField, -2, -1, -2))));
        GroupLayout EventDetailPanelLayout = new GroupLayout(this.EventDetailPanel);
        this.EventDetailPanel.setLayout(EventDetailPanelLayout);
        EventDetailPanelLayout.setHorizontalGroup(EventDetailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(EventDetailPanelLayout.createSequentialGroup().addComponent(this.EventDetailEditorPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        EventDetailPanelLayout.setVerticalGroup(EventDetailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EventDetailEditorPanel, -1, -1, Short.MAX_VALUE));
        this.eventInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEventPanel.class, (String)"IndividualEventPanel.EventDetailPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Event.png")), this.EventDetailPanel);
        this.sourceCitationsTablePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.eventInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.sourcesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/source.png")), this.sourcesPanel);
        this.noteCitationsTablePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.eventInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.notesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Note.png")), this.notesPanel);
        this.multimediaObjectCitationsTablePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout galleryPanelLayout = new GroupLayout(this.galleryPanel);
        this.galleryPanel.setLayout(galleryPanelLayout);
        galleryPanelLayout.setHorizontalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        galleryPanelLayout.setVerticalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.eventInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("IndividualEventPanel.galleryPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png")), this.galleryPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventInformationTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventInformationTabbedPane));
    }

    private void editPlaceButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        final PlaceEditorPanel placeEditorPanel = new PlaceEditorPanel();
        JButton OKButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Ok"));
        JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Cancel"));
        Object[] options = new Object[]{OKButton, cancelButton};
        placeEditorPanel.setOKButton(OKButton);
        placeEditorPanel.set(gedcom, this.mPlace, false);
        DialogManager.ADialog eventEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(this.getClass(), (String)"PlaceEditorPanel.edit.title"), (JComponent)placeEditorPanel);
        eventEditorDialog.setDialogId(PlaceEditorPanel.class.getName());
        eventEditorDialog.setOptions(options);
        Object o = eventEditorDialog.show();
        placeEditorPanel.saveSize();
        if (o == OKButton) {
            this.placeTextField.getDocument().removeDocumentListener(this.changeListner);
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        placeEditorPanel.commit(IndividualEventPanel.this.mEvent, IndividualEventPanel.this.mPlace);
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
            this.placeTextField.setText(this.mPlace != null ? this.mPlace.getDisplayValue() : "");
            this.changeSupport.fireChange();
            this.placeTextField.getDocument().addDocumentListener(this.changeListner);
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    private void associateButtonActionPerformed(ActionEvent evt) {
        block6: {
            Gedcom gedcom = this.mRoot.getGedcom();
            int undoNb = gedcom.getUndoNb();
            final AssociationEditorPanel associationEditorPanel = new AssociationEditorPanel();
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        IndividualEventPanel.this.mAssociation = (PropertyAssociation)IndividualEventPanel.this.mRoot.addProperty("ASSO", "@@");
                    }
                });
                associationEditorPanel.set((Entity)((Indi)this.mRoot), this.mAssociation, this.mEvent);
                DialogManager.ADialog associationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.create.title"), (JComponent)associationEditorPanel);
                associationEditorDialog.setDialogId(AssociationEditorPanel.class.getName());
                if (associationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                    try {
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                associationEditorPanel.commit();
                            }
                        });
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.changeListner.stateChanged(null);
                    break block6;
                }
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean hasChanged() {
        return this.mEventModified;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void set(Property root, Property event) {
        Property eventCause;
        Property eventType;
        this.mRoot = root;
        this.mEvent = event;
        this.changeListner.mute();
        if (!this.mEvent.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
            this.privateRecordToggleButton.setVisible(false);
        }
        if (this.mEvent.getTag().equals("EVEN") || this.mEvent.getTag().equals("FACT")) {
            this.eventNameLabel.setVisible(true);
            this.eventNameChoiceWidget.setVisible(true);
            this.eventNameChoiceWidget.setEditable(true);
            this.eventNameChoiceWidget.setValues(this.mEvent.getGedcom().getReferenceSet("TYPE").getKeys((Comparator)this.mEvent.getGedcom().getCollator()));
            eventType = this.mEvent.getProperty("TYPE", false);
            if (eventType != null) {
                this.eventNameChoiceWidget.setText(eventType.getValue());
            } else {
                this.eventNameChoiceWidget.setText("");
            }
            this.eventCauseTextArea.setText(this.mEvent.getValue());
        } else if (this.mIndividualAttributesTags.contains(event.getTag()) && !event.getTag().equals("RESI")) {
            this.eventNameLabel.setVisible(true);
            this.eventNameChoiceWidget.setVisible(true);
            this.eventNameChoiceWidget.setValues(this.mEvent.getGedcom().getReferenceSet(this.mEvent.getTag()).getKeys((Comparator)this.mEvent.getGedcom().getCollator()));
            this.eventNameLabel.setText(PropertyTag2Name.getTagName(this.mEvent.getTag()));
            this.eventNameChoiceWidget.setText(this.mEvent.getValue());
            this.eventNameChoiceWidget.setEditable(true);
            eventType = this.mEvent.getProperty("TYPE");
            if (eventType != null) {
                this.eventDescriptorTextArea.setText(eventType.getValue());
            } else {
                this.eventDescriptorTextArea.setText("");
            }
            eventCause = this.mEvent.getProperty("CAUS", false);
            if (eventCause != null) {
                this.eventCauseTextArea.setText(eventCause.getValue());
            } else {
                this.eventCauseTextArea.setText("");
            }
        } else {
            this.eventNameLabel.setVisible(false);
            this.eventNameChoiceWidget.setVisible(false);
            this.eventNameChoiceWidget.setText("");
            eventType = this.mEvent.getProperty("TYPE");
            if (eventType != null) {
                this.eventDescriptorTextArea.setText(eventType.getValue());
            } else {
                this.eventDescriptorTextArea.setText("");
            }
            eventCause = this.mEvent.getProperty("CAUS", false);
            if (eventCause != null) {
                this.eventCauseTextArea.setText(eventCause.getValue());
            } else {
                this.eventCauseTextArea.setText("");
            }
        }
        Property restrictionNotice = this.mEvent.getProperty("RESN", true);
        if (restrictionNotice != null) {
            this.privateRecordToggleButton.setSelected(true);
        } else {
            this.privateRecordToggleButton.setSelected(false);
        }
        Property p = this.mEvent.getProperty("DATE", false);
        this.mDate = (PropertyDate)(p instanceof PropertyDate ? p : null);
        if (this.mDate == null) {
            this.aDateBean.setContext(this.mEvent, null);
        } else {
            this.aDateBean.setContext((Property)this.mDate);
        }
        if (!this.mEvent.getTag().equals("BIRT") && this.mDate != null) {
            this.IndividualAgeLabel.setVisible(true);
            this.individualAgeTextField.setVisible(true);
            PropertyAge age = (PropertyAge)this.mEvent.getProperty("AGE", false);
            if (age != null) {
                this.individualAgeTextField.setText(age.getDisplayValue());
                Indi indi = (Indi)this.mRoot;
                if (this.mDate.isValid() && indi != null && indi.getBirthDate() != null && indi.getBirthDate().isValid()) {
                    this.individualAgeTextField.setEditable(false);
                    this.individualAgeTextField.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
                } else {
                    this.individualAgeTextField.setEditable(true);
                    this.individualAgeTextField.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                }
            } else if (this.mDate != null && this.mDate.isValid()) {
                Delta deltaAge = ((Indi)this.mRoot).getAge(this.mDate.getStart());
                if (deltaAge != null) {
                    this.individualAgeTextField.setText(deltaAge.toString());
                    this.individualAgeTextField.setEditable(false);
                    this.individualAgeTextField.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
                } else {
                    this.individualAgeTextField.setText("");
                    this.individualAgeTextField.setEditable(true);
                    this.individualAgeTextField.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                }
            } else {
                this.individualAgeTextField.setText("");
                this.individualAgeTextField.setEditable(true);
                this.individualAgeTextField.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        } else {
            this.IndividualAgeLabel.setVisible(false);
            this.individualAgeTextField.setVisible(false);
        }
        this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
        if (this.mPlace != null) {
            this.placeTextField.setText(this.mPlace.getDisplayValue());
        } else {
            this.placeTextField.setText("");
        }
        Property[] sourcesList = this.mEvent.getProperties("SOUR");
        this.sourceCitationsTablePanel.set(this.mEvent, Arrays.asList(sourcesList));
        this.noteCitationsTablePanel.set(this.mEvent, Arrays.asList(this.mEvent.getProperties("NOTE")));
        this.multimediaObjectCitationsTablePanel.set(this.mEvent, Arrays.asList(this.mEvent.getProperties("OBJE")));
        Property responsibleAgency = this.mEvent.getProperty("AGNC");
        if (responsibleAgency != null) {
            this.responsibleAgencyTextField.setText(responsibleAgency.getValue());
        } else {
            this.responsibleAgencyTextField.setText("");
        }
        this.mEventModified = false;
        this.mEventCauseModified = false;
        this.mIndividualAgeModified = false;
        this.mEventNameModified = false;
        this.mEventTypeModified = false;
        this.mPlaceModified = false;
        this.mResponsibleAgencyModified = false;
        this.changeListner.unmute();
    }

    public void commit() {
        if (this.mRoot != null && (this.mEventModified || this.aDateBean.hasChanged())) {
            Property eventCause;
            String causeText;
            Property eventType;
            this.mEventModified = false;
            if (this.aDateBean.hasChanged()) {
                try {
                    this.aDateBean.commit();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.mEvent.getTag().equals("EVEN") || this.mEvent.getTag().equals("FACT")) {
                if (this.mEventNameModified) {
                    this.mEventNameModified = false;
                    eventType = this.mEvent.getProperty("TYPE", false);
                    if (eventType != null) {
                        eventType.setValue(this.eventNameChoiceWidget.getText());
                    } else {
                        this.mEvent.addProperty("TYPE", this.eventNameChoiceWidget.getText());
                    }
                }
                if (this.mEventCauseModified) {
                    this.mEventCauseModified = false;
                    this.mEvent.setValue(this.eventCauseTextArea.getText().replaceAll("\n", " "));
                }
            } else if (this.mIndividualAttributesTags.contains(this.mEvent.getTag())) {
                if (this.mEventNameModified) {
                    this.mEventNameModified = false;
                    this.mEvent.setValue(this.eventNameChoiceWidget.getText());
                }
                if (this.mEventTypeModified) {
                    this.mEventTypeModified = false;
                    eventType = this.mEvent.getProperty("TYPE", false);
                    if (eventType != null) {
                        eventType.setValue(this.eventDescriptorTextArea.getText());
                    } else {
                        this.mEvent.addProperty("TYPE", this.eventDescriptorTextArea.getText());
                    }
                }
                if (this.mEventCauseModified) {
                    this.mEventCauseModified = false;
                    causeText = this.eventCauseTextArea.getText().replaceAll("\n", " ");
                    eventCause = this.mEvent.getProperty("CAUS", false);
                    if (causeText.length() > 0) {
                        if (eventCause == null) {
                            this.mEvent.addProperty("CAUS", causeText);
                        } else {
                            eventCause.setValue(causeText);
                        }
                    } else if (eventCause != null) {
                        this.mEvent.delProperty(eventCause);
                    }
                }
            } else {
                Property p;
                PropertyDate date;
                if (this.mEventTypeModified) {
                    this.mEventTypeModified = false;
                    eventType = this.mEvent.getProperty("TYPE", false);
                    if (eventType != null) {
                        eventType.setValue(this.eventDescriptorTextArea.getText());
                    } else {
                        this.mEvent.addProperty("TYPE", this.eventDescriptorTextArea.getText());
                    }
                }
                if (this.mEventCauseModified) {
                    this.mEventCauseModified = false;
                    causeText = this.eventCauseTextArea.getText().replaceAll("\n", " ");
                    eventCause = this.mEvent.getProperty("CAUS", false);
                    if (causeText.length() > 0) {
                        if (eventCause == null) {
                            this.mEvent.addProperty("CAUS", causeText);
                        } else {
                            eventCause.setValue(causeText);
                        }
                    } else if (eventCause != null) {
                        this.mEvent.delProperty(eventCause);
                    }
                }
                if ((date = (PropertyDate)((p = this.mEvent.getProperty("DATE", false)) instanceof PropertyDate ? p : null)) != null && date.isValid()) {
                    this.mEvent.setValue("");
                } else {
                    Logger.getLogger("ancestris").info(this.mEvent.getTag());
                    if (this.mEvent.getTag().matches("(BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI)")) {
                        this.mEvent.setValue("y");
                    }
                }
            }
            Property restrictionNotice = this.mEvent.getProperty("RESN", true);
            if (this.privateRecordToggleButton.isSelected()) {
                if (restrictionNotice == null) {
                    this.mEvent.addProperty("RESN", "confidential");
                }
            } else if (restrictionNotice != null) {
                this.mEvent.delProperty(restrictionNotice);
            }
            if (this.mIndividualAgeModified) {
                this.mIndividualAgeModified = false;
                PropertyAge age = (PropertyAge)this.mEvent.getProperty("AGE", false);
                if (age != null) {
                    age.setValue(this.individualAgeTextField.getText() + " y");
                } else {
                    this.mEvent.addProperty("AGE", this.individualAgeTextField.getText() + " y");
                }
            }
            if (this.mPlaceModified) {
                this.mPlaceModified = false;
                Property place = this.mEvent.getProperty("PLAC", false);
                if (place != null) {
                    place.setValue(this.placeTextField.getText());
                } else {
                    this.mEvent.addProperty("PLAC", this.placeTextField.getText());
                }
            }
            if (this.mResponsibleAgencyModified) {
                this.mResponsibleAgencyModified = false;
                Property responsibleAgency = this.mEvent.getProperty("AGNC", false);
                if (responsibleAgency != null) {
                    responsibleAgency.setValue(this.responsibleAgencyTextField.getText());
                } else {
                    this.mEvent.addProperty("AGNC", this.responsibleAgencyTextField.getText());
                }
            }
        }
    }

    private String displayAddressValue(Property address) {
        String addressValue = "";
        addressValue = address.getDisplayValue();
        if (addressValue.length() == 0) {
            Property propertyAdr1 = address.getProperty("ADR1");
            addressValue = (propertyAdr1 != null ? propertyAdr1.getValue() : "") + ", ";
            Property propertyAdr2 = address.getProperty("ADR2");
            addressValue = addressValue + (propertyAdr2 != null ? propertyAdr2.getValue() : "") + ", ";
            Property propertyAdr3 = address.getProperty("ADR3");
            addressValue = addressValue + (propertyAdr3 != null ? propertyAdr3.getValue() : "") + ", ";
            Property propertyCity = address.getProperty("CITY");
            addressValue = addressValue + (propertyCity != null ? propertyCity.getValue() : "") + ", ";
            Property propertyState = address.getProperty("STAE");
            addressValue = addressValue + (propertyState != null ? propertyState.getValue() : "") + ", ";
            Property propertyPostalCode = address.getProperty("POST");
            addressValue = addressValue + (propertyPostalCode != null ? propertyPostalCode.getValue() : "") + ", ";
            Property propertyCountry = address.getProperty("CTRY");
            addressValue = addressValue + (propertyCountry != null ? propertyCountry.getValue() : "");
        }
        return addressValue;
    }

    public class ChangeListner
    implements DocumentListener,
    ChangeListener,
    ActionListener {
        private boolean mute = false;

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (!this.mute) {
                IndividualEventPanel.this.mEventModified = true;
                Object propertyName = de.getDocument().getProperty("name");
                if (propertyName != null) {
                    if (propertyName.equals("eventNameTextField")) {
                        IndividualEventPanel.this.mEventNameModified = true;
                    }
                    if (propertyName.equals("eventCauseTextArea")) {
                        IndividualEventPanel.this.mEventCauseModified = true;
                    }
                    if (propertyName.equals("eventDescriptorTextArea")) {
                        IndividualEventPanel.this.mEventTypeModified = true;
                    }
                    if (propertyName.equals("individualAgeTextField")) {
                        IndividualEventPanel.this.mIndividualAgeModified = true;
                    }
                    if (propertyName.equals("placeTextField")) {
                        IndividualEventPanel.this.mPlaceModified = true;
                    }
                    if (propertyName.equals("responsibleAgencyTextField")) {
                        IndividualEventPanel.this.mResponsibleAgencyModified = true;
                    }
                    IndividualEventPanel.this.changeSupport.fireChange();
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            if (!this.mute) {
                IndividualEventPanel.this.mEventModified = true;
                Object propertyName = de.getDocument().getProperty("name");
                if (propertyName != null) {
                    if (propertyName.equals("eventNameTextField")) {
                        IndividualEventPanel.this.mEventTypeModified = true;
                    }
                    if (propertyName.equals("eventCauseTextArea")) {
                        IndividualEventPanel.this.mEventCauseModified = true;
                    }
                    if (propertyName.equals("eventDescriptorTextArea")) {
                        IndividualEventPanel.this.mEventNameModified = true;
                    }
                    if (propertyName.equals("individualAgeTextField")) {
                        IndividualEventPanel.this.mIndividualAgeModified = true;
                    }
                    if (propertyName.equals("placeTextField")) {
                        IndividualEventPanel.this.mPlaceModified = true;
                    }
                    if (propertyName.equals("responsibleAgencyTextField")) {
                        IndividualEventPanel.this.mResponsibleAgencyModified = true;
                    }
                    IndividualEventPanel.this.changeSupport.fireChange();
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            if (!this.mute) {
                IndividualEventPanel.this.mEventModified = true;
                Object propertyName = de.getDocument().getProperty("name");
                if (propertyName != null) {
                    if (propertyName.equals("eventNameTextField")) {
                        IndividualEventPanel.this.mEventTypeModified = true;
                    }
                    if (propertyName.equals("eventCauseTextArea")) {
                        IndividualEventPanel.this.mEventCauseModified = true;
                    }
                    if (propertyName.equals("eventDescriptorTextArea")) {
                        IndividualEventPanel.this.mEventNameModified = true;
                    }
                    if (propertyName.equals("individualAgeTextField")) {
                        IndividualEventPanel.this.mIndividualAgeModified = true;
                    }
                    if (propertyName.equals("placeTextField")) {
                        IndividualEventPanel.this.mPlaceModified = true;
                    }
                    if (propertyName.equals("responsibleAgencyTextField")) {
                        IndividualEventPanel.this.mResponsibleAgencyModified = true;
                    }
                    IndividualEventPanel.this.changeSupport.fireChange();
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (!this.mute) {
                IndividualEventPanel.this.mEventModified = true;
                IndividualEventPanel.this.mEventNameModified = true;
                IndividualEventPanel.this.changeSupport.fireChange();
            }
        }

        public void mute() {
            this.mute = true;
        }

        public void unmute() {
            this.mute = false;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.mute) {
                IndividualEventPanel.this.mEventModified = true;
                IndividualEventPanel.this.mEventNameModified = true;
                IndividualEventPanel.this.changeSupport.fireChange();
            }
        }
    }
}

