/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class EventsListModel
extends AbstractListModel<String> {
    private final ArrayList<String> mIndividualAttributesTags = new ArrayList<String>(){
        {
            this.add("CAST");
            this.add("DSCR");
            this.add("EDUC");
            this.add("IDNO");
            this.add("NATI");
            this.add("NCHI");
            this.add("NMR");
            this.add("OCCU");
            this.add("PROP");
            this.add("RELI");
            this.add("RESI");
            this.add("SSN");
            this.add("TITL");
        }
    };
    List<Property> eventsList = new ArrayList<Property>();

    @Override
    public int getSize() {
        return this.eventsList.size();
    }

    @Override
    public String getElementAt(int row) {
        if (row < this.eventsList.size()) {
            String date;
            Property propertyEvent = this.eventsList.get(row);
            Property p = propertyEvent.getProperty("DATE");
            PropertyDate propertyDate = (PropertyDate)(p instanceof PropertyDate ? p : null);
            String string = date = propertyDate != null ? propertyDate.getDisplayValue() : null;
            if (propertyEvent.getTag().equals("EVEN") || propertyEvent.getTag().equals("FACT")) {
                Property eventType = propertyEvent.getProperty("TYPE");
                return PropertyTag2Name.getTagName(propertyEvent.getTag()) + (eventType != null ? " " + eventType.getValue() : "") + (date != null ? " - " + date : "");
            }
            if (this.mIndividualAttributesTags.contains(propertyEvent.getTag())) {
                return PropertyTag2Name.getTagName(propertyEvent.getTag()) + " " + propertyEvent.getValue() + (date != null ? " - " + date : "");
            }
            return PropertyTag2Name.getTagName(propertyEvent.getTag()) + (date != null ? " - " + date : "");
        }
        return "";
    }

    public int indexOf(Object o) {
        return this.eventsList.indexOf(o);
    }

    public void addAll(List<Property> eventsList) {
        if (!eventsList.isEmpty()) {
            this.eventsList.addAll(eventsList);
            this.fireIntervalAdded(this, 0, this.eventsList.size() - 1);
        }
    }

    public void add(Property event) {
        this.eventsList.add(event);
        this.fireIntervalAdded(this, 0, this.eventsList.size() - 1);
    }

    public Property getValueAt(int row) {
        return this.eventsList.get(row);
    }

    public Property remove(int row) {
        Property event = this.eventsList.remove(row);
        this.fireContentsChanged(this, 0, this.eventsList.size() - 1);
        return event;
    }

    public void clear() {
        this.eventsList.clear();
        this.fireContentsChanged(this, 0, this.eventsList.size() - 1);
    }
}

