/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.beans;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImageBean
extends JPanel {
    private String[] genders = new String[]{"unknown", "male", "female"};
    private boolean isDefault = true;
    private Image loadImage = null;
    private Image scaledImage = null;

    public ImageBean() {
        try {
            this.loadImage = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/genealogyeditor/resources/profile_" + this.genders[0] + ".png"));
            this.isDefault = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(null);
        this.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/beans/Bundle").getString("ImageBean.toolTipText"), new Object[0]));
        this.setMinimumSize(new Dimension(150, 200));
        this.setName(NbBundle.getMessage(ImageBean.class, (String)"ImageBean.name"));
        this.setPreferredSize(new Dimension(150, 200));
        this.setRequestFocusEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ImageBean.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 150, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.loadImage != null) {
            this.scaledImage = this.getWidth() < this.getHeight() ? this.loadImage.getScaledInstance(this.getWidth(), -1, 1) : this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
            this.repaint();
        }
    }

    public void setImage(File file, int defaultGender) {
        if (file != null && file.exists()) {
            try {
                FileInputStream imageInputStream = new FileInputStream(file);
                this.loadImage = ImageIO.read(imageInputStream);
                if (this.loadImage != null) {
                    if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                        this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                    } else if (this.getHeight() > 0) {
                        this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                    }
                }
                this.isDefault = false;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            InputStream imageInputStream = ImageBean.class.getResourceAsStream("/ancestris/modules/editors/genealogyeditor/resources/profile_" + this.genders[defaultGender] + ".png");
            try {
                this.loadImage = ImageIO.read(imageInputStream);
                if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                    this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                } else if (this.getHeight() > 0) {
                    this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                }
                this.isDefault = true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.repaint();
    }

    public void setImage(byte[] imageData, int defaultGender) {
        if (imageData != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
            try {
                this.loadImage = ImageIO.read(bais);
                if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                    this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                } else if (this.getHeight() > 0) {
                    this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                }
                this.isDefault = false;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            try {
                this.loadImage = ImageIO.read(ImageBean.class.getResourceAsStream("/ancestris/modules/editors/genealogyeditor/resources/profile_" + this.genders[defaultGender] + ".png"));
                if (this.getWidth() > 0 && this.getWidth() < this.getHeight()) {
                    this.scaledImage = this.loadImage.getScaledInstance(this.getWidth(), -1, 1);
                } else if (this.getHeight() > 0) {
                    this.scaledImage = this.loadImage.getScaledInstance(-1, this.getHeight(), 1);
                }
                this.isDefault = true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            ((Graphics2D)g).drawImage(this.scaledImage, 0 + (this.getWidth() - this.scaledImage.getWidth(this)) / 2, (this.getHeight() - this.scaledImage.getHeight(this)) / 2, null);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

