/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.actions;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.modules.editors.genealogyeditor.actions.Bundle;
import ancestris.modules.editors.genealogyeditor.editors.FamilyEditor;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class TreeViewOpenGenealogyEditorAction
extends AbstractAction
implements ContextAwareAction {
    private Gedcom gedcom = null;
    private Entity entity = null;

    @Override
    public void actionPerformed(ActionEvent ae) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new OpenEditor((Entity)context.lookup(Entity.class));
    }

    private static final class OpenEditor
    extends AbstractAncestrisAction {
        Entity entity;

        public OpenEditor(Entity context) {
            this.entity = context;
            this.setText(Bundle.OpenInEditor_title());
            this.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        }

        public void actionPerformed(ActionEvent e) {
            SelectionDispatcher.muteSelection((boolean)true);
            if (this.entity != null) {
                Gedcom gedcom = this.entity.getGedcom();
                int undoNb = gedcom.getUndoNb();
                if (this.entity instanceof Indi) {
                    IndividualEditor individualEditor = new IndividualEditor();
                    individualEditor.setContext(new Context(this.entity));
                    if (!individualEditor.showPanel()) {
                        while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                            gedcom.undoUnitOfWork(false);
                        }
                    }
                } else if (this.entity instanceof Fam) {
                    FamilyEditor familyEditor = new FamilyEditor();
                    familyEditor.setContext(new Context(this.entity));
                    if (!familyEditor.showPanel()) {
                        while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                            gedcom.undoUnitOfWork(false);
                        }
                    }
                }
                SelectionDispatcher.muteSelection((boolean)false);
            }
        }
    }
}

