/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import java.util.Collection;
import java.util.List;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class NoteQuickSearch
implements SearchProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        NoteQuickSearch noteQuickSearch = this;
        synchronized (noteQuickSearch) {
            for (Context context : GedcomDirectory.getDefault().getContexts()) {
                String[] ENTITIES;
                for (Note note : context.getGedcom().getNotes()) {
                    String rep = Utilities.getPhraseBit((String)note.getDisplayValue(), (String)request.getText());
                    if (rep == null) continue;
                    rep = rep + " (" + note.getId() + ")";
                    if (response.addResult(this.createAction((Property)note), rep)) continue;
                    return;
                }
                for (String type : ENTITIES = new String[]{"INDI", "FAM"}) {
                    Collection entities = context.getGedcom().getEntities(type);
                    block6: for (Entity entity : entities) {
                        List properties = entity.getAllProperties("NOTE");
                        for (Property noteProp : properties) {
                            String rep;
                            String text;
                            if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getDisplayValue().trim()).isEmpty() || (rep = Utilities.getPhraseBit((String)text, (String)request.getText())) == null) continue;
                            rep = rep + " (" + noteProp.getEntity().getId() + ")";
                            if (response.addResult(this.createAction(noteProp), rep)) continue block6;
                            return;
                        }
                    }
                }
            }
        }
    }

    private Runnable createAction(final Property property) {
        return new Runnable(){

            @Override
            public void run() {
                SelectionDispatcher.fireSelection((Context)new Context(property));
            }
        };
    }
}

