/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.geneanet;

import ancestris.reports.geneanet.GeneanetIndexLine;
import ancestris.reports.geneanet.Location;
import genj.fo.Document;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportGedcom2Geneanet
extends Report {
    private Map locationTranslationTable = new HashMap();
    private ArrayList gedcomPlaceFormatList = null;
    private String[] arrayTypes = new String[]{"W", "A", "D", "F", "L", "P", "R"};
    public int sourceType = 0;
    public String[] sourceTypes = new String[]{this.translate("type_W"), this.translate("type_A"), this.translate("type_D"), this.translate("type_F"), this.translate("type_L"), this.translate("type_P"), this.translate("type_R")};
    public int superiorYearLimit = 0;
    private static final TagPath OCCUPATION_TAG = new TagPath("INDI:OCCU");
    private static final TagPath TITLE_TAG = new TagPath("INDI:TITL");
    private String gedcomName = null;
    private Map geneanetIndexLinesMap1 = new HashMap();
    public Config conf = new Config();

    public Document start(Gedcom gedcom) {
        this.gedcomName = gedcom.getName();
        if (!this.initializeLocationIndex(gedcom)) {
            return null;
        }
        if (Location.existPLACTag) {
            Location.initializeLocationElementIndex(this.locationTranslationTable);
        }
        Collection indis = gedcom.getEntities("INDI");
        Iterator it = indis.iterator();
        while (it.hasNext()) {
            this.analyze((Indi)it.next());
        }
        return this.generateOutput();
    }

    private Document generateOutput() {
        Document doc = new Document(this.getName());
        doc.startTable("genj:csv=true,width=100%");
        this.generateHeader(doc);
        Object[] keys = this.geneanetIndexLinesMap1.keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Map map2 = (Map)this.geneanetIndexLinesMap1.get(keys[i]);
            Iterator i2 = map2.keySet().iterator();
            while (i2.hasNext()) {
                GeneanetIndexLine line = (GeneanetIndexLine)map2.get((String)i2.next());
                doc.nextTableRow();
                doc.nextTableCell();
                doc.addText(line.toString());
            }
        }
        return doc;
    }

    private void analyze(Indi indi) {
        PropertyPlace place2 = null;
        PropertyDate date2 = null;
        if (indi.isPrivate()) {
            return;
        }
        String name = indi.getLastName();
        if (name.length() == 0) {
            return;
        }
        name = name.trim();
        try {
            for (PropertyPlace place2 : indi.getProperties(PropertyPlace.class)) {
                if (place2.toString().replaceAll(",", "").trim().length() == 0 || place2.isPrivate()) continue;
                int startYear = Integer.MAX_VALUE;
                int endYear = Integer.MIN_VALUE;
                for (PropertyDate date2 : place2.getParent().getProperties(PropertyDate.class)) {
                    int end;
                    if (!date2.isValid() || date2.isPrivate()) continue;
                    int start = date2.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    if (start > (end = date2.isRange() ? date2.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : start) || this.superiorYearLimit != 0 && start > this.superiorYearLimit) continue;
                    startYear = Math.min(startYear, start);
                    endYear = Math.max(endYear, end);
                }
                if (startYear == Integer.MAX_VALUE) continue;
                String info = "";
                if (indi.getProperty(TITLE_TAG) != null) {
                    info = indi.getProperty(TITLE_TAG).getValue();
                } else if (indi.getProperty(OCCUPATION_TAG) != null) {
                    info = indi.getProperty(OCCUPATION_TAG).getValue();
                }
                Map locationAsKeyMap = (Map)this.lookup(this.geneanetIndexLinesMap1, name, HashMap.class);
                GeneanetIndexLine line = (GeneanetIndexLine)this.lookup(locationAsKeyMap, Location.buildLocationKey(place2), GeneanetIndexLine.class);
                line.add(name, info, startYear, endYear, new Location(place2), this.arrayTypes[this.sourceType]);
            }
        }
        catch (Throwable t) {
            LOG.warning("indi : " + indi.getName() + " " + indi.getFirstName() + " " + t.toString());
        }
    }

    private Object lookup(Map<String, Object> index, String key, Class fallback) {
        Object result = index.get(key);
        if (result == null) {
            try {
                result = fallback.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IllegalArgumentException("can't instantiate fallback " + fallback);
            }
            index.put(key, result);
        }
        return result;
    }

    private boolean initializeLocationIndex(Gedcom gedcom) {
        if (gedcom.getPlaceFormat() == "") {
            Location.existPLACTag = false;
            return true;
        }
        Object chosenOrderText = null;
        this.gedcomPlaceFormatList = new ArrayList<String>(Arrays.asList(gedcom.getPlaceFormat().split("\\,")));
        Location.existPLACTag = true;
        String[] locationJuridictionArray = gedcom.getPlaceFormat().split("\\,");
        this.conf.townIndexs = locationJuridictionArray;
        ArrayList townIdJuridictionList = (ArrayList)this.gedcomPlaceFormatList.clone();
        townIdJuridictionList.add(this.translate("nothing"));
        String[] townIdJuridictionArray = townIdJuridictionList.toArray(new String[townIdJuridictionList.size()]);
        this.conf.townIdIndexs = townIdJuridictionArray;
        this.conf.subRegionIndexs = locationJuridictionArray;
        this.conf.regionIndexs = locationJuridictionArray;
        this.conf.countryIndexs = locationJuridictionArray;
        if (!this.getOptionsFromUser(this.translate("placeFormatAsking"), this.conf)) {
            return false;
        }
        this.locationTranslationTable.put("P", new Integer(this.conf.townIndex));
        this.locationTranslationTable.put("Z", new Integer(this.conf.townIdIndex));
        this.locationTranslationTable.put("S", new Integer(this.conf.subRegionIndex));
        this.locationTranslationTable.put("R", new Integer(this.conf.regionIndex));
        this.locationTranslationTable.put("C", new Integer(this.conf.countryIndex));
        return true;
    }

    private Document generateOutput(List geneanetList) {
        Iterator it = geneanetList.iterator();
        Document doc = new Document(this.getName());
        doc.startTable("genj:csv=true,width=100%");
        this.generateHeader(doc);
        while (it.hasNext()) {
            GeneanetIndexLine geneanet = (GeneanetIndexLine)it.next();
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText(geneanet.toString());
        }
        return doc;
    }

    private void generateHeader(Document doc) {
        doc.nextTableRow();
        doc.nextTableCell();
        doc.addText("# ---------------------------------------------------");
        doc.nextTableRow();
        doc.nextTableCell();
        doc.addText("# " + this.translate("gedcomFile", new Object[]{this.gedcomName}));
        if (Location.existPLACTag) {
            String townIdElement;
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText("# " + this.translate("placeFormatAsking") + " : ");
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText("# Geneanet " + this.translate("town") + " : " + this.gedcomPlaceFormatList.get((Integer)this.locationTranslationTable.get("P")));
            doc.nextTableRow();
            doc.nextTableCell();
            try {
                townIdElement = (String)this.gedcomPlaceFormatList.get((Integer)this.locationTranslationTable.get("Z"));
            }
            catch (IndexOutOfBoundsException e) {
                townIdElement = this.translate("nothing");
            }
            doc.addText("# Geneanet " + this.translate("townId") + " : " + townIdElement);
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText("# Geneanet " + this.translate("subregion") + " : " + this.gedcomPlaceFormatList.get((Integer)this.locationTranslationTable.get("S")));
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText("# Geneanet " + this.translate("region") + " : " + this.gedcomPlaceFormatList.get((Integer)this.locationTranslationTable.get("R")));
            doc.nextTableRow();
            doc.nextTableCell();
            doc.addText("# Geneanet " + this.translate("country") + " : " + this.gedcomPlaceFormatList.get((Integer)this.locationTranslationTable.get("C")));
        }
        doc.nextTableRow();
        doc.nextTableCell();
        doc.addText("# " + this.translate("superiorYearLimit") + " : " + (this.superiorYearLimit != 0 ? Integer.toString(this.superiorYearLimit) : this.translate("noYearLimit")));
        doc.nextTableRow();
        doc.nextTableCell();
        doc.addText("# ---------------------------------------------------");
    }

    private void getInfo(List indiList, GeneanetIndexLine geneanet) {
        String occupation = null;
        String title = null;
        boolean isOccupationStillFillable = true;
        boolean isTitleStillFillable = true;
        for (Indi indi : indiList) {
            if (!isTitleStillFillable) continue;
            if (indi.getProperty(TITLE_TAG) != null) {
                if (title != null) {
                    isTitleStillFillable = false;
                    continue;
                }
                title = indi.getProperty(TITLE_TAG).getValue();
                continue;
            }
            if (!isOccupationStillFillable || indi.getProperty(OCCUPATION_TAG) == null) continue;
            if (occupation != null) {
                isOccupationStillFillable = false;
                continue;
            }
            occupation = indi.getProperty(OCCUPATION_TAG).getValue();
        }
        if (isTitleStillFillable) {
            if (title != null) {
                geneanet.setInfo(title);
            } else if (isOccupationStillFillable && occupation != null) {
                geneanet.setInfo(occupation);
            }
        } else {
            geneanet.setInfo("");
        }
        if (isOccupationStillFillable && occupation != null) {
            geneanet.setInfo(occupation);
        }
    }

    public class Config {
        public int townIndex = 0;
        public String[] townIndexs = new String[]{""};
        public int townIdIndex = 0;
        public String[] townIdIndexs = new String[]{""};
        public int subRegionIndex = 0;
        public String[] subRegionIndexs = new String[]{""};
        public int regionIndex = 0;
        public String[] regionIndexs = new String[]{""};
        public int countryIndex = 0;
        public String[] countryIndexs = new String[]{""};
    }
}

