/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public class ReportGenealogyStatus
extends Report {
    public int maxNbOfAncestors = 512;
    public boolean includeSiblings = false;
    public String directoryOption = "";
    private static String SOSATAG = "_SOSA";
    private static String OUI = "1";
    private static String NON = ".";
    private static String ERR = "#";
    private static String SEQ = "o";
    private static String FIL = "S";
    private static String SPA = " ";
    private static String TAB = "\t";
    private String[] placeFormat = null;
    private int sizePlaces = this.placeFormat != null ? this.placeFormat.length : 0;
    private Map<String, Indi> sosaList = new TreeMap<String, Indi>();
    private Map<Source, String> sourceMap = new TreeMap<Source, String>();
    private Map<String, String> entMap = new TreeMap<String, String>();
    private int cntAnomaly = 0;
    private int cntOutOfSeq = 0;
    private int cntKnwnSrc = 0;

    public void start(Gedcom gedcom) {
        int i;
        Collection entities = gedcom.getEntities("INDI");
        for (Indi indi : entities) {
            Property[] props = indi.getProperties(SOSATAG);
            if (props == null) continue;
            for (i = 0; i < props.length; ++i) {
                Property prop = props[i];
                String sosaStr = prop.getValue();
                if (!this.includeSiblings && (sosaStr.indexOf("+") != -1 || sosaStr.indexOf("-") != -1) && sosaStr.indexOf("00000001") == -1) continue;
                this.sosaList.put(sosaStr, indi);
            }
        }
        if (this.sosaList.isEmpty()) {
            this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_NoSosaFound"));
            this.println("========");
            return;
        }
        this.placeFormat = this.validatePlaceFormat(gedcom.getPlaceFormat());
        this.headerLine();
        int sosaCnt = 1;
        i = 1;
        for (String key : this.sosaList.keySet()) {
            Indi indi = this.sosaList.get(key);
            int sosaNb = this.getSosaNb(key);
            if (sosaNb > 1) {
                ++sosaCnt;
            }
            while (sosaNb > sosaCnt && sosaCnt < this.maxNbOfAncestors) {
                this.println(this.emptyLine());
                ++sosaCnt;
            }
            this.println(this.getLine(indi, i++, key));
            if (i / 10 * 10 != i) continue;
            this.midLine();
        }
        this.sosaList.clear();
        this.sourceMap.clear();
        this.println(" ");
        this.println(" ");
        this.println("========");
        this.println(" ");
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_sources_header"));
        this.println(" ");
        List ents = gedcom.getEntities();
        for (Entity ent : ents) {
            List ps = ent.getProperties(PropertyXRef.class);
            for (PropertyXRef xref : ps) {
                Entity entity = xref.getTargetEntity();
                if (entity == null) continue;
                String str = this.entMap.get(entity.getId());
                if (str == null) {
                    this.entMap.put(entity.getId(), ent.getId());
                    continue;
                }
                this.entMap.put(entity.getId(), str + "," + ent.getId());
            }
        }
        for (Entity ent : ents) {
            String str = this.entMap.get(ent.getId());
            if (str == null) {
                this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_entity_not_used") + ent.getId());
            }
            if (str == null || this.numberOf(str, ",") <= this.numberOf(str, "R") || !(ent instanceof Source)) continue;
            this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_multiple_source") + ent.getId() + " - " + str);
        }
        this.entMap.clear();
        this.println(" ");
        this.println(" ");
        this.println("========");
        this.println(" ");
        ArrayList<String> gedcomFiles = new ArrayList<String>();
        entities = gedcom.getEntities();
        for (Entity ent : entities) {
            for (PropertyFile file : ent.getProperties(PropertyFile.class)) {
                gedcomFiles.add(file.getFile().getName());
            }
        }
        File directory = new File(this.directoryOption);
        boolean found = false;
        if (directory != null) {
            this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_unused_media", (Object)directory.toString()));
            this.println(" ");
            found = this.checkDirectory(directory, gedcomFiles);
        }
        if (!found) {
            this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_directory"));
        }
        this.println(" ");
        this.println(" ");
        this.println("========");
        this.println(" ");
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_counters"));
        this.println(" ");
        this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_anomalies") + " (" + ERR + ")                   : " + this.cntAnomaly);
        this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_sequence") + " (" + SEQ + ")  : " + this.cntOutOfSeq);
        this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_source") + " (" + FIL + ") : " + this.cntKnwnSrc);
        this.println(" ");
        this.println(" ");
        this.println("========");
    }

    private void headerLine() {
        this.println("Nb " + TAB + "Sosa              " + TAB + "Gen" + TAB + "Id   " + TAB + "Med" + TAB + "Birt" + SPA + "Deat" + SPA + "Marr" + SPA + "Fam  " + TAB + "Marl" + SPA + "Marc" + SPA + "Div " + TAB + "Chr " + SPA + "Buri" + SPA + "Occu" + SPA + "Resi" + SPA + "Grad" + SPA + "Even" + SPA + "Natu" + SPA + "Adop" + SPA + "Immi" + SPA + "Nom                     ");
        this.midLine();
    }

    private void midLine() {
        this.println("---" + TAB + "------------------" + TAB + "---" + TAB + "-----" + TAB + "---" + TAB + "----" + SPA + "----" + SPA + "----" + SPA + "-----" + TAB + "----" + SPA + "----" + SPA + "----" + TAB + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "----" + SPA + "------------------------");
    }

    private String emptyLine() {
        return ".  " + TAB + ".                 " + TAB + ".   " + TAB + ".    " + TAB + ".  " + TAB + ".   " + SPA + ".   " + SPA + ".   " + SPA + "     " + TAB + "    " + SPA + "    " + SPA + "    " + TAB + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + "    " + SPA + ".                       ";
    }

    private String getLine(Indi indi, int index, String sosa) {
        String line = "";
        line = line + index;
        line = line + TAB;
        line = line + sosa + "                     ".substring(sosa.length());
        line = line + TAB;
        int sosaNb = this.getSosaNb(sosa);
        line = line + (sosaNb == 0 ? "--" : Integer.valueOf((int)(Math.log(2 * sosaNb) / Math.log(2.0))));
        line = line + TAB;
        line = line + indi.getId();
        line = line + TAB;
        Property[] props = indi.getProperties(new TagPath("INDI:OBJE:FILE"));
        line = line + (props == null || props.length == 0 ? NON : Integer.valueOf(props.length));
        line = line + TAB;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:BIRT", true);
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:DEAT", sosaNb > 15);
        line = line + SPA;
        line = line + this.getFamilies(sosa, indi, sosaNb > 1 && sosa.indexOf("-") == -1);
        line = line + TAB;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:CHR", false);
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:BURI", false);
        line = line + SPA;
        line = line + this.getMultipleEvent(sosa, (Entity)indi, "OCCU");
        line = line + SPA;
        line = line + this.getMultipleEvent(sosa, (Entity)indi, "RESI");
        line = line + SPA;
        line = line + this.getMultipleEvent(sosa, (Entity)indi, "GRAD");
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:EVEN", false);
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:NATU", false);
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:ADOP", false);
        line = line + SPA;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:IMMI", false);
        line = line + SPA;
        line = line + indi.getLastName() + ", " + indi.getFirstName().substring(0, Math.min(10, indi.getFirstName().length()));
        return line;
    }

    private int getSosaNb(String str) {
        int start;
        int end = str.length() - 1;
        for (start = 0; start <= end && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return 0;
        }
        int sosaNb = Integer.parseInt(str.substring(start, end));
        return sosaNb;
    }

    private String getEvent(String sosa, Entity ent, String tag, boolean mandatory) {
        String line = "";
        Property prop = ent.getPropertyByPath(tag);
        if (prop == null) {
            return mandatory ? this.err() + this.err() + this.err() + this.err() : "    ";
        }
        line = line + this.isValidAndComplete(ent.getPropertyByPath(tag + ":DATE"));
        line = line + this.isValidAndComplete(ent.getPropertyByPath(tag + ":PLAC"));
        line = line + this.getSource(sosa, ent, tag + ":SOUR");
        return line;
    }

    private String getMultipleEvent(String sosa, Entity ent, String tag) {
        String line = "";
        boolean debug = false;
        boolean isOccu = tag.equalsIgnoreCase("OCCU");
        boolean isGrad = tag.equalsIgnoreCase("GRAD");
        boolean isResi = tag.equalsIgnoreCase("RESI");
        Property[] prop = ent.getProperties(tag);
        if (prop == null || prop.length == 0) {
            return "    ";
        }
        int intNbFound = 0;
        String src = "  ";
        for (int i = 0; i < prop.length; ++i) {
            Property address;
            Property property = prop[i];
            if (isOccu) {
                String str = property.toString();
                intNbFound += str != null && str.length() > 0 ? 1 : 0;
            }
            if (isGrad) {
                Property agency = property.getProperty("AGNC");
                intNbFound += agency == null || agency.toString().length() < 1 ? 0 : 1;
            }
            if (isResi && (address = property.getProperty("ADDR")) != null) {
                Property city = address.getProperty("CITY");
                intNbFound += city == null || city.toString().length() < 1 ? 0 : 1;
            }
            String tmpSrc = this.getSource(sosa, ent, tag + ":SOUR");
            if (src.compareTo(ERR) != -1) continue;
            if (tmpSrc.compareTo(ERR) != -1) {
                src = tmpSrc;
                continue;
            }
            if (src.compareTo(FIL) == -1) {
                src = tmpSrc;
            }
            if (tmpSrc.compareTo(FIL) != -1) {
                src = tmpSrc;
                continue;
            }
            if (src.compareTo(NON) == -1) {
                src = tmpSrc;
            }
            if (tmpSrc.compareTo(NON) == -1) continue;
            src = tmpSrc;
        }
        line = line + (prop.length == 0 ? NON : String.valueOf(prop.length));
        line = line + (intNbFound == 0 ? NON : String.valueOf(intNbFound));
        line = line + src;
        return line;
    }

    private String getSource(String sosa, Entity ent1, String tag) {
        String src = "";
        Property[] props = ent1.getProperties(new TagPath(tag));
        if (props == null || props.length == 0) {
            return NON + NON;
        }
        if (props.length != 1) {
            return this.err() + this.err();
        }
        Property prop = props[0];
        if (prop == null || !(prop instanceof PropertyXRef)) {
            src = src + NON + NON;
        } else {
            Entity ent2 = ((PropertyXRef)prop).getTargetEntity();
            if (ent2 instanceof Source) {
                Source source = (Source)ent2;
                String sosa2 = this.sourceMap.get(source);
                if (sosa2 == null || sosa2.compareTo(sosa) != 0) {
                    this.sourceMap.put(source, sosa);
                    src = src + OUI;
                } else {
                    src = src + this.err();
                }
                Property ptext = ent2.getProperty("TEXT");
                Property pobje = ent2.getPropertyByPath("SOUR:OBJE:FILE");
                src = src + (ptext == null || ptext.toString().length() < 1 ? (pobje == null ? NON : this.err()) : (pobje == null ? this.fil() : OUI));
            } else {
                src = src + this.err() + NON;
            }
        }
        return src;
    }

    private String getFamilies(String sosa, Indi indi, boolean mandatory) {
        String line = "";
        Fam[] families = indi.getFamiliesWhereSpouse();
        if (families == null || families.length == 0) {
            return (mandatory ? this.err() + this.err() + this.err() + this.err() : "    ") + SPA + "    " + TAB + "    " + SPA + "    " + SPA + "    ";
        }
        Fam famFound = null;
        for (int i = 0; i < families.length; ++i) {
            Fam family = families[i];
            Indi spouse = family.getHusband();
            if (spouse == indi) {
                spouse = family.getWife();
            }
            if (spouse != null && spouse.getProperty(SOSATAG) == null && sosa.indexOf("-") == -1) continue;
            famFound = family;
            break;
        }
        if (famFound != null) {
            line = line + this.getEvent(sosa, (Entity)famFound, "FAM:MARR", mandatory);
            line = line + this.checkKidsOrder(famFound);
            line = line + TAB;
            line = line + famFound.getId();
            line = line + TAB;
            line = line + this.getEvent(sosa, (Entity)famFound, "FAM:MARL", false);
            line = line + SPA;
            line = line + this.getEvent(sosa, (Entity)famFound, "FAM:MARC", false);
            line = line + SPA;
            line = line + this.getEvent(sosa, (Entity)famFound, "FAM:DIV", false);
            return line;
        }
        return NON + NON + NON + NON + TAB + NON + NON + NON + NON + TAB + "    " + SPA + "    " + SPA + "    ";
    }

    private String isValidAndComplete(Property prop) {
        if (prop == null || !(prop instanceof PropertyDate) && !(prop instanceof PropertyPlace)) {
            return NON;
        }
        if (prop instanceof PropertyDate) {
            PropertyDate pDate = (PropertyDate)prop;
            if (pDate == null || !pDate.isValid() || pDate.isRange()) {
                return NON;
            }
            PropertyDate.Format pf = pDate.getFormat();
            if (pf != PropertyDate.DATE) {
                return NON;
            }
            PointInTime pit = pDate.getStart();
            if (!pit.isValid() || !pit.isComplete()) {
                return NON;
            }
            return OUI;
        }
        if (prop instanceof PropertyPlace) {
            String[] place = prop.toString().split("\\,", -1);
            if (this.sizePlaces > 0 && place.length != this.sizePlaces) {
                return NON;
            }
            if (this.isEmpty(place)) {
                return NON;
            }
            return OUI;
        }
        return NON;
    }

    private boolean isEmpty(String[] tags) {
        if (tags == null) {
            return true;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private String[] validatePlaceFormat(String placeFormat) {
        String[] tags = null;
        if (placeFormat.length() != 0) {
            tags = placeFormat.split("\\,", -1);
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = tags[i].trim();
            }
        }
        return tags;
    }

    private String checkKidsOrder(Fam family) {
        String line = "";
        Indi[] kids = family.getChildren(false);
        if (kids == null || kids.length < 2) {
            return "";
        }
        PropertyDate pDatePrev = null;
        for (int i = 0; i < kids.length; ++i) {
            PropertyDate pDate = kids[i].getBirthDate();
            if (pDate == null || !pDate.isValid()) continue;
            if (pDatePrev != null && pDate.compareTo((Property)pDatePrev) < 0) {
                return this.seq();
            }
            pDatePrev = pDate;
        }
        return "";
    }

    private int numberOf(String str, String seq) {
        if (str == null || seq == null) {
            return 0;
        }
        int value = 0;
        int pos = 1;
        while (pos < str.length() && (pos = str.indexOf(seq, pos - 1) + 2) != 1) {
            ++value;
        }
        return value;
    }

    private String err() {
        ++this.cntAnomaly;
        return ERR;
    }

    private String seq() {
        ++this.cntOutOfSeq;
        return SEQ;
    }

    private String fil() {
        ++this.cntKnwnSrc;
        return FIL;
    }

    private boolean checkDirectory(File directory, List<String> gedcomFiles) {
        boolean found = false;
        File[] files = directory.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                found = found || this.checkDirectory(files[i], gedcomFiles);
                continue;
            }
            String filename = files[i].getName();
            if (gedcomFiles.contains(filename)) continue;
            this.println(files[i].toString());
            found = true;
        }
        return found;
    }
}

