/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openide.util.Lookup;

public class ReportLoader {
    private List<Report> instances = new ArrayList<Report>(Lookup.getDefault().lookupAll(Report.class));
    private static volatile ReportLoader singleton;

    static void clear() {
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportLoader getInstance() {
        if (singleton != null) return singleton;
        Class<ReportLoader> clazz = ReportLoader.class;
        synchronized (ReportLoader.class) {
            if (singleton != null) return singleton;
            singleton = new ReportLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Report getReportByName(String classname) {
        for (Report report : this.instances) {
            if (!report.getClass().getName().equals(classname)) continue;
            return report;
        }
        return null;
    }

    private ReportLoader() {
        Collections.sort(this.instances, new Comparator<Report>(){

            @Override
            public int compare(Report a, Report b) {
                try {
                    return a.getName().compareTo(b.getName());
                }
                catch (Throwable t) {
                    return 0;
                }
            }
        });
    }

    public Report[] getReports() {
        return this.getReports(true);
    }

    public Report[] getReports(boolean showHidden) {
        ArrayList<Report> result = new ArrayList<Report>(this.instances.size());
        for (Report r : this.instances) {
            if (r.isHidden()) continue;
            result.add(r);
        }
        return result.toArray(new Report[result.size()]);
    }

    void saveOptions() {
        Report[] rs = this.getReports();
        for (int r = 0; r < rs.length; ++r) {
            if (rs[r].isHidden()) continue;
            rs[r].saveOptions();
        }
    }
}

