/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.Report;
import genj.report.ReportSelectionListener;
import genj.report.ReportView;
import genj.util.Registry;
import genj.util.Resources;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ReportList
extends JScrollPane {
    public static final int VIEW_LIST = 0;
    public static final int VIEW_TREE = 1;
    private Report[] reports;
    private JTree tree = null;
    private int viewType;
    private Report selection = null;
    private Callback callback = new Callback();
    private ReportSelectionListener selectionListener = null;
    private TreeModel treeModel = null;
    private TreeModel listModel = null;
    private static final Registry registry = Registry.get(ReportList.class);
    private static final Resources RESOURCES = Resources.get(ReportView.class);

    public ReportList(Report[] reports, int viewType) {
        this.reports = reports;
        this.viewType = viewType;
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(this.callback);
        this.tree.addTreeSelectionListener(this.callback);
        this.tree.addTreeExpansionListener(this.callback);
        this.tree.setRootVisible(false);
        this.setViewportView(this.tree);
        this.refreshView();
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
        this.refreshView();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setSelection(Report report) {
        this.selection = report;
        if (this.selection == null) {
            this.tree.clearSelection();
        } else {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath path = this.tree.getPathForRow(i);
                Object v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                if (v != this.selection) continue;
                this.tree.addSelectionPath(path);
                this.tree.makeVisible(path);
                break;
            }
        }
    }

    public Report getSelection() {
        return this.selection;
    }

    public void setSelectionListener(ReportSelectionListener listener) {
        this.selectionListener = listener;
    }

    public void setReports(Report[] reports) {
        this.reports = reports;
        this.listModel = null;
        this.treeModel = null;
        this.refreshView();
    }

    private void refreshView() {
        Report oldSelection = this.getSelection();
        if (this.viewType == 0) {
            if (this.listModel == null) {
                this.listModel = this.createList();
            }
            this.tree.setModel(this.listModel);
        } else {
            if (this.treeModel == null) {
                this.treeModel = this.createTree();
            }
            this.tree.setModel(this.treeModel);
            this.refreshExpanded();
        }
        this.setSelection(oldSelection);
    }

    private void refreshExpanded() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath path = this.tree.getPathForRow(i);
            Object v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(v instanceof Report.Category)) continue;
            Report.Category category = (Report.Category)v;
            if (registry.get("expanded." + category.getName(), true)) {
                this.tree.expandPath(path);
                continue;
            }
            this.tree.collapsePath(path);
        }
    }

    private TreeModel createList() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode();
        for (int i = 0; i < this.reports.length; ++i) {
            top.add(new DefaultMutableTreeNode(this.reports[i]));
        }
        return new DefaultTreeModel(top);
    }

    private TreeModel createTree() {
        CategoryList list;
        TreeMap<String, CategoryList> categories = new TreeMap<String, CategoryList>();
        for (int i = 0; i < this.reports.length; ++i) {
            String name = this.reports[i].getCategory().getDisplayName();
            list = (CategoryList)categories.get(name);
            if (list == null) {
                list = new CategoryList(this.reports[i].getCategory());
                categories.put(name, list);
            }
            list.add(this.reports[i]);
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode();
        Iterator iterator = categories.entrySet().iterator();
        while (iterator.hasNext()) {
            list = (CategoryList)iterator.next().getValue();
            DefaultMutableTreeNode cat = new DefaultMutableTreeNode(list.getCategory());
            Report[] reps = list.getReportsInCategory();
            for (int i = 0; i < reps.length; ++i) {
                cat.add(new DefaultMutableTreeNode(reps[i]));
            }
            top.add(cat);
        }
        return new DefaultTreeModel(top);
    }

    private static class CategoryList {
        private Report.Category category;
        private List reportsInCategory = new ArrayList();

        public CategoryList(Report.Category category) {
            this.category = category;
        }

        public Report.Category getCategory() {
            return this.category;
        }

        public Report[] getReportsInCategory() {
            return this.reportsInCategory.toArray(new Report[this.reportsInCategory.size()]);
        }

        public void add(Report report) {
            this.reportsInCategory.add(report);
        }
    }

    private class Callback
    implements TreeCellRenderer,
    TreeSelectionListener,
    TreeExpansionListener {
        private DefaultTreeCellRenderer defTreeRenderer = new DefaultTreeCellRenderer();

        private Callback() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int index, boolean hasFocus) {
            this.defTreeRenderer.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, index, hasFocus);
            Object v = ((DefaultMutableTreeNode)value).getUserObject();
            if (v instanceof Report) {
                Report report = (Report)v;
                this.defTreeRenderer.setText(report.getName());
                this.defTreeRenderer.setIcon(report.getIcon());
            } else if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                this.defTreeRenderer.setText(category.getDisplayName());
                this.defTreeRenderer.setIcon((Icon)category.getImage());
            }
            return this.defTreeRenderer;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object v;
            ReportList.this.selection = null;
            TreePath path = ReportList.this.tree.getSelectionPath();
            if (path != null && (v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Report) {
                ReportList.this.selection = (Report)v;
            }
            if (ReportList.this.selectionListener != null) {
                ReportList.this.selectionListener.valueChanged(ReportList.this.selection);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            Object v = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
            if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                registry.put("expanded." + category.getName(), Boolean.valueOf(true));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            Object v = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
            if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                registry.put("expanded." + category.getName(), Boolean.valueOf(false));
            }
        }
    }
}

