/* File automatically created by ./mkctext.pl*/

const char * disciplines_vams = ""
"/*\n"
"  Copyright C 2007 Accellera Organization, Inc.\n"
"  Standard definitions\n"
"  This file contains the standard definition package disciplines.vams for Verilog-AMS HDL.\n"
"*/\n"
"\n"
"`ifdef DISCIPLINES_VAMS\n"
"`else\n"
"`define DISCIPLINES_VAMS 1\n"
"//\n"
"// Natures and Disciplines\n"
"//\n"
"discipline logic\n"
"  domain discrete;\n"
"enddiscipline\n"
"/*\n"
"* Default absolute tolerances may be overridden by setting the\n"
"* appropriate _ABSTOL prior to including this file\n"
"*/\n"
"// Electrical\n"
"// Current in amperes\n"
"nature Current\n"
"  units = \"A\";\n"
"  access = I;\n"
"  idt_nature = Charge;\n"
"`ifdef CURRENT_ABSTOL\n"
"  abstol = `CURRENT_ABSTOL;\n"
"`else\n"
"  abstol = 1e-12;\n"
"`endif\n"
"endnature\n"
"// Charge in coulombs\n"
"nature Charge\n"
"  units = \"coul\";\n"
"  access = Q;\n"
"  ddt_nature = Current;\n"
"`ifdef CHARGE_ABSTOL\n"
"  abstol = `CHARGE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-14;\n"
"`endif\n"
"endnature\n"
"// Potential in volts\n"
"nature Voltage\n"
"  units = \"V\";\n"
"  access = V;\n"
"  idt_nature = Flux;\n"
"`ifdef VOLTAGE_ABSTOL\n"
"  abstol = `VOLTAGE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Flux in Webers\n"
"nature Flux\n"
"  units = \"Wb\";\n"
"  access = Phi;\n"
"  ddt_nature = Voltage;\n"
"`ifdef FLUX_ABSTOL\n"
"  abstol = `FLUX_ABSTOL;\n"
"`else\n"
"  abstol = 1e-9;\n"
"`endif\n"
"endnature\n"
"// Conservative discipline\n"
"discipline electrical\n"
"  potential Voltage;\n"
"  flow Current;\n"
"enddiscipline\n"
"// Signal flow disciplines\n"
"discipline voltage\n"
"  potential Voltage;\n"
"enddiscipline\n"
"discipline current\n"
"  potential Current;\n"
"enddiscipline\n"
"// Magnetic\n"
"// Magnetomotive force in Ampere-Turns.\n"
"nature Magneto_Motive_Force\n"
"  units = \"A*turn\";\n"
"  access = MMF;\n"
"`ifdef MAGNETO_MOTIVE_FORCE_ABSTOL\n"
"  abstol = `MAGNETO_MOTIVE_FORCE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-12;\n"
"`endif\n"
"endnature\n"
"// Conservative discipline\n"
"discipline magnetic\n"
"  potential Magneto_Motive_Force;\n"
"  flow Flux;\n"
"enddiscipline\n"
"// Thermal\n"
"// Temperature in Kelvin\n"
"nature Temperature\n"
"  units = \"K\";\n"
"  access = Temp;\n"
"`ifdef TEMPERATURE_ABSTOL\n"
"  abstol = `TEMPERATURE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-4;\n"
"`endif\n"
"endnature\n"
"// Power in Watts\n"
"nature Power\n"
"  units = \"W\";\n"
"  access = Pwr;\n"
"`ifdef POWER_ABSTOL\n"
"  abstol = `POWER_ABSTOL;\n"
"`else\n"
"  abstol = 1e-9;\n"
"`endif\n"
"endnature\n"
"// Conservative discipline\n"
"discipline thermal\n"
"  potential Temperature;\n"
"  flow Power;\n"
"enddiscipline\n"
"// Kinematic\n"
"// Position in meters\n"
"nature Position\n"
"  units = \"m\";\n"
"  access = Pos;\n"
"  ddt_nature = Velocity;\n"
"`ifdef POSITION_ABSTOL\n"
"  abstol = `POSITION_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Velocity in meters per second\n"
"nature Velocity\n"
"  units = \"m/s\";\n"
"  access = Vel;\n"
"  ddt_nature = Acceleration;\n"
"  idt_nature = Position;\n"
"`ifdef VELOCITY_ABSTOL\n"
"  abstol = `VELOCITY_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Acceleration in meters per second squared\n"
"nature Acceleration\n"
"  units = \"m/s^2\";\n"
"  access = Acc;\n"
"  ddt_nature = Impulse;\n"
"  idt_nature = Velocity;\n"
"`ifdef ACCELERATION_ABSTOL\n"
"  abstol = `ACCELERATION_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Impulse in meters per second cubed\n"
"nature Impulse\n"
"  units = \"m/s^3\";\n"
"  access = Imp;\n"
"  idt_nature = Acceleration;\n"
"`ifdef IMPULSE_ABSTOL\n"
"  abstol = `IMPULSE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Force in Newtons\n"
"nature Force\n"
"  units = \"N\";\n"
"  access = F;\n"
"`ifdef FORCE_ABSTOL\n"
"  abstol = `FORCE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Conservative disciplines\n"
"discipline kinematic\n"
"  potential Position;\n"
"  flow Force;\n"
"enddiscipline\n"
"discipline kinematic_v\n"
"  potential Velocity;\n"
"  flow Force;\n"
"enddiscipline\n"
"// Rotational\n"
"// Angle in radians\n"
"nature Angle\n"
"  units = \"rads\";\n"
"  access = Theta;\n"
"  ddt_nature = Angular_Velocity;\n"
"`ifdef ANGLE_ABSTOL\n"
"  abstol = `ANGLE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Angular Velocity in radians per second\n"
"nature Angular_Velocity\n"
"  units = \"rads/s\";\n"
"  access = Omega;\n"
"  ddt_nature = Angular_Acceleration;\n"
"  idt_nature = Angle;\n"
"`ifdef ANGULAR_VELOCITY_ABSTOL\n"
"  abstol = `ANGULAR_VELOCITY_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Angular acceleration in radians per second squared\n"
"nature Angular_Acceleration\n"
"  units = \"rads/s^2\";\n"
"  access = Alpha;\n"
"  idt_nature = Angular_Velocity;\n"
"`ifdef ANGULAR_ACCELERATION_ABSTOL\n"
"  abstol = `ANGULAR_ACCELERATION_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Torque in Newtons\n"
"nature Angular_Force\n"
"  units = \"N*m\";\n"
"  access = Tau;\n"
"`ifdef ANGULAR_FORCE_ABSTOL\n"
"  abstol = `ANGULAR_FORCE_ABSTOL;\n"
"`else\n"
"  abstol = 1e-6;\n"
"`endif\n"
"endnature\n"
"// Conservative disciplines\n"
"discipline rotational\n"
"  potential Angle;\n"
"  flow Angular_Force;\n"
"enddiscipline\n"
"discipline rotational_omega\n"
"  potential Angular_Velocity;\n"
"  flow Angular_Force;\n"
"enddiscipline\n"
"`endif\n"
;
