/*
 * Copyright (c) 2006 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "krb5_locl.h"

/*
 * This PAC and keys are copied (with permission) from Samba torture
 * regression test suite, they where created by Andrew Bartlet.
 */

static const unsigned char saved_pac[] = {
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xd8, 0x01, 0x00, 0x00,
	0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x58, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0xc8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0xdf, 0xa6, 0xcb,
	0x4f, 0x7d, 0xc5, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0xc0, 0x3c, 0x4e, 0x59, 0x62, 0x73, 0xc5, 0x01, 0xc0, 0x3c, 0x4e, 0x59,
	0x62, 0x73, 0xc5, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x16, 0x00, 0x16, 0x00,
	0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00, 0x65, 0x00, 0x00, 0x00,
	0xed, 0x03, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x16, 0x00, 0x20, 0x00, 0x02, 0x00, 0x16, 0x00, 0x18, 0x00,
	0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
	0x57, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x33, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4e, 0x00,
	0x41, 0x00, 0x4c, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x33, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x41, 0x00, 0x4c, 0x00,
	0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00,
	0x4e, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x33, 0x00, 0x54, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4e, 0x00,
	0x4b, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x15, 0x00, 0x00, 0x00, 0x11, 0x2f, 0xaf, 0xb5, 0x90, 0x04, 0x1b, 0xec, 0x50, 0x3b, 0xec, 0xdc,
	0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x66, 0x28, 0xea, 0x37, 0x80, 0xc5, 0x01, 0x16, 0x00, 0x77, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x33, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x24, 0x00,
	0x76, 0xff, 0xff, 0xff, 0x37, 0xd5, 0xb0, 0xf7, 0x24, 0xf0, 0xd6, 0xd4, 0xec, 0x09, 0x86, 0x5a,
	0xa0, 0xe8, 0xc3, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xb4, 0xd8, 0xb8, 0xfe,
	0x83, 0xb3, 0x13, 0x3f, 0xfc, 0x5c, 0x41, 0xad, 0xe2, 0x64, 0x83, 0xe0, 0x00, 0x00, 0x00, 0x00
};

static int type_1_length = 472;

static const krb5_keyblock kdc_keyblock = {
    ETYPE_ARCFOUR_HMAC_MD5,
    { 16, "\xB2\x86\x75\x71\x48\xAF\x7F\xD2\x52\xC5\x36\x03\xA1\x50\xB7\xE7" }
};

static const krb5_keyblock member_keyblock = {
    ETYPE_ARCFOUR_HMAC_MD5,
    { 16, "\xD2\x17\xFA\xEA\xE5\xE6\xB5\xF9\x5C\xCC\x94\x07\x7A\xB8\xA5\xFC" }
};

static time_t authtime = 1120440609;
static const char *user = "w2003final$";

/*
 * This pac from Christan Krause
 */

static const unsigned char saved_pac2[] =
    "\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\xc8\x01\x00\x00"
    "\x58\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x18\x00\x00\x00"
    "\x20\x02\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x70\x00\x00\x00"
    "\x38\x02\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x14\x00\x00\x00"
    "\xa8\x02\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x14\x00\x00\x00"
    "\xc0\x02\x00\x00\x00\x00\x00\x00\x01\x10\x08\x00\xcc\xcc\xcc\xcc"
    "\xb8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x7d\xee\x09\x76"
    "\xf2\x39\xc9\x01\xff\xff\xff\xff\xff\xff\xff\x7f\xff\xff\xff\xff"
    "\xff\xff\xff\x7f\x6d\x49\x38\x62\xf2\x39\xc9\x01\x6d\x09\xa2\x8c"
    "\xbb\x3a\xc9\x01\xff\xff\xff\xff\xff\xff\xff\x7f\x0e\x00\x0e\x00"
    "\x04\x00\x02\x00\x10\x00\x10\x00\x08\x00\x02\x00\x00\x00\x00\x00"
    "\x0c\x00\x02\x00\x00\x00\x00\x00\x10\x00\x02\x00\x00\x00\x00\x00"
    "\x14\x00\x02\x00\x00\x00\x00\x00\x18\x00\x02\x00\x02\x01\x00\x00"
    "\x52\x04\x00\x00\x01\x02\x00\x00\x03\x00\x00\x00\x1c\x00\x02\x00"
    "\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x10\x00\x12\x00\x20\x00\x02\x00\x0e\x00\x10\x00"
    "\x24\x00\x02\x00\x28\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x10\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
    "\x6f\x00\x70\x00\x65\x00\x6e\x00\x6d\x00\x73\x00\x70\x00\x00\x00"
    "\x08\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x6f\x00\x70\x00"
    "\x65\x00\x6e\x00\x20\x00\x6d\x00\x73\x00\x70\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
    "\x60\x04\x00\x00\x07\x00\x00\x00\x01\x02\x00\x00\x07\x00\x00\x00"
    "\x5e\x04\x00\x00\x07\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00"
    "\x08\x00\x00\x00\x43\x00\x48\x00\x4b\x00\x52\x00\x2d\x00\x41\x00"
    "\x44\x00\x53\x00\x08\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
    "\x4d\x00\x53\x00\x50\x00\x2d\x00\x41\x00\x44\x00\x53\x00\x00\x00"
    "\x04\x00\x00\x00\x01\x04\x00\x00\x00\x00\x00\x05\x15\x00\x00\x00"
    "\x91\xad\xdc\x4c\x63\xb8\xb5\x48\xd5\x53\xd2\xd1\x00\x00\x00\x00"
    "\x00\x66\xeb\x75\xf2\x39\xc9\x01\x0e\x00\x6f\x00\x70\x00\x65\x00"
    "\x6e\x00\x6d\x00\x73\x00\x70\x00\x38\x00\x10\x00\x28\x00\x48\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x70\x00\x65\x00\x6e\x00"
    "\x6d\x00\x73\x00\x70\x00\x40\x00\x6d\x00\x73\x00\x70\x00\x2d\x00"
    "\x61\x00\x64\x00\x73\x00\x2e\x00\x70\x00\x65\x00\x70\x00\x70\x00"
    "\x65\x00\x72\x00\x63\x00\x6f\x00\x6e\x00\x2e\x00\x64\x00\x65\x00"
    "\x4d\x00\x53\x00\x50\x00\x2d\x00\x41\x00\x44\x00\x53\x00\x2e\x00"
    "\x50\x00\x45\x00\x50\x00\x50\x00\x45\x00\x52\x00\x43\x00\x4f\x00"
    "\x4e\x00\x2e\x00\x44\x00\x45\x00\x76\xff\xff\xff\xb3\x56\x15\x29"
    "\x37\xc6\x5c\xf7\x97\x35\xfa\xec\x59\xe8\x96\xa0\x00\x00\x00\x00"
    "\x76\xff\xff\xff\x50\x71\xa2\xb1\xa3\x64\x82\x5c\xfd\x23\xea\x3b"
    "\xb0\x19\x12\xd4\x00\x00\x00\x00";


static const krb5_keyblock member_keyblock2 = {
    ETYPE_DES_CBC_MD5,
    { 8, "\x9e\x37\x83\x25\x4a\x7f\xf2\xf8" }
};

static time_t authtime2 = 1225304188;
static const char *user2 = "openmsp";


/* PAC ticket-signature test data. */

static const krb5_keyblock rwdc_tgt_key = {
    ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    { 32, "\x27\x86\x34\x1d\xd3\x15\x06\x0d\x6f\xd6\x40\xfa\x03\xb1\x95\x32"
          "\x91\x22\xe8\x6b\x0f\x47\xe0\xb5\xfe\xda\xef\x54\x98\xdc\x07\x5a" }
};

static const krb5_keyblock rwdc_tgt_pac_key = {
    ENCTYPE_ARCFOUR_HMAC,
    { 16,  "\xb9\xf0\x39\x8d\xe9\x60\xb8\x40\x8c\x54\x0b\x61\xf9\xd2\xf1\x16" }
};

static const krb5_keyblock rodc_tgt_key = {
    ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    { 32, "\x0c\x7e\x63\x47\xc8\x70\x7f\x58\x7c\x91\x59\xba\xc9\xbf\x50\xb4"
          "\xe2\xd6\x49\xb6\x85\xd3\xd9\xf3\x80\xba\xe9\x02\x46\x51\xab\x23" }
};

static const krb5_keyblock rodc_tgt_pac_key = {
    ENCTYPE_ARCFOUR_HMAC,
    { 16,  "\x80\x5d\x66\xb9\x5f\x66\xd6\x80\xc3\x5a\x07\x41\xe8\x97\xcc\x66" }
};

static const krb5_keyblock server_key = {
    ENCTYPE_ARCFOUR_HMAC,
    { 16, "\xed\x23\x11\x20\x7a\x21\x44\x20\xbf\xc0\x8d\x36\xf7\xf6\xb2\x3e" }
};


static const unsigned char tgt_ticket[] =
    "\x61\x82\x03\xe1\x30\x82\x03\xdd\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x1d\x30\x1b\xa0\x03\x02"
    "\x01\x02\xa1\x14\x30\x12\x1b\x06\x6b\x72\x62\x74\x67\x74\x1b\x08"
    "\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa3\x82\x03\xa9\x30\x82\x03\xa5"
    "\xa0\x03\x02\x01\x12\xa1\x03\x02\x01\x02\xa2\x82\x03\x97\x04\x82"
    "\x03\x93\xfb\x16\x6b\x43\xca\x54\x6a\xed\xc8\xa4\x1f\x9e\xde\x88"
    "\xa0\xa2\xc8\x86\x50\x17\x67\xbc\x0b\x13\xb8\x00\x80\x48\x54\x77"
    "\xb2\x4c\x5f\xff\x34\xb6\x05\xc4\xff\xdb\x68\x00\x7c\xf4\x4f\x65"
    "\x56\x69\x1a\x2f\x32\x24\x19\xef\x0a\xf8\xcd\x22\x4a\xe9\xcc\x2b"
    "\x65\xfb\x3a\xff\x3d\xb3\xdc\xea\x5a\x9b\xb0\x14\xd0\xa6\x1d\x7c"
    "\x82\xa7\x18\x23\xad\xd3\x43\x6c\x23\x41\x6e\x7c\x84\x01\xc7\xd6"
    "\x60\xdf\xbb\x19\xac\xf3\x5b\x52\xea\xd1\xdb\xa5\x49\xc6\xf1\x44"
    "\x59\x41\x15\x78\x13\xbc\x85\x73\xba\xd7\xde\x55\xe9\x84\x30\x11"
    "\x5e\x00\x47\xff\x01\x87\x46\xda\xe3\xb4\xe3\xef\xac\x67\xa8\x8d"
    "\x06\xf4\x04\xa3\x15\x5f\x51\x59\xe9\xb4\x65\x00\x1f\x45\x7c\x2a"
    "\xcf\x17\x78\x75\xad\xc8\x65\x92\xe7\x20\x89\x41\x43\x5e\x08\x1d"
    "\xc9\x4b\xa1\x57\x26\x7f\x9a\x64\xc7\xe3\x90\xbf\xa8\x9f\x86\x89"
    "\xbf\x37\xd0\x1a\x9c\xe7\x32\xbb\x9f\x8d\x38\xfd\xe8\xf4\x88\x54"
    "\x3d\xe7\xd0\xfb\x73\x1a\x97\xee\xa5\x32\x67\x62\x4d\x1c\x28\x85"
    "\x01\x4f\x76\x4c\xf6\xe5\x73\x93\x0e\xd8\x0a\xf1\x6f\xf0\x8c\xbf"
    "\x65\x80\x87\xd1\xe8\xbc\xc5\x8f\x03\xb8\xfe\x7e\xd6\xde\x80\xa5"
    "\x27\x8c\x26\x14\x66\xf3\xd2\x4d\x51\x51\xe7\x47\xac\xa5\x93\xd7"
    "\x01\x5b\x6b\xca\x6c\xd5\x19\x7b\xad\x97\xf2\xa6\x18\x0e\xe3\xea"
    "\x5e\x81\xe4\xd7\xf5\xb0\xca\x0f\x04\x13\xc4\xed\x5b\x0c\xb2\xc4"
    "\x5e\xd3\xc2\xb6\x0f\x0a\x76\x8a\x7d\x1c\x79\x62\xb5\x68\x47\x33"
    "\x5e\x28\x3a\xd6\x78\x89\xb3\xbd\x34\x72\x7f\xe1\x8e\x5e\xa9\x89"
    "\xfe\xc5\xba\x5f\x76\x00\x27\x29\x88\x79\xb4\x42\x33\xe7\x4c\xce"
    "\x47\x39\xac\xfa\x8e\x93\x7a\x92\x7f\xbd\x91\xc8\xff\xe4\x7b\x04"
    "\xe8\xf7\x29\x3b\xb4\x41\xb9\xe0\x61\x14\x2a\xc9\x5b\x02\xc2\x01"
    "\x6f\x61\xa8\x1a\x5e\x2d\x0b\x3f\xc3\x1d\x6a\xb0\x9e\xf1\x41\xaf"
    "\xc6\xe0\x11\xb3\x47\xb2\x43\x42\xb4\x6e\xdb\x16\x41\x6a\x7b\x53"
    "\x97\x01\x7f\x3e\x9d\x47\x27\x14\x29\x7d\xc7\xa5\x40\xaf\x77\xcb"
    "\xc9\x3e\x2e\x1f\xa3\xc8\x69\x98\xf7\xb2\x18\xa7\xcf\x45\x87\xba"
    "\x48\x0b\xb8\x03\x10\x46\x2d\x95\x59\x5b\x9e\xe3\xe4\x20\x08\x80"
    "\x97\x39\x16\x0c\x34\x27\x35\xd3\xd9\x71\x7b\xc2\x7d\x16\x36\xad"
    "\xa0\x95\x12\x49\x5a\x3b\xea\xcf\x85\x75\x9e\xa4\x96\x51\x6c\x34"
    "\x60\xd5\x3a\x9d\x60\x80\x53\x71\xac\x21\xfe\xea\xb3\xc5\x74\x65"
    "\x7b\x98\xb6\x63\x58\xb7\xc9\x0c\x80\xad\x54\x9b\x1c\xdf\x84\xf9"
    "\x97\xac\x73\x72\x4f\xbe\x10\x72\x6a\xec\x36\xfc\x7c\x98\xc6\x98"
    "\x81\xde\xab\x2b\x8a\x68\x17\xd6\xb0\xac\xfd\xed\x5d\x67\xd3\x5a"
    "\xbe\x7e\x88\x63\x5f\xc3\x1f\xf7\x04\xd9\xcd\x0a\xc7\x70\x83\x93"
    "\x60\x86\x0c\x08\x21\xbb\x2f\x29\x28\xaf\x3f\x93\x24\x5f\x3a\x1d"
    "\xf3\x81\x95\xb4\xef\xd6\x8c\x79\xdf\xf7\x9d\x4a\x0a\x49\xa7\x46"
    "\xcd\x05\x30\x6e\x92\xa2\x26\x23\x8e\xf3\xe1\x38\x41\x63\x2f\xe6"
    "\xd1\x59\x99\x8d\x7a\x8c\x4d\x57\x19\x5c\xee\x75\x7a\xd8\x0a\x53"
    "\x43\xb0\x92\x01\x4a\xf7\xc4\x54\x8e\xe8\xc6\x43\x0b\x43\x9a\xa3"
    "\xfd\x5c\x0c\x47\x52\xdf\xc6\x47\xa0\x14\xef\x45\xcf\xdf\xb7\x04"
    "\xca\x3e\x5d\x8b\x32\x9b\x81\xa3\x8b\x9d\x7c\x0f\x11\x13\xf1\x0d"
    "\xc0\xd0\xe2\xc1\xf7\x65\x03\xe0\x50\x6c\xbb\x3c\xd2\xc1\xad\x15"
    "\xa3\xcd\x24\x85\xc0\x94\x54\x12\x2d\x63\x01\x47\x8b\x51\xee\xd1"
    "\x46\xc0\x47\xcf\xce\xa1\x81\x5a\x5c\xe6\x59\x99\xb1\xaf\x80\x05"
    "\xc3\x22\x69\xb3\x19\xec\x0e\xdd\x72\x0a\xcb\xf5\x4e\x90\x65\x41"
    "\x68\x46\x8e\xab\xb3\xcc\xb6\xe2\xbd\xbf\xc0\x04\x12\x35\x84\xe5"
    "\xef\xa5\x7f\x98\x8e\x0d\xac\x92\xae\x8f\x9c\x41\xce\x41\xb5\xcc"
    "\x59\x00\xa5\x2c\x71\xe3\xdd\x25\x29\xd2\xac\x0f\x9b\x23\xbd\x1e"
    "\x25\xe5\x06\xbd\x43\x46\x46\x4f\x81\x08\x1f\x57\xa9\x93\x24\xe4"
    "\x83\x42\x13\x00\xce\x95\xdb\xde\x95\xc5\x8c\xd8\x29\x4e\x43\xb2"
    "\x64\xe6\x6c\x0e\x40\x86\x35\xef\xac\x5b\x15\x92\xfb\x3c\xf0\x94"
    "\xd8\x1f\xf9\x90\x8a\xd2\xa8\x4a\x1d\x77\x57\x4c\x65\xb3\x4f\xe4"
    "\x03\x13\x3d\x52\x8b\xe4\x9e\x98\x53\xf1\xad\xc1\x2a\x3c\xda\x4f"
    "\x24\xbf\x24\xb2\xb7\x34\xc7\xde\xfb\xe6\xe9\x82\x05\x07\x25\xd9"
    "\x8e\xea\xd8\xb7\x0d\x1d\x0d\xf1\x0c\x99\x1a\x6a\xa7\xe7\x27\x49"
    "\x26\x2a\x75\xd5\x84";

static const unsigned char service_ticket[] =
    "\x61\x82\x03\xf3\x30\x82\x03\xef\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x13\x30\x11\xa0\x03\x02"
    "\x01\x01\xa1\x0a\x30\x08\x1b\x06\x61\x70\x61\x63\x68\x65\xa3\x82"
    "\x03\xc5\x30\x82\x03\xc1\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02"
    "\xa2\x82\x03\xb3\x04\x82\x03\xaf\x7e\x88\x85\x77\x22\x5e\x30\x7a"
    "\xaf\x63\xc4\x2b\xc1\xae\x88\x87\x27\x65\x0e\x1e\xa7\x94\x67\xf9"
    "\x9d\x49\x5b\x6b\xba\xfb\x51\x04\xc4\xe8\x44\xc9\xdf\x8d\x8d\x58"
    "\x61\xdb\x1e\x82\x98\xc7\x68\x9e\x81\xf0\xc4\x88\x87\xd6\xf5\x7b"
    "\x44\x8e\x4a\x65\x4f\x37\x49\x8a\x81\x67\x00\x7e\xf3\x7e\x75\x9d"
    "\x61\x18\x6d\x6f\x21\x73\xe3\xab\xe2\x86\xc0\xf1\x8b\x9f\x25\xc2"
    "\xdc\xc4\x65\xeb\xba\x24\x3d\x2d\x5a\x9b\xbe\xc1\x24\x8c\xf1\x78"
    "\xfc\xf9\xca\x14\x8e\xd4\xe3\xb3\x54\x87\xce\x97\x0c\x7b\x11\x2e"
    "\x38\x30\xed\x8c\x41\x28\x90\x5b\xc6\x3d\xba\x29\x7b\x11\xfa\x85"
    "\x54\x13\xab\x22\xe9\x52\xdd\xad\x5a\xdc\xa7\xca\x4f\x19\x49\x81"
    "\x53\x09\x10\xca\x6b\x1a\x44\x13\xe6\x88\xec\x14\xd2\x15\x5a\x65"
    "\x8a\xef\x55\x6a\xb1\xda\xc4\xe6\x0d\xc8\x2d\x8b\x0c\x00\x71\x6a"
    "\x7b\x06\x34\xe0\x93\xa4\x5d\x5b\xa9\x43\x65\x42\xc5\x13\x64\xee"
    "\x51\xd3\xd9\xc8\x3d\x52\xe2\xba\xb2\x81\xe6\x86\x25\x6f\xa6\x22"
    "\x25\x97\xbb\xf1\xe4\x6e\xe1\x9a\xfa\xa4\xa0\x8b\xd6\x7b\x4a\x8a"
    "\x62\x3d\x21\x1c\x08\x16\x8d\x29\x58\x7e\xfd\x43\x48\xba\xd7\x19"
    "\x7c\xdd\x57\xe4\x8f\x94\x6e\x97\xed\x8d\xf2\x68\xe4\x89\xde\xc3"
    "\xed\xa6\x7b\xcd\xff\x0c\xcf\xac\xad\xfa\x54\x89\xfc\xd0\x94\xd9"
    "\x48\x25\x61\x71\x89\x32\xb8\xdb\xf9\xfb\xb9\xf4\x8b\x7e\x9c\x95"
    "\x5d\xa3\x03\x13\xaa\x50\x28\xfa\x0b\x54\x5e\x0a\x3a\xb6\x4e\x58"
    "\xee\x3f\xbc\xd2\x23\x81\x82\x82\xab\xef\x6a\xf8\x10\x56\x0e\x43"
    "\xc2\x4a\x30\xa9\x17\x1a\x46\xb2\xdd\xcf\x7d\x20\x46\x0e\xc8\xff"
    "\x54\xf5\xa1\xa1\x43\x8b\x02\x00\x0c\x31\xbb\x66\xcd\x17\xf0\x12"
    "\x83\x39\x6c\xcf\x9c\xe9\x68\x26\x68\x86\xd4\xa4\xe6\x33\xa1\xdb"
    "\x74\x1d\x56\x1c\x2b\xff\x5e\xdd\xe7\xdd\x3a\x3e\x3a\x13\xbf\x36"
    "\x5a\x3f\x0d\x21\x9d\x9c\xd5\x20\x13\x1d\x86\xb4\xb2\xa5\x34\xa2"
    "\x0b\x9a\x0c\xa0\xac\x92\x9b\x02\xf2\x68\x19\x9e\x1c\x66\x40\x29"
    "\x81\x13\xf3\x06\x49\xa4\xf5\xd9\xe9\xd1\x2f\x89\xac\x1d\x20\x9e"
    "\xb1\x2e\xf3\xde\x09\x7c\xf4\xe6\x2b\x61\x3f\x35\x0f\x83\xa9\x24"
    "\xd3\xbd\x14\x0f\x48\xcb\xe4\x98\x02\x7c\x83\x1b\x61\x59\x34\x7d"
    "\x32\x59\xbc\xb8\xe2\xb3\x99\x80\x75\x4b\x4b\xb5\x2b\x6d\x07\x66"
    "\x3c\x8a\xbc\x6d\x61\x6e\xcb\x12\x53\xe2\x07\x38\x4e\x2f\xdb\xe0"
    "\x15\x4c\x8b\xdb\x7e\xeb\x61\x96\xfb\x4f\x3d\x5f\xbe\xdb\x34\xb0"
    "\x73\x7a\xe6\x10\x8a\xe7\x37\xa3\x15\x68\x44\x85\xc2\xc1\x4f\x3e"
    "\x4c\xc8\x51\x54\x2c\x7d\x50\x86\xf2\xbd\x19\x63\x51\x4c\xb4\xd4"
    "\x29\x6a\x03\xae\x38\x77\x25\xbc\x15\xba\xa8\x65\x29\x29\xdd\xb1"
    "\xaa\xe8\x9a\xbf\x4c\x15\xcf\x13\x11\x0b\x86\x5c\x44\xca\x82\x49"
    "\x8c\x1b\x77\x28\x36\x87\xf9\xad\x6d\xe0\x05\x0f\x93\x00\x1f\xaf"
    "\xe4\xe9\x5a\x8f\x61\x41\x46\x2f\x52\x4d\x16\x4f\x9c\xca\x94\xff"
    "\x19\x2e\xa5\x65\x09\x4f\x58\xfb\x4b\xbe\x89\xb3\x1a\x3b\x9b\xe4"
    "\xb9\x7b\x58\xcd\xa3\x73\x41\xe0\xcb\xbd\xce\x97\x87\x1f\x60\xc8"
    "\xbb\x8c\xe9\xd7\x4f\x9a\x2d\xb5\xd4\x73\x4e\x25\xf3\x36\xbc\x3f"
    "\x81\x23\x82\x1e\xde\xbe\x9b\x35\x67\x99\x9f\x9c\x02\x9c\x75\x0c"
    "\xed\xb1\xcb\x82\x7f\xf5\x31\x66\x76\x01\x5a\x61\x3c\xa4\xe9\xae"
    "\x1a\xc1\x3f\x35\x7d\xd4\x41\xdb\x7f\xd2\xc5\x5f\xbe\x8c\x13\xa6"
    "\x1a\xd3\x2e\xf6\x0f\x91\xd5\x20\xd5\x36\x57\xa8\x40\x17\x3b\x49"
    "\xf6\xe5\x55\x04\xcf\xf3\x72\x3d\xa6\x99\x3a\x40\x49\xdf\x5a\x69"
    "\xfb\x35\x43\x3a\x49\x8e\xb9\x6d\x1b\xd3\xb9\x6a\xcb\xcd\x6c\xda"
    "\x68\x3f\xc1\xd4\x0e\xdb\x7a\xd5\x05\x77\xac\xc2\x95\xf4\x7c\x83"
    "\x3c\xaf\x55\x9f\x29\x52\xee\xe4\x34\x2d\x4c\x5f\xfa\x76\x0a\xe2"
    "\x8e\xe3\xb7\x12\x37\x79\x9e\xfb\xe2\xaf\x3f\xbc\x2a\x2e\x35\x79"
    "\xd4\x65\x05\x88\xb7\x1d\xc6\xf8\x89\xe7\xe9\xa1\xe0\xf0\x18\x3a"
    "\xd4\x06\x47\x22\xf2\xb7\xbf\x67\x41\x24\xaf\x19\x85\x32\xf5\x91"
    "\x8a\x16\xd8\x99\xd5\x27\x0e\x08\xfd\x07\x42\xdd\xd9\x41\xd7\x1c"
    "\x7e\x64\x09\x9b\xe7\x51\xff\x02\x37\x32\x12\x6d\x60\x3f\x36\x25"
    "\xd0\x53\xd8\xbd\x22\x6f\x2c\xec\x7c\xe4\x65\x7b\xd4\xcc\xce\xc4"
    "\x8d\xee\x53\x48\x26\x8c\x97\x18\x0a\x06\x62\xaf\x31\x0c\x85\xc8"
    "\x27\x11\xb3\x18\x9b\x24\x57\x38\x20\xf6\xe5\x42\x72\x1c\x3c\xfb"
    "\xce\xd4\x26\x65\x92\x21\x49\x0b\x5d\x62\x72\xeb\xb3\x53\x89\x55"
    "\xb6\x81\xef\xfd\xd2\xb6\xed";

static const unsigned char s4u2self_ticket[] =
    "\x61\x82\x03\xf2\x30\x82\x03\xee\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x13\x30\x11\xa0\x03\x02"
    "\x01\x01\xa1\x0a\x30\x08\x1b\x06\x61\x70\x61\x63\x68\x65\xa3\x82"
    "\x03\xc4\x30\x82\x03\xc0\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02"
    "\xa2\x82\x03\xb2\x04\x82\x03\xae\x41\x12\xbe\x9e\x19\x0b\x27\xfe"
    "\x38\xd3\x9b\x98\x8d\xcf\xc4\xe5\x34\x43\x64\x4a\x96\x00\x12\x52"
    "\x92\x24\xcc\x8a\xe2\x80\x2a\x9e\xc1\x67\x6d\xd2\x77\x41\xe3\xc3"
    "\xb7\xde\xf9\xdf\x8f\xdb\xe8\xd6\x78\x84\x83\xa0\x99\x2a\xbb\x24"
    "\x25\x9d\x3a\x4d\xb0\x89\xe8\xa7\x67\xbe\x4e\x7b\xd4\x20\xad\xa6"
    "\xb5\xa2\xab\xf4\x07\xf9\x14\x2e\x08\xc5\xa8\x43\xc2\xaf\x24\x53"
    "\xb3\xaf\x7b\x83\xb5\xd1\xca\x8a\x99\x83\x14\x08\x37\x1f\x20\x03"
    "\xfc\xd4\xb4\xce\xb3\x9a\xc1\xbd\x31\x54\x21\xb6\xbe\x7c\x82\xbc"
    "\x30\x61\x0d\x9a\x10\x90\x00\x69\xee\xd5\xd3\xf6\x7c\xfa\x70\xa7"
    "\xd4\xa1\xe6\xbd\x0b\xb1\xe2\xcc\x4e\xc6\x53\xc7\x89\x39\x57\x63"
    "\xca\xfb\x4f\x0d\x73\xf7\x2a\xda\x94\x40\xdd\x0a\xd6\x00\x14\xc2"
    "\x7b\x5f\xda\x27\x7c\x95\x32\xab\xcf\xd1\xac\xd0\xfc\x4a\xb4\x82"
    "\x80\x5f\x56\xa5\xac\xb9\xb4\xc8\xb9\x08\x0a\x52\x9b\x2e\x80\xf4"
    "\x9d\x85\x73\x09\xb1\x9a\xd6\x50\x59\x47\x0f\x8f\x72\xd5\x91\x76"
    "\x89\xba\x49\xe3\x5e\x76\x07\x84\x8b\xf2\xc0\x57\xd4\xd2\x31\xfe"
    "\xfd\xa3\xcd\x96\x5a\xbe\x19\x18\x97\x8e\xbf\x18\x1b\xdf\xf9\x78"
    "\x5b\xac\x3c\x1f\xff\x4c\x64\xef\x1d\x5e\x69\x04\xcf\x68\xf6\x97"
    "\xc4\xff\x16\x8e\xb2\x22\xf3\xc5\x84\x67\x41\x04\xce\x72\xdd\x76"
    "\x65\x2e\xee\x84\xfb\x85\x83\x4b\x41\xdf\x24\x1e\xc7\x31\xf0\xc4"
    "\xf1\xf7\x83\xfe\x46\x6d\x6f\x45\xf6\xb4\x40\xbb\x2f\x09\xf7\xe2"
    "\x6f\x19\xd3\x3e\xa6\x94\x76\x46\x6b\x78\x43\x08\x4c\xfc\x15\xc2"
    "\x4d\xef\x12\xe0\x38\x6a\xdb\x49\x7a\x71\x6c\xeb\xe3\xdf\xe7\x57"
    "\x25\x23\x09\x4d\x74\xac\x93\x95\x8a\x6c\x01\x70\x0a\xb7\x42\xee"
    "\xf5\x5c\x65\x64\xc6\xd7\x3e\x57\x7e\x0f\x9b\xdd\xf0\xfb\xdb\x92"
    "\xa6\x1c\x75\x18\x88\x29\x03\xf9\x58\xf0\xd0\xc2\x91\x9c\xf6\x58"
    "\x4e\x15\xe1\xab\x46\x1e\x23\x7c\xdc\xa5\xdd\xaf\x59\xae\x22\xbb"
    "\xc3\x6d\x02\x0f\x02\x9e\x4a\xc1\x6d\x55\x4b\x35\x69\xd5\xaa\x92"
    "\x61\xef\x0d\x50\x42\x49\xc0\xb5\x9d\x57\x3f\x50\x4d\xc2\x17\xda"
    "\xc4\x43\xd1\x1f\x8c\x77\x4c\xa1\x37\x5c\x39\xe7\x51\x7e\x52\x68"
    "\x0f\x6d\x8e\x1e\xb7\x81\x14\xc1\x11\x17\xa9\x37\x75\x48\x72\x35"
    "\xca\xeb\xcb\x0d\x84\xbb\xf1\x08\x79\xde\x31\x00\x7f\x54\xc8\xbc"
    "\x38\x1f\x2c\x56\x3b\xfc\x9d\x8a\xbc\x2d\x72\x8b\x32\x29\xf7\x52"
    "\x96\x60\x34\x70\x13\x6f\x5a\x98\x7f\x69\xdc\x00\x21\x4c\x9d\x21"
    "\x52\xd9\x71\xa3\xc6\xea\xd9\xdb\xeb\xd5\x78\xe5\x8f\x5e\x1d\xa8"
    "\xa6\x0a\x58\x9c\xc9\x45\xc0\xb6\xb1\xe5\xfb\x49\xd2\x71\x41\x52"
    "\xae\x52\x84\xd6\x90\x1e\x9a\xc2\xdb\x5b\xf8\x18\xf8\x47\x25\x70"
    "\x1b\x07\x64\x8c\x4a\x94\xb0\x52\x50\xf0\x99\x3b\x0d\x11\x33\xb9"
    "\xd6\xdf\x43\xfe\x34\x92\x3f\xa9\x1c\x9e\xfc\x89\x11\xdb\xe5\x15"
    "\xae\x74\xd2\x1b\xd0\x42\x5a\x19\x0c\x03\x8e\x09\x16\xd2\xcf\xe8"
    "\xd5\x02\xa4\x58\xe3\xca\xef\xe3\xa5\x36\x4f\x79\x6e\xc2\x57\x7f"
    "\x97\xcf\x87\xec\x10\x57\x35\x15\xd8\x67\x4c\xaf\x2c\x6b\x50\x04"
    "\xd6\xf7\x5f\x83\x1a\x4d\xfe\x44\x67\x60\x3f\x98\xfe\xa5\xd0\x56"
    "\xf1\x46\x1e\xa0\x38\x21\x62\x0e\xce\xd5\x9a\x41\x4b\xb1\x9a\x7d"
    "\xfe\x7d\x2d\x88\x16\x82\x73\x27\x4d\x9f\xad\x06\x1e\x93\x0f\xe7"
    "\xd0\x98\xc5\x2e\xd8\xfc\x97\x4c\xed\x3b\x89\x94\xf4\x71\x88\x9f"
    "\xc6\x5a\x73\x6e\x00\x4a\xd4\x99\xe2\x87\x32\x62\x03\x20\x73\xe3"
    "\xba\xcc\x5d\x35\xa8\x20\x10\xb8\x60\xff\xed\x8c\x44\x21\x31\x1a"
    "\x41\xb1\x3b\xa3\x44\x15\x45\x99\xa2\x89\x47\xd1\x80\xfd\xee\xc7"
    "\xe8\xa2\xaa\xb3\x90\x2b\x04\x3c\x78\xf9\xcd\x0a\x90\xd5\x46\x28"
    "\x52\x62\xbb\x08\x46\x19\x82\xb6\xe6\x2d\x3e\x04\x95\xd5\x0e\x7e"
    "\xb3\x5f\x0e\x30\xbe\xf0\xdb\x36\x15\x69\xd5\x2d\x38\x95\x17\x27"
    "\x2b\xa3\xc8\x68\x00\x55\xde\x2e\xd6\x07\xb4\x7a\x89\x1c\xe7\xc2"
    "\x3c\xc4\x57\x9f\x45\xea\x77\xaf\xd8\xf1\xbe\x2a\x05\x46\x04\x51"
    "\x83\x21\xa7\x1a\xa8\x23\x2f\x62\xa9\x67\xe6\xf3\xab\x47\xb9\xa6"
    "\xec\x98\x7c\x7b\xd3\x42\x5d\x73\x37\xab\x46\x75\x2b\x33\xda\xf8"
    "\xad\x2c\x62\x36\x2a\x91\x8f\x2c\x12\x4d\x00\xd5\x02\x98\x58\xfe"
    "\xd2\x3d\x38\xc1\xe0\x2d\xeb\x7f\x22\xe6\x12\x72\xcd\xc7\x4b\xac"
    "\x6d\x70\xc1\xcc\xda\x6d\xf1\x21\x44\xb4\x92\xec\xce\xd7\x6a\xde"
    "\xea\x62\x63\xa9\x15\xe8\xf3\xea\xc6\xc8\x26\x39\xef\xa0\x76\x66"
    "\x54\x45\xb6\xdd\x4b\xff";

static const unsigned char s4u2proxy_ticket[] =
    "\x61\x82\x04\x9f\x30\x82\x04\x9b\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x20\x30\x1e\xa0\x03\x02"
    "\x01\x03\xa1\x17\x30\x15\x1b\x03\x73\x71\x6c\x1b\x0e\x6d\x79\x73"
    "\x71\x6c\x2e\x61\x63\x6d\x65\x2e\x63\x6f\x6d\xa3\x82\x04\x64\x30"
    "\x82\x04\x60\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02\xa2\x82\x04"
    "\x52\x04\x82\x04\x4e\xaa\x63\x2e\xe0\x3a\x24\xed\x98\x29\x42\xa4"
    "\x17\x2b\x4a\x17\x1d\xea\x46\x2a\xc9\xeb\x10\xeb\x02\xe3\xa2\x40"
    "\xf5\x79\xaa\x1c\x83\x20\xe0\x24\x9b\x6f\x06\xc4\x31\x82\xc8\x52"
    "\xdb\x9a\x04\x36\xff\x5c\x7a\xa5\xfe\x5c\xf3\x40\xcf\x7c\x31\x0f"
    "\xda\x2a\x20\xa1\x7e\xdb\xf4\x05\x54\xcb\x51\xa0\x54\x25\xc8\x9f"
    "\x4d\x23\x0a\xef\x56\x4e\xa0\xdf\xf5\x0b\xce\x75\x93\x5b\xf9\xe5"
    "\x3a\xdf\x08\x3f\xce\x1c\x75\x6b\x4f\x38\x1a\x90\x4c\x3e\x99\x49"
    "\x6c\x7a\x55\xf5\xdd\x59\x64\xab\x43\xfd\x3f\x45\x5a\xd3\x0f\x4f"
    "\x37\x44\x03\x42\x0e\x83\xac\xf9\x04\x83\x43\xfc\x60\xc3\x1b\xc4"
    "\xc0\x2a\x6c\x6e\x65\xf4\x8f\x2d\x52\x1f\x18\xbe\x09\x17\x10\x1d"
    "\xd4\xc7\xe6\xa9\x9f\x70\x90\x65\x8a\x30\x63\x26\xfd\xb4\x63\xd0"
    "\xaa\x3d\x80\x03\x79\x74\xc7\x5d\xe8\x50\x9e\x1b\x0a\xa7\x69\x62"
    "\x91\xda\xcb\x80\xe8\xa3\x0d\xd8\xef\x05\x46\x2a\xb8\x14\x6f\x45"
    "\x4e\xa6\x76\x28\x1b\xbe\x50\x0b\x5b\xf9\xe1\x61\x66\x5b\xe8\xb7"
    "\xa1\x9c\xea\x2a\x8b\x28\x63\x8e\x20\x41\xaa\xdc\xca\x61\xa9\x1f"
    "\x1b\xf1\xf3\x39\x47\xdf\x1f\xc3\x0d\xdd\xe7\x40\xb1\x8d\xbf\x28"
    "\x22\xd4\x5d\x82\x63\x80\xc6\x75\x45\xa3\xe2\x79\x71\xa9\x5d\x9a"
    "\x29\xa4\xc5\x3d\x1a\x56\x99\x2a\x3f\x4c\x97\x02\x85\xd8\x21\x15"
    "\xd7\xaa\x8c\x6e\xa9\x0f\xb8\xa7\x1b\x43\xa4\xb5\xf0\xab\x2f\x77"
    "\xa0\xa9\x23\xb2\x81\xf4\x0d\x02\x0e\x17\xa5\xb7\xa6\x54\xc6\x3b"
    "\x12\xd9\x2e\x30\xdc\xb7\x84\x46\x9b\x28\x89\x15\x48\xd0\xe4\x44"
    "\xd5\x22\x67\x3e\x58\x96\xcf\xd1\x0f\x5e\xd1\x5c\xa5\xdd\x5a\x60"
    "\xf2\xf9\x36\xad\xe0\x39\x2a\x56\x98\x71\x37\x67\xca\x3a\xc4\x7f"
    "\xda\x43\x22\x7b\xe9\xf3\x8c\x0d\x31\x9e\xc3\x8d\xf8\x49\xf1\x81"
    "\xe0\xb3\x4d\x47\xfa\x91\xdd\x46\xfb\x03\x84\x13\x37\x9c\x12\x0c"
    "\x80\x4f\x01\xc6\x19\x62\x0e\xba\x94\x0d\x89\x24\x0c\x14\xbe\x0f"
    "\x06\xc2\x8d\x54\xfb\x84\x64\xa2\x57\x9e\x85\x54\x98\xad\x25\x2c"
    "\xa0\x73\x39\x14\x47\xf4\xa6\x1d\xf8\x1e\x94\x4c\x2e\x0f\xd6\x33"
    "\xa6\x1b\x58\x7a\xc1\x29\x8d\xc8\x7e\x79\xb7\x44\x92\x8a\xf3\x69"
    "\x37\x34\x74\xe6\x29\xf7\x38\xb1\xb5\xad\x4a\x2a\x56\x86\xa5\xc5"
    "\x65\xcf\x0b\x9b\x2a\x54\x31\x1d\xad\xc0\xac\xd0\xf3\xaf\x41\x9a"
    "\x4c\x5b\x42\x2c\x4c\x38\x72\xa4\x74\xcb\xfb\x77\xe1\xc7\x08\xba"
    "\x72\xc1\x8e\xa7\x60\xeb\x6a\x63\xeb\x75\x0f\xe6\xd0\x82\x43\xa3"
    "\x49\x7c\x74\xac\x50\xbb\x30\xf8\x59\x31\xa6\xcf\xaf\xc9\x08\x1c"
    "\x21\x6d\x42\xa6\x84\x7a\xc9\x3e\x1d\x65\xc8\x8a\x6f\x28\xaa\x54"
    "\x0a\x87\xed\x09\xa4\x90\xe1\x4a\xda\x71\x9c\x3d\x06\x82\x86\xf6"
    "\xc9\x0d\xe6\xcd\xdc\xe7\xe8\x9f\x07\x4b\x6b\xf3\x50\x30\xee\xdb"
    "\xd6\x7c\x97\xa5\x53\x09\x91\xa8\xc1\x06\xed\xc2\x30\xd5\x66\x07"
    "\x5c\x1c\xb2\x04\x81\x09\x9f\x7c\xdf\x47\xc7\xfa\x04\x4d\x73\xbd"
    "\x1a\x28\x8c\x83\x2a\x4b\xcd\xcc\x93\x41\xc9\x9f\x05\x7a\xb6\xff"
    "\x98\x58\xa4\x11\xf1\x3d\xca\x94\x71\xb6\x0e\x6e\xeb\x30\x3c\xfc"
    "\x5a\xf6\x0e\x0b\x1a\x0a\x3d\xd0\x9a\x08\xd4\x43\xaf\x06\xbe\x8f"
    "\xc0\xf2\xfb\xe7\x94\xa0\x5d\x9c\x44\x7f\xca\xbd\x1e\x83\xf8\x22"
    "\xe8\x6e\x7f\xd4\xc6\xaa\x8a\x45\x76\x37\xf7\x45\xdb\xcb\x20\xa9"
    "\xcc\x74\x62\x52\xe2\x88\xbf\x95\x4d\xe8\x1e\xac\x30\xfa\x9c\x1e"
    "\xe7\xe6\xeb\x18\x75\xe3\x0f\xb8\xfc\xbf\x6c\x6f\x59\x51\xd4\x38"
    "\xb0\xab\x85\x73\x16\x51\x5d\x27\x94\x83\x03\xd2\x86\x28\x99\xa1"
    "\x8c\x04\x4c\xfb\x21\x79\x7b\x95\x96\x21\x47\x81\xc9\xba\xef\x13"
    "\x18\xd6\x8f\xa9\xf4\x89\x25\x5b\xa4\xae\xbc\x6a\x59\x1e\x7b\x15"
    "\xc9\xa5\xc8\x8a\x8c\x35\xec\xee\xe2\x8a\x0e\x1b\x8e\xaf\x4b\x51"
    "\x9e\x66\xe7\x94\x56\xf6\x37\x93\x22\x5d\xe3\x9e\x33\x5e\xb4\x74"
    "\xf1\x69\xe3\x93\xc3\xe8\xc7\x61\x09\x6a\xc1\xb7\x42\xcc\x3b\x5b"
    "\x24\x40\x28\xf7\x9b\xef\x5c\x98\xb9\xe7\x2c\x01\xed\x99\x66\xa7"
    "\x06\xeb\x08\x89\xd6\x5e\xce\x85\x08\x1a\x90\xc4\x92\x40\x53\xc5"
    "\x53\x8b\xcb\x1a\xe9\x30\x8c\x48\xdb\x66\xc3\x98\x24\x1d\x5f\xee"
    "\x6c\x2c\xc1\x3e\xcd\xcd\xb9\x1a\x5d\x8d\xb9\x64\xd9\x4c\x33\x83"
    "\xa4\xa5\x08\x0a\xe3\x73\x0c\xe9\xd9\x6f\xb8\x78\x9a\x46\xdf\x6f"
    "\x7f\x9f\x38\x69\x4b\x44\x00\x7e\x5b\xee\xf6\x2b\xba\xdd\xf7\x8a"
    "\x0e\xa3\xff\xfc\x09\x5a\xd0\x44\x7e\x58\x2f\xfa\xe9\x1d\x1d\xc8"
    "\x39\xc7\x2c\x62\xff\xf5\x22\xca\x8d\xae\xfd\x86\xef\x3b\x8f\xac"
    "\x1b\x11\xb8\x6a\x4e\xf9\x6a\x93\xb1\xda\x8d\x80\xb9\xfa\xca\x52"
    "\x0d\x4a\x45\xf1\x43\x5b\xca\x74\x1f\x94\xe6\x2a\x83\x2f\x76\x8c"
    "\x70\x00\xcf\xa5\x95\x3c\x31\x10\x75\xd2\x75\xf8\x83\x09\x58\x11"
    "\xff\xf9\x82\x32\x26\xad\x72\x85\x13\x64\x6e\xf6\xc1\x71\x55\xe3"
    "\x51\x98\xda\x03\x76\xf0\x5b\x5f\xbe\x5c\xf3\x12\xe5\x6f\x03\xc4"
    "\x36\x84\x66\xb7\xf8\xd5\xb9\x99\xeb\x66\x84\xbc\xf2\x78\x23\x87"
    "\xb2\xa5\x64\xc4\x4a\xa1\x30\x93\x7f\x3a\x48\xe1\xad\xc0\x14\xc2"
    "\x28\x14\x77\x7f\x23\xc7\xa8\xa2\x6c\xab\xd4\x74\xdf\xb1\x42\x84"
    "\xa7\x11\x73\xef\x2d\xf6\x7a\xfb\xe1\xe6\xdb\xac\x57\x3b\xc7\xba"
    "\x8c\x83\x19";

static const unsigned char tgt_rodc[] =
    "\x61\x82\x03\xe4\x30\x82\x03\xe0\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x1d\x30\x1b\xa0\x03\x02"
    "\x01\x02\xa1\x14\x30\x12\x1b\x06\x6b\x72\x62\x74\x67\x74\x1b\x08"
    "\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa3\x82\x03\xac\x30\x82\x03\xa8"
    "\xa0\x03\x02\x01\x12\xa1\x06\x02\x04\xb6\x51\x00\x01\xa2\x82\x03"
    "\x97\x04\x82\x03\x93\xe2\x97\x36\xa2\x9f\x18\x79\x44\x87\xbf\xc8"
    "\x27\x59\x40\xd1\x9d\x3b\x3d\x1d\x8b\xc8\x86\xfb\xc5\x4a\xf8\x27"
    "\x5b\xee\x59\xcc\x3a\xcd\x2f\x0d\xb3\x9f\xb7\x87\xe2\x83\xdb\x36"
    "\xee\xa0\x1c\xdb\x91\x9b\xe1\x50\x3e\xaa\x3d\xea\xae\x93\x65\xdf"
    "\xb3\x23\xfb\xa6\x00\xaf\x55\x49\xf5\x6e\xd9\x2c\xc1\x61\x97\x37"
    "\x19\x83\xe6\x60\xd8\x46\x2d\xdb\x0c\xc4\x55\x2e\x0a\x52\x0d\x64"
    "\xb4\x80\xa9\x3d\x37\xb6\xed\x06\xdc\x32\xfd\x6a\x40\x20\xc4\x69"
    "\x59\xf5\x80\x9c\x7f\x7a\x68\x88\x1c\x67\x37\x52\x85\x1a\x2f\x01"
    "\xf8\x46\xd7\x7a\x24\xfb\x14\x31\xa8\x23\xd0\xac\x13\x85\x1c\xef"
    "\xb1\xe4\x26\x20\x4f\x0c\xbb\xcc\xbb\x86\x40\xb3\x2e\x76\x25\x26"
    "\x2e\x0f\x33\xec\xca\xac\x32\xa2\x35\x98\x1a\x9d\x34\x30\xe8\xaa"
    "\x85\x8c\xa0\x0a\xf6\xe9\x60\x4f\x59\x20\xed\x51\x9d\xcf\xb4\xc1"
    "\xdf\x1e\x8f\x91\x3e\xe2\x32\x9f\x68\x14\x41\x22\x2e\x05\xa7\x6d"
    "\x1d\xa5\x55\xd8\x3b\x1c\xa4\x0b\x80\xf1\x43\x5f\xf7\xc2\xef\xa6"
    "\x28\xcf\xbb\x2a\xbc\x0f\xbc\x20\x11\xff\xc1\x1b\x75\x5b\x49\x6f"
    "\xc5\xc4\xa8\x3c\x46\xb3\xfd\x41\x70\x2a\xd8\x8b\xa6\xc1\x54\xad"
    "\x15\x3e\x96\xca\x28\x3e\xca\x06\xe6\x0d\xad\xc8\x74\x32\x9a\x0d"
    "\x80\x65\xd6\x49\x35\xc0\xd8\x75\xed\xb7\x4b\x9d\xb5\xd5\x3b\x3b"
    "\xd3\x2e\x9f\xed\xbe\xd3\x83\x68\xe1\x3a\x25\x2c\xb5\xfe\xbd\x89"
    "\xf3\x0e\xe3\x5e\xb3\x15\x2e\x0e\xb5\x2b\x97\x47\x6c\x6d\x88\x82"
    "\x42\x54\x0d\x97\x52\x17\x56\x16\x9b\x5e\xaa\x63\xb0\xcb\x6f\xe6"
    "\x0f\x9c\x9e\x6f\x3f\x49\x31\x60\x88\x2f\x25\xae\xff\x1c\x90\x55"
    "\x9d\x63\x50\x56\x4d\x6e\x55\x5c\x48\x84\x1d\xf1\x0a\x03\xa6\x99"
    "\x90\x13\xd6\x9a\xf1\x43\x5d\x0d\x69\x74\x3d\x60\xf5\xa0\x58\x29"
    "\x98\x74\x10\x35\x2f\x6b\x35\x0b\x9a\xed\x3d\x7c\x4f\x00\x55\xec"
    "\x0e\x20\xd0\x77\x46\x45\x7c\x0f\xfa\xf6\x55\xd9\x9f\xf8\x4b\x81"
    "\xfa\x7a\x36\x05\xb9\x8e\xaf\xd8\xd3\x40\x6c\x0f\x72\x0d\x06\xba"
    "\x91\x65\xbe\x5a\xfd\xf4\xb4\x49\xfa\x41\x83\xcb\xcf\x8d\x8a\xb0"
    "\xf6\x3b\xcc\x08\xf8\x26\x41\x0d\x7e\xc6\xb3\x29\x8c\x33\x32\xb3"
    "\x44\x7c\xbd\x0a\xc7\x0a\x58\x75\xfb\x2d\xf0\x53\x6c\xba\x89\x77"
    "\xfd\x71\x7f\xe2\x9d\x9d\x35\x1d\x6b\xb2\x6f\x72\x27\x9b\xe5\x9e"
    "\xc0\x21\x6f\x4a\x5f\x15\xf3\x13\xa4\xd9\x76\x96\xc1\xb3\xcf\x95"
    "\xad\x47\x39\xa7\x10\x39\x7b\xfd\x9d\x71\xe3\xb8\xc4\xdf\xea\x96"
    "\x40\x5e\xbb\x91\xfe\x99\x78\xc7\x97\x89\xca\x38\xd5\xdc\x7f\xad"
    "\x3c\xf8\x59\x46\x05\x54\xb0\xfd\x33\x00\xd8\xa8\xb2\xf6\x44\xad"
    "\xd5\xfc\x2d\xce\x92\x59\x85\x61\x5c\x53\xba\xf9\xe6\xc8\x47\x2f"
    "\x50\xa3\x4a\xa6\x69\x70\xc2\x03\x5a\x44\x84\x20\x4b\x0a\x37\xa1"
    "\x3b\xa8\x46\x96\xa6\x95\xfa\x59\x01\x38\xb5\xc7\xdb\x7c\xa8\x24"
    "\xf9\x75\x90\xa9\x3d\x56\x5f\x95\x14\x17\xc7\xa3\x6f\xe7\xed\x0f"
    "\x6b\xc9\x24\xfa\x0e\x4b\x33\x32\x0f\xd4\xe8\x3d\xae\x03\x9d\xfd"
    "\xbf\x68\xef\x1b\x5a\xfa\x4b\x2e\x7f\x70\xd8\x95\x69\x03\x58\x1b"
    "\xae\xf2\xde\xdb\x1e\xbd\x8a\xb0\xe5\xb3\x1a\x19\xe6\x1c\xf3\xf1"
    "\xa5\xea\x8e\x61\x47\xd6\x4a\x5c\xb1\x2d\x4c\xcb\x22\xb5\x5a\x41"
    "\xac\xad\xdc\x94\x71\xd4\x53\xcf\x67\xc6\xfa\xd4\x6b\x60\xe7\xf6"
    "\x8e\xaf\xae\x98\x1c\x55\xd8\xed\xff\x48\x05\x69\xf4\x63\x4b\x0b"
    "\x1a\xa4\x50\x3e\xff\x61\x72\x23\x5d\x8a\x19\x9e\x7b\x32\x79\x81"
    "\xab\x4e\x5b\x5d\x06\x89\x2a\x26\x13\x20\x6d\xeb\xb2\x69\xb0\xd9"
    "\xa3\x17\x04\xfd\x85\xfb\x54\x12\x02\xa8\x1d\xc4\xd8\x17\x15\xe0"
    "\x67\xc0\x17\x81\x91\xab\x8a\x4b\x72\xe0\x10\x17\xc2\xd3\xe2\x5e"
    "\x08\x24\xfe\x6f\x9d\xc0\x57\x03\x19\x4b\x62\x0a\xee\x3c\xd3\xc6"
    "\xa7\x70\xe6\xca\x02\xea\x91\xf6\x31\xcd\x02\x5b\x55\xd2\xf4\x76"
    "\x2b\x24\xbd\x09\x45\xe8\x00\x63\xbd\x3b\xf8\xeb\xe7\x17\x20\x24"
    "\xaf\x11\x65\xaa\x52\xd1\xf5\x74\xf5\xed\xd2\x5b\x60\x86\x9a\xfc"
    "\xa4\x63\x10\x25\x50\xb4\x40\x14\x97\x20\xf0\x53\xbe\x0f\x2a\x28"
    "\x09\xac\x4d\x9d\x45\x52\x77\xcd\x65\x9a\x2c\xf2\x49\xfe\x92\x1a"
    "\x6d\xb9\xf3\x29\x6c\xcd\x5b\xee\x73\x28\x6b\x2c\x14\xec\x6a\x25"
    "\x64\xac\xcb\xdf\x1a\xe0\xaf\x56\xf6\x49\xea\xad\x06\x9c\xa3\x60"
    "\xb2\xcf\x2c\xad\x19\xeb\xc3\x0f";

static const unsigned char service_rodc[] =
    "\x61\x82\x03\xf3\x30\x82\x03\xef\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x13\x30\x11\xa0\x03\x02"
    "\x01\x01\xa1\x0a\x30\x08\x1b\x06\x61\x70\x61\x63\x68\x65\xa3\x82"
    "\x03\xc5\x30\x82\x03\xc1\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02"
    "\xa2\x82\x03\xb3\x04\x82\x03\xaf\xaf\x34\x2b\xc2\xe0\x1a\x4d\x2d"
    "\xb9\xda\x8c\x44\x52\xa3\xc1\xbf\xe2\xb3\xc9\x27\x29\xd2\x90\xa4"
    "\xca\x87\xd7\xae\x3d\x10\x1a\xc4\x88\x6c\x22\x78\x9a\xb8\xd9\xb0"
    "\x64\xa8\xfc\x49\x8b\xcd\x95\xf6\xc0\xeb\x32\xaa\x70\x06\xdf\xa8"
    "\x98\x9f\xa5\x56\x42\xdf\x33\xd5\x6d\x15\x9d\xea\x6c\x04\x0d\xef"
    "\x06\x13\x52\xe2\xa7\xc3\x76\xb9\xec\x95\x94\xc4\xad\xad\xb5\xa0"
    "\xf5\x44\x69\x69\x96\xf3\xfb\x9e\x99\x48\xca\x5d\x85\x34\x10\xfb"
    "\x51\xb1\x6f\x59\x70\x98\x06\x39\x55\xdc\xa3\x1f\xc8\x36\x63\x47"
    "\xc8\xfc\xc7\x8e\x44\xaf\x5c\x20\x79\x3c\x8f\x54\xb5\x3b\x38\xb4"
    "\xda\xcf\x6c\xea\xcd\x33\x0d\xc6\x86\x07\x08\xa7\x37\x3f\xed\xc4"
    "\x3a\xa6\x98\xcd\x5e\xf8\x06\x3c\x47\xea\x04\xaf\x1e\xd3\x88\x1e"
    "\x17\xf9\xac\xa7\x9e\xf2\x92\x70\xef\xd3\xb7\x39\x24\x65\x0c\x32"
    "\x7e\x03\x2f\x36\x31\xa1\x9b\xe4\x58\x8f\x78\xde\xec\xa5\xba\x54"
    "\x68\xb4\x4c\x17\x23\x0a\x62\xc6\xb0\x22\x3d\x21\x35\xfa\x4f\xf4"
    "\x6d\x9e\x46\xb7\xf5\xcc\x28\xe4\x78\x3a\x36\x6a\x44\xc5\x34\xb7"
    "\x34\x0d\xac\x4f\x02\x41\x8f\xfd\xcb\xd4\x4c\xb6\x4e\xf1\xd1\xe7"
    "\x4a\x1b\xf1\x96\xa5\xd3\x15\x74\xd4\x52\xbe\x1b\xbd\xe1\x17\xe8"
    "\x77\x79\xf6\x51\xc4\xc3\xd9\x6a\xe9\x4c\x70\x10\x33\xed\x59\xa5"
    "\x7d\x05\x17\xde\x61\x65\x5f\xf5\xde\x06\xa4\xd6\x39\xe4\x3f\x83"
    "\xdd\x95\xa3\xb3\x57\x60\x1c\xf3\x42\xdb\xdc\xd5\x39\x76\x68\xd3"
    "\x6e\xc8\x06\xff\x6b\x5b\x1d\x72\x7d\xb4\x4d\xec\x3e\xb8\x6d\x09"
    "\xff\xa5\x0e\x30\xe8\x12\x72\x31\xce\xf3\xdd\x78\xee\x43\x53\x75"
    "\x26\x43\xc2\x29\x1f\x78\x2f\x03\x4f\x2d\x82\xe3\x7c\x82\xb0\x1d"
    "\x64\xdc\x67\xb3\x53\xa6\x7f\x17\xd5\x11\xc1\x0d\xde\x79\x28\x07"
    "\x40\x08\xe0\xfa\x41\x2b\xeb\x3e\xa9\xf0\x92\xdd\x4f\xfe\x13\x05"
    "\x73\x1a\xc7\xfe\x14\x56\x86\x32\x27\x4d\xe5\x4e\x15\x35\x1e\xe5"
    "\x54\x87\x8f\x75\x2a\xcb\x48\x5d\xc4\xce\xd3\x71\x25\x3b\xc6\x51"
    "\xe2\x4f\x83\x87\x05\x97\xc9\x35\x4a\xce\xd7\x5a\x82\xcc\xe5\xc1"
    "\xf6\xf6\x40\x8a\x91\xce\x05\x3a\x6a\xba\x9b\x43\xc6\x9f\x3b\x59"
    "\xb4\xb7\x9b\x24\x6e\xad\x98\xdf\x3e\x12\x9f\x17\x31\x0c\xc7\x7d"
    "\x31\x0b\x6c\xc0\x7b\x72\x1f\xb3\xcf\x24\x80\x64\x49\x95\x5d\xc0"
    "\x0a\x84\xfc\x66\xf7\xcc\xc6\x82\x78\xf4\x23\x69\xfd\x34\x09\x94"
    "\x9e\xd6\x26\xd3\xb6\x4f\x61\x50\xd0\x38\x72\x6d\x06\xef\xa1\x0f"
    "\x3d\x3d\x46\xb0\x4b\xd9\xe8\xe9\x76\x73\xfe\x53\x82\x84\xbd\xea"
    "\x4b\x1b\x97\x5e\x23\x55\x8d\xe6\x2d\x14\xe2\x9c\xbd\x07\xd2\xc2"
    "\x98\x18\xbe\x02\xda\x19\x89\x95\x05\x06\xdb\x59\x4b\xd3\xfc\x18"
    "\x9a\xf7\x39\x98\x9b\x79\x9c\xe1\xbe\x96\xf5\x55\xd7\x2c\x1b\xbb"
    "\x84\x1b\xd3\xad\x8c\x26\x50\xbf\x86\x1b\x59\xfa\xab\xf5\xaf\x2b"
    "\x04\x75\xf9\x33\xcf\xed\x01\x46\xbc\x5c\xd8\x9a\x3c\x1e\x11\x9e"
    "\x03\x86\xf7\xed\x72\x93\xde\xf4\x5f\xb7\x63\x9c\x13\x0a\xa9\xba"
    "\x51\x12\x3d\x13\xa5\xcf\x3e\x4b\x0d\x09\xfe\x97\x87\xde\xdf\x23"
    "\x8d\x2a\x5a\x97\x7d\xfc\xe0\x40\x1a\x99\x75\x02\x7a\xb9\xae\xb4"
    "\x51\x5d\x48\xcd\x98\xb1\xa7\x1e\x91\x06\xf5\xb7\x85\xb5\xd3\xe0"
    "\x9e\xa2\x44\x08\xd7\xed\xbf\x3f\x6c\x39\x19\xfe\xd9\x80\x24\xe4"
    "\x16\x7d\xd8\x66\x1f\xbb\x85\xc1\x38\x03\x1f\x36\xce\x77\x18\x11"
    "\x99\x22\x7e\xb1\x7c\x47\x19\xd7\x8d\x79\x39\xef\xf5\xbd\xa0\xf7"
    "\xca\x88\x79\x7e\xc9\x2b\xd7\x99\x2c\x87\x78\x7b\x4f\x4c\x38\xd8"
    "\x02\xcd\x7c\xd4\x07\x33\x74\x89\x61\xa7\x11\x04\x98\xb2\x5f\x95"
    "\x0c\xc3\x17\x35\xf6\xc3\x38\xee\xc3\xf6\xcf\x46\x68\xeb\x95\xb4"
    "\xa3\x92\xbb\xe9\xd7\x7c\x92\x7f\xd0\x67\x64\x7d\x93\xc6\x37\xb3"
    "\xb4\xe2\xf6\x31\x89\x22\x4b\xd7\xa6\x9d\xad\x14\x0c\x00\xc4\x7c"
    "\x44\xfa\x2c\x89\x3a\x78\xc0\xe8\xb2\x6e\x4f\xde\x37\x07\xca\x5e"
    "\x4a\x7f\x27\xbc\x2e\x96\x5b\xaf\xd0\x6b\xa4\x31\xad\x21\x2d\x0e"
    "\x4c\x25\x97\xde\x42\x07\xc3\x97\xf0\xf5\x3b\x69\x8c\x89\x34\x8f"
    "\xd4\xe7\x7c\xca\x45\x83\x7f\xf7\x7b\x4e\x75\x86\x39\x3b\x67\xbe"
    "\x57\x76\xa1\x26\x65\x1d\x49\x8c\x33\x5c\xdf\x05\x9b\xcf\x4d\xce"
    "\x06\xc9\xaa\xd5\xee\xf0\x3a\x42\x75\x02\x93\xf5\xeb\x00\xa7\xa4"
    "\xfc\xe6\xff\x9e\xda\xb6\xbd\xc9\xe0\x67\xac\x99\x74\x99\xd8\x3e"
    "\xf1\x13\xa8\x2f\xd7\x9c\x26\x95\x0e\xbe\x52\x79\x9b\xda\x8a\x78"
    "\x7e\x2b\x9f\x22\xf3\xfb\x0f";

static const unsigned char s4u2self_rodc[] =
    "\x61\x82\x03\xf2\x30\x82\x03\xee\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x13\x30\x11\xa0\x03\x02"
    "\x01\x01\xa1\x0a\x30\x08\x1b\x06\x61\x70\x61\x63\x68\x65\xa3\x82"
    "\x03\xc4\x30\x82\x03\xc0\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02"
    "\xa2\x82\x03\xb2\x04\x82\x03\xae\x4d\x90\xed\x46\x56\x94\x72\x5e"
    "\x2a\x3d\x13\xad\xfa\xfa\x0e\xd6\x75\x91\x38\x57\xd4\x31\x6b\x07"
    "\x75\x4b\x5c\x3c\x2c\x7a\xdc\x71\xd9\x36\x27\xf9\x27\xbf\xf0\xa9"
    "\xb5\x16\xa0\x12\x3c\x36\x36\x16\x6e\xa5\x19\xcb\x28\xf9\xbb\xe3"
    "\x66\xf7\x02\xad\xa8\xf9\xca\xe0\x84\x27\x7e\x9f\x81\x02\xea\xba"
    "\x85\x6c\x57\x56\x39\x59\xfd\xce\x0f\xb6\x7d\x11\x1c\xc4\x9c\x92"
    "\xb7\xbc\xe0\xc9\x51\xb8\x0f\xd4\x03\x84\xc4\x25\x0b\x9d\x44\x56"
    "\x3f\xc2\xf3\x63\x7b\x8d\x2b\x61\xf2\x5f\x5b\x51\x46\x9f\x81\x1e"
    "\xfc\xc6\x96\x71\x81\x63\xf9\xd8\x20\x57\x08\x6a\xf2\xce\xf7\x4b"
    "\x7f\x92\x3b\x20\x21\xac\x1e\x30\x9e\x88\x71\x55\x00\x12\xef\xe4"
    "\xfe\xf1\x6c\xe1\xab\x2f\x7c\xd9\xea\x53\xac\xd8\x74\x36\x04\xe7"
    "\x40\x9e\x2d\x49\xc4\x9a\x6d\xdb\x95\xd1\xa1\x41\x27\xf9\x9d\xa7"
    "\x16\x44\xd3\x58\x50\x95\x93\xdd\xba\xd0\x81\x17\xaf\x37\x19\x99"
    "\x66\x3d\xc8\x3b\x75\xa0\xef\xd8\xa6\x8d\xa5\xe9\x94\xba\x53\x1c"
    "\x0f\xc7\xcc\x34\x34\x23\x4f\xd5\x63\xda\x33\x49\x9c\x89\xd9\xb7"
    "\xef\x3d\xf3\x9b\x44\x44\xcf\x84\x72\x0d\x54\xca\x40\x67\x42\x81"
    "\xd9\xd8\xd4\x83\x6c\x52\x94\x1b\xdc\x36\x81\xee\x51\x9f\x82\x1c"
    "\xda\x04\x84\x26\x0c\x83\xd2\xe0\x56\xbe\x53\x6b\x50\x43\xc2\x1e"
    "\xaa\x08\xce\x37\x6b\xa8\xa8\xf8\xf2\x03\x69\xfb\xfa\xcb\xfc\xa4"
    "\x89\x47\xbb\xd2\x68\xe5\x2d\x00\x3e\xb2\x06\x71\xda\x4c\x35\xe9"
    "\x6d\xfc\x17\x2a\xdf\xc2\xd5\x96\x67\x03\x39\x75\xe9\xa7\x1f\x77"
    "\xb2\xa8\x0d\xc1\x50\xc2\xe5\xed\x1a\x88\xc3\x73\x81\xa9\x86\xd2"
    "\xc6\x34\xc7\xaa\x1c\x7f\xe6\x47\xbf\x47\xc9\x90\x39\xb3\x2c\x31"
    "\xa0\x26\xee\x7d\xbc\x61\xe0\x26\xaa\xf6\xce\x73\x6f\xdc\xed\x27"
    "\xdd\x13\x53\x0e\x21\x52\x1f\xd3\x75\xdb\x07\x62\x14\x00\xda\x85"
    "\x76\x77\x16\x34\x30\x90\x7f\x94\xc5\x54\x9d\xc6\xce\xab\x11\x0b"
    "\x98\xa9\xe6\x5f\x82\xb7\x1b\x13\xcd\xb0\xcc\xa6\xb8\x27\xb3\xd7"
    "\x0f\x1f\xd8\x75\x56\x0e\xc5\x73\x95\x6f\x90\xda\x49\x12\xd8\x2d"
    "\x23\x49\x13\x43\x49\x1e\xe3\xbf\x80\x4a\xde\xd6\x97\x1e\x33\x50"
    "\x44\x6b\x7b\x00\x05\x90\xab\xfe\x94\xa8\x7c\x40\x86\x42\x4a\x6b"
    "\xc7\x26\x21\x12\x19\x98\x01\xd5\x64\x7d\xdb\xf7\xe3\xf7\xea\xca"
    "\x5d\xf8\xcb\x0a\x3f\x83\xf2\x6b\xe7\x2e\x3c\x71\x73\xc9\x3c\xc0"
    "\x82\xc5\x2d\x7b\xd0\x03\xa2\xe2\xd9\x6d\xcd\x15\xd5\xd4\xbf\x90"
    "\xc6\xf4\x19\x5b\x72\x0f\xaf\x42\xd4\x28\x58\x4f\xbe\xff\x63\x6a"
    "\x0d\x42\x9f\x05\xfe\xbd\xdb\x81\x18\xaa\x73\x4b\x16\x96\x1b\x62"
    "\xe8\x21\x88\xde\x9a\x57\x70\xcc\xab\x49\x4e\x0c\x31\xec\x8d\xce"
    "\x82\x20\x3c\x44\x9b\xbc\x36\xb2\x8f\x7d\xe5\xea\x11\xf6\x71\x16"
    "\x8e\x66\xcb\xfb\xc2\x92\xf5\xc1\x09\xac\x90\x68\xc6\xd7\x93\x21"
    "\xcb\xb8\x57\x47\x56\x8c\x13\x7e\x78\x81\x08\x25\x3d\x4c\x1d\xeb"
    "\x39\x2c\xf5\x9b\x67\x5d\xb4\xee\xb5\x71\xba\xcf\x29\x7a\x6b\xa5"
    "\x30\x4a\xfd\x16\x33\x5d\x68\x95\x62\xe7\x76\xca\x06\xb8\x94\x51"
    "\x1f\x9a\x71\x99\x78\xaa\xec\xcf\x27\xc9\x16\xcb\x91\xa0\xbe\xca"
    "\xf9\x9c\xbe\x4d\xb0\xb9\x98\x21\x01\xb2\xa7\x7a\x8a\x0d\x1c\x62"
    "\xeb\x7d\x52\x81\xf9\xf5\x94\x0b\x27\x6a\x1c\xfc\xb6\xb2\x3a\x52"
    "\x39\xd2\x6c\xca\x23\x43\xd1\xbf\x44\x54\x85\xb6\xd5\xb9\x93\xb9"
    "\x91\x86\x59\x7f\xd2\x23\x1c\xeb\x2c\x5d\xb0\xcd\x09\x2d\x83\x62"
    "\x24\x94\x65\x64\x13\x00\xe0\x1d\xd0\xf5\x56\x79\xff\xcc\xa9\xb9"
    "\xda\xd4\x6a\xab\xe9\x2a\x91\x40\x44\xed\x7b\x8c\xed\xb1\x39\x70"
    "\xd0\x51\x51\x6c\x45\x5f\xd4\xed\x0d\x36\x17\xf0\x69\xf6\x92\x72"
    "\xca\xc8\x90\x1e\xe0\x44\xf0\x19\x2e\x2c\x1f\x12\x42\xa3\x15\x9d"
    "\x37\x86\xa3\xa3\x6e\x04\xfc\x84\x73\xf8\x1d\x13\x30\xe5\x0f\x32"
    "\x58\xab\x51\x0e\xad\x0a\xcc\xb9\x32\x81\x44\x7c\x6e\xc1\xec\xcd"
    "\x5d\x6a\x9a\xb7\x27\x53\x98\xcc\x2b\x8d\x3c\xac\xbe\x12\xcb\x01"
    "\xeb\xe7\xbe\xb5\x10\x16\x22\xc1\x92\x86\xe7\xa6\x1f\x88\xfa\x6a"
    "\x70\xec\xd8\x38\x31\x85\x6f\x08\x33\x3c\x1b\x49\x68\xd4\xa5\x4c"
    "\x7e\xf1\xbc\x25\x4f\x2f\xef\x39\xad\x78\x19\x23\x31\x47\xa1\x96"
    "\xae\x7b\x8d\x8b\xf1\xf4\xc4\x3b\x06\xc0\xf6\x6e\x0f\xd2\xe0\x18"
    "\xca\xc4\x09\x1b\x34\xbe\x1f\x12\x21\x69\x79\x9c\xaf\xe2\x78\xb4"
    "\x19\x85\x83\xb7\x9c\x2d\x1a\x14\x1d\x64\xc8\x36\x48\xf2\x3d\xf6"
    "\x26\x8c\x5a\x4c\x03\xae";

static const unsigned char s4u2proxy_rodc[] =
    "\x61\x82\x04\x9f\x30\x82\x04\x9b\xa0\x03\x02\x01\x05\xa1\x0a\x1b"
    "\x08\x41\x43\x4d\x45\x2e\x43\x4f\x4d\xa2\x20\x30\x1e\xa0\x03\x02"
    "\x01\x03\xa1\x17\x30\x15\x1b\x03\x73\x71\x6c\x1b\x0e\x6d\x79\x73"
    "\x71\x6c\x2e\x61\x63\x6d\x65\x2e\x63\x6f\x6d\xa3\x82\x04\x64\x30"
    "\x82\x04\x60\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02\xa2\x82\x04"
    "\x52\x04\x82\x04\x4e\xd2\x92\xec\x00\xf9\xc9\x37\xde\x46\xf6\x35"
    "\x62\xb7\xa1\x77\x0c\x9a\x4f\x6d\x17\x2e\xfd\x59\x24\xfe\x85\x32"
    "\x3f\xf2\x40\x1e\xcd\xf1\xa6\xd2\xeb\xba\x26\xa1\x87\xee\x0b\xee"
    "\xbf\x3e\xad\x73\x07\xf1\xc8\xb9\x2b\xc7\x16\x31\xf3\x63\x95\x56"
    "\x5d\x5d\x00\x6a\xff\xa0\x20\x05\x14\x0b\x50\x0b\x1e\x1a\xf2\x61"
    "\x29\x1b\x49\x54\xf9\xac\x6c\x08\x91\xdf\x44\x3e\x43\x42\xbe\x4a"
    "\x5a\x7d\xaf\xd5\xb9\x26\xe4\x91\x5f\xf0\xcc\x55\x3d\xc7\xc4\xc0"
    "\x46\x3b\x32\x1f\xca\xcf\x16\xec\x18\x1b\x29\xe9\xb1\x4c\xdd\x0f"
    "\xb3\x53\x2b\x0a\x7a\x5a\xff\xa0\xf4\x62\xcf\xf1\x2c\xc9\x64\xfa"
    "\x35\xad\xb7\x18\x9b\x53\xb2\xe4\xdc\x81\x59\x8b\x2a\xb7\x94\xe0"
    "\xf5\x99\x7d\x04\xb6\x49\xa2\x9a\x6a\xcc\x17\x62\x63\x5d\x2e\xf2"
    "\x24\x56\x58\x00\x68\x6a\x60\x37\xf9\xa7\x55\xac\xb8\x95\xcb\x22"
    "\x6a\xd6\x6c\x91\x99\x22\xc4\x33\x38\xfa\xf4\x7f\xf0\xf1\xae\x2e"
    "\x5c\xa5\x6c\x6b\x98\x3e\x82\x94\xee\x2e\x4c\xbd\x41\xb8\x4f\xeb"
    "\x0a\xca\xb1\x0b\x88\xfb\x51\x76\x87\x69\x7c\x0b\x61\xc3\xe6\xe1"
    "\xd8\x2a\xc3\xee\xde\x13\x70\xbf\x6a\x9f\x7d\x2a\x6f\x7b\x57\x28"
    "\xd3\x9e\x39\xf8\xc7\x05\xd5\xc0\xe3\x11\x11\x05\xeb\x2f\x08\x14"
    "\x1c\x98\xae\x7e\x56\x8a\xb7\xcc\x2b\x74\xda\x01\x69\xeb\x56\x3c"
    "\x89\x4f\x5d\xf8\xf7\xdb\x73\xa4\x84\x29\x91\x79\x32\xcc\xa0\xc1"
    "\x28\xad\x9d\x4e\xcf\x45\x00\x6e\x8a\xe7\xf8\xd5\xeb\x87\x51\x37"
    "\xcb\xb9\x4f\xc7\x08\x27\x2a\xf3\xaa\x24\x26\x0b\xed\x40\xcf\x74"
    "\xae\xa9\xa3\xed\x1e\x97\xd0\x05\xb5\xae\xdf\x37\xb5\x24\x52\xa1"
    "\xac\xd7\x31\xa2\xef\xc8\xab\x8a\xc4\x8c\x3d\x7c\xf3\x00\xf0\xc3"
    "\xe7\xa3\x6d\x93\x83\xe4\x08\x2e\xa1\xb5\xc4\xdc\x4b\x3f\x06\x23"
    "\x40\xaa\x0a\x72\xe6\x5a\xad\x65\x53\x3d\x48\x6c\x6f\xe3\xc5\x8b"
    "\xa3\xba\x54\x73\x78\x07\xf8\x88\xd5\xf4\x87\x04\x5d\x88\x1b\xba"
    "\x4e\x67\x9f\x92\xe8\x9c\xf0\xc4\xba\xfb\xe3\x78\xe2\xd9\xa3\x38"
    "\xdb\xd6\x41\x4c\xa4\x76\x92\x36\xc1\xd7\x30\x05\x3f\xf8\x9f\xd1"
    "\xf8\x79\x13\xeb\x98\xc2\x7a\xa3\x25\xab\x32\x1e\x14\x10\x87\xc0"
    "\x00\x68\x26\xf8\x8d\x4d\xb5\x96\xb7\x35\x81\xe5\x0c\x3f\x45\x2c"
    "\xcf\x4e\xdd\xda\xe6\xd4\xb3\xcb\x50\xf1\xe5\x48\x4c\xec\xcc\x10"
    "\x33\xa0\x11\x53\x0d\xf3\x2c\x98\xcb\x76\xbf\x6e\xd7\xe9\x20\xe7"
    "\xdb\xbd\xae\xcf\x69\x0e\xd1\xce\x47\xae\x5a\xe1\x21\x0d\xe9\xd5"
    "\x2f\x09\xc4\x36\x53\x24\x4a\x5c\xac\x07\xff\xd8\xac\xfe\xae\x91"
    "\x93\x92\xbf\xc6\x3b\xa4\xdb\x28\x52\x23\x58\x7d\xcb\xbd\x39\x34"
    "\x07\xeb\x56\x1a\xf9\x47\xf8\x70\xee\x60\x51\x2e\x80\x92\xd4\xcf"
    "\xd8\x9d\x75\x16\x50\xf1\xb0\x02\x61\x99\x51\x7c\x46\x48\xf9\x6b"
    "\x84\xdf\x5c\xef\xe1\x1f\x0c\x22\x9b\xdc\xbc\x76\x7f\x3f\x6d\xfe"
    "\xb8\x2f\x93\xb9\x27\x58\xa9\x93\x42\xda\xf2\x67\xf7\x01\xbe\xd8"
    "\xa2\x18\xec\x1e\x40\x3d\x3b\x6f\xfe\x50\xab\xb9\x35\xb7\xdd\x2a"
    "\xe1\x51\xf9\xce\xea\xf5\x1d\xed\x6c\x2b\xbc\x86\xc9\x53\x41\x8b"
    "\x2e\x06\xc8\xc0\x08\x48\x37\x40\x8c\xf8\xe9\x4b\xc7\xc0\x6f\x1b"
    "\xe1\x0c\x8c\x0e\xf4\x73\x19\x7e\xc6\x36\x84\xa2\x8f\x72\x2e\x59"
    "\x53\x25\x2c\x92\x95\x04\x9b\x13\x97\x7a\xc7\x53\xa4\xa6\x0f\xf3"
    "\x06\x59\x25\xe7\xd5\x35\x0e\xe9\x10\x95\x60\x0f\x53\xd4\x24\x13"
    "\x72\xf6\x6d\x17\xb8\x43\xb2\xac\x40\x15\x11\xb6\x1b\xbb\x13\xb3"
    "\x90\x66\x85\x92\xcb\xb4\xf5\x9c\x15\x89\x41\xbc\x07\xb0\x37\x21"
    "\xff\x13\x93\x55\xe9\xe0\x2d\x32\x64\x62\x40\x45\xb5\x41\x80\xdd"
    "\xb8\xf2\xe9\x64\x3e\xfb\xe6\x69\x1c\xd0\xb4\xb1\xa2\x58\x95\xe5"
    "\xf7\x48\x8e\x10\x4c\x8b\x05\x96\xfa\x6f\x36\x34\xe1\x29\x1c\x65"
    "\x65\x8d\xb0\x39\x50\x27\x00\xac\xa6\x4f\x5b\xd2\xb0\xfe\x69\x17"
    "\xa2\xa8\x19\x34\x78\x9b\xef\x8c\xc2\xb9\xf1\xb6\xee\x28\xf4\x74"
    "\xd6\x18\xe0\x0f\x36\x91\xf4\x56\xbc\x5d\x16\x21\x0e\x14\xb2\x5e"
    "\x42\x38\xe2\x10\x81\x31\x54\x4b\xf5\xfd\x62\x72\xb0\x05\x16\x19"
    "\x88\xe0\xd4\x5d\x5f\x10\x5c\x0d\x1f\x6a\x9f\x27\x48\x58\x18\xd1"
    "\x60\x46\x17\xf3\x5e\xbc\xf1\x3a\xcd\x4b\x01\x08\x2e\x34\x5e\xa6"
    "\x91\xa3\x87\x0f\xe7\x34\x9c\xcb\x87\x95\x40\xee\x22\x1c\x41\x55"
    "\xc1\x6b\x36\x22\xa2\xbb\xf2\x55\x04\xb7\x79\x0f\xe1\xb8\x95\xcf"
    "\x7b\x8a\x37\x6d\x1e\x78\x09\x5c\x1a\x6c\xa3\x93\x13\x70\xfe\x37"
    "\xcc\x4a\xe7\x58\xda\xaa\x14\xe1\x32\xac\x64\xdb\x52\xef\x33\x71"
    "\xf3\x27\xa5\x2e\x2c\x69\xe3\xa6\xab\x15\xe5\xdc\x27\xf4\xe8\x6d"
    "\x7a\x66\x9a\x1e\x69\x46\xa9\xfa\x02\xbb\x35\x6e\x16\xc0\x06\xdf"
    "\xd7\xcf\x8b\xab\x3e\xfc\x62\x7d\x35\x95\xb8\x15\xe2\xee\x6d\x61"
    "\x5b\x7b\xb5\x88\x03\x45\x1c\xa0\x79\xff\x81\x4f\x75\xa9\xe7\x0a"
    "\xed\x81\xac\xe6\x2f\x86\xb2\x23\x9b\x5a\xfe\x5c\xee\x18\x5a\x4a"
    "\x0f\x4a\xf4\x49\x8d\xbc\x7f\x3f\xc4\xbc\x7f\xbf\x41\x95\x62\x9e"
    "\xc6\x73\x5f\x5a\x5d\x41\x53\xe2\xaa\x03\xc8\x00\x68\xad\x26\xf2"
    "\x8f\x66\x78\x10\x3f\xa8\x56\x4b\x77\xb9\x0d\x94\x49\x54\x47\xd5"
    "\x69\x9d\x4f\x44\xce\xc3\x6d\xae\x51\x20\x24\x61\xb6\x6f\xff\x27"
    "\xc4\x36\xb1";

static const unsigned char extra_logon_info[] =
    "\x08\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\xf0\x01\x00\x00"
    "\x88\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x1e\x00\x00\x00"
    "\x78\x02\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x98\x00\x00\x00"
    "\x98\x02\x00\x00\x00\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00"
    "\x30\x03\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x08\x00\x00\x00"
    "\x30\x03\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x1c\x00\x00\x00"
    "\x38\x03\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x10\x00\x00\x00"
    "\x58\x03\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x10\x00\x00\x00"
    "\x68\x03\x00\x00\x00\x00\x00\x00\x01\x10\x08\x00\xcc\xcc\xcc\xcc"
    "\xe0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\x7f\xff\xff\xff\xff"
    "\xff\xff\xff\x7f\x59\xa1\x0f\x59\x77\xf5\xd7\x01\x59\xa1\x0f\x59"
    "\x77\xf5\xd7\x01\x59\x21\x69\x4e\x78\x16\xd8\x01\x14\x00\x14\x00"
    "\x04\x00\x02\x00\x00\x00\x00\x00\x08\x00\x02\x00\x00\x00\x00\x00"
    "\x0c\x00\x02\x00\x00\x00\x00\x00\x10\x00\x02\x00\x00\x00\x00\x00"
    "\x14\x00\x02\x00\x00\x00\x00\x00\x18\x00\x02\x00\x00\x00\x00\x00"
    "\x4d\x04\x00\x00\x01\x02\x00\x00\x01\x00\x00\x00\x1c\x00\x02\x00"
    "\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x0e\x00\x10\x00\x20\x00\x02\x00\x0e\x00\x10\x00"
    "\x24\x00\x02\x00\x28\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x02\x00\x00\x00\x2c\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00"
    "\x63\x00\x39\x00\x64\x00\x38\x00\x30\x00\x31\x00\x61\x00\x38\x00"
    "\x5f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x01\x00\x00\x00\x01\x02\x00\x00\x07\x00\x00\x00\x08\x00\x00\x00"
    "\x00\x00\x00\x00\x07\x00\x00\x00\x54\x00\x45\x00\x53\x00\x54\x00"
    "\x2d\x00\x44\x00\x43\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
    "\x07\x00\x00\x00\x45\x00\x58\x00\x41\x00\x4d\x00\x50\x00\x4c\x00"
    "\x45\x00\x00\x00\x04\x00\x00\x00\x01\x04\x00\x00\x00\x00\x00\x05"
    "\x15\x00\x00\x00\xa1\xa5\x92\x7f\x29\x19\xc5\x3b\xbb\x56\xb0\x05"
    "\x02\x00\x00\x00\x30\x00\x02\x00\x07\x00\x00\x00\x34\x00\x02\x00"
    "\x07\x00\x00\x00\x05\x00\x00\x00\x01\x05\x00\x00\x00\x00\x00\x05"
    "\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\xf1\x01\x00\x00\x01\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x12"
    "\x01\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x8f\x5a\x77\xf5\xd7\x01"
    "\x14\x00\x63\x00\x39\x00\x64\x00\x38\x00\x30\x00\x31\x00\x61\x00"
    "\x38\x00\x5f\x00\x30\x00\x00\x00\x2c\x00\x18\x00\x16\x00\x48\x00"
    "\x03\x00\x00\x00\x14\x00\x60\x00\x1c\x00\x78\x00\x00\x00\x00\x00"
    "\x63\x00\x39\x00\x64\x00\x38\x00\x30\x00\x31\x00\x61\x00\x38\x00"
    "\x5f\x00\x30\x00\x40\x00\x45\x00\x58\x00\x41\x00\x4d\x00\x50\x00"
    "\x4c\x00\x45\x00\x2e\x00\x43\x00\x4f\x00\x4d\x00\x00\x00\x00\x00"
    "\x45\x00\x58\x00\x41\x00\x4d\x00\x50\x00\x4c\x00\x45\x00\x2e\x00"
    "\x43\x00\x4f\x00\x4d\x00\x00\x00\x63\x00\x39\x00\x64\x00\x38\x00"
    "\x30\x00\x31\x00\x61\x00\x38\x00\x5f\x00\x30\x00\x00\x00\x00\x00"
    "\x01\x05\x00\x00\x00\x00\x00\x05\x15\x00\x00\x00\xa1\xa5\x92\x7f"
    "\x29\x19\xc5\x3b\xbb\x56\xb0\x05\x4d\x04\x00\x00\x00\x00\x00\x00"
    "\x02\x00\x00\x00\x01\x00\x00\x00\x01\x05\x00\x00\x00\x00\x00\x05"
    "\x15\x00\x00\x00\xa1\xa5\x92\x7f\x29\x19\xc5\x3b\xbb\x56\xb0\x05"
    "\x4d\x04\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\xfd\x39\xd8\x32"
    "\x3b\x8c\xa5\xfe\x6b\x3d\x27\xff\x10\x00\x00\x00\x2f\x99\x7e\x57"
    "\xca\xe4\xe1\xc7\x1b\xc0\xbd\xee";

struct test_pac_ticket {
    const char *name;
    const unsigned char *ticket;
    size_t ticket_len;
    uint16_t rodc_id;
    const krb5_keyblock *key;
    const krb5_keyblock *kdc_key;
};

static const struct test_pac_ticket pac_tickets[] = {
    { "tgt_ticket", tgt_ticket, sizeof(tgt_ticket), 0, &rwdc_tgt_key, &rwdc_tgt_pac_key },
    { "service_ticket", service_ticket, sizeof(service_ticket), 0, &server_key, &rwdc_tgt_pac_key },
    { "s4u2self_ticket", s4u2self_ticket, sizeof(s4u2self_ticket), 0, &server_key, &rwdc_tgt_pac_key },
    { "s4u2proxy_ticket", s4u2proxy_ticket, sizeof(s4u2proxy_ticket), 0, &server_key, &rwdc_tgt_pac_key },
    { "tgt_rodc", tgt_rodc, sizeof(tgt_rodc), 46673, &rodc_tgt_key, &rodc_tgt_pac_key },
    { "service_rodc", service_rodc, sizeof(service_rodc), 46673, &server_key, &rodc_tgt_pac_key },
    { "s4u2self_rodc", s4u2self_rodc, sizeof(s4u2self_rodc), 46673, &server_key, &rodc_tgt_pac_key },
    { "s4u2proxy_rodc", s4u2proxy_rodc, sizeof(s4u2proxy_rodc), 46673, &server_key, &rodc_tgt_pac_key },
    { NULL, NULL, 0, 0, NULL, NULL }
};

static void
t_err(krb5_context context,
      const char *test,
      const char *func,
      krb5_error_code error)
{
   krb5_err(context, 1, error, "test %s failed in %s", test, func);
}

static krb5_boolean
is_krbtgt(const PrincipalName *p)
{
    return (p->name_string.len == 2 &&
	    strcmp(p->name_string.val[0], KRB5_TGS_NAME) == 0);
}

static void
check_ticket_signature(krb5_context context,
		       const struct test_pac_ticket *tkt)
{
    krb5_error_code ret;
    krb5_crypto crypto;
    krb5_data data, orig_pac_ad;
    Ticket ticket;
    EncTicketPart et;
    krb5_principal client;
    krb5_pac pac;
    krb5_boolean signedticket;
    krb5_cksumtype cstype;
    uint16_t rodc_id;

    ret = decode_Ticket(tkt->ticket, tkt->ticket_len, &ticket, NULL);
    if (ret)
	t_err(context, tkt->name, "decode_Ticket", ret);

    ret = krb5_crypto_init(context, tkt->key, tkt->key->keytype, &crypto);
    if (ret)
	t_err(context, tkt->name, "krb5_crypto_init", ret);

    ret = krb5_decrypt_EncryptedData(context,
				     crypto,
				     KRB5_KU_TICKET,
				     &ticket.enc_part,
				     &data);
    if (ret)
	t_err(context, tkt->name, "krb5_decrypt_EncryptedData", ret);

    ret = decode_EncTicketPart(data.data, data.length, &et, NULL);
    if (ret)
	t_err(context, tkt->name, "decode_EncTicketPart", ret);

    ret = _krb5_principalname2krb5_principal(context, &client, et.cname,
					     et.crealm);
    if (ret)
	t_err(context, tkt->name, "_krb5_principalname2krb5_principal", ret);

    ret = _krb5_kdc_pac_ticket_parse(context, &et, &signedticket, &pac);
    if (ret)
	t_err(context, tkt->name, "_krb5_kdc_pac_ticket_parse", ret);

    heim_assert(!is_krbtgt(&ticket.sname) == !!signedticket, "ticket-signature");

    ret = krb5_pac_verify(context, pac, et.authtime, client,
			  tkt->key, tkt->kdc_key);
    if (ret)
	t_err(context, tkt->name, "krb5_pac_verify ticket-sig", ret);

    ret = krb5_pac_get_kdc_checksum_info(context, pac, &cstype, &rodc_id);
    if (ret)
	t_err(context, tkt->name, "krb5_pac_get_kdc_checksum_info", ret);

    heim_assert(cstype == CKSUMTYPE_HMAC_MD5, "Wrong checksum type");
    heim_assert(rodc_id == tkt->rodc_id, "Wrong RODCIdentifier");

    /* Try to resign the PAC */
    orig_pac_ad = et.authorization_data->val[0].ad_data;
    et.authorization_data->val[0].ad_data.data = NULL;

    ret = remove_AuthorizationData(et.authorization_data, 0);
    if (ret)
	t_err(context, tkt->name, "remove_AuthorizationData", ret);

    ret = _krb5_kdc_pac_sign_ticket(context, pac, client, tkt->key,
				    tkt->kdc_key, tkt->rodc_id,
				    NULL, NULL, signedticket, &et, NULL);
    if (ret)
	t_err(context, tkt->name, "_krb5_kdc_pac_sign_ticket", ret);

    heim_assert(krb5_data_cmp(&et.authorization_data->val[0].ad_data,
			      &orig_pac_ad) == 0, "PACs differ");

    /* Sign and verify a clean PAC */
    krb5_pac_free(context, pac);
    ret = krb5_pac_init(context, &pac);
    if (ret)
	t_err(context, tkt->name, "krb5_pac_init", ret);

    ret = remove_AuthorizationData(et.authorization_data, 0);
    if (ret)
	t_err(context, tkt->name, "remove_AuthorizationData 2", ret);

    ret = _krb5_kdc_pac_sign_ticket(context, pac, client, tkt->key,
				    tkt->kdc_key, tkt->rodc_id,
				    NULL, NULL, signedticket, &et, NULL);
    if (ret)
	t_err(context, tkt->name, "_krb5_kdcsignedticketsign_ticket 2", ret);

    krb5_pac_free(context, pac);

    ret = _krb5_kdc_pac_ticket_parse(context, &et, &signedticket, &pac);
    if (ret)
	t_err(context, tkt->name, "_krb5_kdc_pac_ticket_parse 2", ret);

    heim_assert(!is_krbtgt(&ticket.sname) == !!signedticket, "ticket-signature");

    ret = krb5_pac_verify(context, pac, et.authtime, client, tkt->key,
			  tkt->kdc_key);
    if (ret)
	t_err(context, tkt->name, "krb5_pac_verify ticket-sig 2", ret);

    ret = krb5_pac_get_kdc_checksum_info(context, pac, &cstype, &rodc_id);
    if (ret)
	t_err(context, tkt->name, "krb5_pac_get_kdc_checksum_info 2", ret);

    heim_assert(cstype == CKSUMTYPE_HMAC_MD5, "Wrong checksum type 2");
    heim_assert(rodc_id == tkt->rodc_id, "Wrong RODCIdentifier 2");

    krb5_pac_free(context, pac);
    krb5_free_principal(context, client);
    krb5_crypto_destroy(context, crypto);
    free_EncTicketPart(&et);
    krb5_data_free(&data);
    free_Ticket(&ticket);
}


int
main(int argc, char **argv)
{
    krb5_error_code ret;
    krb5_context context;
    krb5_pac pac;
    krb5_data data;
    krb5_principal p, p2;

    ret = krb5_init_context(&context);
    if (ret)
	errx(1, "krb5_init_context");

    krb5_enctype_enable(context, ETYPE_DES_CBC_MD5);

    ret = krb5_parse_name_flags(context, user,
				KRB5_PRINCIPAL_PARSE_NO_REALM, &p);
    if (ret)
	krb5_err(context, 1, ret, "krb5_parse_name");

    ret = krb5_pac_parse(context, saved_pac, sizeof(saved_pac), &pac);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_parse");

    ret = krb5_pac_verify(context, pac, authtime, p,
			   &member_keyblock, &kdc_keyblock);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_verify");

    ret = _krb5_pac_sign(context, pac, authtime, p,
			 &member_keyblock, &kdc_keyblock, 0, NULL, NULL,
			 NULL, &data);
    if (ret)
	krb5_err(context, 1, ret, "_krb5_pac_sign");

    krb5_pac_free(context, pac);

    ret = krb5_pac_parse(context, data.data, data.length, &pac);
    krb5_data_free(&data);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_parse 2");

    ret = krb5_pac_verify(context, pac, authtime, p,
			   &member_keyblock, &kdc_keyblock);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_verify 2");

    /* make a copy and try to reproduce it */
    {
	uint32_t *list;
	size_t len, i;
	krb5_pac pac2;

	ret = krb5_pac_init(context, &pac2);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_init");

	/* our two user buffer plus the three "system" buffers */
	ret = krb5_pac_get_types(context, pac, &len, &list);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_get_types");

	for (i = 0; i < len; i++) {
	    /* skip server_cksum, privsvr_cksum, and logon_name */
	    if (list[i] == 6 || list[i] == 7 || list[i] == 10)
		continue;

	    ret = krb5_pac_get_buffer(context, pac, list[i], &data);
	    if (ret)
		krb5_err(context, 1, ret, "krb5_pac_get_buffer");

	    if (list[i] == 1) {
		if (type_1_length != data.length)
		    krb5_errx(context, 1, "type 1 have wrong length: %lu",
			      (unsigned long)data.length);
	    } else
		krb5_errx(context, 1, "unknown type %lu",
			  (unsigned long)list[i]);

	    ret = krb5_pac_add_buffer(context, pac2, list[i], &data);
	    if (ret)
		krb5_err(context, 1, ret, "krb5_pac_add_buffer");
	    krb5_data_free(&data);
	}
	free(list);

	ret = _krb5_pac_sign(context, pac2, authtime, p,
			     &member_keyblock, &kdc_keyblock, 0,
			     NULL, NULL, NULL, &data);
	if (ret)
	    krb5_err(context, 1, ret, "_krb5_pac_sign 4");

	krb5_pac_free(context, pac2);

	ret = krb5_pac_parse(context, data.data, data.length, &pac2);
	krb5_data_free(&data);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_parse 4");

	ret = krb5_pac_verify(context, pac2, authtime, p,
			      &member_keyblock, &kdc_keyblock);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_verify 4");

	krb5_pac_free(context, pac2);
    }

    krb5_pac_free(context, pac);

    /*
     * check pac from Christian
     */

    ret = krb5_parse_name_flags(context, user2,
				KRB5_PRINCIPAL_PARSE_NO_REALM, &p2);
    if (ret)
	krb5_err(context, 1, ret, "krb5_parse_name");

    ret = krb5_pac_parse(context, saved_pac2, sizeof(saved_pac2) -1, &pac);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_parse");

    ret = krb5_pac_verify(context, pac, authtime2, p2,
			   &member_keyblock2, NULL);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_verify c1");

    krb5_pac_free(context, pac);
    krb5_free_principal(context, p2);

    /*
     * Test empty free
     */

    ret = krb5_pac_init(context, &pac);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_init");
    krb5_pac_free(context, pac);

    /*
     * Test add remove buffer
     */

    ret = krb5_pac_init(context, &pac);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_init");

    {
	const krb5_data cdata = { 2, "\x00\x01" } ;

	ret = krb5_pac_add_buffer(context, pac, 1, &cdata);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_add_buffer");
    }
    {
	ret = krb5_pac_get_buffer(context, pac, 1, &data);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_get_buffer");
	if (data.length != 2 || memcmp(data.data, "\x00\x01", 2) != 0)
	    krb5_errx(context, 1, "krb5_pac_get_buffer data not the same");
	krb5_data_free(&data);
    }

    {
	const krb5_data cdata = { 2, "\x02\x00" } ;

	ret = krb5_pac_add_buffer(context, pac, 2, &cdata);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_add_buffer");
    }
    {
	ret = krb5_pac_get_buffer(context, pac, 1, &data);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_get_buffer");
	if (data.length != 2 || memcmp(data.data, "\x00\x01", 2) != 0)
	    krb5_errx(context, 1, "krb5_pac_get_buffer data not the same");
	krb5_data_free(&data);
	/* */
	ret = krb5_pac_get_buffer(context, pac, 2, &data);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_get_buffer");
	if (data.length != 2 || memcmp(data.data, "\x02\x00", 2) != 0)
	    krb5_errx(context, 1, "krb5_pac_get_buffer data not the same");
	krb5_data_free(&data);
    }

    ret = _krb5_pac_sign(context, pac, authtime, p,
			 &member_keyblock, &kdc_keyblock, 0,
			 NULL, NULL, NULL, &data);
    if (ret)
	krb5_err(context, 1, ret, "_krb5_pac_sign");

    krb5_pac_free(context, pac);

    ret = krb5_pac_parse(context, data.data, data.length, &pac);
    krb5_data_free(&data);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_parse 3");

    ret = krb5_pac_verify(context, pac, authtime, p,
			   &member_keyblock, &kdc_keyblock);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_verify 3");

    {
	uint32_t *list;
	size_t len;

	/* our two user buffer plus the three "system" buffers */
	ret = krb5_pac_get_types(context, pac, &len, &list);
	if (ret)
	    krb5_err(context, 1, ret, "krb5_pac_get_types");
	if (len != 5)
	    krb5_errx(context, 1, "list wrong length");
	free(list);
    }

    krb5_pac_free(context, pac);
    krb5_free_principal(context, p);

    /*
     * check extra logon info PAC
     */
    ret = krb5_pac_parse(context, extra_logon_info,
			 sizeof(extra_logon_info) - 1, &pac);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_parse");

    ret = krb5_pac_verify(context, pac, 0, NULL, NULL, NULL);
    if (ret)
	krb5_err(context, 1, ret, "krb5_pac_verify");

    ret = krb5_parse_name(context, "c9d801a8_0@EXAMPLE.COM", &p);
    if (ret)
	krb5_err(context, 1, ret, "_krb5_pac_get_canon_principal");

    ret = _krb5_pac_get_canon_principal(context, pac, &p2);
    if (ret)
	krb5_err(context, 1, ret, "_krb5_pac_get_canon_principal");

    if (!krb5_principal_compare(context, p, p2))
	krb5_errx(context, 1, "canon principal doesn't match");

    krb5_pac_free(context, pac);
    krb5_free_principal(context, p);
    krb5_free_principal(context, p2);

    /* Test PAC ticket-signature */
    {
	const struct test_pac_ticket *tkt;

	for (tkt = pac_tickets; tkt->name != NULL; tkt++)
	    check_ticket_signature(context, tkt);
    }

    krb5_free_context(context);

    return 0;
}
