/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsSupportsArray_h__
#define nsSupportsArray_h__

#include "nsIArray.h"
#include "nsCOMArray.h"
#include "mozilla/Attributes.h"


// Disable deprecation warnings generated by nsISupportsArray and associated
// classes.
#if defined(__GNUC__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#elif defined(_MSC_VER)
#pragma warning (push)
#pragma warning (disable : 4996)
#endif

#include "nsISupportsArray.h"

class nsSupportsArray final : public nsISupportsArray,
                              public nsIArray
{
  ~nsSupportsArray(void); // nonvirtual since we're not subclassed

public:
  nsSupportsArray(void);

  static MOZ_MUST_USE nsresult
  Create(nsISupports* aOuter, REFNSIID aIID, void** aResult);

  NS_DECL_THREADSAFE_ISUPPORTS

  NS_DECL_NSISERIALIZABLE

  // nsICollection methods:
  NS_IMETHOD Count(uint32_t* aResult) override
  {
    *aResult = mArray.Length();
    return NS_OK;
  }
  NS_IMETHOD GetElementAt(uint32_t aIndex, nsISupports** aResult) override;
  MOZ_MUST_USE NS_IMETHOD
  SetElementAt(uint32_t aIndex, nsISupports* aValue) override
  {
    return ReplaceElementAt(aValue, aIndex) ? NS_OK : NS_ERROR_FAILURE;
  }
  MOZ_MUST_USE NS_IMETHOD AppendElement(nsISupports* aElement) override
  {
    // XXX Invalid cast of bool to nsresult (bug 778110)
    return (nsresult)InsertElementAt(aElement, mArray.Length())/* ? NS_OK : NS_ERROR_FAILURE*/;
  }
  // XXX this is badly named - should be RemoveFirstElement
  MOZ_MUST_USE NS_IMETHOD RemoveElement(nsISupports* aElement) override;
  NS_IMETHOD DeprecatedEnumerate(nsIEnumerator** aResult) override;
  NS_IMETHOD Clear(void) override;

  // nsISupportsArray methods:
  NS_IMETHOD_(int32_t) IndexOf(const nsISupports* aPossibleElement) override;

  NS_IMETHOD GetIndexOf(nsISupports* aPossibleElement, int32_t* aResult) override
  {
    *aResult = IndexOf(aPossibleElement);
    return NS_OK;
  }

  MOZ_MUST_USE NS_IMETHOD_(bool)
  InsertElementAt(nsISupports* aElement, uint32_t aIndex) override;

  MOZ_MUST_USE NS_IMETHOD_(bool)
  ReplaceElementAt(nsISupports* aElement, uint32_t aIndex) override;

  MOZ_MUST_USE NS_IMETHOD_(bool)
  RemoveElementAt(uint32_t aIndex) override;

  MOZ_MUST_USE NS_IMETHOD DeleteElementAt(uint32_t aIndex) override
  {
    return (RemoveElementAt(aIndex) ? NS_OK : NS_ERROR_FAILURE);
  }

  MOZ_MUST_USE NS_IMETHOD Clone(nsISupportsArray** aResult) override;

  /**
   * nsIArray adapters.
   */
  NS_DECL_NSIARRAY

private:
  // Copy constructors are not allowed
  explicit nsSupportsArray(const nsISupportsArray& aOther);

  nsCOMArray<nsISupports> mArray;
};

#if defined(__GNUC__)
#pragma GCC diagnostic pop
#elif defined(_MSC_VER)
#pragma warning (pop)
#endif

#endif // nsSupportsArray_h__
