#!/bin/bash
#Non instrusive script to remind users to check for updates every X days_to_wait_before_warning, or always warn users, if there are updatable packages in the system. Works on Debian systems (but has to be adapted to run on an OS other than antiX). Originally concieved to be called from anacron, once a day. 
#By PPC, as part of the ft10-transformation package, full GPL license, 2/2/22

### Localization ###
TEXTDOMAINDIR=/usr/share/locale
TEXTDOMAIN=ft10-update-reminder

#Allow only one instance of the script at a time:
scriptname=ft10-update-reminder.sh
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then exit 1     
    fi 
done

#Main script:
days_to_wait_before_warning=8
date_of_last_update=$(stat -c %y /var/lib/apt/periodic/update-success-stamp| cut -d" " -f1)
today=$(date +%Y-%m-%d)
let DIFF=(`date +%s -d $today`-`date +%s -d $date_of_last_update`)/86400
available_updates=$(apt-get dist-upgrade -s --quiet=2 | grep ^Inst | wc -l)

if [ "$available_updates" -gt "0" ]; then
 Warning=$" There are, at least $available_updates available updates ";
fi

if [ $DIFF -ge $days_to_wait_before_warning ]; then
#check if a network connection is available, if no network is detected, exit
	network_check=$(ping -c 1 -q google.com >&/dev/null; echo $?)
	if [ "$network_check" -eq "0" ]; then
	 status="You are connect to a network";
		else status="No network available"; exit;
	fi

yad --borders=10 --image="/usr/share/icons/papirus-antix/48x48/emblems/emblem-important.png" --undecorated --geometry=280x50-40-50  --window-icon="software-sources" --title="antix Updater" --text=$"It's been $DIFF days since you last checked for updates.You should check for updates now. $warning" --button="x" --button=$"Check for Updates":"bash -c 'gksudo ft10-yad-updater'"

 else

 #Even if user ran "apt update" recently, always warn if there are upgrades available. 	
	if [ "$available_updates" -gt "0" ]; then
	yad  --borders=10 --image="/usr/share/icons/papirus-antix/48x48/emblems/emblem-important.png" --undecorated --geometry=280x50-40-50 --window-icon="software-sources" --title="antix Updater" --text="$Warning" --button=$"Update":"bash -c 'gksudo ft10-yad-updater'" --button="x"
    fi 
 exit
fi
