#!/bin/bash
# Adds/Removes icons to the Tint2 toolbar(adding icons is done using the info from the app's .desktop file) 
# By PPC, 6/01/2021 adapted from many, many on-line examples, and from toolbar icon manager for icewm
# GPL licence - feel free to improve/adapt this script - but keep the lines about the license and author

###Check if tint2 is running, if not, exit
running_windows=$(wmctrl -l)
if [[ $running_windows == *" tint2"* ]]; then
echo "You are running tint2..."
else 
 yad --window-icon=/usr/share/pixmaps/icewm_editor.png --title='Aviso' --text='This script is meant to be run only with tint2 toolbar!!!' --timeout=10 --no-buttons --center
 exit
fi

### show "please wait"
yad --title="tint2-wait" --center --undecorated --no-buttons --text="\n  Por favor aguarde... " &

###Create list of availables apps, with localized names- this takes a few seconds on low powered devices:

#Get system language (to allow localization):
lang=$(locale | grep LANG | cut -d= -f2 | cut -d_ -f1) #To test localization to another language, like french, use: lang=fr
window_icon="/usr/share/icons/papirus-antix/24x24/apps/tint2.png"
#Loop through all .desktop files in the applications folders and extract name and save that to a .txt file 

cd /usr/share/applications/
find ~+ -type f -name "*.desktop" > ~/.apps-antix-0.txt
###NOTE: repeat the last 2 lines, changing the first, the "cd" one, to change to the folder where your .desktop files are
sort ~/.apps-antix-0.txt > ~/.apps-antix.txt
cd ~

for file in $(cat ~/.apps-antix.txt)
do
name1=$(grep -o -m 1 '^Name=.*' $file)

### localized menu entries generator (slows the script down, but produces nearly perfectly localized menus):
name2=$name1
translated_name1=$(grep -o -m 1 "^Name\[$lang\]=.*" $file)
[ -z "$translated_name1" ] && note="No localized name found, using the original one" || name2=$translated_name1
#if the desktop file has the string "Desktop Action" simply use the original untranslated name, to avoid risking using a translation that's not the name of the app
grep -q "Desktop Action" $file && name2=$name1
name1=$name2
### end of localized menu entries generator	 
name=$(echo $name1|sed 's/.*\=//') 

echo "$name"  --  "$file"
done > /tmp/list.txt
sort /tmp/list.txt > ~/.apps.txt
###

delete_icon()
{
for (( ; ; ))
do

###Function to delete  icon
#criar lista de ícones:
grep -r "launcher_item_app" ~/.config/tint2/tint2rc > /tmp/launchers_list.txt
#remover o texto "launcher_item_app = ", 21 leters
(cat /tmp/launchers_list.txt | cut -c21-) > /tmp/launchers.txt

#apagar ficheiro temporiario
echo > /tmp/lista_apelativa.txt
#processar linha a linha a lista dos launchers existentes na barra
cat /tmp/launchers.txt | while read line; do
### ver se o ficheiros apps.txt, que tem todos os programas, com descrição, tem uma linha que corresponde à aplicação que está a ser analisada, a "line" da lista launchers.txt
app_with_descri=$(grep -E $line ~/.apps.txt)
#se não houver correspondencia, manter o nome do .desktop
[ -z "$app_with_descri" ] && app_with_descri=$line
echo $app_with_descri >> /tmp/lista_apelativa.txt
done

#choose application to delete
    EXEC=$(yad   --window-icon=window_icon --title="Escolha o ícone a ser removido da barra"  --height=550 --width=650 --center  --separator=" " --list  --column= --button=" !/usr/share/icons/papirus-antix/24x24/actions/xml-attribute-delete.png" < /tmp/lista_apelativa.txt )
#choose only path and desktop file (last field from string:
selection_to_delete=$(echo $EXEC | awk '{print $NF}')

# if no application selected- avoids creating empty icon: (also allows to exit the infinit loop tha keeps respawning the selection window)
if [ -z "$EXEC" ]; then exit
fi

#delete application icon from toolbar
grep -v $selection_to_delete ~/.config/tint2/tint2rc > temp && mv temp ~/.config/tint2/tint2rc		 

#instantly restart toolbar to show changes
old_tint2_pid=$(pgrep tint2)
nohup  tint2 && sleep 0.1 &&
kill -9  $old_tint2_pid &

#refresh list of launchers
echo > /tmp/lista_apelativa.txt
cat /tmp/launchers.txt | while read line; do
app_with_descri=$(grep -E $line ~/.apps.txt)
[ -z "$app_with_descri" ] && app_with_descri=$line
echo $app_with_descri >> /tmp/lista_apelativa.txt
done

#end initial infine loop (so window is always open after selection)
done
}		

move_icon()
{
#criar lista de ícones:
grep -r "launcher_item_app" ~/.config/tint2/tint2rc > /tmp/launchers_list.txt
#remover o texto "launcher_item_app = ", 21 leters
(cat /tmp/launchers_list.txt | cut -c21-) > /tmp/launchers.txt

# estabelecer linha que é o limite minimo esquerdo até onde um ícone pode ser movido
limite_esq_zona=$(grep -n -m 1 "# Launcher" ~/.config/tint2/tint2rc |sed  's/\([0-9]*\).*/\1/')
limite_esq_launchers=$(grep -n -m 1 "launcher_item_app =" ~/.config/tint2/tint2rc |sed  's/\([0-9]*\).*/\1/')
if [ $limite_esq_launchers -ge $limite_esq_zona ]; then limite_esq=$limite_esq_launchers
else
limite_esq=$limite_esq_zona
fi
limite_esq_final=$(($limite_esq -1 ))
echo $limite_esq_final

# estabelecer linha que é o limite máximo direito até onde um ícone pode ser movido 
#number_of_lines=$(wc -l < ~/.config/tint2/tint2rc)
limite_dir_launchers=$(grep -n launcher_item_app ~/.config/tint2/tint2rc |cut -d':' -f1 |tail -n 1)

#apagar ficheiro temporiario
echo > /tmp/lista_apelativa.txt
#processar linha alinha a lista dos launchers existentes na barra
cat /tmp/launchers.txt | while read line; do
### ver se o ficheiros apps.txt, que tem todos os programas, com descrição, tem uma linha que corresponde à aplicação que está a ser analisada, a "line" da lista launchers.txt
app_with_descri=$(grep -E $line ~/.apps.txt)
#se não houver correspondencia, manter o nome do .desktop
[ -z "$app_with_descri" ] && app_with_descri=$line
echo $app_with_descri >> /tmp/lista_apelativa.txt
done

#choose application to move
    EXEC=$(yad --window-icon=$window_icon --title="Escolha o ícone que deseja mover na barra" --width=450 --height=480 --center --separator=" " --list  --column=" "  < /tmp/lista_apelativa.txt --button=' !/usr/share/icons/papirus-antix/24x24/actions/kt-upnp.png':4)

    #get line number(s) where the choosen application is
    x=$(echo $EXEC)
    #get last filed of the selected line in practice it's the path and file name of the .desktop file)
    x=$(echo $EXEC | awk '{print $NF}')
    Line=$(grep -n -m 1 $x ~/.config/tint2/tint2rc |cut -f1 -d: )

     #get number of lines in file
     number_of_lines=$(wc -l < $file)
     
#####Act on selection:
#only do something if a icon was selected :
if test -z "$x" 
then
  echo "nothing was selected"
else

file_name=~/.config/tint2/tint2rc
a=$Line

#this performs an infinite loop, so the Move window is ALWAYS open unless the user clicks "Cancel"
while :
do

nome=$(echo $EXEC |cut -d'-' -f1)
yad --window-icon=/usr/share/pixmaps/icewm_editor.png --center --undecorated --title="Mover ícone da barra" --text="A mover o ícone $nome" \
--button=" !/usr/share/icons/papirus-antix/24x24/actions/gtk-quit.png":1 \
--button=" ← ":2 \
--button=" → ":3 

foo=$?
Line_to_the_left=line_number=$((line_number-1))
line_number=$a

if [[ $foo -eq 1 ]]; then exit
fi

#move icon to the left:
limite_esquerdo=0
if [[ $foo -eq 2 ]]; then
b=$(($a-1))
if [ $b -gt $limite_esq_final ]; then
sed -n "$b{h; :a; n; $a{p;x;bb}; H; ba}; :b; p" ${file_name} > test2.txt
#create backup file before changes
cp ~/.config/tint2/tint2rc ~/.config/tint2/tint2rc.bak
cp test2.txt ~/.config/tint2/tint2rc
sleep .3

old_tint2_pid=$(pgrep tint2)
nohup  tint2 && sleep 0.1 &&
kill -9  $old_tint2_pid &

a=$(($a-1))   # update selected icon's position, just in case the user wants to move it again
fi
fi

#move icon to the right:
if [[ $foo -eq 3 ]]; then
a=$(($a+1))
b=$(($a-1))
if [ $b -ge  $limite_dir_launchers ]; then 
  exit 
else
sed -n "$b{h; :a; n; $a{p;x;bb}; H; ba}; :b; p" ${file_name} > test2.txt
#create backup file before changes 
cp ~/.config/tint2/tint2rc ~/.config/tint2/tint2rc.bak
cp test2.txt  ~/.config/tint2/tint2rc
sleep .3

old_tint2_pid=$(pgrep tint2)
nohup  tint2 && sleep 0.1 &&
kill -9  $old_tint2_pid &
# There's no need to update selected icon's position, just in case the user wants to move it again, because moving right just moves the icon to the right of the select icon to the left, so, it updates instantly the selected icon's position
fi
fi

done

fi ### ends if cicle that checks if user selected icon to move in the main Move icon window

}	

add_icon()
{

####begin infinite loop
for (( ; ; ))
do

# Use a Yad window to select file to be added to the menu
DADOS=$(yad --window-icon=$window_icon --title="Escolha o ícone a adicionar à barra"  --height=550 --width=650 --center  --separator=" " --list  --column= --button=" !/usr/share/icons/papirus-antix/24x24/actions/add.png" < ~/.apps.txt)
SELECTION=$(echo $DADOS | sed 's/^.*--//')
    ###Function to add a new icon
COMANDO0=$(echo "$DADOS" | cut -d'|' -f1)
#this strips any existing path from the name:
EXEC0=$(grep Exec= $COMANDO0 | cut -d '=' -f2)
EXEC=$(echo "$EXEC0" | cut -f1 -d" ")

# if no application selected- avoids creating empty icon: (also allows to exit the infinit loop tha keeps respawning the selection window)
if [ -z "$EXEC" ]; then exit
fi

#add line to toolbar
echo "launcher_item_app ="$SELECTION  >> ~/.config/tint2/tint2rc
#instantly restart toolbar to show changes
old_tint2_pid=$(pgrep tint2)
nohup  tint2 && sleep 0.1 &&
kill -9  $old_tint2_pid &


#end initial infine loop (so window is always open after selection)
done
    ###END of Function to add a new icon
}

##check if window with the title "tint2-wait" is showing, if so, close that window:
wmctrl -lp | awk '/tint2-wait/{print $3}' | xargs kill

#display main window
export -f delete_icon add_icon move_icon
DADOS=$(yad --window-icon=$window_icon --paned --center --splitter="200" --title="Gerir ícones da barra" \
--form  \
--center \
--button=" !/usr/share/icons/papirus-antix/24x24/actions/xml-attribute-delete.png":"bash -c delete_icon" \
--button=" !/usr/share/icons/papirus-antix/24x24/actions/kt-upnp.png":"bash -c move_icon" \
--button=" !/usr/share/icons/papirus-antix/24x24/actions/add.png":"bash -c add_icon" \
--wrap)

### wait for a button to be pressed then perform the selected function
foo=$?

[[ $foo -eq 1 ]] && exit 0
