#!/bin/bash
# Very basic managment of jgmenu's contents (adding "favorites" is done using the info from the app's .desktop file) 
# Version Beta3, By PPC, 8/8/2021 adapted from many, many on-line examples and Tollbar Icon Manager for IceWM
# GPL licence - feel free to improve/adapt this script - but keep the lines about the license and author
###Create list of availables apps, with localized names- this takes a few seconds on low powered devices:

#Get system language (to allow localization):
lang=$(locale | grep LANG | cut -d= -f2 | cut -d_ -f1) #To test localization to another language, like french, use: lang=fr

#Loop through all .desktop files in the applications folders and extract name and save that to a .txt file 

cd /usr/share/applications/
find ~+ -type f -name "*.desktop" > ~/.apps-antix-0.txt
cd ~/.local/share/applications/
find ~+ -type f -name "*.desktop" >> ~/.apps-antix-0.txt
###NOTE: repeat the last 2 lines, changing the first, the "cd" one, to change to the folder where your .desktop files are
sort ~/.apps-antix-0.txt > ~/.apps-antix.txt
cd ~

#for file in /usr/share/applications/*.desktop
for file in $(cat ~/.apps-antix.txt)
do
 name1=$(grep -o -m 1 '^Name=.*' $file)

 ### localized menu entries generator (slows the script down, but produces nearly perfectly localized menus):
    name2=$name1
	translated_name1=$(grep -o -m 1 "^Name\[$lang\]=.*" $file)
	[ -z "$translated_name1" ] && note=$"No localized name found, using the original one" || name2=$translated_name1
	#if the desktop file has the string "Desktop Action" simply use the original untranslated name, to avoid risking using a translation that's not the name of the app
	grep -q "Desktop Action" $file && name2=$name1
	name1=$name2
 ### end of localized menu entries generator	 
 name=$(echo $name1|sed 's/.*\=//') 

echo "$name"  --  "$file"
done > /tmp/list.txt
sort /tmp/list.txt > ~/.apps.txt
###

delete_icon()
{
		###Function to delete  icon
		### Select any application whose icon you want to remove from the toolbar:
		#display only application names
grep -A100 -P '^# App' ~/.config/jgmenu/append.csv| sed '/^#/d' | sed '/^$/d' | sed '/^\^/d'| awk -F"," '{print $1}'  > /tmp/toolbar-test-edit.txt
EXEC=$(yad --title=$"Toolbar Icon Manager" --width=450 --height=480 --center --separator=" " --list  --column=$"Double click any Application to remove its icon:"  < /tmp/toolbar-test-edit.txt --button=$"Remove":4)
#get line number(s) where the choosen application is
x=$(echo $EXEC)
Line=$(sed -n "/$x/=" ~/.config/jgmenu/append.csv)
## NOTE: to be on the safe side, in order to use $Line to delete the line(s) that match the selection, first extract it's first number, to avoid errors in case more than one line matchs the selection (there's more that one icon for the same app on the toolbar), TIM should only delete the first occorrence!!! Also: changed the sed command so it directly deletes line number $Line (solves the bug of not deleting paterns with spaces)...
firstx=$(echo $Line | grep -o -E '[0-9]+' | head -1 | sed -e 's/^0\+//')
# remove the first line that matchs the user selection, only if something was selected
if test -z "$x" 
then
      echo $"nothing was selected"
else
sed -i ${firstx}d ~/.config/jgmenu/append.csv
fi
}		

move_icon()
{
	
		grep -A100 -P '^# App' ~/.config/jgmenu/append.csv| sed '/^#/d' | sed '/^$/d' | sed '/^\^/d'| awk -F"," '{print $1}'  > /tmp/toolbar-test-edit.txt
EXEC=$(yad --title=$"Toolbar Icon Manager" --width=450 --height=480 --center --separator=" " --list  --column=$"Double click any Application to remove its icon:"  < /tmp/toolbar-test-edit.txt --button=$"Move":4)
		#get line number(s) where the choosen application is
		x=$(echo $EXEC)
		 Line=$(sed -n "/$x/=" ~/.config/jgmenu/append.csv)
		 #get number of lines in file
		 number_of_lines=$(wc -l < $file)

#only do something if a icon was selected :
if test -z "$x" 
then
      echo $"nothing was selected"
else

file_name=~/.config/jgmenu/append.csv
a=$Line

#this performs an infinite loop, so the Move window is ALWAYS open unless the user clicks "Cancel"
	while :
	do

yad --center --undecorated --title=$"Favorites Manager" --text=$"Choose where to move $EXEC" \
--button=gtk-quit:1 \
--button=$"Move Up":2 \
--button=$"Move Down":3 

foo=$?
Line_to_the_left=line_number=$((line_number-1))
line_number=$a

if [[ $foo -eq 1 ]]; then exit
fi

#move icon to the left:
if [[ $foo -eq 2 ]]; then
b=$(($a-1))
	if [ $b -gt 0 ]; then
sed -i -n "$b{h; :a; n; $a{p;x;bb}; H; ba}; :b; p" ${file_name} 
a=$(($a-1))   # update selected icon's position, just in case the user wants to move it again
	fi
fi

#move icon to the right
if [[ $foo -eq 3 ]]; then
a=$(($a+1))
number_of_lines=$(wc -l < ~/.config/jgmenu/append.csv)
b=$(($a-1))
    if [[ $line_number -ge  $number_of_lines ]]; then 
  exit 
  else
  sed -i -n "$b{h; :a; n; $a{p;x;bb}; H; ba}; :b; p" ${file_name} > test2.txt
  fi
fi

	done

fi ### ends if cicle that checks if user selected icon to move in the main Move icon window

	}	

add_icon()
{

####begin infinite loop
for (( ; ; ))
do


# Use a Yad window to select file to be added to the menu
DADOS=$(yad --button=gtk-quit:1 --button=$"Add selected app's icon":2 --title=$"Choose application to add to the Toolbar"  --height=500 --width=400 --center  --separator=" " --list  --column=  < ~/.apps.txt)

		###Function to add a new icon
COMANDO0=$(echo "$DADOS" | cut -d'|' -f1)
#this strips any existing path from the name:
EXEC0=$(grep Exec= $COMANDO0 | cut -d '=' -f2)
EXEC=$(echo "$EXEC0" | cut -f1 -d" ")
#this strips any existing path from the name:
COMANDO00=$(basename $COMANDO0)
#this strips any existing .desktop from the name:
REMOVE=".desktop"
##strip selection until only the localized application name remains:
#NOME=${DADOS%/usr*}
NOME=${DADOS%--*}

 #try to find app icon:
	ICON0=$(grep Icon= $COMANDO0 | cut -d '=' -f2)
	ICON00=$(echo "$ICON0" | cut -f1 -d" ")
	ICONwithoutpath=$(basename $ICON00)

# By default set the icon as the gears icon, then look if the icon exist in several paths...
ICONE="/usr/share/icons/papirus-antix/24x24/apps/yast-runlevel.png"

# if a icon with a full path exists on the .desktop, use that icon
if [[ -f "$ICON00" ]]; then  ICONE=$ICON00
fi

#...Also check if the icon's name exists in several possible default paths, if a existing icon is found, use that instead!
#We can add as many paths as we want for the system to look for icons, also, we can look for icons with extensions other than .png (ex: svg), adding new "extension" and path's, and repeating the if-fi cicle
extension=".png"

path="/usr/share/pixmaps/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

path="/usr/share/icons/papirus-antix/24x24/apps/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

path="/usr/share/icons/papirus-antix/24x24/places/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

## v.9 - looks in another folder, that has icon's for example, for Brave Browser
path="/usr/share/icons/hicolor/24x24/apps/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

## v.9 – if no icon was found after searching the default couple of icon folders, perform active search for icons and use search result only if an icon was found- it takes about 1 second, but almost always finds a icon!
default="/usr/share/icons/papirus-antix/24×24/apps/yast-runlevel.png"
if [ "$ICONE" == "$default" ]; then
  search=$(locate /usr/share/icons/*/$ICONwithoutpath$extension)
  first_result=$(echo $search | head -n1 | awk '{print $1;}')
  if [ -z "$first_result" ]
  then 
  echo $"No icon located, using default Gears icon"
  else 
  echo $"Icon located!" ; ICONE=${first_result::-4}
  fi
fi
###
    
# exit if no application selected- avoids creating empty icon on toolbar:
if [ -z "$EXEC" ]; then exit
fi

#open .desktop file and get EXEC= contents
EXEC0=$(grep Exec= $COMANDO0 | cut -d '=' -f2)
#in case EXEC has more than one line, use only the first
readarray -t lines < <(echo "$EXEC0")
EXECperc="${lines[0]}"

#add entry to menu - the | cut -f1 -d"%"   part removes any %x option from the exec command.
xx=$(grep -c ".*" ~/.config/jgmenu/append.csv)
line=$((xx-1))
i="i"
text=$(echo sed -i \'$line$i\\\ ${NOME}, ${EXECperc}, ${ICONE}\' ~/.config/jgmenu/append.csv)
eval $text

##awk -v n=8 -v s="Project_Name=sowstest" 'NR == n {print s} {print}' file > file.new


done ###close infite loop
		###END of Function to add a new icon
}

advanced()
{
		###Function to manually manage icons (ADVANCED management)
		yad --center --form --title=$"Toolbar Icon Manager" --field=$"Warning::TXT" $"If you click 'Yes', jgmenu's append.csv configuration file will be opened for manual editing.\n
How-to:\nEach Favorite is identified by it's name, on the start of it's line followed a comma, the application executable file, a comma, then icon.\n Move, edit or delete the entire line referring to each favorite.\nNote: Lines starting with # are comments only and will be ignored.\nThere can be empty lines.\nDon't forget to save any changes, backing up first." --width=400 --height=360 --button=gtk-quit:1 --button=gtk-yes:0 && geany ~/.config/jgmenu/append.csv
		###END of Function to manually arrange icons
}	

toggle_tiles()
{
POSICAO_ATUAL=$(egrep "^menu_width          =" ~/.config/jgmenu/jgmenurc | cut -d'=' -f2)
echo $POSICAO_ATUAL
if [[ POSICAO_ATUAL -eq 620 ]]
then
echo tiles are enabled, disabling
#disable tiles
sed -i "/^menu_width          = /s/620/400/g" ~/.config/jgmenu/jgmenurc
sed -i "/^menu_padding_right  =/s/200/2/g" ~/.config/jgmenu/jgmenurc
exit 0
fi

if [[ POSICAO_ATUAL -eq 400 ]]  
then
echo tiles are disabled, enabling
#enable tiles
sed -i "/^menu_width          = /s/400/620/g" ~/.config/jgmenu/jgmenurc
sed -i "/^menu_padding_right  =/s/2/200/g" ~/.config/jgmenu/jgmenurc
exit 0
fi
}	

export -f help delete_icon advanced restore_icon add_icon move_icon toggle_tiles

DADOS=$(yad --length=200 --width=280 --center --title="Manage Favorites" \
--form  \
--button=gtk-quit:1 \
--field=$"ADVANCED!help-hint:FBTN" "bash -c advanced" \
--field=$"ADD!add:FBTN" "bash -c add_icon" \
--field=$"MOVE!gtk-go-back-rtl:FBTN" "bash -c move_icon" \
--field=$"REMOVE!remove:FBTN" "bash -c delete_icon" \
--field=$"Toogle Tiles on/off!settings:FBTN" "bash -c toggle_tiles" \
--wrap --text=$"Please select any option from the buttons below to manage antiX Ft10's Menu Favorites")


### wait for a button to be pressed then perform the selected function
foo=$?

[[ $foo -eq 1 ]] && exit 0
