.ds AK \s-1IceWM\s+1
.ds EP \fIIceWM: Window Manager\fP
.if !\n(.g \{\
.	if !\w|\*(lq| \{\
.		ds lq ``
.		if \w'\(lq' .ds lq "\(lq
.	\}
.	if !\w|\*(rq| \{\
.		ds rq ''
.		if \w'\(rq' .ds rq "\(rq
.	\}
.\}
.TH ICEWM 1 "2017-07-11" "" "IceWM Window Manager"

.SH NAME
icewm \- lightweight X11 window manager

.SH SYNOPSIS
.B icewm-session [options...]

.SH DESCRIPTION
.I IceWM
is a lightweight window manager for the X11 window system.
It aims to be small, fast and familiar to new users.
IceWM is called a re-parenting window manager, because
it draws small frames around application windows.
Windows are manipulated via the mouse by dragging or resizing this frame.
It is also called a stacking window manager, because windows can overlap.
Many windows may exist, some hidden behind others,
while interaction takes place with the currently visible ones.
IceWM supports a configurable number of virtual desktops.
It provides a taskbar for monitoring applications
and a pager to switch between desktops.
IceWM is mostly compatible with the ICCCM 2.0 and EWMH window manager protocols.

IceWM was originally designed to emulate the look of Motif,
OS/2 Warp 4, OS/2 Warp 3 and Windows 95.
Since it has a theming engine other styles are possible.
The installation comes with several preconfigured themes.
The IceWM menu allows to choose between them.

Generally, it tries to make all functions available
by both keyboard and mouse.
Configurability is very good through various preferences files.
However, configuring is not required:
it works fine out of the box.

IceWM consists of several programs:

.B icewm
- the actual window manager. It positions application windows
on screen and decorates them with borders. It gives input focus to
the current active application. Icewm supports three different
focus modes: click to focus, sloppy mouse focuse and a custom
user-definable focus mode. Icewm also draws a small taskbar
at the bottom of the screen, which gives easy access to programs,
to active applications, and to a small set of monitoring applets.

.B icewmbg
- the background setting application. It can assign plain
background color or images in different formats to the X background.
It supports semitransparency. Semitransparent background image
and color can be configured. When the background image has changed
then icewmbg can be notified to update the background.
This program should be started before icewm.

.B icewmtray
- catches the Docklet objects which are installed by various
applications like PSI.

.B icewm-session
- runs all of the above when needed.
It first loads additional environment variables from the optional
.I env
file. Then it starts icewmbg, icewmtray and icewm.
It also runs the
.I startup
script.
It implements basic session management.
Icewm-session is the preferred program to start the IceWM system.
On termination the
.I shutdown
script will be run first, then icewm-session will terminate
icewmtray, icewm and icewmbg.

.B icesh
- could be used to manage IceWM internals from command line.

.B icehelp
- is used by icewm to display the IceWM manual.

.B icewmhint
- used internally.

.B icesound
- plays audio files on GUI events raised by IceWM.

.B icewm-menu-fdo
- generate an IceWM menu with executable desktop applications
according to Freedesktop.org specifications.

.SH OPTIONS
.TP
Each of the IceWM executables supports the following options:
.TP
.B \-c, \-\^\-config=FILE
Use FILE as the source of configuration options.
By default IceWM looks for a file named "preferences".
Typically this file is stored as one of ~/.config/icewm/preferences,
or ~/.icewm/preferences, or in one of the configuration
directories explained below. It contains a long list of options
which allow the user to tweak the behavior of IceWM to ones taste.
A default
.I preferences
file contains comments about the purpose
of each option, the range of useful values and the
current or default value. A preferences file is a readable
text file which can be modified with the help of a text editor.
If this option is given to icewm-session then it is passed
on to icewm. If icewm is started independently then this option
can be given to icewm directly. However, usually one will
want to use a preferences file from a default location.

.TP
.B \-t, \-\^\-theme=NAME
Use NAME as the name of the IceWM
.I theme
to use.
A theme defines the look and feel of IceWM,
like colors, fonts, buttons and button behavior.
Originally a theme defined options to emulate
the appearance of other desktop environments,
like Motif, OS/2 Warp, or Windows.
Over the years many new original themes have been
designed with beautiful icons and backgrounds, which
advance the state of the art in desktop look and feel.
Many of them can be downloaded from the website
https://www.box-look.org/ and stored in either the
directory ~/.config/icewm/themes/ or in ~/.icewm/themes/.
You can then activate such a theme via the
menu in the lower left corner of the display.
A default theme is specified in either
~/.icewm/theme, or in ~/.config/icewm/theme.
When a new theme is selected then this value is overwritten,
so that the next time IceWM is started this choice is reused.

.TP
.B \-\^\-display=NAME
NAME specifies the connection to the X11 server.
If this option is missing, as is usually the case,
then NAME is read from the environment variable DISPLAY.

.TP
.B \-\^\-sync
This option is sometimes used in software development of IceWM.
It specifies to use a slower synchronous communication mode
with the X11 server.  This is irrelevant for normal use of IceWM.

.TP
.B \-h, \-\^\-help
Gives a complete list of all the available command line options
with some very brief explanation.

.TP
.B \-V, \-\^\-version
Shows the software release version for this program.

.TP
The icewm program supports some additional options:

.TP
.B --replace
Instructs IceWM to replace an existing window manager.
Once that window manager notices that it is to be replaced
it will cease operations and typically stop execution.
This allows IceWM to establish itself as the only active
window manager.

.TP
.B --restart
Instructs IceWM to restart itself, but one should not
use this option directly. Instead one selects the
.B Restart Icewm
button from the menu in the lower left corner of the desktop.

.TP
.B --configured
Shows a list of configuration options which were
enabled when IceWM was compiled from source code.
This can be helpful if one suspects some functionality may be missing.

.TP
.B --directories
Gives a list of directories where IceWM will look for configuration data.
This list is printed in the actual order in which IceWM uses it
to search for configuration files.

.TP
.B --list-themes
Icewm will search all the configuration directories for
theme files and print a list of all found themes.

.TP
.B --postpreferences
This gives a long list of all the internal IceWM options
with their actual values after icewm has processed all of
the configuration and theme files. In some advanced
scenarios this can be helpful to inspect which configuration
was chosen or whether option formatting was correct.

.PD 1
.SH TASKBAR

On startup IceWM launches the taskbar at the bottom of the screen.
The taskbar consists from left to right  of the following components:

.PD 0
.PP
The
.I menu button
in the lower left corner gives access to the IceWM
root menu. This menu has submenus to start applications,
to control IceWM settings, and the IceWM Logout menu.

.PP
The
.I Show Desktop
button unmaps all application windows to fully uncover the desktop.

.PP
The 
.I Window list menu button
gives access to a menu with a list of active windows
for the current workspace and a list of workspaces
with submenus for their active application windows.

.PP
The
.I toolbar
is a list of icons for applications which are
defined in the toolbar configuration file.

.PP
The
.I workspace list
shows one button for each workspace.
The current workspace is indicated by a pressed button.
Pressing another workspace button switches to that workspace.
The workspaces are defined in the preferences file.
When
.B PagerShowPreview
is turned on a small graphical summary for each workspace is shown.

.PP
The
.I task pane
consists of a list of wide buttons for each application
which is running on the current workspace.
Each task button shows the application icon and the application title.
The active application is indicated by a pressed button.
This is the application which has input focus.
Pressing another button activates that application:
it is brought to the foreground and receives input focus.

.PP
If there are not many application buttons then a stretch of plain
taskbar is visible.
Clicking on it with the right mouse button gives the taskbar menu.

.PP
The
.I tray applet
shows Docklet objects.

.PP
The
.I APM applet
shows battery power status.

.PP
The
.I Net applet
shows network activity.
Network devices to monitor are given by the
.B NetworkStatusDevice
option.

.PP
The
.I Mem applet
monitors memory usage.

.PP
The
.I CPU applet
monitors processor utilization.

.PP
The
.I Mailbox applet
monitors mailbox status changes.
The location of the mailbox is given by the
.B MailBoxPath
preferences option or else by the
.B MAIL
environment variable.
It can be the path of a local mail spool file or
the specification of a remote
.I POP3
or
.I IMAP
location.
For example:
.B MailBoxPath="pop3://myname:password@host.com/"

.PP
The
.I Clock applet
shows the current time and date.
It is configured by the
.B TimeFormat
option.

.PP
The
.I taskbar collapse button
collapses the taskbar and hides it.

.PP
Not all IceWM applets may show up on the taskbar.
They must have been enabled during configuration of the IceWM software.
Their appearance is also controlled by options in the preferences file.

.PD 1
.SH INPUT FOCUS

Of all visible windows only one can be the
.I active window.
This is the window which has
.I input focus.
It is the primary receiver of keyboard and mouse events
and hence one can interact with the application
which created that window.
A primary task of a window manager is to allow the user
to switch input focus between different windows.
The primary means to do this is the mouse pointer.
By moving the mouse pointer over the screen to
another window, and perhaps also by clicking
on a window, input focus can be directed. 

The
.I FocusMode
option controls the way IceWM
gives input focus to applications.
It is initialized by the
.I focus_mode
configuration file.
It can be modified via the IceWM Focus menu.
IceWM supports three focus models:
Click-to-focus (1),
Sloppy-mouse-focus (2)
and Custom-mode (0).
The default is
.I FocusMode=1
(Click-to-focus).
In this mode changing input focus requires to click a window with the
left mouse button.
.I Sloppy-mouse-focus
sets input focus merely by moving the mouse pointer over a window.
It is called sloppy, because if the mouse then moves to the desktop
focus remains with the last active window.
.I Custom-mode
is a focus mode which is defined in detail by ten options
in the preferences file.
These are:
ClickToFocus,
FocusOnAppRaise,
RequestFocusOnAppRaise,
RaiseOnFocus,
RaiseOnClickClient,
FocusChangesWorkspace,
FocusOnMap,
FocusOnMapTransient,
FocusOnMapTransientActive,
MapInactiveOnTop.
The two non-Custom focus modes override these ten options.

Apart from the mouse, IceWM supports changing input
focus in two other ways. Both involve the keyboard.
The first uses the
.I QuickSwitch window.
It is activated by pressing
.B Alt+Tab
or
.B Alt+Shift+Tab.
A window pops up in the center of the screen
with a narrow band over the next or previous
window which will receive input focus
when the Alt key is released.
By repeatedly pressing Alt+Tab or Alt+Shift+Tab
one can cycle through all windows.

The second keyboard method involves pressing
.B Alt+Esc
or
.B Alt+Shift+Esc.
Input focus is immediately changed to the next
or previous window, which will be raised to
make it fully visible.

.SH WINDOW PLACEMENT

A second important task of a window manager
is to place new windows on the screen.
By default IceWM chooses a placement with minimal overlap,
but this is determined by the
.B SmartPlacement
option in the preferences file.
If SmartPlacement is turned off then windows are placed
in sequence from left to right and top to bottom.
One can also turn on
.B ManualPlacement.
Then new windows appear initially in the top left corner
and the mouse cursor changes into a fist.
By moving the fist cursor to a suitable location and
clicking the new window will appear at the mouse click location.

.SH WINDOW LAYERS

Windows can overlap.
Which window appears on top is determined by three features.
Newer windows appear over older windows.
By clicking on a window it is raised to the top.
But both are overruled by the
.I window layer.
Windows can be placed in different layers via the
.B Layers
menu.
Click with the right mouse button on the window frame
and select
.B Layer.
From there choose one of seven window layers.
These are ordered from higher to lower.
Windows in higher layers appear over windows in lower layers.

.SH WORKSPACES

IceWM supports multiple virtual desktops called workspaces.
A workspace is like a screen where a subset of all
application windows are mapped.
Thanks to multiple workspaces we can more easily
manage a large number of applications.
The number of workspaces and their names are configurable in the
.I preferences
file through the
.B WorkspaceNames
option.
By default four workspaces are created
with the names 1, 2, 3 and 4 thus:

WorkspaceNames=" 1 ", " 2 ", " 3 ", " 4 "

This syntax is typical for IceWM options which receive multiple values.
It is a list of comma separated values each of which can be quoted.

The workspaces are visible on the toolbar.
One can switch to a different workspace by pressing the workspace button
in the toolbar, but after becoming familiar with the
.I keyboard shortcuts
below one will want to use a hotkey to choose a workspace.
If the
.B EdgeSwitch
options is enabled in the preferences file
(with sub-options
.B HorizontalEdgeSwitch
and
.B VerticalEdgeSwitch)
then one can move to the next or previous workspace
by moving the mouse to the edge of the screen.
The
.B ContinuousEdgeSwitch
option enables continuous movement to subsequent workspaces.
The
.B EdgeSwitchDelay
option says how long to wait before a change of workspace occurs.

To move an application window to a different workspace
one can use a keyboard shortcut.
Another option is to select the
.B Move To
submenu in the window menu of the window frame.

.SH KEYBOARD SHORTCUTS
.PD 0

IceWM supports a large number of hotkeys to activate
some behavior with a single key combination.
These are all configurable in the preferences file.
Here we give their default values,
followed by their preferences names
and short descriptions of their effect.

.TP
.B Alt+F1\ 
KeyWinRaise raises the window which currently has input focus. 

.TP
.B Alt+F2\ 
KeyWinOccupyAll makes the active window occupy all workspaces.

.TP
.B Alt+F3\ 
KeyWinLower lowers the window which currently has input focus.

.TP
.B Alt+F4\ 
KeyWinClose closes the active window.

.TP
.B Alt+F5\ 
KeyWinRestore restores the active window to its visible state.

.TP
.B Alt+F6\ 
KeyWinNext switches focus to the next window.

.TP
.B Alt+Shift+F6
KeyWinPrev switches focus to the previous window.

.TP
.B Alt+F7\ 
KeyWinMove starts movement of the active window.

.TP
.B Alt+F8\ 
KeyWinSize starts resizing of the active window.

.TP
.B Alt+F9\ 
KeyWinMinimize iconifies the active window.

.TP
.B Alt+F10
KeyWinMaximize maximizes the active window with borders.

.TP
.B Alt+Shift+F10
KeyWinMaximizeVert maximizes the active window vertically.

.TP
.B Alt+F11
KeyWinFullscreen maximizes the active window without borders.

.TP
.B Alt+F12
KeyWinRollup rolls up the active window.

.TP
.B Alt+Shift+F12
KeyWinHide hides the active window.

.TP
.B Alt+Space
KeyWinMenu posts the window menu.

.TP
.B Ctrl+Alt+KP_7
KeyWinArrangeNW moves the active window to the top left corner of the screen.

.TP
.B Ctrl+Alt+KP_8
KeyWinArrangeN moves the active window to the top middle of the screen.

.TP
.B Ctrl+Alt+KP_9
KeyWinArrangeNE moves the active window to the top right of the screen.

.TP
.B Ctrl+Alt+KP_6
KeyWinArrangeE moves the active window to the middle right of the screen.

.TP
.B Ctrl+Alt+KP_3
KeyWinArrangeSE moves the active window to the bottom right of the screen.

.TP
.B Ctrl+Alt+KP_2
KeyWinArrangeS moves the active window to the bottom middle of the screen.

.TP
.B Ctrl+Alt+KP_1
KeyWinArrangeSW moves the active window to the bottom left of the screen.

.TP
.B Ctrl+Alt+KP_4
KeyWinArrangeW moves the active window to the middle left of the screen.

.TP
.B Ctrl+Alt+KP_5
KeyWinArrangeC moves the active window to the center of the screen.

.TP
.B Shift+Esc
KeySysWinMenu posts the system window menu.

.TP
.B Alt+Ctrl+Del
KeySysDialog opens the IceWM system dialog in the center of the screen.

.TP
.B Ctrl+Esc
KeySysMenu activates the IceWM root menu in the lower left corner.

.TP
.B Alt+Ctrl+Esc
KeySysWindowList opens the IceWM system window list in the center of the screen.

.TP
.B Alt+Ctrl+Space
KeySysAddressBar opens the address bar in the taskbar where a command can be typed.

.TP
.B Alt+Ctrl+Left
KeySysWorkspacePrev goes one workspace to the left.

.TP
.B Alt+Ctrl+Right
KeySysWorkspaceNext goes one workspace to the right.

.TP
.B Alt+Ctrl+Down
KeySysWorkspaceLast goes to the previous workspace.

.TP
.B Alt+Ctrl+Shift+Left
KeySysWorkspacePrevTakeWin takes the active window one workspace to the left.

.TP
.B Alt+Ctrl+Shift+Right
KeySysWorkspaceNextTakeWin takes the active window one workspace to the right.

.TP
.B Alt+Ctrl+Shift+Down
KeySysWorkspaceLastTakeWin takes the active window to the previous workspace.

.TP
.B Alt+Ctrl+1
KeySysWorkspace1 goes to workspace 1.

.TP
.B Alt+Ctrl+2
KeySysWorkspace2 goes to workspace 2.

.TP
.B Alt+Ctrl+3
KeySysWorkspace3 goes to workspace 3.

.TP
.B Alt+Ctrl+4
KeySysWorkspace4 goes to workspace 4.

.TP
.B Alt+Ctrl+5
KeySysWorkspace5 goes to workspace 5.

.TP
.B Alt+Ctrl+6
KeySysWorkspace6 goes to workspace 6.

.TP
.B Alt+Ctrl+7
KeySysWorkspace7 goes to workspace 7.

.TP
.B Alt+Ctrl+8
KeySysWorkspace8 goes to workspace 8.

.TP
.B Alt+Ctrl+9
KeySysWorkspace9 goes to workspace 9.

.TP
.B Alt+Ctrl+0
KeySysWorkspace10 goes to workspace 10.

.TP
.B Alt+Ctrl+bracketleft
KeySysWorkspace11 goes to workspace 11.

.TP
.B Alt+Ctrl+bracketright
KeySysWorkspace12 goes to workspace 12.

.TP
.B Alt+Ctrl+Shift+1
KeySysWorkspace1TakeWin takes the active window to workspace 1.

.TP
.B Alt+Ctrl+Shift+2
KeySysWorkspace2TakeWin takes the active window to workspace 2.

.TP
.B Alt+Ctrl+Shift+3
KeySysWorkspace3TakeWin takes the active window to workspace 3.

.TP
.B Alt+Ctrl+Shift+4
KeySysWorkspace4TakeWin takes the active window to workspace 4.

.TP
.B Alt+Ctrl+Shift+5
KeySysWorkspace5TakeWin takes the active window to workspace 5.

.TP
.B Alt+Ctrl+Shift+6
KeySysWorkspace6TakeWin takes the active window to workspace 6.

.TP
.B Alt+Ctrl+Shift+7
KeySysWorkspace7TakeWin takes the active window to workspace 7.

.TP
.B Alt+Ctrl+Shift+8
KeySysWorkspace8TakeWin takes the active window to workspace 8.

.TP
.B Alt+Ctrl+Shift+9
KeySysWorkspace9TakeWin takes the active window to workspace 9.

.TP
.B Alt+Ctrl+Shift+0
KeySysWorkspace10TakeWin takes the active window to workspace 10.

.TP
.B Alt+Ctrl+Shift+bracketleft
KeySysWorkspace11TakeWin takes the active window to workspace 11.

.TP
.B Alt+Ctrl+Shift+bracketright
KeySysWorkspace12TakeWin takes the active window to workspace 12.

.TP
.B Alt+Shift+F2
KeySysTileVertical tiles all windows from left to right maximized vertically.

.TP
.B Alt+Shift+F3
KeySysTileHorizontal tiles all windows from top to bottom maximized horizontally.

.TP
.B Alt+Shift+F4
KeySysCascade makes a horizontal cascade of all windows which are maximized vertically.

.TP
.B Alt+Shift+F5
KeySysArrange rearranges the windows.

.TP
.B Alt+Shift+F7
KeySysUndoArrange undoes arrangement.

.TP
.B Alt+Shift+F8
KeySysArrangeIcons rearranges icons.

.TP
.B Alt+Shift+F9
KeySysMinimizeAll minimizes all windows.

.TP
.B Alt+Shift+F11
KeySysHideAll hides all windows.

.TP
.B Alt+Ctrl+d
KeySysShowDesktop unmaps all windows to show the desktop.

.TP
.B Alt+Ctrl+h
KeySysCollapseTaskBar hides the taskbar.

.PD 1
.SH MOUSE BINDINGS
.PD 0

You can control windows by a modified mouse button press:

.TP
.B Alt+Pointer_Button1
MouseWinMove moves the window under the mouse over the screen.

.TP
.B Alt+Pointer_Button3
MouseWinSize resizes the window.
Keep the key and button pressed.
To enlarge the window move the mouse button away from the center.
To shrink it move towards the center.

.TP
.B Ctrl+Alt+Pointer_Button1
MouseWinRaise raises the window under the mouse.

.PP
Clicking on the
.I desktop
activates a menu.
The middle button shows the window list (DesktopWinListButton=2).
The right button shows the root menu (DesktopMenuButton=3).

.PP
The
.I title frame
of a window also listens for mouse clicks.
Left double clicking maximizes the window (TitleBarMaximizeButton=1).
Middle double clicking rolls up the window (TitleBarRollupButton=2).
Pressing a mouse button and moving it will move the window.
Alt + left button lowers the window.

.PP
When the mouse is on the
.I window frame
then a left click raises the window.
Dragging with the left button down resizes the window.
Clicking the right button pops up the context menu.
Dragging with the right button moves the window.

.PD 1
.SH SIGNALS
.PD 0
The
.I icewm
process supports the following signals:

.TP
.B SIGHUP\ 
Icewm will restart itself. It is a way to reload the configuration.

.TP
.B SIGINT
.TP
.B SIGTERM
Icewm will cease to manage application windows and terminate.

.TP
.B SIGQUIT
Icewm will initiate the
.I Logout
procedure.
If a
.B LogoutCommand
was configured in the
.I preferences
file it will be executed.


.PD 1
.SH ENVIRONMENT VARIABLES

.I XDG_CONFIG_HOME=PATH
.RS
The directory for user private configuration files.
The default value is "$HOME/.config/icewm/".
.RE

.I ICEWM_PRIVCFG=PATH
.RS
The directory for user private configuration files.
The default value is "$HOME/.icewm/".
.RE

.I DISPLAY=NAME
.RS
The name of the X11 server.
See Xorg(1) or Xserver(1).
This value can be overridden by the --display option.
.RE

.I MAIL=URL
.RS
Gives the location of your mailbox.
If the schema is omitted the local "file" schema is assumed.
This is used by the mailbox applet in the taskbar
to show the status of your mailbox.
If the
.I MailBoxPath
option in the
.I preferences
file is set, then that one takes precedence.
.RE

.SH FILES
IceWM looks for configuration files in the following directories,
in the given order, until it finds one:

.I $HOME/.config/icewm/
.RS
Contains user-specific configurations.
.RE

.I $HOME/.icewm/
.RS
Contains user-specific configurations.
.RE

.I /etc/icewm/
or
.I /etc/X11/icewm/
.RS
Contains system-wide customized defaults.
Please note that your local installation may have been
configured to use a different system location.
The icewm --directories option will show this location.
.RE

.I /usr/share/icewm/
or
.I /usr/local/share/icewm/
.RS
Default local installation settings.
.RE

.B Configuration files

.I env
.RS
.I icewm-session
loads additional environment variables from the file
.B env.
Each line is subjected to posix-shell expansion by
.I wordexp(3).
Comment lines starting by a #-sign are ignored.
Icewm-session will load those expanded lines which
contain a name, followed by an equals sign,
followed by the value (which may be empty).
.RE

.I focus_mode
.RS
Defines the initial value for FocusMode.
Its default value is
.I FocusMode=1
(Click-to-focus).
This can be changed via the menu.
IceWM will save the Focus menu choice in this file.
.RE

.I keys
.RS
Global keybindings to launch applications,
which need not be window manager related.
Each non-empty line starts with the word
.B key.
After one or more spaces follows a double-quoted string
of the bound X11 key combination like "Alt+Ctrl+Shift+X".
Then after at least one space follows a shell command line which
will be executed by IceWM whenever this key combination is pressed.
.RE

.I menu
.RS
A menu of startable applications; usually customized by the user.
IceWM provides either the program
.I icewm-menu-fdo
or the program
.I icewm-menu-gnome2
to generate a default menu.
Similar programs are
.I xdg_menu,
.I mmaker
(MenuMaker),
.I xde-menu,
.I xdgmenumaker.
.RE

.I preferences
.RS
Contains general settings like paths, colors and fonts,
but also options to control the IceWM focus behavior
and the applets which are started in the taskbar.
The icewm installation will provide a default
.I preferences
file, which can be copied to the IceWM user
configuration directory and modified.
.RE

.I prefoverride
.RS
Settings which override the settings from a theme.
Some of the IceWM configuration options from the
preferences file which control the look-and-feel
may be overridden by the theme,
if the theme designer thinks this is desirable.
However, this
.I prefoverride
file will again override this for a
few specific options of your choosing.
It is safe to leave this file empty initially.
.RE

.I programs
.RS
An automatically generated menu of startable applications.
This could be used by wmconfig, menu or similar programs
to give easy access to all the desktop applications
which are installed on the system.
.RE

.I theme
.RS
This file contains the name of the default theme.
On startup icewm reads this file to obtain the theme name,
unless icewm was started with the --theme option.
Whenever a different theme is selected from the IceWM Menu then
the theme file is overwritten with the name of the selected theme.
This theme file contains the keyword
.B Theme,
followed by an equals sign,
followed by a double-quoted string with the theme name.
The theme name is the name of the theme directory,
followed by a slash, followed by the theme file.
Usually the theme file is just "default.theme",
but a theme may have alternatives.
Alternatives are small tweakings of a theme.
These are specified in their own ".theme" file,
which replaces "default.theme".
If no theme file exists then IceWM will use the
default setting of Theme="default/default.theme".
.RE

.I toolbar
.RS
Contains names of quick to launch applications with icons for the taskbar.
Each non-empty non-comment line starts with the keyword
.B prog.
After one or more spaces follows a name, which is displayed in a
tooltip whenever the mouse cursor hovers over the toolbar icon.
This name may be a double quoted string.
Then follows the bare name of the icon to use without extensions.
This icon will be shown in the toolbar.
The last component is a shell command line which will be executed
whenever the user presses the icon in the toolbar.
.RE

.I winoptions
.RS
Contains settings to control window appearance and behavior
which are specific to applications or groups of applications.
Options can control the border, whether it appears on the
taskbar, the window list, the system tray and the workspaces.
Also its layer, geometry, whether it is movable, resizable
and closable.
Full details for this file are explained in the
.I IceWM Manual
.
.RE

.I startup
.RS
Contains commands to be executed on IceWM startup.
This is an executable script with commands to tweak
X11 settings and launch some applications which need
to be active whenever IceWM is started.
It is run by
.I icewm-session
when IceWM starts.
.RE

.I shutdown
.RS
Contains commands to be executed on IceWM shutdown.
This is an executable script with commands to be
executed in the last stage of IceWM termination.
Typically they may undo some of the effects of the
.I startup
script.
It is run by
.I icewm-session
when IceWM terminates.
.RE

.B Configuration directories

.I icons
.RS
Contains icons which are used to picturally identify applications.
Usually these files are in the XPM format,
but the PNG and SVG image formats are also supported.
The names of icon files may follow a specific naming pattern, like
.I app_32x32.xpm
.
They start with a basename, usually this is just a single word.
Then follows an underscore, followed by a size specification in
the format _SIZExSIZE.
This is followed by a dot and the file extension,
where the extension denotes the icon image format.
Common sizes are 16, 32 and 48 for small, large and huge icons.
This depends on the respective IconSize preferences options.
.RE

.I ledclock
.RS
Pictures of digits for the LED clock which is displayed in
the bottom-right corner of the taskbar.
These can be seen when the TaskBarShowClock and TaskBarClockLeds
options are both set to 1.
.RE

.I mailbox
.RS
Icons which are used to display different states of
the mailbox applet in the taskbar.
There are five states and each has its own icon:
mail.xpm, newmail.xpm, unreadmail.xpm, nomail.xpm, errmail.xpm.
.RE

.I taskbar
.RS
Pictures to customize the look of the taskbar.
These include:
taskbarbg.xpm,
taskbuttonactive.xpm,
taskbuttonbg.xpm,
taskbuttonminimized.xpm,
toolbuttonbg.xpm,
workspacebuttonactive.xpm,
workspacebuttonbg.xpm.
.RE

.I themes
.RS
A directory to store themes.
Each theme is stored in its own subdirectory in the
.I themes
directory. A theme contains at least a
.I default.theme
file, and optionally
.I "theme alternatives"
which are additional files which have a ".theme"
filename extension and which contain tweakings
of the "default.theme" file.
.RE

.SH EXAMPLES
Examples of the above configuration files
can be found in the default installation
path or in the system-wide defaults.
See the output of
.I icewm --directories
for their locations.

.SH CONFORMING TO
ICCCM 2.0: mostly.  EWMH: mostly.
See the file COMPLIANCE in the distribution for full details.

.SH SEE ALSO
Xorg(1),
Xserver(1),
xinit(1),
xprop(1),
xwininfo(1),
wmctrl(1).

.IR "IceWM Help"
from the IceWM menu contains a manual (somewhat outdated, but still useful).

.IR http://www.icewm.org/manual/
gives the IceWM Manual (somewhat outdated).

.IR http://www.icewm.org/FAQ/
gives frequently asked questions.

.IR http://www.icewm.org/themes/
explains how to design new themes.

.IR https://github.com/bbidulock/icewm/
for current software development.

.IR https://www.box-look.org/browse/cat/142/ord/latest/
for new themes.

.SH BUG REPORTS
If you find a bug in IceWM
please use the bug reporting system on
.BR https://github.com/bbidulock/icewm/issues
to report it. We welcome all friendly feedback.

.SH COPYING
IceWM is licensed under the GNU Library General Public License.
See the file COPYING in the distribution for full details.
